

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMFetchPruneReq.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMFetchPruneReq.sp,v $ $Id: MM_SMFetchPruneReq.sp,v 1.1.4.6 2018/03/19 23:57:21 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MM_SMFetchPruneReq <<<'

IF EXISTS (select * from sysobjects where name='MM_SMFetchPruneReq')
	drop procedure MM_SMFetchPruneReq
IF EXISTS (select * from GxQscripts where name='MM_SMFetchPruneReq')
	delete from GxQscripts where name = 'MM_SMFetchPruneReq'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMFetchPruneReq')
	delete from GXDBVersions where aliasname = 'MM_SMFetchPruneReq'
GO
print '... Creating Procedure: MM_SMFetchPruneReq'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMFetchPruneReq
  @i_xmlText XML
AS
  DECLARE @o_SnapShotEngineId integer
  DECLARE @o_CtrlHostId integer
  DECLARE @o_MAForDel integer
  DECLARE @o_NumOfSnaps integer
  DECLARE @o_MMErrorCode integer
  DECLARE @o_ErrorMsg varchar(1024)
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	-- Adding this check to check whether there are any rows in the SMVolume table
	-- For Non Snap CS, the snap prune thread is called every minute
	IF NOT EXISTS (SELECT 1 FROM SMVOLUME (NOLOCK))
	BEGIN
		RETURN
	END
	IF object_id('tempdb.dbo.#tblSMVolumeMountStatus') IS NOT Null DROP TABLE #tblSMVolumeMountStatus
	create table	#tblSMVolumeMountStatus  (
			MountStatus integer,
			primary key (mountstatus)
		)
	INSERT INTO #tblSMVolumeMountStatus SELECT 0					/*SM_VS_NONE*/
	INSERT INTO #tblSMVolumeMountStatus SELECT 10			/*SM_VS_PRP_STARTED*/
	INSERT INTO #tblSMVolumeMountStatus SELECT 11			/*SM_VS_PRP_DV_DSCVRD*/
	INSERT INTO #tblSMVolumeMountStatus SELECT 12	/*SM_VS_PRP_DV_DSCVR_FAILED*/
	INSERT INTO #tblSMVolumeMountStatus SELECT 18				/*SM_VS_PRP_FAILED*/
	INSERT INTO #tblSMVolumeMountStatus SELECT 19			/*SM_VS_PRP_PREPARED*/
	INSERT INTO #tblSMVolumeMountStatus SELECT 20			/*SM_VS_UPRP_STARTED*/
	INSERT INTO #tblSMVolumeMountStatus SELECT 28			/*SM_VS_UPRP_FAILED*/
	INSERT INTO #tblSMVolumeMountStatus SELECT 29			/*SM_VS_UPRP_FINISHED*/
	INSERT INTO #tblSMVolumeMountStatus SELECT 30			/*SM_VS_CRT_STARTED*/
	INSERT INTO #tblSMVolumeMountStatus SELECT 38				/*SM_VS_CRT_FAILED*/
	INSERT INTO #tblSMVolumeMountStatus SELECT 39			/*SM_VS_CRT_CREATED*/
	INSERT INTO #tblSMVolumeMountStatus SELECT 79			/*SM_VS_UMT_UNMOUNTED*/
	INSERT INTO #tblSMVolumeMountStatus SELECT 89			/*SM_VS_RVT_REVERTED*/
	INSERT INTO #tblSMVolumeMountStatus SELECT 90			/*SM_VS_DEL_STARTED*/
	INSERT INTO #tblSMVolumeMountStatus SELECT 97		/*SM_VS_DEL_EXT_DELETED*/
	INSERT INTO #tblSMVolumeMountStatus SELECT 98				/*SM_VS_DEL_FAILED*/
	IF object_id('tempdb.dbo.#tblSMVolumePruneFlags') IS NOT Null DROP TABLE #tblSMVolumePruneFlags
	create table #tblSMVolumePruneFlags (
		PruneFlags integer,
		primary key (PruneFlags)
		)
	INSERT INTO #tblSMVolumePruneFlags SELECT 0		/*MM_SM_PRUNEFLAGS_INACTIVE*/
	INSERT INTO #tblSMVolumePruneFlags SELECT 1		/*MM_SM_PRUNEFLAGS_ACTIVE*/
	INSERT INTO #tblSMVolumePruneFlags SELECT 2		/*MM_SM_PRUNEFLAGS_TOBEAGED*/
	INSERT INTO #tblSMVolumePruneFlags SELECT 6		/*MM_SM_PRUNEFLAGS_PHYSIC*/
	DECLARE @RetryParam integer = 0
SET @RetryParam = ISNULL((select Value from MMConfigs (NOLOCK) where name = 'MMS2_CONFIG_VOLSNAP_RETRY_COUNT'), 50/*MMS2_CONFIG_VOLSNAP_RETRY_COUNT_DEFAULT*/)
	DECLARE @i_callForNewlyAgedSnaps INT = 0
	SET @i_callForNewlyAgedSnaps = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlText.nodes('/MM_SMFetchPruneReq/callForNewlyAgedSnaps') R(ref)), 1)
	DECLARE @CurrentTime	INT = 0
	SET @CurrentTime = dbo.GetUnixTime(GETUTCDATE())
	-- If this flag is set, prune only the newly aged
	IF @i_callForNewlyAgedSnaps = 1
	BEGIN
		SELECT		A.SnapShotEngineId, A.ControlHostId, A.MAForDEL, COUNT(DISTINCT A.SMSnapId) SnapCount,0,''
		FROM
		(
		SELECT		DISTINCT SNAP.SMSnapId, SNAP.SnapShotEngineId, SNAP.ControlHostId, VOL.MountStatusUpdateTime,
					(CASE WHEN  AC.ArrayNum IS NOT NULL THEN 0 ELSE VOL.SourceClientId END) AS MAForDel
		FROM		SMVolume (NOLOCK) VOL
					INNER JOIN SMVolSnapMap (NOLOCK) MAP ON MAP.SMVolumeId = VOL.SMVolumeId
					INNER JOIN SMSnap (NOLOCK) SNAP ON SNAP.SMSnapId = MAP.SMSnapId
					INNER JOIN SMControlHost CTRL (NOLOCK) ON CTRL.ControlHostId = SNAP.ControlHostId
					LEFT JOIN SMArrayController (NOLOCK) AC ON AC.ArrayNum = SNAP.ControlHostId AND AC.Options & 262144/*SM_SNAPSHOT_ENGINE_CAPABILITY_GUI_SNAP_PRUNING*/ > 0
					LEFT JOIN MMHost MMH (NOLOCK) ON MMH.ClientId = VOL.SourceClientId
					LEFT JOIN archFileCopy AFC (NOLOCK) ON AFC.archFileId = VOL.ArchFileId AND AFC.archCopyId = VOL.CopyId AND AFC.commCellId = VOL.CommCellId
WHERE		((CTRL.Flags & 2) = 0)
					AND VOL.PruneFlags NOT IN (SELECT PruneFlags FROM #tblSMVolumePruneFlags)
					AND VOL.MountStatus IN (SELECT MountStatus FROM #tblSMVolumeMountStatus)
					AND VOL.SMVolumeId NOT IN (SELECT DISTINCT SMVolumeId FROM SMSnapResource (NOLOCK))
					AND VOL.SMVolumeId NOT IN (SELECT DISTINCT SMVolumeId FROM SMVolAction (NOLOCK))
					AND VOL.SMVolumeId NOT IN (SELECT DISTINCT SMVolumeId FROM SMMountVolume (NOLOCK) WHERE MountStatus < 79 /*SM_VS_UMT_UNMOUNTED*/ )
					AND VOL.MountStatus < 99 /*SM_VS_DEL_DELETED*/
					AND VOL.RetryCount = 0
					AND VOL.SnapSource = 0 /*SM_SS_CV*/
					AND VOL.CopyId NOT IN (SELECT ID FROM archGroupCopy (NOLOCK) WHERE isSnapCopy = 1 AND isMirrorCopy = 1)
AND ( (SNAP.ControlHostId > 0) OR (SNAP.ControlHostId = 0 AND SNAP.SnapShotEngineId IN(1, 53, 48, 58, 59)) )
					AND ( AC.ArrayNum IS NOT NULL OR ( MMH.ClientId IS NOT NULL AND MMH.MmHostEnabled = 1 AND MMH.MmHostSoftState = 1 ) )
AND ( VOL.PruneFlags < 7 OR (VOL.PruneFlags = 7 AND (AFC.flags & 256/*CVA_AGED_DATA_FLAG*/ > 0 OR AFC.flags IS NULL)) )
					AND SNAP.SnapStatus <> 20 /*CVSO::DELETED*/
		) A
		GROUP BY	A.SnapShotEngineId, A.ControlHostId, A.MAForDel
		ORDER BY	MIN(A.MountStatusUpdateTime)
	END
	-- prune the entries which have already been attempted once
	ELSE
	BEGIN
		SELECT		A.SnapShotEngineId, A.ControlHostId, A.MAForDEL, COUNT(DISTINCT A.SMSnapId) SnapCount,0,''
		FROM
		(
		SELECT		DISTINCT SNAP.SMSnapId, SNAP.SnapShotEngineId, SNAP.ControlHostId, VOL.MountStatusUpdateTime,
					(CASE WHEN  AC.ArrayNum IS NOT NULL THEN 0 ELSE VOL.SourceClientId END) AS MAForDel
		FROM		SMVolume (NOLOCK) VOL
					INNER JOIN SMVolSnapMap (NOLOCK) MAP ON MAP.SMVolumeId = VOL.SMVolumeId
					INNER JOIN SMSnap (NOLOCK) SNAP ON SNAP.SMSnapId = MAP.SMSnapId
					INNER JOIN SMControlHost CTRL (NOLOCK) ON CTRL.ControlHostId = SNAP.ControlHostId
					INNER JOIN SMSnapShotEngine ENG (NOLOCK) ON ENG.SnapShotEngineId = SNAP.SnapshotEngineId
					LEFT JOIN SMArrayController (NOLOCK) AC ON AC.ArrayNum = SNAP.ControlHostId AND AC.Options & 262144/*SM_SNAPSHOT_ENGINE_CAPABILITY_GUI_SNAP_PRUNING*/ > 0
					LEFT JOIN MMHost MMH (NOLOCK) ON MMH.ClientId = VOL.SourceClientId
WHERE		((CTRL.Flags & 2) = 0)
					AND VOL.PruneFlags NOT IN (SELECT PruneFlags FROM #tblSMVolumePruneFlags)
					AND VOL.MountStatus IN (SELECT MountStatus FROM #tblSMVolumeMountStatus)
					AND VOL.SMVolumeId NOT IN (SELECT DISTINCT SMVolumeId FROM SMSnapResource (NOLOCK))
					AND VOL.SMVolumeId NOT IN (SELECT DISTINCT SMVolumeId FROM SMVolAction (NOLOCK))
					AND VOL.SMVolumeId NOT IN (SELECT DISTINCT SMVolumeId FROM SMMountVolume (NOLOCK) WHERE MountStatus < 79 /*SM_VS_UMT_UNMOUNTED*/ )
					AND VOL.MountStatus < 99 /*SM_VS_DEL_DELETED*/
					AND VOL.RetryCount > 0 AND VOL.RetryCount <= @RetryParam
					AND VOL.SnapSource = 0 /*SM_SS_CV*/
					AND VOL.CopyId NOT IN (SELECT ID FROM archGroupCopy (NOLOCK) WHERE isSnapCopy = 1 AND isMirrorCopy = 1)
					AND (  (VOL.MountStatusUpdateTime + (ENG.DeleteCleanupInterval * 60)) < @CurrentTime)
AND ( (SNAP.ControlHostId > 0) OR (SNAP.ControlHostId = 0 AND SNAP.SnapShotEngineId IN(1, 53, 48, 58, 59)) )
					AND ( AC.ArrayNum IS NOT NULL OR ( MMH.ClientId IS NOT NULL AND MMH.MmHostEnabled = 1 AND MMH.MmHostSoftState = 1 ) )
					AND SNAP.SnapStatus <> 20 /*CVSO::DELETED*/
		) A
		GROUP BY	A.SnapShotEngineId, A.ControlHostId, A.MAForDel
		ORDER BY	MIN(A.MountStatusUpdateTime)
	END
	IF object_id('tempdb.dbo.#tblSMVolumeMountStatus') IS NOT Null DROP TABLE #tblSMVolumeMountStatus
	IF object_id('tempdb.dbo.#tblSMVolumePruneFlags') IS NOT Null DROP TABLE #tblSMVolumePruneFlags
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMFetchPruneReq')
	delete from GxQscripts where name = 'MM_SMFetchPruneReq'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMFetchPruneReq')
	delete from GXDBVersions where aliasname = 'MM_SMFetchPruneReq'
GO

insert into GXDBVersions values(2, 'MM_SMFetchPruneReq',  '00010001000400060000', 'MM_SMFetchPruneReq', '00010001000400060000')
GO

