

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMExtendSnapMountRsrv.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMExtendSnapMountRsrv.sp,v $ $Id: MM_SMExtendSnapMountRsrv.sp,v 1.1.2.1 2018/05/11 11:23:14 bbrindavan Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MM_SMExtendSnapMountRsrv <<<'

IF EXISTS (select * from sysobjects where name='MM_SMExtendSnapMountRsrv')
	drop procedure MM_SMExtendSnapMountRsrv
IF EXISTS (select * from GxQscripts where name='MM_SMExtendSnapMountRsrv')
	delete from GxQscripts where name = 'MM_SMExtendSnapMountRsrv'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMExtendSnapMountRsrv')
	delete from GXDBVersions where aliasname = 'MM_SMExtendSnapMountRsrv'
GO
print '... Creating Procedure: MM_SMExtendSnapMountRsrv'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMExtendSnapMountRsrv
  @i_xmlInput XML,
  @i_reserveInt INT
AS
  DECLARE @o_ErrorCode INTEGER
  DECLARE @o_ErrorStr VARCHAR(1024)
SET NOCOUNT ON
/*
<ISVolMountRsrvList MountJobId="3" ExpiryIntervalTime="10" >
	<VolToExtend SMVolumeId="1" MountVolumeId="2"  />
	<VolToExtend SMVolumeId="2" MountVolumeId="4"  />
	<VolToExtend SMVolumeId="3" MountVolumeId="5"  />
</ISVolMountRsrvList>
*/
SET @o_ErrorCode = 0
SET @o_ErrorStr = ''
--Validate  Input XML
IF @i_xmlInput IS NULL
BEGIN
SET @o_ErrorCode = 60347 /*E_MM_SM_SB_EXTEND_SNAP_VOLUME_MOUNT_FAILED */
    SET @o_ErrorStr = 'Input XML Parameter cannot be empty.'
    GOTO PROC_END
END
-- Create Table from XML Input
IF OBJECT_ID('tempdb.dbo.#tblExtendSnapMountRsrv') IS NOT NULL DROP TABLE #tblExtendSnapMountRsrv
CREATE TABLE #tblExtendSnapMountRsrv (SMVolumeId int,MountVolumeId int)
INSERT INTO #tblExtendSnapMountRsrv(SMVolumeId ,MountVolumeId )
SELECT  ref.value('@SMVolumeId', 'int')  ,
		ref.value('@MountVolumeId', 'int')
FROM @i_xmlInput.nodes('/ISVolMountRsrvList/VolToExtend') R(ref)
--Validate  Input XML
IF NOT EXISTS (SELECT 1 FROM #tblExtendSnapMountRsrv)
BEGIN
SET @o_ErrorCode = 60347 /*E_MM_SM_SB_EXTEND_SNAP_VOLUME_MOUNT_FAILED */
    SET @o_ErrorStr = 'No VolumeId or MountVolumeId found in Input XML'
    GOTO PROC_END
END
DECLARE @x_MountJobId int
DECLARE @x_ExpiryIntervalTime int
SELECT @x_MountJobId=ref.value('@MountJobId', 'int'),
	@x_ExpiryIntervalTime=ref.value('@ExpiryIntervalTime', 'int')
FROM @i_xmlInput.nodes('/ISVolMountRsrvList') R(ref)
--Validate VolumeID
IF EXISTS (
	SELECT  TOP 1 (1)
	FROM    #tblExtendSnapMountRsrv toRsrv
	LEFT JOIN
			SMVolume(READUNCOMMITTED) VOL
	ON      VOL.SMVolumeId = toRsrv.SMVolumeId
	WHERE   VOL.SMVolumeId IS NULL
)
BEGIN
SET @o_ErrorCode = 60347 /*E_MM_SM_SB_EXTEND_SNAP_VOLUME_MOUNT_FAILED */
	SET @o_ErrorStr ='Invalid Volume Id found'
	GOTO PROC_END
END
--Validate MountVolume ID
IF EXISTS (
	SELECT  TOP 1 (1)
	FROM    #tblExtendSnapMountRsrv toRsrv
	LEFT JOIN
			SMMountVolume(READUNCOMMITTED) MV
	ON      MV.id = toRsrv.MountVolumeId
	WHERE   toRsrv.MountVolumeId<>0 AND MV.id IS NULL
)
BEGIN
SET @o_ErrorCode = 60347 /*E_MM_SM_SB_EXTEND_SNAP_VOLUME_MOUNT_FAILED */
	SET @o_ErrorStr ='Invalid Mount Volume Id found'
	GOTO PROC_END
END
--Check if all the volumes are Mounted
IF EXISTS(
	SELECT TOP 1(1)
	FROM #tblExtendSnapMountRsrv toRsrv
	JOIN  SMVolume(READUNCOMMITTED) VOL ON VOL.SMVolumeId=toRsrv.SMVolumeId
WHERE toRsrv.MountVolumeId = 0 AND VOL.MountStatus <> 59 /*SM_VS_MNT_MOUNTED */
	UNION
	SELECT TOP 1(1)
	FROM #tblExtendSnapMountRsrv toRsrv
	JOIN  SMMountVolume(READUNCOMMITTED) VOL ON VOL.Id=toRsrv.MountVolumeId
WHERE toRsrv.MountVolumeId <> 0 AND VOL.MountStatus <> 59 /*SM_VS_MNT_MOUNTED */
 )
BEGIN
SET @o_ErrorCode = 60347 /*E_MM_SM_SB_EXTEND_SNAP_VOLUME_MOUNT_FAILED */
	SET @o_ErrorStr = 'Unmounted Volumes Found'
	GOTO PROC_END
END
--Validate SMSnapResource
IF EXISTS (
	SELECT  TOP 1 (1)
	FROM    #tblExtendSnapMountRsrv toRsrv
	LEFT JOIN
			SMSnapResource(READUNCOMMITTED) RES
	ON      ((toRsrv.MountVolumeId=0 AND toRsrv.SMVolumeId = RES.SMVolumeId) OR (toRsrv.MountVolumeId<>0 AND toRsrv.MountVolumeId = RES.SnapShotId ))
			AND (@x_MountJobId = RES.JobId)
	WHERE   RES.SMResourceId IS NULL
)
BEGIN
SET @o_ErrorCode = 60347 /*E_MM_SM_SB_EXTEND_SNAP_VOLUME_MOUNT_FAILED */
	SET @o_ErrorStr ='Failed to get SMSnapResource entries'
	GOTO PROC_END
END
--Fetch Engine Defined Expiry Interval (Max of Expiry Intervals [MultiEngine Snaps])
DECLARE @x_MaxEngineExpiryInterval int =
(
	SELECT  max(ENGINE.MountStatusUpdateExpiryInterval)
	FROM #tblExtendSnapMountRsrv toRsrv
		JOIN SMVolSnapMap(READUNCOMMITTED) MAP ON MAP.SMVolumeId=toRsrv.SMVolumeId
		JOIN SMSnap(READUNCOMMITTED) SNAP ON SNAP.SMSnapId=MAP.SMSnapId
		JOIN SMSnapShotEngine(READUNCOMMITTED) ENGINE ON ENGINE.SnapShotEngineId=SNAP.SnapShotEngineId
)
IF @x_ExpiryIntervalTime = 0
	SET @x_ExpiryIntervalTime = @x_MaxEngineExpiryInterval
--Extend SMSnapResource
UPDATE RES
SET RES.ExpiryInterval = CASE WHEN RES.ExpiryInterval = 0
								THEN @x_ExpiryIntervalTime+@x_MaxEngineExpiryInterval
								ELSE @x_ExpiryIntervalTime+RES.ExpiryInterval
							END
FROM #tblExtendSnapMountRsrv toRsrv
JOIN SMSnapResource RES
ON  (toRsrv.MountVolumeId<>0 AND toRsrv.MountVolumeId=RES.SnapShotId)
	OR (toRsrv.MountVolumeId=0 AND toRsrv.SMVolumeId=RES.SMVolumeId)
WHERE  @x_MountJobId=RES.JobId
PROC_END:
SELECT @o_ErrorCode, @o_ErrorStr
IF OBJECT_ID('tempdb.dbo.#tblExtendSnapMountRsrv') IS NOT NULL DROP TABLE #tblExtendSnapMountRsrv
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMExtendSnapMountRsrv')
	delete from GxQscripts where name = 'MM_SMExtendSnapMountRsrv'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMExtendSnapMountRsrv')
	delete from GXDBVersions where aliasname = 'MM_SMExtendSnapMountRsrv'
GO

insert into GXDBVersions values(2, 'MM_SMExtendSnapMountRsrv',  '00010001000200010000', 'MM_SMExtendSnapMountRsrv', '00010001000200010000')
GO

