

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMDeleteSnapAction.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMDeleteSnapAction.sp,v $ $Id: MM_SMDeleteSnapAction.sp,v 1.1.2.3 2018/03/20 00:14:19 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MM_SMDeleteSnapAction <<<'

IF EXISTS (select * from sysobjects where name='MM_SMDeleteSnapAction')
	drop procedure MM_SMDeleteSnapAction
IF EXISTS (select * from GxQscripts where name='MM_SMDeleteSnapAction')
	delete from GxQscripts where name = 'MM_SMDeleteSnapAction'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMDeleteSnapAction')
	delete from GXDBVersions where aliasname = 'MM_SMDeleteSnapAction'
GO
print '... Creating Procedure: MM_SMDeleteSnapAction'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMDeleteSnapAction
  @i_inputXML XML,
  @i_options INTEGER
AS
  DECLARE @o_ErrorCode INTEGER
  DECLARE @o_ErrorStr VARCHAR(1024)
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
/*
<MM_SMDeleteSnapAction>
	<JobId>12345</JobId>
	<RequestId>2345</RequestId>
	<SnapOpType>7</SnapOpType>
	<HostId>5</HostId>
	<SnapList>
		<SMSnap SMSnapId="7" Status="97"/>
		<SMSnap SMSnapId="8" Status="97"/>
	</SnapList>
</MM_SMDeleteSnapAction>
*/
SET @o_ErrorCode = 0
SET @o_ErrorStr = ''
DECLARE @tblSnaps TABLE (SMSnapId INT, Status INT)
INSERT INTO @tblSnaps
SELECT  ref.value('@SMSnapId', 'int') AS SMSnapId,
		ref.value('@Status', 'int') AS Status
		FROM @i_inputXML.nodes('/MM_SMDeleteSnapAction/SnapList/SMSnap') R(ref)
DECLARE @i_jobId INT = 0
SET @i_jobId = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_inputXML.nodes('/MM_SMDeleteSnapAction/JobId') R(ref)), 0)
DECLARE @i_snapOpType INT = 0
SET @i_snapOpType = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_inputXML.nodes('/MM_SMDeleteSnapAction/SnapOpType') R(ref)), 0)
DECLARE @i_requestId INT = 0
SET @i_requestId = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_inputXML.nodes('/MM_SMDeleteSnapAction/RequestId') R(ref)), 0)
DECLARE @i_HostId INT = 0
SET @i_HostId = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_inputXML.nodes('/MM_SMDeleteSnapAction/HostId') R(ref)), 0)
DECLARE @DeleteTime DATETIME
SET @DeleteTime = GETUTCDATE()
IF OBJECT_ID('temp.dbo.#tmpSnapAction') IS NOT NULL DROP TABLE #tmpSnapAction
CREATE TABLE #tmpSnapAction
(
    SMSnapId            integer,
    JobId               integer,
    CommCellId          integer,
    HostId              integer,
    SnapOpType          integer,
    RequestId           integer,
    ActionStatus        integer,
	StartTime           bigint
)
BEGIN TRY
	BEGIN TRANSACTION DeleteSnapActionTran
		DELETE	A
		OUTPUT	DELETED.*
		INTO	#tmpSnapAction
		FROM	@tblSnaps T
				INNER JOIN SMSnapAction A ON A.SMsnapId = T.SMsnapId
					AND A.JobId = @i_jobId
					AND A.SnapOpType = @i_snapOpType
					AND A.RequestId = @i_requestId
		INSERT	INTO SMSnapActionHistory (DeleteTime, SMSnapId, JobId, CommCellId, HostId, SnapOpType, RequestId, ActionStatus, StartTime)
		SELECT	@DeleteTime, TMP.SMSnapId, TMP.JobId, TMP.CommCellId, TMP.HostId, TMP.SnapOpType, TMP.RequestId, INP.Status, TMP.StartTime
		FROM	#tmpSnapAction TMP
				INNER JOIN @tblSnaps INP ON TMP.SMSnapId = INP.SMSnapId
					AND TMP.JobId = @i_jobId
					AND TMP.SnapOpType = @i_snapOpType
					AND TMP.RequestId = @i_requestId
	COMMIT TRANSACTION DeleteSnapActionTran
END TRY
BEGIN CATCH
	IF XACT_STATE() <> 0
		ROLLBACK TRANSACTION DeleteSnapActionTran
	SET @o_ErrorCode = ERROR_NUMBER()
	SET @o_ErrorStr = ERROR_MESSAGE()
END CATCH
IF OBJECT_ID('temp.dbo.#tmpSnapAction') IS NOT NULL DROP TABLE #tmpSnapAction
SELECT @o_ErrorCode, @o_ErrorStr
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMDeleteSnapAction')
	delete from GxQscripts where name = 'MM_SMDeleteSnapAction'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMDeleteSnapAction')
	delete from GXDBVersions where aliasname = 'MM_SMDeleteSnapAction'
GO

insert into GXDBVersions values(2, 'MM_SMDeleteSnapAction',  '00010001000200030000', 'MM_SMDeleteSnapAction', '00010001000200030000')
GO

