

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMDeleteDFMDataSetsAndMembers.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMDeleteDFMDataSetsAndMembers.sp,v $ $Id: MM_SMDeleteDFMDataSetsAndMembers.sp,v 1.2.56.4 2018/03/20 00:10:52 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MM_SMDeleteDFMDataSetsAndMembers <<<'

IF EXISTS (select * from sysobjects where name='MM_SMDeleteDFMDataSetsAndMembers')
	drop procedure MM_SMDeleteDFMDataSetsAndMembers
IF EXISTS (select * from GxQscripts where name='MM_SMDeleteDFMDataSetsAndMembers')
	delete from GxQscripts where name = 'MM_SMDeleteDFMDataSetsAndMembers'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMDeleteDFMDataSetsAndMembers')
	delete from GXDBVersions where aliasname = 'MM_SMDeleteDFMDataSetsAndMembers'
GO
print '... Creating Procedure: MM_SMDeleteDFMDataSetsAndMembers'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMDeleteDFMDataSetsAndMembers
  @i_xmlTextInput XML,
  @i_reserveInt INTEGER,
  @i_reserveStr VARCHAR(255)
AS
-- Following are the "columns" returned, in the order in which they are returned
-- Column of NVARCHAR_UTF8(MAX) type should be at the end
  DECLARE @o_errCode INT
  DECLARE @o_errMsg VARCHAR(255)
SET NOCOUNT ON
BEGIN
	DECLARE @tblDatasets TABLE (DataSetId	int)
	DECLARE @tblDSMembers TABLE (DataSetMemberId	int)
	DECLARE @errCode	INT = 0
	DECLARE @errMsg		VARCHAR(255) = ''
    INSERT  INTO @tblDatasets
	SELECT  ref.value('./DataSetId[1]', 'int') AS DataSetId
    FROM	@i_xmlTextInput.nodes('/MM_SMDeleteDFMDataSetsAndMembers/DataSet') R(ref)
    INSERT  INTO @tblDSMembers
	SELECT  ref.value('./DataSetMemberId[1]', 'int') AS DataSetId
    FROM	@i_xmlTextInput.nodes('/MM_SMDeleteDFMDataSetsAndMembers/DataSetMember') R(ref)
	INSERT	INTO @tblDSMembers
	SELECT	DISTINCT DSM1.DataSetMemberId
	FROM	SMDataSetMember DSM1 (NOLOCK)
			INNER JOIN SMDataSetMember DSM2 (NOLOCK) ON DSM1.DataSetId = DSM2.DataSetId
				AND DSM1.ExtDataSetMemberId = DSM2.ExtDataSetMemberId
AND DSM1.Flags & 1 = 1 AND DSM2.Flags & 1 = 1
AND DSM1.Flags & 256 = 256 AND DSM2.Flags & 256 <> 256
	DELETE
    FROM	SMDataSetMember
    WHERE	DataSetId IN (SELECT DataSetId FROM @tblDatasets)
	SET @errCode = @@ERROR
	IF @errCode > 0
	BEGIN
		SET @errMsg = 'Failed to delete DataSet Members for aged datasets.'
		GOTO ERR_EXIT
	END
	DELETE
	FROM	SMDataSet
	WHERE	DataSetId IN (SELECT DataSetId FROM @tblDatasets)
	SET @errCode = @@ERROR
	IF @errCode > 0
	BEGIN
		SET @errMsg = 'Failed to delete DataSets from SMDataSet.'
		GOTO ERR_EXIT
	END
	DELETE
	FROM	SMDataSetMember
	WHERE	DataSetMemberId IN (SELECT DataSetMemberId FROM @tblDSMembers)
	SET @errCode = @@ERROR
	IF @errCode > 0
	BEGIN
		SET @errMsg = 'Failed to delete DataSetMembers from SMDataSetMember.'
		GOTO ERR_EXIT
	END
	DELETE	MAP
	FROM	SMDataSetToSubClientMap MAP
			LEFT OUTER JOIN SMDatasetMember DS_MEM
			ON MAP.DatasetId = DS_MEM.DatasetId AND DS_MEM.AppId = MAP.AppId
AND DS_MEM.Flags & 1 = 1
	WHERE	DS_MEM.DatasetMemberId IS NULL
AND MAP.Flags & 256 = 256
	SET @errCode = @@ERROR
	IF @errCode > 0
	BEGIN
		SET @errMsg = 'Failed to delete SMDataSetToSubClientMap for aged dataset members.'
		GOTO ERR_EXIT
	END
	SELECT 0, ''
	RETURN
ERR_EXIT:
	SELECT	@errCode, @errMsg
	RETURN
END
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMDeleteDFMDataSetsAndMembers')
	delete from GxQscripts where name = 'MM_SMDeleteDFMDataSetsAndMembers'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMDeleteDFMDataSetsAndMembers')
	delete from GXDBVersions where aliasname = 'MM_SMDeleteDFMDataSetsAndMembers'
GO

insert into GXDBVersions values(2, 'MM_SMDeleteDFMDataSetsAndMembers',  '00010002005600040000', 'MM_SMDeleteDFMDataSetsAndMembers', '00010002005600040000')
GO

