

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMDFMStorageServiceRpt.sp] ---------- 

-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "MM_SMDFMStorageServiceRpt"
--	|	This Procedure is used in the Custom Report displaying relationship between OCUM and Simpana entities
-- 	+-----------------------------------------------------------------------+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MM_SMDFMStorageServiceRpt <<<'

IF EXISTS (select * from sysobjects where name='MM_SMDFMStorageServiceRpt')
	drop procedure MM_SMDFMStorageServiceRpt
IF EXISTS (select * from GxQscripts where name='MM_SMDFMStorageServiceRpt')
	delete from GxQscripts where name = 'MM_SMDFMStorageServiceRpt'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMDFMStorageServiceRpt')
	delete from GXDBVersions where aliasname = 'MM_SMDFMStorageServiceRpt'
GO
print '... Creating Procedure: MM_SMDFMStorageServiceRpt'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMDFMStorageServiceRpt
  @i_ReserveInt INT,
  @i_ReserveStr VARCHAR(255)
AS
SET NOCOUNT ON
DECLARE @tempDFMInfo TABLE
	(	ControlHostId					INTEGER,
OnCommandUnifiedManager			NVARCHAR(1024),
Version							NVARCHAR(255),
DataSetId						NVARCHAR(512),
DataSetName						NVARCHAR(256),
StorageServiceId				NVARCHAR(512),
StorageServiceName				NVARCHAR(256),
NodeId							NVARCHAR(512),
NodeType						NVARCHAR(255),
		SubClientId						INTEGER,
		SubClientName					NVARCHAR(128),
		ClientId						INTEGER,
ClientName						NVARCHAR(255),
		StoragePolicyId					INTEGER,
StoragePolicyName				NVARCHAR(255),
		StoragePolicyCopyId				INTEGER,
StoragePolicyCopyName			NVARCHAR(255),
		Description						NVARCHAR(MAX),
		TotalSnapCount					INTEGER,
		ValidSnapCount					INTEGER
	)
	INSERT INTO @tempDFMInfo
    SELECT      HOST.ControlHostId AS DFMHostId, HOST.SMArrayId AS DFMHostName, '' AS DFMVersion,
                DATASET.ExtDataSetId AS DataSetId, DATASET.ExtDataSetName AS DataSetName,
                REL.ExtRelationId AS StorageServiceId, REL.ExtRelationName AS StorageServiceName,
                NODE.ExtNodeId AS NodeId,
                CASE
					WHEN AG_HOST.SMReplicationProtocolType = 1 THEN 'LREP'
					WHEN AGC.isSnapCopy > 0 AND AGC.isMirrorCopy > 0 THEN 'Mirror'
					WHEN AGC.isSnapCopy > 0 THEN 'Vault'
				END,
                APP.id AS SubClientId, APP.subclientName AS SubClientName,
                CLIENT.id AS ClientId, CLIENT.name AS ClientName,
                AG.id AS StoragePolicyId, AG.name AS StoragePolicyName,
                AGC.id AS StoragePolicyCopyId, AGC.name AS StoragePolicyCopyName,
                'Storage Policy with OCUM, Storage Service(s), Subclient(s) and DataSet(s)' AS Description, 0, 0
    FROM        ArchGroupControlHost(NOLOCK) AG_HOST
                INNER JOIN SMControlHost(NOLOCK) HOST ON AG_HOST.ControlHostId = HOST.ControlHostId
                INNER JOIN SMRelation(NOLOCK) REL ON REL.ControlHostId = AG_HOST.ControlHostId
                INNER JOIN archGroup(NOLOCK) AG ON AG_HOST.ArchGroupId = AG.id
                INNER JOIN archGroupCopy(NOLOCK) AGC ON AGC.archGroupId = AG_HOST.ArchGroupId
                INNER JOIN SMCopyToRelationMap(NOLOCK) MAP
                    ON MAP.SMRelationId = REL.SMRelationId
                    AND MAP.ArchGroupCopyId = AGC.id
				INNER JOIN SMRelationNode(NOLOCK) NODE ON MAP.SMRelationId = NODE.SMRelationID
					AND MAP.SMRelationNodeId = NODE.SMRelationNodeId
                INNER JOIN APP_Application(NOLOCK) APP ON (APP.dataArchGrpId = AG_HOST.ArchGroupId)
                INNER JOIN APP_Client(NOLOCK) CLIENT ON CLIENT.id = APP.clientId
                INNER JOIN SMDataSetToSubClientMap(NOLOCK) DS
                    ON DS.SMRelationId = MAP.SMRelationId
                    AND DS.AppId = APP.id
				INNER JOIN SMDataSet(NOLOCK) DATASET ON DS.DataSetId = DATASET.DataSetId
	INSERT INTO @tempDFMInfo
    -- DFM, SP, Storage Service, No Subclient, Dataset
    SELECT      HOST.ControlHostId AS DFMHostId, HOST.SMArrayId AS DFMHostName, '' AS DFMVersion,
                DATASET.ExtDataSetId AS DataSetId, DATASET.ExtDataSetName AS DataSetName,
                REL.ExtRelationId AS StorageServiceId, REL.ExtRelationName AS StorageServiceName,
                NODE.ExtNodeId AS NodeId,
                CASE
					WHEN AG_HOST.SMReplicationProtocolType = 1 THEN 'LREP'
					WHEN AGC.isSnapCopy > 0 AND AGC.isMirrorCopy > 0 THEN 'Mirror'
					WHEN AGC.isSnapCopy > 0 THEN 'Vault'
				END,
                APP1.id AS SubClientId, APP1.subclientName AS SubClientName,
                CLIENT.id AS ClientId, CLIENT.name AS ClientName,
                AG.id AS StoragePolicyId, AG.name AS StoragePolicyName,
                AGC.id AS StoragePolicyCopyId, AGC.name AS StoragePolicyCopyName,
                'Storage Policy with OCUM, Storage Service(s) and DataSet(s) - Subclient association changed' AS Description, 0, 0
    FROM        ArchGroupControlHost(NOLOCK) AG_HOST
                INNER JOIN SMControlHost(NOLOCK) HOST ON AG_HOST.ControlHostId = HOST.ControlHostId
                INNER JOIN SMRelation(NOLOCK) REL ON REL.ControlHostId = AG_HOST.ControlHostId
                INNER JOIN archGroup(NOLOCK) AG ON AG_HOST.ArchGroupId = AG.id
                INNER JOIN archGroupCopy(NOLOCK) AGC ON AGC.archGroupId = AG_HOST.ArchGroupId
                INNER JOIN SMCopyToRelationMap(NOLOCK) MAP
                    ON MAP.SMRelationId = REL.SMRelationId
                    AND MAP.ArchGroupCopyId = AGC.id
				INNER JOIN SMRelationNode NODE (NOLOCK) ON MAP.SMRelationId = NODE.SMRelationId
					AND MAP.SMRelationNodeId = NODE.SMRelationNodeId
                INNER JOIN SMDataSetToSubClientMap(NOLOCK) DS ON DS.SMRelationId = MAP.SMRelationId
				INNER JOIN SMDataSet DATASET (NOLOCK) ON DS.DataSetId = DATASET.DataSetId
                INNER JOIN APP_Application(NOLOCK) APP1 ON (APP1.id = DS.AppId)
                INNER JOIN APP_Client(NOLOCK) CLIENT ON CLIENT.id = APP1.clientId
                LEFT OUTER JOIN APP_Application(NOLOCK) APP2 ON (APP2.id = APP1.id AND APP2.dataArchGrpId = AG_HOST.ArchGroupId)
    WHERE       APP2.id IS NULL
	INSERT INTO @tempDFMInfo
      -- DFM, SP, Storage Service, Subclient, No Dataset
    SELECT      HOST.ControlHostId AS DFMHostId, HOST.SMArrayId AS DFMHostName, '' AS DFMVersion,
                'N/A' AS DataSetId, 'N/A' AS DataSetName,
                REL.ExtRelationId AS StorageServiceId, REL.ExtRelationName AS StorageServiceName,
                NODE.ExtNodeId AS NodeId,
                CASE
					WHEN AG_HOST.SMReplicationProtocolType = 1 THEN 'LREP'
					WHEN AGC.isSnapCopy > 0 AND AGC.isMirrorCopy > 0 THEN 'Mirror'
					WHEN AGC.isSnapCopy > 0 THEN 'Vault'
				END,
                APP.id AS SubClientId, APP.subclientName AS SubClientName,
                CLIENT.id AS ClientId, CLIENT.name AS ClientName,
                AG.id AS StoragePolicyId, AG.name AS StoragePolicyName,
                AGC.id AS StoragePolicyCopyId, AGC.name AS StoragePolicyCopyName,
                'Storage Policy with OCUM, Storage Service(s) and Subclient(s) - no Dataset' AS Description, 0, 0
    FROM        ArchGroupControlHost(NOLOCK) AG_HOST
                INNER JOIN SMControlHost(NOLOCK) HOST ON AG_HOST.ControlHostId = HOST.ControlHostId
                INNER JOIN SMRelation(NOLOCK) REL ON REL.ControlHostId = AG_HOST.ControlHostId
                INNER JOIN archGroup(NOLOCK) AG ON AG_HOST.ArchGroupId = AG.id
                INNER JOIN archGroupCopy(NOLOCK) AGC ON AGC.archGroupId = AG_HOST.ArchGroupId
                INNER JOIN SMCopyToRelationMap(NOLOCK) MAP
                    ON MAP.SMRelationId = REL.SMRelationId
                    AND MAP.ControlHostId = AG_HOST.ControlHostId
                    AND MAP.ArchGroupCopyId = AGC.id
				INNER JOIN SMRelationNode NODE (NOLOCK) ON MAP.SMRelationNodeId = NODE.SMRelationNodeId
					AND MAP.SMRelationId = NODE.SMRelationId
                INNER JOIN APP_Application(NOLOCK) APP ON (APP.dataArchGrpId = AG_HOST.ArchGroupId)
                INNER JOIN APP_Client(NOLOCK) CLIENT ON CLIENT.id = APP.clientId
                LEFT OUTER JOIN SMDataSetToSubClientMap(NOLOCK) DS
                    ON DS.SMRelationId = MAP.SMRelationId
                    AND DS.AppId = APP.id
    WHERE       DS.DataSetId IS NULL
	INSERT INTO @tempDFMInfo
    -- DFM, SP, No Storage Service, Subclient, No Dataset
    SELECT      HOST.ControlHostId AS DFMHostId, HOST.SMArrayId AS DFMHostName, '' AS DFMVersion,
				'N/A' AS DataSetId, 'N/A' AS DataSetName,
                'N/A' AS StorageServiceId, 'N/A' AS StorageServiceName,
                'N/A' AS NodeId, '',
                APP.id AS SubClientId, APP.subclientName AS SubClientName,
                CLIENT.id AS ClientId, CLIENT.name AS ClientName,
                AG.id AS StoragePolicyId, AG.name AS StoragePolicyName,
                0 AS StoragePolicyCopyId, 'N/A' AS StoragePolicyCopyName,
                'Storage Policy with OCUM and Subclient(s) - no Storage Service' AS Description, 0, 0
    FROM        ArchGroupControlHost(NOLOCK) AG_HOST
                INNER JOIN SMControlHost(NOLOCK) HOST ON HOST.ControlHostId = AG_HOST.ControlHostId
                INNER JOIN archGroup(NOLOCK) AG ON AG_HOST.ArchGroupId = AG.id
                INNER JOIN APP_Application(NOLOCK) APP ON (APP.dataArchGrpId = AG_HOST.ArchGroupId)
                INNER JOIN APP_Client(NOLOCK) CLIENT ON CLIENT.id = APP.clientId
                LEFT OUTER JOIN
					(	SELECT	IAGC.id, IAGC.archGroupId FROM archGroupCopy(NOLOCK) IAGC
							INNER JOIN archGroup(NOLOCK) IAG
								ON IAG.id = IAGC.archGroupId AND IAGC.isSnapCopy = 1
                            LEFT OUTER JOIN ArchGroupControlHost AGCH
								ON AGCH.ArchGroupId = IAG.id AND AGCH.SMReplicationProtocolType = 1
								AND (IAGC.id <> IAG.defaultSnapCopy OR AGCH.SMReplicationProtocolType IS NOT NULL) ) AGC
                    ON AGC.archGroupId = AG.id
    WHERE       AGC.id IS NULL
	INSERT INTO @tempDFMInfo
    -- DFM, SP, Storage Service, No Subclient, No Dataset
    SELECT      HOST.ControlHostId AS DFMHostId, HOST.SMArrayId AS DFMHostName, '' AS DFMVersion,
                'N/A' AS DataSetId, 'N/A' AS DataSetName,
                REL.ExtRelationId AS StorageServiceId, REL.ExtRelationName AS StorageServiceName,
                NODE.ExtNodeId AS NodeId,
                CASE
					WHEN AG_HOST.SMReplicationProtocolType = 1 THEN 'LREP'
					WHEN AGC.isSnapCopy > 0 AND AGC.isMirrorCopy > 0 THEN 'Mirror'
					WHEN AGC.isSnapCopy > 0 THEN 'Vault'
				END,
                0 AS SubClientId, 'N/A' AS SubClientName,
                0 AS ClientId, 'N/A' AS ClientName,
                AG.id AS StoragePolicyId, AG.name AS StoragePolicyName,
                AGC.id AS StoragePolicyCopyId, AGC.name AS StoragePolicyCopyName,
                'Storage Policy with OCUM and Storage Service(s) - no subclient' AS Description, 0, 0
    FROM        ArchGroupControlHost(NOLOCK) AG_HOST
                INNER JOIN SMControlHost(NOLOCK) HOST ON AG_HOST.ControlHostId = HOST.ControlHostId
                INNER JOIN SMRelation(NOLOCK) REL ON REL.ControlHostId = AG_HOST.ControlHostId
                INNER JOIN archGroup(NOLOCK) AG ON AG_HOST.ArchGroupId = AG.id
                INNER JOIN archGroupCopy(NOLOCK) AGC ON AG_HOST.ArchGroupId = AGC.archGroupId
                INNER JOIN SMCopyToRelationMap(NOLOCK) MAP
                    ON MAP.SMRelationId = REL.SMRelationId
                    AND MAP.ArchGroupCopyId = AGC.id
				INNER JOIN SMRelationNode NODE (NOLOCK) ON MAP.SMRelationId = NODE.SMRelationId
					AND MAP.SMRelationNodeId = NODE.SMRelationNodeId
                LEFT OUTER JOIN APP_Application(NOLOCK) APP ON (APP.dataArchGrpId = AG_HOST.ArchGroupId)
    WHERE       APP.id IS NULL
	INSERT INTO @tempDFMInfo
    -- DFM, SP, No Storage Service, No Subclient, No Dataset
    SELECT      HOST.ControlHostId AS DFMHostId, HOST.SMArrayId AS DFMHostName, '' AS DFMVersion,
				'N/A' AS DataSetId, 'N/A' AS DataSetName,
                'N/A' AS StorageServiceId, 'N/A' AS StorageServiceName,
                'N/A' AS NodeId,
                'N/A' AS NodeType,
                0 AS SubClientId, 'N/A' AS SubClientName,
                0 AS ClientId, 'N/A' AS ClientName,
                AG.id AS StoragePolicyId, AG.name AS StoragePolicyName,
                CASE WHEN AGC.id IS NULL THEN 0 ELSE AGC.id END,
                CASE WHEN AGC.id IS NULL THEN 'N/A' ELSE AGC.name END,
                'Storage Policy with OCUM - no Storage Service, no Subclient' AS Description, 0, 0
    FROM        ArchGroupControlHost(NOLOCK) AG_HOST
                INNER JOIN SMControlHost(NOLOCK) HOST ON HOST.ControlHostId = AG_HOST.ControlHostId
                INNER JOIN archGroup(NOLOCK) AG ON AG_HOST.ArchGroupId = AG.id
                LEFT OUTER JOIN
                        (SELECT IAGC.id, IAGC.archGroupId, IAGC.name FROM archGroupCopy(NOLOCK) IAGC
							INNER JOIN archGroup(NOLOCK) IAG
								ON IAG.id = IAGC.archGroupId AND IAGC.isSnapCopy = 1
								AND IAGC.sourceCopyId > 0
                            LEFT OUTER JOIN ArchGroupControlHost AGCH
								ON AGCH.ArchGroupId = IAG.id AND AGCH.SMReplicationProtocolType = 1
								AND (IAGC.id <> IAG.defaultSnapCopy OR AGCH.SMReplicationProtocolType IS NOT NULL) )
						AGC ON AGC.archGroupId = AG.id
                LEFT OUTER JOIN APP_Application APP(NOLOCK) ON APP.dataArchGrpID = AG_HOST.ArchGroupId
    WHERE       APP.id IS NULL AND AGC.id IS NULL
	INSERT INTO @tempDFMInfo
    -- DFM, No SP
    SELECT      HOST.ControlHostId AS DFMHostId, HOST.SMArrayId AS DFMHostName, '' AS DFMVersion,
				'N/A' AS DataSetId, 'N/A' AS DataSetName,
                'N/A' AS StorageServiceId, 'N/A' AS StorageServiceName,
                'N/A' AS NodeId, 'N/A',
                0 AS SubClientId, 'N/A' AS SubClientName,
                0 AS ClientId, 'N/A' AS ClientName,
                0 AS StoragePolicyId, 'N/A' AS StoragePolicyName,
                0 AS StoragePolicyCopyId, 'N/A' AS StoragePolicyCopyName,
                'OCUM with no associated Storage Policy' AS Description, 0, 0
    FROM SMControlHost(NOLOCK) HOST
                LEFT JOIN ArchGroupControlHost(NOLOCK) AG_HOST
                ON HOST.ControlHostId = AG_HOST.ControlHostId
    WHERE       (HOST.SMHostFlags & 1) = 1
                AND AG_HOST.ControlHostId IS NULL
	UPDATE	@tempDFMInfo
	SET		Version = (	CASE
							WHEN HOST.SMHostOption = 2 THEN '6.x'
							ELSE '5.x'
						END )
	FROM	@tempDFMInfo DFM
			INNER JOIN SMControlHost HOST
			ON HOST.ControlHostId = DFM.ControlHostId
			AND HOST.SMHostFlags & 1 = 1
	UPDATE	@tempDFMInfo
	SET		TotalSnapCount = T.SnapCount
	FROM	(	SELECT	VOL.AppId, VOL.CopyId, COUNT(CHECKSUM(SNAP.GroupId, SNAP.UniqueIdentifier)) AS SnapCount
				FROM	@tempDFMInfo TEMP
						INNER JOIN SMVolume VOL (NOLOCK) ON VOL.CopyId = TEMP.StoragePolicyCopyId AND VOL.AppId = TEMP.SubClientId
						INNER JOIN SMVolSnapMap (NOLOCK) MAP ON VOL.SMVolumeId = MAP.SMVolumeId
						INNER JOIN SMSnap (NOLOCK) SNAP ON MAP.SMSnapId = SNAP.SMSnapId
						GROUP BY VOL.AppId, VOL.CopyId	) T
	WHERE	StoragePolicyCopyId = T.CopyId AND SubClientId = T.AppId
	UPDATE	@tempDFMInfo
	SET		ValidSnapCount = T.SnapCount
	FROM	(	SELECT	VOL.AppId, VOL.CopyId, COUNT(CHECKSUM(SNAP.GroupId, SNAP.UniqueIdentifier)) AS SnapCount
				FROM	@tempDFMInfo TEMP INNER JOIN SMVolume VOL (NOLOCK)
							ON VOL.CopyId = TEMP.StoragePolicyCopyId AND VOL.AppId = TEMP.SubClientId AND VOL.PruneFlags = 1 /*MM_SM_PRUNEFLAGS_ACTIVE */
						INNER JOIN archFile AF (NOLOCK)
							ON AF.id = VOL.ArchFileId AND VOL.CommCellId = AF.commCellId AND VOL.JobId = AF.jobId AND VOL.AppId = AF.appId AND AF.isValid = 1
						INNER JOIN archFileCopy AFC (NOLOCK)
							ON AF.id = AFC.archFileId AND AFC.archCopyId = VOL.CopyId AND AFC.isValid = 1
						INNER JOIN SMVolSnapMap (NOLOCK) MAP ON VOL.SMVolumeId = MAP.SMVolumeId
						INNER JOIN SMSnap (NOLOCK) SNAP ON MAP.SMSnapId = SNAP.SMSnapId
						GROUP BY VOL.AppId, VOL.CopyId	) T
	WHERE	StoragePolicyCopyId = T.CopyId AND SubClientId = T.AppId
	SELECT	OnCommandUnifiedManager AS 'OCUM',
			Version AS 'OCUM Version',
			StorageServiceName AS 'Storage Service Name',
			NodeType AS 'Node Type',
			CASE
				WHEN StoragePolicyName <> 'N/A' AND StoragePolicyCopyName <> 'N/A'
					THEN StoragePolicyName + ' (' + StoragePolicyCopyName + ')'
				WHEN StoragePolicyName <> 'N/A' AND StoragePolicyCopyName = 'N/A'
					THEN StoragePolicyName
				ELSE 'N/A'
			END AS 'Storage Policy (Copy)',
			DataSetName AS 'DataSet Name',
			ClientName AS 'Client',
			SubClientName AS 'Subclient',
			CONVERT(NVARCHAR(64), TotalSnapCount) + ' (' + CONVERT(NVARCHAR(64), ValidSnapCount) + ')' AS 'Total Snap Count (Valid)',
			Description,
			ControlHostId AS 'OCUM Host Id',
			StorageServiceId AS 'Storage Service Id',
			NodeId AS 'Node Id',
			StoragePolicyId AS 'Storage Policy Id',
			StoragePolicyCopyId AS 'Copy Id',
			DataSetId AS 'DataSet Id',
			ClientId AS 'Client Id',
			SubClientId AS 'Subclient Id'
	FROM @tempDFMInfo
	ORDER BY ControlHostId, ClientId, SubClientId
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMDFMStorageServiceRpt')
	delete from GxQscripts where name = 'MM_SMDFMStorageServiceRpt'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMDFMStorageServiceRpt')
	delete from GXDBVersions where aliasname = 'MM_SMDFMStorageServiceRpt'
GO

insert into GXDBVersions values(2, 'MM_SMDFMStorageServiceRpt',  '00000000000000000000', 'MM_SMDFMStorageServiceRpt', '00000000000000000000')
GO

