

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMDBPruneVolSnaps.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMDBPruneVolSnaps.sp,v $ $Id: MM_SMDBPruneVolSnaps.sp,v 1.4.2.8 2020/09/17 01:27:23 kkumar Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MM_SMDBPruneVolSnaps')
BEGIN
	print '>>> Drop Stored Procedure: MM_SMDBPruneVolSnaps <<<'
	drop procedure MM_SMDBPruneVolSnaps
END
IF EXISTS (select * from GxQscripts where name='MM_SMDBPruneVolSnaps')
	delete from GxQscripts where name = 'MM_SMDBPruneVolSnaps'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMDBPruneVolSnaps')
	delete from GXDBVersions where aliasname = 'MM_SMDBPruneVolSnaps'
GO
print '... Creating Procedure: MM_SMDBPruneVolSnaps'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMDBPruneVolSnaps
  @i_options INTEGER,
  @i_flags INTEGER
AS
  DECLARE @retVal INTEGER;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
BEGIN
	IF object_id('tempdb.dbo.#ToBeDeletedVols') IS NOT null DROP TABLE #ToBeDeletedVols
	CREATE TABLE #ToBeDeletedVols (
			SMVolumeId integer,
			ArchFileId integer,
			CommCellId integer,
			CopyId integer,
			primary key (SMVolumeId, ArchFileId, CommCellId, CopyId)
		)
	SET @retVal = 0
	-----------------------------------------------------------------------------------
	--  Deletion of volume entries which are for mirror copies of parents VSA v2 where no afilecopy exists
	--  and their source copy volume entries are removed too for same afile
	-----------------------------------------------------------------------------------
	DECLARE @tblDanglingMirror Table ( SMVolumeId INT )
	INSERT 	INTO	@tblDanglingMirror
	SELECT DISTINCT MIR_VOL.SMVolumeId
	FROM    SMVolume MIR_VOL (READUNCOMMITTED)
		INNER JOIN archGroupCopy MIR_AGC (READUNCOMMITTED)
			ON MIR_VOL.CopyId = MIR_AGC.id
				AND MIR_AGC.isMirrorCopy = 1
				AND MIR_AGC.isSnapCopy = 1
				--AND MIR_VOL.PruneFlags = 4
				AND MIR_VOL.MasterJobId = MIR_VOL.JobId
AND MIR_VOL.VolumeFlags & CAST( 4294967296 as bigint) > 0 /*CVSM_VOLUMEFLAGS_VSA_V2_SNAP_DB*/
		LEFT OUTER JOIN archFileCopy MIR_AFC (READUNCOMMITTED)
			ON MIR_AFC.archFileId = MIR_VOL.ArchFileId
				AND MIR_AFC.archCopyId = MIR_VOL.CopyId
				AND MIR_AFC.CommcellId = MIR_VOL.CommcellId
		INNER JOIN archGroupCopy SRC_AGC (READUNCOMMITTED)
			ON MIR_AGC.SourceCopyId = SRC_AGC.id
		LEFT OUTER JOIN SMVolume SRC_VOL (READUNCOMMITTED)
			ON MIR_VOL.archFileId = SRC_VOL.archFileId
			AND MIR_VOL.CommcellId = SRC_VOL.CommcellId
		    AND SRC_AGC.id	= SRC_VOL.CopyId
	WHERE    SRC_VOL.SMVolumeId IS NULL
			AND MIR_AFC.archFileId IS NULL
	-- Prune EDC prepared
	INSERT INTO #ToBeDeletedVols
	SELECT A.SMVolumeId, A.ArchFileId, A.CommCellId, A.CopyId
	FROM SMVolume A WITH (NOLOCK), JMPreparedJob B WITH (NOLOCK)
	WHERE A.JobId = B.JobId
	AND A.CommCellId = B.CommCellId
	DELETE #ToBeDeletedVols
	FROM #ToBeDeletedVols A, ArchFileCopy B WITH (NOLOCK)
	WHERE A.ArchFileId = B.ArchFileId
	AND A.CommCellId = B.CommCellId
	AND A.CopyId = B.ArchCopyId
	INSERT INTO #ToBeDeletedVols
	SELECT A.SMVolumeId, A.ArchFileId, A.CommCellId, A.CopyId
	FROM SMVolume A WITH (NOLOCK)
WHERE (A.MountStatus = 99 OR
			EXISTS (SELECT id FROM ArchGroupCopy WITH (NOLOCK) WHERE id = A.CopyId AND isSnapCopy = 1 AND isMirrorCopy = 1 AND
((flags & 1073741824) = 1073741824))
			)
	AND A.SMVolumeId NOT IN (SELECT SMVolumeId FROM #ToBeDeletedVols)
	------------------------------------------------------------------
	-- Cleanup snap volumes that have failed (in prepare phase with
	-- ControlHostId = 0 for Non-Native Snap Engines) snap volumes
	-- No rolling back
	------------------------------------------------------------------
	INSERT	INTO #ToBeDeletedVols
	SELECT	DISTINCT VOL.SMVolumeId, VOL.ArchFileId, VOL.CommCellId, VOL.CopyId
	FROM	SMVolume VOL WITH (NOLOCK) INNER JOIN SMVolSnapMap MAP WITH (NOLOCK) ON VOL.SMVolumeId = MAP.SMVolumeId
			INNER JOIN SMSnap SNAP WITH (NOLOCK) ON MAP.SMSnapId = SNAP.SMSnapId
	WHERE	SNAP.ControlHostId = 0
AND SNAP.SnapShotEngineId NOT IN ( 1, 53, 48,
58, 59 )
			AND VOL.JobId NOT IN (SELECT JobId FROM JMJobInfo WITH (NOLOCK))
AND VOL.PruneFlags <> 1
AND ( VOL.MountStatus < 39 /*SM_VS_CRT_CREATED*/ OR VOL.MountStatus = 98 /*SM_VS_DEL_FAILED*/ )
			AND	VOL.SMVolumeId NOT IN (SELECT SMVolumeId FROM #ToBeDeletedVols)
	-- Get the linked cloned DFM volumes set through SMVolSnapInfo::clone()
	-- Get all the mirrored copies for the source snaps which are going to be deleted
    WHILE EXISTS 	(SELECT T.SMVolumeId
					FROM #ToBeDeletedVols T, SMVolume S WITH (NOLOCK), ArchGroupCopy AGC  WITH (NOLOCK)
					WHERE T.SMVolumeId = S.ReserveField1
						AND S.SMVolumeId NOT IN (SELECT SMVolumeId FROM #ToBeDeletedVols)
						AND S.CopyID = AGC.id
						AND AGC.IsSnapCopy = 1
						AND AGC.IsMirrorCopy = 1)
    BEGIN
		INSERT INTO #ToBeDeletedVols
		SELECT S.SMVolumeId, S.ArchFileId, S.CommCellId, S.CopyId
		FROM #ToBeDeletedVols T, SMVolume S WITH (NOLOCK), ArchGroupCopy AGC WITH (NOLOCK)
		WHERE T.SMVolumeId = S.ReserveField1
			AND S.SMVolumeId NOT IN (SELECT SMVolumeId FROM #ToBeDeletedVols)
			AND S.CopyID = AGC.id
			AND AGC.IsSnapCopy = 1
			AND AGC.IsMirrorCopy = 1
	END
	-- get dangling vsa v2.1 parent mirror volumes too , whose source snaps are gone, they dont have afilecopy id and they are marked prunable
	INSERT INTO #ToBeDeletedVols
	SELECT VOL.SMVolumeId, VOL.ArchFileId, VOL.CommCellId, VOL.CopyId
	FROM @tblDanglingMirror Mirror_VOl, SMVolume VOL WITH (NOLOCK)
	WHERE Mirror_VOl.SMVolumeId = VOL.SMVolumeId AND Mirror_VOl.SMVolumeId NOT IN (SELECT SMVolumeId FROM #ToBeDeletedVols)
	DECLARE @tblMntMirrorVols TABLE (SMVolumeID INT, archFileId INT, CopyId INT, CommcellId INT, SourceVolId INT)
	INSERT INTO @tblMntMirrorVols
	select VOL.SMVolumeId, VOL.ArchFileId, VOL.CopyId, VOL.CommCellId, VOL.ReserveField1
	FROM SMSnapResource RES (NOLOCK)
			INNER JOIN SMVolume VOL (NOLOCK) ON VOL.SMVolumeId = RES.SMVolumeId AND VOL.PruneFlags > 1 AND VOL.PruneFlags < 7
			INNER JOIN archGroupCopy AGC (NOLOCK) ON VOL.CopyId = AGC.id AND AGC.isMirrorCopy = 1
	WHILE EXISTS (	SELECT VOL.SMVolumeId, VOL.ArchFileId, VOL.CopyId, VOL.CommCellId, VOL.ReserveField1
	from @tblMntMirrorVols TMP
	INNER JOIN SMVolume VOL (NOLOCK) ON TMP.archFileId = VOL.ArchFileId AND TMP.CommcellId = VOL.CommCellId AND VOL.SMVolumeID = TMP.SourceVolId
	INNER JOIN archGroupCopy AGC (NOLOCK) ON TMP.CopyId = AGC.id AND AGC.IsSnapCopy = 1 AND AGC.IsMirrorCopy = 1
	AND VOL.SMVolumeID NOT IN (SELECT SMVolumeId FROM @tblMntMirrorVols) )
	BEGIN
		INSERT INTO @tblMntMirrorVols
		SELECT VOL.SMVolumeId, VOL.ArchFileId, VOL.CopyId, VOL.CommCellId, VOL.ReserveField1
		from @tblMntMirrorVols TMP
		INNER JOIN SMVolume VOL (NOLOCK) ON TMP.archFileId = VOL.ArchFileId AND TMP.CommcellId = VOL.CommCellId AND VOL.SMVolumeID = TMP.SourceVolId
		INNER JOIN archGroupCopy AGC (NOLOCK) ON TMP.CopyId = AGC.id AND AGC.IsSnapCopy = 1 AND AGC.IsMirrorCopy = 1
		AND VOL.SMVolumeID NOT IN (SELECT SMVolumeId FROM @tblMntMirrorVols)
	END
	DELETE	TMP
	FROM	#ToBeDeletedVols TMP
			INNER JOIN @tblMntMirrorVols TMNT
			ON TMP.SMVolumeId = TMNT.SMVolumeID
	-- Remove volumes from ToBeDeletedVols list which are having mounts\clones in smmountvolume
	-- As it will fail the whole batch and causes TRs as test clones may have long expiry.
	-- TR - 19 (V11) - Norfolk Southern - F507F - Sp19 Snapshots failing to clear from HDS array - 200811-378 CVLT::0487049980
	DELETE	TMP
	FROM	#ToBeDeletedVols TMP
			INNER JOIN SMMountVolume  TMNTVol
				ON TMP.SMVolumeId = TMNTVol.SMVolumeID
WHERE  TMNTVol.MountStatus < 79 /*SM_VS_UMT_UNMOUNTED*/
	-- Get volsnap entries from failed auxcopy attempts
	DECLARE @tmpAuxCopyFailAttempt TABLE (ArchFileId INT, CopyId INT, CommCellId INT, AuxCopyJobId INT)
	INSERT INTO @tmpAuxCopyFailAttempt
	SELECT	VOL.archfileId, VOL.CopyId, VOL.commcellid, MAX(ISNULL(ACC.adminJobId, 0))
	FROM	SMvolume VOL (NOLOCK)
			INNER JOIN archGroupCopy AGC (NOLOCK)
ON AGC.id = VOL.CopyId AND AGC.isSnapCopy = 1 AND AGC.extendedFlags & 256 <> 256
			INNER JOIN archGroup AG (NOLOCK) ON AG.id = AGC.archGroupId AND AG.defaultSnapCopy <> AGC.id
			LEFT OUTER JOIN archChunkToCopyHistory ACC (NOLOCK) ON VOL.ArchFileId = ACC.archFileId
				AND VOL.CopyId = ACC.destCopyId AND VOL.CommCellId = ACC.commCellId
WHERE	VOL.MountStatus = 10
	GROUP	BY VOL.archfileId, VOL.CopyId, VOL.commcellid
	DELETE TMP
	FROM @tmpAuxCopyFailAttempt TMP
		INNER JOIN JMAdminJobInfoTable JOB (NOLOCK) ON JOB.jobId = TMP.AuxCopyJobId AND JOB.commCellId = TMP.commCellId AND JOB.opType in (13, 104)
	DELETE TMP
	FROM @tmpAuxCopyFailAttempt TMP
		INNER JOIN #ToBeDeletedVols VOL ON TMP.ArchFileId = VOL.ArchFileId AND TMP.CommCellId = vol.CommCellId AND TMP.CopyId = VOL.CopyId
	INSERT	INTO #ToBeDeletedVols
	SELECT	VOL.SMVolumeId, VOL.ArchFileId, VOL.CommCellId, VOL.CopyId
	FROM	@tmpAuxCopyFailAttempt TMP
			INNER JOIN SMvolume VOL (NOLOCK) ON VOL.ArchFileId = TMP.ArchFileId AND VOL.CopyId = TMP.CopyId
				AND VOL.CommCellId = TMP.CommCellId
	EXEC @retVal = MM_SMDeleteVolSnaps 1, 0
	IF @retVal <> 0
		GOTO FINISH
FINISH:
DROP TABLE #ToBeDeletedVols
SELECT	@retVal
RETURN	@retVal
END
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMDBPruneVolSnaps')
	delete from GxQscripts where name = 'MM_SMDBPruneVolSnaps'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMDBPruneVolSnaps')
	delete from GXDBVersions where aliasname = 'MM_SMDBPruneVolSnaps'
GO

insert into GXDBVersions values(2, 'MM_SMDBPruneVolSnaps',  '00010004000200080000', 'MM_SMDBPruneVolSnaps', '00010004000200080000')
GO

