

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMCreateSnapToSnapRelation.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMCreateSnapToSnapRelation.sp,v $ $Id: MM_SMCreateSnapToSnapRelation.sp,v 1.5.210.1 2018/03/20 00:07:05 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MM_SMCreateSnapToSnapRelation <<<'

IF EXISTS (select * from sysobjects where name='MM_SMCreateSnapToSnapRelation')
	drop procedure MM_SMCreateSnapToSnapRelation
IF EXISTS (select * from GxQscripts where name='MM_SMCreateSnapToSnapRelation')
	delete from GxQscripts where name = 'MM_SMCreateSnapToSnapRelation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMCreateSnapToSnapRelation')
	delete from GXDBVersions where aliasname = 'MM_SMCreateSnapToSnapRelation'
GO
print '... Creating Procedure: MM_SMCreateSnapToSnapRelation'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMCreateSnapToSnapRelation
  @i_xmlTextInput XML,
  @i_reserveParam INTEGER
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @ErrorVolId			INTEGER
DECLARE @ErrorCode			INTEGER
DECLARE @ErrorStr			VARCHAR(1024)
DECLARE @SnapToSnapId			INTEGER
DECLARE @CopyId				INTEGER
DECLARE @docHandle			INTEGER
create table #tempNoHostList (hostName nvarchar(250))
	EXEC sp_xml_preparedocument @docHandle OUTPUT, @i_xmlTextInput
	SELECT
			tXml.SrcHostName			as 'SrcHostName',
			tXml.SrcPath				as 'SrcPath',
			tXml.TgtHostName			as 'TgtHostName',
			tXml.TgtPath				as 'TgtPath',
			tXml.RelationType			as 'RelationType'
	INTO #tempRelation
	FROM
		OPENXML(@docHandle, 'EVGui_NetAppSVSMRelationList/lSVSMRelationList', 0)
		WITH
		(
			SrcHostName			VARCHAR(1024) 	'@sSrcHostName',
			SrcPath				VARCHAR(1024)	'@sSrcPath',
			TgtHostName			VARCHAR(1024)	'@sTgtHostName',
			TgtPath				VARCHAR(1024)	'@sTgtPath',
			RelationType			VARCHAR(10)	'@sRelationType'
		) as tXml
	set @ErrorCode = @@ERROR
	if (@ErrorCode <> 0)
	BEGIN
		SET @ErrorStr = 'ERROR: MM_SMCreateSnapToSnapRelation -- #tempRelation -- Insert '
		GOTO CX_EXIT
	END
	Insert into #tempNoHostList
	SELECT T.SrcHostName from #tempRelation T Where T.SrcHostName not in (select SMArrayId from SMControlHost)
	union
	SELECT T.TgtHostName from #tempRelation T where T.TgtHostName not in (select SMArrayId from SMControlHost)
	--Delete those row where host is not found.
	Delete from #tempRelation
	where #tempRelation.SrcHostName not in (select SMArrayId from SMControlHost)
	Delete from #tempRelation
	where #tempRelation.TgtHostName not in (select SMArrayId from SMControlHost)
-- Reconcile the relations here.
	-- Insert the relations to SMSnapToSnap which are available in XML but not in table.
	INSERT INTO SMSnapToSnap (SrcCtrlHostId, SrcPath, TgtCtrlHostId, TgtPath, CopyId, OrigCCId, ReserveField1, ReserveField2, ReserveFieldStr)
	SELECT (SELECT ControlHostId FROM SMControlHost SMCH WHERE SMArrayId = T.SrcHostName),
	T.SrcPath,
	(SELECT ControlHostId FROM SMControlHost SMCH WHERE SMArrayId = T.TgtHostName),
	T.TgtPath, 0, 0, (case when T.RelationType = 'SV' then 1 when T.RelationType = 'SM' then 2 end), 0, ''
	FROM #tempRelation T
	EXCEPT
	SELECT SMSS.SrcCtrlHostId, SMSS.SrcPath, SMSS.TgtCtrlHostId, SMSS.TgtPath, 0, 0, SMSS.ReserveField1, 0, ''
	FROM SMSnapToSnap SMSS
	--Update the relations as inactive which are available in the table but not in the DB.
	UPDATE SMSnapToSnap
	SET ReserveField2 = ReserveField2 | 1
	from (
							SELECT SMSS.SrcCtrlHostId, SMSS.SrcPath, SMSS.TgtCtrlHostId, SMSS.TgtPath, SMSS.ReserveField1
							FROM SMSnapToSnap SMSS, SMControlHost SMCH, #tempRelation T
							WHERE SMSS.SrcCtrlHostId = SMCH.ControlHostId
							and SMCH.SMArrayId = T.SrcHostName
							and SMSS.SnapToSnapId > 0
							EXCEPT
							(SELECT (SELECT ControlHostId FROM SMControlHost SMCH WHERE SMCH.SMArrayId = T.SrcHostName),
							T.SrcPath,
							(SELECT ControlHostId FROM SMControlHost SMCH WHERE SMCH.SMArrayId = T.TgtHostName),
							T.TgtPath,
							(case when T.RelationType = 'SV' then 1 when T.RelationType = 'SM' then 2 end)
							FROM #tempRelation T
							)) as Temp
	WHERE SMSnapToSnap.SrcCtrlHostId = Temp.SrcCtrlHostId
	and SMSnapToSnap.SrcPath = Temp.SrcPath
	and SMSnapToSnap.TgtCtrlHostId = Temp.TgtCtrlHostId
	and SMSnapToSnap.TgtPath = Temp.TgtPath
        and SMSnapToSnap.ReserveField1 = Temp.ReserveField1
	-- Return All list of snap relations
		SELECT hostName as '@val'
		FROM #tempNoHostList A WITH (NOLOCK)
		FOR XML PATH ('srcCtrlHostNameList'),ROOT('EVGui_DetectSVSMRelationResp')
CX_EXIT:
IF OBJECT_ID('tempdb.dbo.#tempRelation') is not null DROP TABLE #tempRelation
RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMCreateSnapToSnapRelation')
	delete from GxQscripts where name = 'MM_SMCreateSnapToSnapRelation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMCreateSnapToSnapRelation')
	delete from GXDBVersions where aliasname = 'MM_SMCreateSnapToSnapRelation'
GO

insert into GXDBVersions values(2, 'MM_SMCreateSnapToSnapRelation',  '00010005021000010000', 'MM_SMCreateSnapToSnapRelation', '00010005021000010000')
GO

