

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMConvertOracleTestCloneToPerm.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MM_SMConvertOracleTestCloneToPerm <<<'

IF EXISTS (select * from sysobjects where name='MM_SMConvertOracleTestCloneToPerm')
	drop procedure MM_SMConvertOracleTestCloneToPerm
IF EXISTS (select * from GxQscripts where name='MM_SMConvertOracleTestCloneToPerm')
	delete from GxQscripts where name = 'MM_SMConvertOracleTestCloneToPerm'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMConvertOracleTestCloneToPerm')
	delete from GXDBVersions where aliasname = 'MM_SMConvertOracleTestCloneToPerm'
GO
print '... Creating Procedure: MM_SMConvertOracleTestCloneToPerm'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMConvertOracleTestCloneToPerm
  @i_cloneJobId INT
AS
  DECLARE @o_errorCode integer
  DECLARE @o_ErrorMsg varchar(1024)
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
BEGIN TRY
	SET @o_errorCode = 0
	DECLARE @tblMD TABLE
	(
		MetaDataId	int,
		MetaData	XML
		PRIMARY KEY (MetaDataId)
	)
IF EXISTS ( SELECT 1 FROM SMMountVolume (NOLOCK) WHERE MountJobId = @i_cloneJobId AND MountStatus <> 59 )
	BEGIN
SET @o_errorCode = 60357
		SET @o_ErrorMsg = 'One or more volume(s) is not in mounted state. Cannot convert clone to permanent clone. '
		SELECT	@o_errorCode, @o_ErrorMsg
		RETURN	@o_errorCode
	END
	INSERT INTO @tblMD
	SELECT	MetaDataId,  CONVERT(xml,REPLACE(Metadata, 'UTF-8', 'UTF-16'))
	FROM	SMMetaData
	WHERE	RefId IN ( SELECT Id FROM SMMountVolume WHERE MountJobId = @i_cloneJobId )
AND RefType = 10
AND MetaDataType = 38
	-- Check if attribute cloneForEver is present. If present, update its value. If not present, add this attribute
	UPDATE	@tblMD
	SET		MetaData.modify('
	insert attribute cloneForEver {"1"}
	into (/Ida_OracleTestCloneMetaData[1])')
	WHERE	 MetaData.exist('(/Ida_OracleTestCloneMetaData/@cloneForEver)[1]') = 0
	UPDATE	@tblMD
	SET		MetaData.modify('
	replace value of (/Ida_OracleTestCloneMetaData/@cloneForEver)[1] with "1"')
	WHERE	 MetaData.exist('(/Ida_OracleTestCloneMetaData/@cloneForEver)[1]') = 1
	UPDATE	MD
	SET		MetaData = '<?xml version="1.0" encoding="UTF-8" standalone="no" ?>' + CONVERT(NVARCHAR(MAX),TBL.Metadata)
	FROM	@tblMD TBL INNER JOIN SMMetaData MD ON TBL.MetaDataId = MD.MetaDataId
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @o_errorCode = ERROR_NUMBER()
	SET @o_ErrorMsg = ERROR_MESSAGE()
	SELECT	@o_errorCode, @o_ErrorMsg
	RETURN
END CATCH
	SELECT	@o_errorCode, @o_ErrorMsg
	RETURN @o_errorCode
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMConvertOracleTestCloneToPerm')
	delete from GxQscripts where name = 'MM_SMConvertOracleTestCloneToPerm'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMConvertOracleTestCloneToPerm')
	delete from GXDBVersions where aliasname = 'MM_SMConvertOracleTestCloneToPerm'
GO

insert into GXDBVersions values(2, 'MM_SMConvertOracleTestCloneToPerm',  '00000000000000000000', 'MM_SMConvertOracleTestCloneToPerm', '00000000000000000000')
GO

