

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMCleanupVolumeMountsMNM.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMCleanupVolumeMountsMNM.sp,v $ $Id: MM_SMCleanupVolumeMountsMNM.sp,v 1.1.2.14 2020/08/18 21:02:29 rksingh Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MM_SMCleanupVolumeMountsMNM')
BEGIN
	print '>>> Drop Stored Procedure: MM_SMCleanupVolumeMountsMNM <<<'
	drop procedure MM_SMCleanupVolumeMountsMNM
END
IF EXISTS (select * from GxQscripts where name='MM_SMCleanupVolumeMountsMNM')
	delete from GxQscripts where name = 'MM_SMCleanupVolumeMountsMNM'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMCleanupVolumeMountsMNM')
	delete from GXDBVersions where aliasname = 'MM_SMCleanupVolumeMountsMNM'
GO
print '... Creating Procedure: MM_SMCleanupVolumeMountsMNM'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MM_SMCleanupVolumeMountsMNM
  @dummy integer
AS
  DECLARE @o_MountHostId integer
  DECLARE @o_JobId integer
  DECLARE @o_SMVolSnapMapId integer
  DECLARE @o_SMVolumeId integer
  DECLARE @o_SMSnapId integer
  DECLARE @o_MetaDataId integer
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	DECLARE @RetryParam integer
SET @RetryParam = ISNULL((select Value from MMConfigs(NOLOCK) where name = 'MMS2_CONFIG_VOLSNAP_RETRY_COUNT'), 50)
	IF object_id('tempdb.dbo.#tblMNMVolList') IS NOT Null DROP TABLE #tblMNMVolList
	CREATE TABLE #tblMNMVolList (
		SMVolumeId		integer,
		MntVolumeId		integer,
		MountHostId		integer,
		MountStatus		integer,
		MountJobId		integer,
		SnapJobId		integer,
		CopyId			integer,
		VolMntHostId	integer,
		Flags			integer,
		UpdateTime		integer,
		RetryCount		integer,
		ExpirationTime	integer,
		MountOptions	integer,
		isMountHostOffline integer,
		swapCoordCtrl	integer,
		appTypeId		integer
		)
	-- Job State - Pending (Include\CvLib\EvLookup.h)
	DECLARE @JOB_STATE_PENDING INTEGER;
	SET @JOB_STATE_PENDING = 2
	-- Job Status - Killed (Include\JobManager\CVjob.h)
	DECLARE @JOB_STATUS_KILLED INTEGER;
	SET @JOB_STATUS_KILLED = 4
	DECLARE @JOB_STATUS_FAILED INTEGER;
	SET @JOB_STATUS_FAILED = 2
	DECLARE @JOB_STATUS_SUCCESS INTEGER;
	SET @JOB_STATUS_SUCCESS = 1
	DECLARE @VOL_TO_UNMOUNT integer = 4
	-- Constant Definition as in EvDebug.h
	DECLARE @JOBID_NA INTEGER;
	SET @JOBID_NA = -123456
	DECLARE @CurrentTime INTEGER;
	SET @CurrentTime = dbo.GetUnixTime(GetUTCDate())
	DECLARE @DayInSeconds INTEGER;
	SET @DayInSeconds = 86400
	-- Failed Mount & Unmount Volumes
	INSERT	INTO #tblMNMVolList
	SELECT	DISTINCT MV.SMVolumeId, MV.Id, MV.MountHostId, MV.MountStatus, MV.MountJobId,VOL.JobId, VOL.CopyId, VOL.MountHostId, @VOL_TO_UNMOUNT, MV.MountStatusUpdateTime, MV.RetryCount, (MV.MountStatusUpdateTime + (ENG.MountStatusUpdateExpiryInterval * 60)),
			( CASE WHEN ISNUMERIC( MV.mountOptions ) = 1 THEN MV.mountOptions ELSE 0 END ),0,0, VOL.AppTypeId
	FROM	SMMountVolume MV (NOLOCK) INNER JOIN SMVolSnapMap MAP (NOLOCK) ON MV.SMVolumeId = MAP.SMVolumeId
			INNER JOIN SMVolume VOL (NOLOCK) ON VOL.SMVolumeId = MV.SMVolumeId
			INNER JOIN SMSnap SNAP (NOLOCK) ON MAP.SMSnapId = SNAP.SMSnapId
			INNER JOIN SMSnapShotEngine ENG (NOLOCK) ON ENG.SnapShotEngineId = SNAP.SnapShotEngineId
			INNER JOIN SMControlHost CTRL(NOLOCK) ON CTRL.ControlHostId = SNAP.ControlHostId
WHERE   MV.MountFlags & (2048 | 32 | 64) = 0 /* Exclude test clone &  SCSI server mounts */
AND MV.MountStatus < 79
AND ( (CTRL.Flags & 2) = 0)
			AND MV.RetryCount < @RetryParam
			AND
			(
				(
					(
						MV.MountJobId > 0
						AND
						(MV.MountJobId NOT IN (SELECT DISTINCT jobId FROM JMJobInfo (NOLOCK))
							OR MV.MountJobId IN (SELECT DISTINCT jobId FROM JMJobInfo (NOLOCK) WHERE STATE = @JOB_STATE_PENDING))
						AND MV.SMVolumeId NOT IN (SELECT SMVolumeId FROM SMSnapResource WHERE JobId <> MV.MountJobId)
					)
					AND
					(
						-- Already attempted Cleanups
( MV.MountStatus > 59 AND (MV.MountStatusUpdateTime + (ENG.MountStatusUpdateExpiryInterval * 60)) < @CurrentTime )
						OR
						-- Failed or successfully mounted snap volumes
( MV.MountStatus <= 59 )
					)
				)
				OR
				(
					MV.MountJobId = @JOBID_NA
					AND
					(
						-- Cases where current snap reservation would already be removed
( ( MV.MountStatus <= 59 OR (MV.MountStatus > 59 AND (MV.MountStatusUpdateTime + (ENG.MountStatusUpdateExpiryInterval * 60)) < @CurrentTime) )
							AND
							NOT EXISTS (SELECT RES.SMResourceId FROM SMSnapResource RES
							WHERE RES.SMVolumeId = MV.SMVolumeId ) )
					)
				)
			)
	-- Do not send an unmount for the controllers if the coordinator is not eligible for unmount
	DELETE	VOL
	FROM	#tblMNMVolList VOL
	WHERE	VOL.MountJobId IN (
		SELECT	MVOL.MountJobId
		FROM	SMMountVolume MVOL (NOLOCK)
				LEFT JOIN #tblMNMVolList T ON T.MntVolumeId = MVOL.Id
		WHERE	MVOL.MountJobId IN (SELECT MountJobId FROM #tblMNMVolList )
AND ( ( CASE WHEN ISNUMERIC( MVOL.MountOptions ) = 1 THEN MVOL.MountOptions ELSE 0 END ) & 1 /*SM_VSA_MOUNT_MODE_COORDINATOR*/ = 1 /*SM_VSA_MOUNT_MODE_COORDINATOR*/)
				AND T.MntVolumeId IS NULL)
	-- Send unmount request only when there is no regular mounts on these snapshots
	-- If the volume is mounted, remove all corresponding entries for the entire mount job.
	DELETE	T
	FROM	#tblMNMVolList T
			INNER JOIN #tblMNMVolList V ON V.SnapJobId = T.SnapJobId AND V.CopyId = T.copyId
	WHERE	V.VolMntHostId > 0
	-- Get the list of the offline MediaAgents
	UPDATE	A
	SET		A.isMountHostOffline = (CASE WHEN B.ClientId IS NULL OR B.MmHostSoftState = 0 OR B.MmHostEnabled = 0 THEN 1 ELSE 0 END)
	FROM	#tblMNMVolList A LEFT OUTER JOIN MMHost B (NOLOCK) ON A.MountHostId = B.ClientId
	-- Get the Jobs for which we need to swap the coordinators and controllers. This needs to be done only for VMware iDA
	UPDATE	VOL
	SET		VOL.swapCoordCtrl = 1
	FROM	#tblMNMVolList VOL INNER JOIN
			(SELECT CTRL.MountJobId
			FROM	#tblMNMVolList CTRL INNER JOIN #tblMNMVolList COORD ON CTRL.MountJobId = COORD.MountJobId
WHERE	( COORD.MountOptions & 1 /*SM_VSA_MOUNT_MODE_COORDINATOR*/ = 1 /*SM_VSA_MOUNT_MODE_COORDINATOR*/)
					AND COORD.isMountHostOffline = 1
AND ( CTRL.MountOptions & 2 /*SM_VSA_MOUNT_MODE_CONTROLLER*/ = 2 /*SM_VSA_MOUNT_MODE_CONTROLLER*/)
					AND CTRL.isMountHostOffline = 0
AND COORD.appTypeId = 106 and CTRL.appTypeId = 106
					) B ON VOL.MountJobId = B.MountJobId
WHERE VOL.appTypeId = 106
	-- If the co-ordinator is offline and there is atleast one controller node online, then swap the controller and the co-ordinator
	IF EXISTS ( SELECT 1 FROM #tblMNMVolList WHERE swapCoordCtrl = 1)
	BEGIN
		-- Set the co-ordinator as a controller
		UPDATE  VAL
SET		MountOptions = ( MountOptions | 2 & ~ 1 )
		FROM	#tblMNMVolList VAL
WHERE	( VAL.MountOptions & 1 /*SM_VSA_MOUNT_MODE_COORDINATOR*/ = 1 /*SM_VSA_MOUNT_MODE_COORDINATOR*/)
				AND swapCoordCtrl = 1
		-- Set the controller as a co-ordinator
		UPDATE VAL
SET		MountOptions = ( MountOptions | 1 & ~ 2 )
		FROM	#tblMNMVolList VAL INNER JOIN (
									SELECT	DISTINCT VAL1.MountJobId, MAX(VAL1.MountHostId) mntHostId
									FROM	#tblMNMVolList VAL1
WHERE	VAL1.MountOptions & 1 /* 1 */ = 0
											AND VAL1.isMountHostOffline = 0
											AND VAL1.swapCoordCtrl = 1
									GROUP BY VAL1.MountJobId ) TEMP ON VAL.MountJobId = TEMP.MountJobId AND VAL.mountHostId = TEMP.mntHostId
		WHERE	VAL.swapCoordCtrl = 1
		UPDATE	MVOL
		SET		MountOptions = VAL.MountOptions
		FROM	#tblMNMVolList VAL INNER JOIN SMMountVolume MVOL ON MVOL.Id = VAL.MntVolumeId
		WHERE	VAL.swapCoordCtrl = 1 AND ( CASE WHEN ISNUMERIC( MVOL.MountOptions ) = 1 THEN MVOL.MountOptions ELSE 0 END ) = VAL.MountOptions
		IF @@ERROR != 0 GOTO MNM_CLEANUP_EXIT
	END
	-- For non-VSA, send coordinator unmount only after all the controllers are unmounted
IF EXISTS (	SELECT 1 FROM #tblMNMVolList VAL WHERE ( VAL.MountOptions & 1 = 1 /*SM_VSA_MOUNT_MODE_COORDINATOR*/ AND VAL.AppTypeId <> 106 ))
	BEGIN
		DELETE	COORD
		FROM	#tblMNMVolList COORD
				INNER JOIN #tblMNMVolList CTRL ON CTRL.MountJobId = COORD.MountJobId
WHERE	( COORD.MountOptions & 1 /*SM_VSA_MOUNT_MODE_COORDINATOR*/ = 1 /*SM_VSA_MOUNT_MODE_COORDINATOR*/)
AND ( CTRL.MountOptions & 2 /*SM_VSA_MOUNT_MODE_CONTROLLER*/ = 2 /*SM_VSA_MOUNT_MODE_CONTROLLER*/)
AND CTRL.AppTypeId <> 106
	END
	-- Remove the requests for the MediaAgents that are offline
	DELETE FROM #tblMNMVolList WHERE isMountHostOffline = 1
	-- For VSA, If the co-ordinator is online, then dont send unmount request for the controllers
IF EXISTS (	SELECT 1 FROM #tblMNMVolList VAL WHERE ( VAL.MountOptions & 1 = 1 /*SM_VSA_MOUNT_MODE_COORDINATOR*/ AND VAL.AppTypeId = 106 ))
	BEGIN
		DELETE	CTRL
		FROM	#tblMNMVolList CTRL
				INNER JOIN #tblMNMVolList COORD ON CTRL.MountJobId = COORD.MountJobId
WHERE	( COORD.MountOptions & 1 /*SM_VSA_MOUNT_MODE_COORDINATOR*/ = 1 /*SM_VSA_MOUNT_MODE_COORDINATOR*/)
AND ( CTRL.MountOptions & 2 /*SM_VSA_MOUNT_MODE_CONTROLLER*/ = 2 /*SM_VSA_MOUNT_MODE_CONTROLLER*/)
AND CTRL.AppTypeId = 106
	END
	SELECT	DISTINCT MV.MountHostId, MV.MountJobId, MMAP.SMVolSnapMapId, MV.Id, MS.Id, MMAP.MetaDataId
	FROM	#tblMNMVolList VAL INNER JOIN SMMountVolume MV (NOLOCK) ON VAL.MntVolumeId = MV.Id AND VAL.MountJobId = MV.MountJobId
			INNER JOIN SMMountMap MMAP (NOLOCK) ON MV.Id = MMAP.SMMountVolumeId
			INNER JOIN SMMountSnap MS (NOLOCK) ON MMAP.SMMountSnapId = MS.Id AND MV.MountJobId = MS.ReserveField4
	ORDER BY MV.MountHostId, MV.Id, MS.Id, MMAP.MetaDataId
	IF object_id('tempdb.dbo.#tblMNMVolList') IS NOT Null DROP TABLE #tblMNMVolList
	RETURN
MNM_CLEANUP_EXIT:
	IF object_id('tempdb.dbo.#tblMNMVolList') IS NOT Null DROP TABLE #tblMNMVolList
	SELECT 0, 0, 0, 0, 0, 0
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMCleanupVolumeMountsMNM')
	delete from GxQscripts where name = 'MM_SMCleanupVolumeMountsMNM'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMCleanupVolumeMountsMNM')
	delete from GXDBVersions where aliasname = 'MM_SMCleanupVolumeMountsMNM'
GO

insert into GXDBVersions values(2, 'MM_SMCleanupVolumeMountsMNM',  '00010001000200140000', 'MM_SMCleanupVolumeMountsMNM', '00010001000200140000')
GO

