

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMCleanupVolumeMounts.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMCleanupVolumeMounts.sp,v $ $Id: MM_SMCleanupVolumeMounts.sp,v 1.48.2.37.12.1 2021/01/15 16:37:04 rksingh Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='MM_SMCleanupVolumeMounts')
BEGIN
	print '>>> Drop Stored Procedure: MM_SMCleanupVolumeMounts <<<'
	drop procedure MM_SMCleanupVolumeMounts
END
IF EXISTS (select * from GxQscripts where name='MM_SMCleanupVolumeMounts')
	delete from GxQscripts where name = 'MM_SMCleanupVolumeMounts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMCleanupVolumeMounts')
	delete from GXDBVersions where aliasname = 'MM_SMCleanupVolumeMounts'
GO
print '... Creating Procedure: MM_SMCleanupVolumeMounts'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure MM_SMCleanupVolumeMounts
  @dummy integer
AS
  DECLARE @o_MountHostId integer
  DECLARE @o_JobId integer
  DECLARE @o_SMVolSnapMapId integer
  DECLARE @o_SMVolumeId integer
  DECLARE @o_SMSnapId integer
  DECLARE @o_MetaDataId integer
  DECLARE @o_GroupingKey varchar(1024)
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	DECLARE @VOL_IN_ACTION integer
	DECLARE @VOL_TO_REVERT integer
	DECLARE @VOL_TO_DELETE integer
	DECLARE @VOL_TO_UNMOUNT integer
	SET @VOL_IN_ACTION = 1
	SET @VOL_TO_REVERT = 2
	SET @VOL_TO_DELETE = 3
	SET @VOL_TO_UNMOUNT = 4
	DECLARE @RetryParam integer
SET @RetryParam = ISNULL((select Value from MMConfigs(NOLOCK) where name = 'MMS2_CONFIG_VOLSNAP_RETRY_COUNT'), 50)
	DECLARE @CloneCleanupRetryFactor INTEGER
SET @CloneCleanupRetryFactor = ISNULL((select Value from MMConfigs(NOLOCK) where name = 'MMS2_CONFIG_CLONE_CLEANUP_RETRY_FACTOR'), 3)
	IF OBJECT_ID('tempdb.dbo.#tblVolList') IS NOT NULL
		DROP TABLE #tblVolList
	IF OBJECT_ID('tempdb.dbo.#tblUnmount') IS NOT NULL
		DROP TABLE #tblUnmount
	IF OBJECT_ID('tempdb.dbo.#tblValidated') IS NOT NULL
		DROP TABLE #tblValidated
	IF OBJECT_ID('tempdb.dbo.#tblValidateResult') IS NOT NULL
		DROP TABLE #tblValidateResult
	IF OBJECT_ID('tempdb.dbo.#tblRunningVol') IS NOT NULL
		DROP TABLE #tblRunningVol
	CREATE TABLE #tblVolList (
		SMVolumeId		integer,
		MountHostId		integer,
		MountStatus		integer,
		Flags			integer,
		UpdateTime		bigint,
		RetryCount		integer,
		ExpirationTime	bigint
		)
	CREATE TABLE #tblUnmount (
		SMVolumeId integer,
		MountHostId integer,
		JobId integer,
		RetryCount integer
		)
	CREATE TABLE #tblValidated (
		SMVolumeId integer,
		MountHostId integer,
		JobId integer,
		SnapJobId integer,
		MasterJobId integer
		)
	DECLARE @t_SMVolumeId INTEGER
	DECLARE @t_MountHostId INTEGER
	CREATE TABLE #tblValidateResult (
			ErrorCode integer,
			ErrorStr varchar(1024),
			MountHostId integer,
			MountStatus integer,
			PruneFlags integer,
MountPath nvarchar(1024),
			IsReserved integer,
			OpCompleted integer,
			UnmountMode integer
		)
	CREATE TABLE #tblRunningVol (
			SMVolumeId		integer
		)
	-- Job State - Pending (Include\CvLib\EvLookup.h)
	DECLARE @JOB_STATE_PENDING INTEGER;
	SET @JOB_STATE_PENDING = 2
	-- Job Status - Killed (Include\JobManager\CVjob.h)
	DECLARE @JOB_STATUS_KILLED INTEGER;
	SET @JOB_STATUS_KILLED = 4
	DECLARE @JOB_STATUS_FAILED INTEGER;
	SET @JOB_STATUS_FAILED = 2
	DECLARE @JOB_STATUS_SUCCESS INTEGER;
	SET @JOB_STATUS_SUCCESS = 1
	-- Constant Definition as in EvDebug.h
	DECLARE @JOBID_NA INTEGER;
	SET @JOBID_NA = -123456
	DECLARE @CurrentTime INTEGER;
	SET @CurrentTime = dbo.GetUnixTime(GetUTCDate())
	DECLARE @DayInSeconds INTEGER;
	SET @DayInSeconds = 86400
	DECLARE @HourInSeconds INTEGER;
	SET @HourInSeconds = 3600
	DECLARE @SnapActionCutOffTime INTEGER
	SET @SnapActionCutOffTime = @CurrentTime - @HourInSeconds
	DECLARE @DeleteTime DATETIME
	SET @DeleteTime = GETUTCDATE()
	IF @dummy > 0 GOTO ERROR_EXIT
	-- Get all volumes reserved by running, waiting and suspended jobs
	INSERT INTO #tblRunningVol
	SELECT DISTINCT A.SMVolumeId
	FROM SMSnapResource A WITH (NOLOCK), JMJobInfo B WITH (NOLOCK)
	WHERE A.JobId = B.JobId
	AND B.state in (1, 3, 5)
	------------------------------------------------------------------
	-- Reset MountStatus for volumes unmonted
	-- No rolling back
	------------------------------------------------------------------
	-- VMLTODO: Need to check what should be that in case MountHostId = 0 but MountPath is not empty
	UPDATE SMVolume
SET MountStatus = 79, MountStatusUpdateTime = @CurrentTime
	WHERE
		( MountHostId = 0 AND MountPath = N'' ) AND
( ( MountStatus >= 40 AND MountStatus < 79 ) )
	------------------------------------------------------------------
	-- Reset RetryCount for volumes whose RetryCount has exceeded the threshold and being in that state for more than 24 hours
	-- No rolling back
	------------------------------------------------------------------
	UPDATE	SMVolume
	SET		RetryCount = 1
	WHERE	RetryCount >= @RetryParam
			AND (MountStatusUpdateTime + @DayInSeconds) < @CurrentTime
	------------------------------------------------------------------
	-- Reset RetryCount for volumes whose RetryCount has exceeded the threshold and being in that state for more than 24 hours
	-- No rolling back
	------------------------------------------------------------------
	UPDATE	SMMountVolume
	SET		RetryCount = 1
	WHERE	RetryCount >= @RetryParam
			AND (MountStatusUpdateTime + @DayInSeconds) < @CurrentTime
	------------------------------------------------------------------
	-- Cleanup dangling actions
	-- No rolling back
	------------------------------------------------------------------
	DELETE SMVolAction
	FROM SMVolAction A WITH (NOLOCK), SMVolume B WITH (NOLOCK)
	WHERE
        A.SMVolumeId = B.SMVolumeId AND
        A.JobId > 0 AND A.JobId NOT IN (SELECT DISTINCT jobId FROM JMJOBINFO WITH (NOLOCK))
	------------------------------------------------------------------
	-- Release reservations for volumes unmonted
	-- No rolling back
	------------------------------------------------------------------
	-- VMLTODO: Need to check what should be that in case MountHostId = 0 but MountPath is not empty
	DELETE A
	FROM SMSnapResource A (NOLOCK)
		INNER JOIN SMVolume B (NOLOCK) ON A.SMVolumeId = B.SMVolumeId
		LEFT OUTER JOIN SMMountVolume C (NOLOCK) ON B.SMVolumeId = C.SMVolumeId AND A.JobId = C.MountJobId AND A.SnapShotId = C.Id
	WHERE
        (
        	(	A.JobId NOT IN (SELECT DISTINCT jobId FROM JMJOBINFO WITH (NOLOCK))
        		AND ( B.MountHostId = 0 AND B.MountPath = N'' ) AND
					(C.Id IS NULL OR (C.Id IS NOT NULL AND C.MountHostId = 0 AND C.MountPath = N'' ))
        	)
            OR
            (
    			-- Application Mounts incomplete for pending job
    				A.JobId != @JOBID_NA
    				AND A.JobId IN (SELECT DISTINCT jobId FROM JMJOBINFO WITH (NOLOCK) WHERE STATE = @JOB_STATE_PENDING)
    				AND B.MountHostId = 0
AND ( B.MountStatus < 40 AND B.MountStatus > 79)
    		)
            OR
            (
    				-- Snap locks of pending job
    				A.JobId != @JOBID_NA
    				AND A.JobId IN (SELECT DISTINCT jobId FROM JMJOBINFO WITH (NOLOCK) WHERE STATE = @JOB_STATE_PENDING)
AND A.FLAGS & 128 = 128
    		)
			OR
			(
				-- Application Mounts for non-running jobs
A.JobId != @JOBID_NA AND A.FLAGS & 2  <> 2
				AND A.JobId NOT IN (SELECT DISTINCT jobId FROM JMJOBINFO WITH (NOLOCK))
			)
		)
	---------------------------------------------------------------------------
	-- TimeFinder SnapVX - Delete dangling target device reservation
	---------------------------------------------------------------------------
DELETE	SMActiveSnap
FROM	SMActiveSnap ASNAP INNER JOIN SMSnap SNAP ON ASNAP.SMSnapId = SNAP.SMSnapId
WHERE	ASNAP.SMSnapId NOT IN
		(
			SELECT	DISTINCT SNAP.SMSnapId
			FROM	SMSnap SNAP WITH (READUNCOMMITTED)
			INNER JOIN SMVolSnapMap MAP WITH (READUNCOMMITTED)
				ON SNAP.SMSnapId = MAP.SMSnapId
WHERE	SNAP.SnapShotEngineId IN( 63, 87)
					AND MAP.SMVolumeId IN
					(
						---- Atleast one mounting snap in SMVolume..
SELECT    DISTINCT VOL.SMVolumeId FROM SMVolume VOL WITH (READUNCOMMITTED) WHERE VOL.MountStatus > 39 AND VOL.MountStatus < 79
						UNION
SELECT    DISTINCT MVOL.SMVolumeId FROM SMMountVolume MVOL WITH (READUNCOMMITTED) WHERE MVOL.MountStatus > 39 AND MVOL.MountStatus < 79
					)
		)
AND SNAP.SnapShotEngineId IN( 63, 87)
	------------------------------------------------------------------
	-- BEGIN TRANSACTION
	------------------------------------------------------------------
	BEGIN TRANSACTION CleanupVolumeMountsTran
	------------------------------------------------------------------
	-- Get All Volumes in Actions (from SMVolAction)
	------------------------------------------------------------------
	INSERT INTO #tblVolList
	SELECT A.SMVolumeId, A.MountHostId, A.MountStatus, @VOL_IN_ACTION,
			(CASE WHEN A.MountStatusUpdateTime > B.StartTime THEN A.MountStatusUpdateTime ELSE B.StartTime END), A.RetryCount, 0
	FROM  SMVolume A WITH (NOLOCK), SMVolAction B WITH (NOLOCK)
	WHERE A.SMVolumeId = B.SMVolumeId
	IF @@ERROR != 0 GOTO CX_ERROR_EXIT
	------------------------------------------------------------------
	-- Get Volumes for Revert
	------------------------------------------------------------------
	INSERT INTO #tblVolList
	SELECT SMVolumeId, MountHostId, MountStatus, @VOL_TO_REVERT, MountStatusUpdateTime, RetryCount, 0
	FROM  SMVolume WITH (NOLOCK)
WHERE MountStatus >= 80 AND MountStatus < 89
AND PruneFlags >= 1
	AND SMVolumeId NOT IN (SELECT SMVolumeId FROM #tblVolList)
	IF @@ERROR != 0 GOTO CX_ERROR_EXIT
	------------------------------------------------------------------
	-- Get Volumes for Delete
	------------------------------------------------------------------
	INSERT INTO #tblVolList
	SELECT SMVolumeId, MountHostId, MountStatus, @VOL_TO_DELETE, MountStatusUpdateTime, RetryCount, 0
	FROM  SMVolume WITH (NOLOCK)
WHERE MountStatus >= 90 AND MountStatus < 99
AND PruneFlags <> 5
	AND SMVolumeId NOT IN (SELECT SMVolumeId FROM #tblVolList)
	IF @@ERROR != 0 GOTO CX_ERROR_EXIT
	------------------------------------------------------------------
	-- Get Volumes for Unmount
	-- Volume mounted, partially mounted, or Failed to be unmounted
	------------------------------------------------------------------
	INSERT INTO #tblVolList
	SELECT SMVolumeId, MountHostId, MountStatus, @VOL_TO_UNMOUNT, MountStatusUpdateTime, RetryCount, 0
	FROM  SMVolume WITH (NOLOCK)
	WHERE MountHostId > 0
	AND SMVolumeId NOT IN (SELECT SMVolumeId FROM #tblVolList)
	AND SMVolumeId NOT IN (SELECT SMVolumeId FROM #tblRunningVol)
	AND MountStatus >= 40 AND MountStatus < 79
	AND RetryCount < @RetryParam
	IF @@ERROR != 0 GOTO CX_ERROR_EXIT
	------------------------------------------------------------------
	-- Get Volumes for Unmount from Browse Mounts
	------------------------------------------------------------------
	INSERT INTO #tblVolList
	SELECT VOL.SMVolumeId, VOL.MountHostId, VOL.MountStatus, @VOL_TO_UNMOUNT, VOL.MountStatusUpdateTime, VOL.RetryCount, 0
	FROM  SMVolume VOL WITH (NOLOCK), SMSnapResource RES WITH (NOLOCK)
	WHERE VOL.MountHostId > 0
	AND VOL.SMVolumeId NOT IN (SELECT SMVolumeId FROM #tblVolList)
	AND VOL.SMVolumeId NOT IN (SELECT SMVolumeId FROM #tblRunningVol)
AND VOL.MountStatus = 79
	AND VOL.RetryCount < @RetryParam
	AND RES.SMVolumeId = VOL.SMVolumeId
AND RES.Flags & 32 = 32
	AND RES.SnapShotId = 0
	IF @@ERROR != 0 GOTO CX_ERROR_EXIT
	------------------------------------------------------------------
	-- Calculate ExpirationTime
	------------------------------------------------------------------
	UPDATE #tblVolList SET ExpirationTime = UpdateTime + D.MountStatusUpdateExpiryInterval * 60
	FROM  #tblVolList A, SMVolSnapMap B WITH (NOLOCK),
		  SMSnap C WITH (NOLOCK), SMSnapShotEngine D WITH (NOLOCK)
	WHERE A.SMVolumeId = B.SMVolumeId
	AND B.SMSnapId = C.SMSnapId
	AND C.SnapShotEngineId = D.SnapShotEngineId
	IF @@ERROR != 0 GOTO CX_ERROR_EXIT
	UPDATE #tblVolList SET ExpirationTime = UpdateTime + RES.ExpiryInterval * 60
	FROM  #tblVolList A INNER JOIN SMSnapResource RES (NOLOCK)
		ON A.SMVolumeId = RES.SMVolumeId
WHERE A.MountStatus = 59 AND RES.ExpiryInterval > 0
	IF @@ERROR != 0 GOTO CX_ERROR_EXIT
	------------------------------------------------------------------
	-- Delete Dangling Actions
	------------------------------------------------------------------
	DELETE SMVolAction
	FROM SMVolAction A, #tblVolList B
	WHERE A.SMVolumeId = B.SMVolumeId
	AND B.Flags = @VOL_IN_ACTION
	AND B.ExpirationTime < @CurrentTime
	IF @@ERROR != 0 GOTO CX_ERROR_EXIT
	DELETE	FROM	SMSnapAction WHERE	StartTime < @SnapActionCutOffTime
	IF @@ERROR != 0 GOTO CX_ERROR_EXIT
	------------------------------------------------------------------
	-- Update snaps & volumes of expired revert
	------------------------------------------------------------------
	UPDATE SMVolume
SET MountStatus = 79,
		MountStatusUpdateTime = @CurrentTime
	FROM SMVolume A, #tblVolList B
	WHERE A.SMVolumeId = B.SMVolumeId
	AND B.Flags = @VOL_TO_REVERT
	AND B.ExpirationTime < @CurrentTime
	IF @@ERROR != 0 GOTO CX_ERROR_EXIT
	UPDATE SMSnap
	SET SnapStatus = 14, /* UNMAPPED */
		SnapStatusUpdateTime = @CurrentTime
	FROM SMSnap SNAP
		INNER JOIN SMVolSnapMap MAP (READUNCOMMITTED) ON MAP.SMSnapId = SNAP.SMSnapId
		INNER JOIN #tblVolList VOL (READUNCOMMITTED) ON VOL.SMVolumeId = MAP.SMVolumeId
	WHERE VOL.Flags = @VOL_TO_REVERT
		AND VOL.ExpirationTime < @CurrentTime
	IF @@ERROR != 0 GOTO CX_ERROR_EXIT
	------------------------------------------------------------------
	-- Update volumes of expired delete
	------------------------------------------------------------------
	UPDATE SMVolume
SET PruneFlags = 5
	FROM SMVolume A, #tblVolList B
	WHERE A.SMVolumeId = B.SMVolumeId
	AND B.Flags = @VOL_TO_DELETE
	AND B.ExpirationTime < @CurrentTime
AND A.PruneFlags <> 4
	IF @@ERROR != 0 GOTO CX_ERROR_EXIT
	------------------------------------------------------------------
	-- COMMIT TRANSACTION
	------------------------------------------------------------------
	COMMIT TRANSACTION CleanupVolumeMountsTran
	------------------------------------------------------------------
	-- Get volumes of to be unmounted
	------------------------------------------------------------------
	INSERT INTO #tblUnmount
	SELECT SMVolumeId, MountHostId, 0, RetryCount
	FROM #tblVolList
	WHERE Flags = @VOL_TO_UNMOUNT
	AND SMVolumeId NOT IN (SELECT SMVolumeId FROM SMSnapResource B WITH (NOLOCK))
	AND ExpirationTime < @CurrentTime
	IF @@ERROR != 0 GOTO CX_ERROR_EXIT
	------------------------------------------------------------------
	-- Get volumes of reserved but partially mounted
	------------------------------------------------------------------
	INSERT INTO #tblUnmount
	SELECT A.SMVolumeId, A.MountHostId, B.JobId, A.RetryCount
	FROM #tblVolList A, SMSnapResource B WITH (NOLOCK)
	WHERE A.SMVolumeId = B.SMVolumeId
	AND A.Flags = @VOL_TO_UNMOUNT
	AND (
			(
				-- Expired mount or unmount
				ExpirationTime < @CurrentTime
			)
			OR
			(	-- Application Mounts for non-running job
B.JobId != @JOBID_NA AND B.FLAGS & 2  <> 2 AND
				B.JobId NOT IN (SELECT DISTINCT jobId FROM JMJOBINFO WITH (NOLOCK))
			)
			OR
			(	-- Application Mounts incomplete for pending job
				B.JobId != @JOBID_NA AND
				B.JobId IN (SELECT DISTINCT jobId FROM JMJOBINFO WITH (NOLOCK) WHERE STATE = @JOB_STATE_PENDING)
			)
		)
	IF @@ERROR != 0 GOTO CX_ERROR_EXIT
	DELETE FROM #tblUnmount
	FROM #tblUnmount A, #tblVolList B, SMSnapResource C WITH (NOLOCK)
WHERE  A.SMVolumeId = B.SMVolumeId AND ( C.JobId = @JOBID_NA OR C.FLAGS & 2  = 2 )AND B.MountStatus = 59
AND C.SMVolumeId = A.SMVolumeId AND C.Flags & 32 <> 32
	DECLARE @tblBrowseMountsForDBCleanup table (
		SMVolumeId		integer,
		MountHostId		integer,
		JobId			integer,
		RetryCount		integer)
	INSERT	INTO @tblBrowseMountsForDBCleanup
	SELECT	A.SMVolumeId, A.MountHostId, B.JobId, A.RetryCount
	FROM	#tblUnmount A, SMSnapResource B WITH (NOLOCK), #tblVolList C
	WHERE	A.SMVolumeId = B.SMVolumeId
AND B.Flags & 32 = 32
			AND C.SMVolumeId = A.SMVolumeId
AND C.MountStatus = 59
	DELETE	tbl FROM #tblUnmount tbl,SMSnapResource Res
	WHERE	tbl.SMVolumeId IN (SELECT SMVolumeId FROM @tblBrowseMountsForDBCleanup)
	AND tbl.SMVolumeId=Res.SMVolumeId
AND Res.Flags & 2 =2
	BEGIN TRANSACTION CleanupVolumeMountsTran
	UPDATE	SMSnapResource
SET		Flags = 2
	WHERE	SMVolumeId IN (SELECT SMVolumeId FROM @tblBrowseMountsForDBCleanup)
			AND JobId = @JOBID_NA
AND Flags & 32 = 32
AND Flags & 2 = 2
    DELETE Res1
	FROM SMSnapResource Res1 , SMSnapResource Res2
	WHERE Res1.SMVolumeId=Res2.SMVolumeId
		AND Res1.JobId=@JOBID_NA
		AND Res2.JobId<>@JOBID_NA
AND Res1.Flags&32=32
AND Res2.Flags&2=2
	COMMIT TRANSACTION CleanupVolumeMountsTran
	-----------------------------------
	-- Get volume and do validation
	-----------------------------------
	/*
	DECLARE VolToUnmountCur CURSOR FOR
		SELECT SMVolumeId, MountHostId
		FROM #tblUnmount
	OPEN VolToUnmountCur
	FETCH VolToUnmountCur INTO @t_SMVolumeId, @t_MountHostId
	WHILE @@FETCH_STATUS = 0
	BEGIN
		DELETE FROM #tblValidateResult
		INSERT INTO #tblValidateResult
		EXEC MM_SMValidationForUnmount @t_SMVolumeId, 0, @t_MountHostId
		IF EXISTS (SELECT * FROM #tblValidateResult WHERE ErrorCode > 0)
			GOTO FETCH_NEXT
		INSERT INTO #tblValidated SELECT @t_SMVolumeId, @t_MountHostId, -12345
		FETCH_NEXT:
			FETCH VolToUnmountCur INTO @t_SMVolumeId, @t_MountHostId
	END
	CLOSE VolToUnmountCur
	DEALLOCATE VolToUnmountCur
	*/
	------------------------------------------------------------------
	-- Filter VSA AppAware Volumes
	------------------------------------------------------------------
	DELETE A FROM #tblUnmount A INNER JOIN SMVolume B ON A.SMVolumeId = B.SMVolumeId
AND ( B.VolumeFlags & 131072 = 131072
OR B.VolumeFlags & 262144 = 262144 )
	-- Filter volumes for array that have automatic cleanup activity disabled
	DELETE	A
	FROM	#tblUnmount A
			INNER JOIN SMVolSnapMap MAP (NOLOCK) ON MAP.SMVolumeId = A.SMVolumeId
			INNER JOIN SMSnap SNAP (NOLOCK) ON SNAP.SMSnapId = MAP.SMSnapId
			INNER JOIN SMControlHost CTRL(NOLOCK) ON CTRL.ControlHostId = SNAP.ControlHostId
WHERE	( (CTRL.Flags & 2) = 2)
	INSERT INTO #tblValidated
SELECT T.SMVolumeId, T.MountHostId, T.JobId, VOL.JobId,  IIF(VOL.volumeflags & Cast(4294967296 AS BIGINT) > 0 /*CVSM_VOLUMEFLAGS_VSA_V2_SNAP_DB */,VOL.MasterJobId,0) FROM #tblUnmount T
	INNER JOIN SMVolume VOL (NOLOCK) ON VOL.SMVolumeId = T.SMVolumeId
	DELETE	FROM #tblValidated
	FROM	#tblValidated A
			LEFT OUTER JOIN MMHost B ON A.MountHostId = B.ClientId
	WHERE	B.ClientId IS NULL OR B.MmHostSoftState = 0 OR B.MmHostEnabled = 0
	-- Remove the snaps that have the group id set to 0.
	DECLARE  @tblMetroVolumesMap TABLE ( SMVolumeId int, SMVolSnapMapId int )
	INSERT INTO @tblMetroVolumesMap
	SELECT MAP.SMVolumeId, MAP.SMVolSnapMapId
	FROM #tblValidated A INNER JOIN SMVolSnapMap MAP (NOLOCK) ON MAP.SMVolumeId = A.SMVolumeId
		INNER JOIN SMSnap SNAP (NOLOCK) ON SNAP.SMSnapId = MAP.SMSnapId
	WHERE	SNAP.SnapShotEngineId <> 3
AND (SNAP.SnapFlags & CAST (17179869184 AS BIGINT)) > 0
			AND SNAP.GroupId <> 1
	-- If the group id is not set for both the snaps in metro config, then send both the snaps for unmount
	DELETE	A
	FROM	@tblMetroVolumesMap A
	WHERE	A.SMVolumeId IN (SELECT	SMVolumeId
	FROM	@tblMetroVolumesMap
	GROUP BY	SMVolumeId
	HAVING COUNT(SMVolSnapMapId) > 1)
	----------------------------------------------------
	-- Test Clone Cleanup
	----------------------------------------------------
	IF OBJECT_ID('tempdb.dbo.#tbl_CleanupTestMNM_VolList') IS NOT NULL
		DROP TABLE #tbl_CleanupTestMNM_VolList
	IF OBJECT_ID('tempdb.dbo.#tbl_CleanupTestMNM_Unmount') IS NOT NULL
		DROP TABLE #tbl_CleanupTestMNM_Unmount
	IF OBJECT_ID('tempdb.dbo.#tbl_CleanupTestMNM_Validated') IS NOT NULL
		DROP TABLE #tbl_CleanupTestMNM_Validated
	CREATE TABLE #tbl_CleanupTestMNM_VolList (
		SMVolumeId		integer,
		MountHostId		integer,
		MountStatus		integer,
		Flags			integer,
		UpdateTime		bigint,
		RetryCount		integer,
		ExpirationTime	bigint
		)
	CREATE TABLE #tbl_CleanupTestMNM_Unmount (
		SMVolumeId integer,
		MountHostId integer,
		JobId integer,
		RetryCount integer,
		MountStatus	integer
		)
	CREATE TABLE #tbl_CleanupTestMNM_Validated (
		SMVolumeId integer,
		MountHostId integer,
		JobId integer,
		SnapJobId integer
		)
	-- Expired Mounted Volumes
	/*
	UPDATE	SMMountVolume
SET		MountStatus = 60
WHERE	MountStatus = 59 AND ExpireTime < @CurrentTime
	*/
	UPDATE	SMMountVolume
SET		MountStatus = 79	/*SM_VS_UMT_UNMOUNTED*/
	WHERE	MountJobId<>@JOBID_NA
			AND
			(
				-- Mounted or Failed ones for which there is no job running or the job is in pending state
				MountJobId NOT IN (SELECT DISTINCT jobId FROM JMJobInfo WITH (NOLOCK)) OR
				MountJobId IN (SELECT DISTINCT jobId FROM JMJobInfo WITH (NOLOCK) WHERE STATE = @JOB_STATE_PENDING)
			)
			AND MountStatus = 0
	-- Delete the left-over unmounted volumes
	------------------------------------------------------------------
	-- BEGIN TRANSACTION
	------------------------------------------------------------------
	BEGIN TRANSACTION CleanupClonesTran
	INSERT	INTO #tbl_CleanupTestMNM_Unmount
	SELECT	MV.Id, MV.MountHostId, MV.MountJobId, MV.ReserveField1, MV.MountStatus
	FROM	SMMountVolume MV WITH (NOLOCK) INNER JOIN SMMountMap MMAP (NOLOCK) ON MV.Id = MMAP.SMMountVolumeId
			INNER JOIN SMMountSnap MS (NOLOCK) ON MMAP.SMMountSnapId = MS.Id AND MV.MountJobId = MS.ReserveField4
			INNER JOIN SMSnap SNAP WITH (NOLOCK) ON MS.SMSnapId = SNAP.SMSnapId
			INNER JOIN SMControlHost CTRL (NOLOCK) ON CTRL.ControlHostId = SNAP.ControlHostId
WHERE	((CTRL.Flags & 2) = 0)
			AND (
			(	-- Persistent Test clone, it does unmount followed by delete.
(MS.SnapFlags & 65536) = 65536 /*CVSM_SNAPSHOTFLAGS_TESTENV_PERSISTENT_MOUNT_DB*/
AND MV.MountStatus = 99		/*SM_VS_DEL_DELETED*/
			)
			OR
			(
(MS.SnapFlags & 65536) <> 65536 /*CVSM_SNAPSHOTFLAGS_TESTENV_PERSISTENT_MOUNT_DB*/
AND MV.MountStatus = 79	/*SM_VS_UMT_UNMOUNTED*/
			))
	---- Don't clear entries for currently running job. It is observed that in case there is a delay between very last unmount status update and
	---- unmount response from MA, the cleanup procedure will remove the entries which will fail the unmount request.
	DELETE	TCMU
	FROM	#tbl_CleanupTestMNM_Unmount TCMU INNER JOIN JMJobInfo JOB (READUNCOMMITTED) ON TCMU.JobId = JOB.JobId
	WHERE		JOB.state = 1	/* Running Job */
AND	TCMU.MountStatus = 79	/*SM_VS_UMT_UNMOUNTED*/
	DECLARE	@tblCloneSnapId	TABLE ( CloneSnapId INTEGER)
	INSERT	INTO @tblCloneSnapId
	SELECT	DISTINCT MSNAP.Id
	FROM	#tbl_CleanupTestMNM_Unmount TVOL LEFT OUTER JOIN SMMountMap MMAP WITH(NOLOCK) ON TVOL.SMVolumeId = MMAP.SMMountVolumeId
			INNER JOIN SMMountVolume MVOL ON TVOL.SMVolumeId = MVOL.Id
			INNER JOIN SMMountSnap MSNAP WITH(NOLOCK) --ON MAP.SMSnapId = MSNAP.SMSnapId
				ON MVOL.MountJobId = MSNAP.ReserveField4
				AND MVOL.CreationTime = MSNAP.CreationTime
			-- AND TVOL.RetryCount = MSNAP.ReserveField1
	WHERE	MMAP.SMMountMapId IS NULL
	INSERT	INTO @tblCloneSnapId
	SELECT	DISTINCT MSNAP.Id
	FROM	#tbl_CleanupTestMNM_Unmount TVOL INNER JOIN SMMountMap MMAP WITH(NOLOCK) ON TVOL.SMVolumeId = MMAP.SMMountVolumeId
			INNER JOIN SMMountSnap MSNAP WITH(NOLOCK) ON MMAP.SMMountSnapId = MSNAP.Id
	DELETE	FROM SMMountMap
	WHERE	SMMountVolumeId IN (SELECT SMVolumeId FROM #tbl_CleanupTestMNM_Unmount)
	IF @@ERROR != 0 GOTO CLONE_ENV_CLEANUP_EXIT
	DELETE	FROM SMMountSnap
	WHERE	Id IN (SELECT CloneSnapId FROM @tblCloneSnapId)
	IF @@ERROR != 0 GOTO CLONE_ENV_CLEANUP_EXIT
	DELETE	FROM SMMetaData
	WHERE	MetaDataId IN (SELECT RetryCount FROM #tbl_CleanupTestMNM_Unmount)
			AND MetaDataType = 39 -- Map Id
	IF @@ERROR != 0 GOTO CLONE_ENV_CLEANUP_EXIT
	DELETE	FROM SMMetaData
	WHERE	RefId IN (SELECT SMVolumeId FROM #tbl_CleanupTestMNM_Unmount)
AND RefType = 10 /*SM_MRT_MOUNT_VOLUME*/
	IF @@ERROR != 0 GOTO CLONE_ENV_CLEANUP_EXIT
	/*
	DELETE	FROM SMMetaData
	WHERE	RefId IN (SELECT SMVolumeId FROM #tbl_CleanupTestMNM_Unmount)
			AND MetaDataType = 38 -- App Data
	IF @@ERROR != 0 GOTO CLONE_ENV_CLEANUP_EXIT
	DELETE	FROM SMMetaData
	WHERE	RefId IN (SELECT SMVolumeId FROM #tbl_CleanupTestMNM_Unmount)
AND MetaDataType = 56 /*SM_MDT_TEST_ENV_WORKFLOW_JOB_ID*/
AND RefType = 10 /*SM_MRT_MOUNT_VOLUME*/
	IF @@ERROR != 0 GOTO CLONE_ENV_CLEANUP_EXIT
	DELETE	FROM SMMetaData
	WHERE	RefId IN (SELECT SMVolumeId FROM #tbl_CleanupTestMNM_Unmount)
AND MetaDataType = 57 /*SM_MDT_TEST_ENV_CLONE_USERID*/
AND RefType = 10 /*SM_MRT_MOUNT_VOLUME*/
	IF @@ERROR != 0 GOTO CLONE_ENV_CLEANUP_EXIT
	DELETE	FROM SMMetaData
	WHERE	RefId IN (SELECT SMVolumeId FROM #tbl_CleanupTestMNM_Unmount)
AND MetaDataType = 58 /*SM_MDT_TEST_ENV_ALERT_SENT_FLAG*/
AND RefType = 10 /*SM_MRT_MOUNT_VOLUME*/
	IF @@ERROR != 0 GOTO CLONE_ENV_CLEANUP_EXIT
	*/
	/* Delete any SMMountSnap metadata saved by engines */
	DELETE	FROM SMMetaData
	WHERE	RefId IN (SELECT CloneSnapId FROM @tblCloneSnapId)
AND RefType = 12 /*SM_MRT_MOUNT_SNAP*/
	IF @@ERROR != 0 GOTO CLONE_ENV_CLEANUP_EXIT
	DELETE	FROM SMMountVolume
	WHERE	Id iN (SELECT SMVolumeId FROM #tbl_CleanupTestMNM_Unmount)
	IF @@ERROR != 0 GOTO CLONE_ENV_CLEANUP_EXIT
	UPDATE	TC
SET		OpStatus = 3 /*SM_TC_STATUS_DELETED*/ ,
			DeleteTime = @CurrentTime ,
			ModifyTime = @CurrentTime
	FROM 	#tbl_CleanupTestMNM_Unmount TVOL JOIN SMTestCloneDetails TC ON TVOL.JobId = TC.OpJobId
	IF @@ERROR != 0 GOTO CLONE_ENV_CLEANUP_EXIT
	COMMIT TRANSACTION CleanupClonesTran
	-------------------------------------------------------
	-- Multi Node Mount Cleanup
	-------------------------------------------------------
	-- Delete expired live browse reservations
	DELETE	RES
	FROM	SMSnapResource RES
			INNER JOIN SMMountVolume MV (NOLOCK) ON RES.SMVolumeId = MV.SMVolumeId AND RES.JobId = MV.MountJobId AND RES.SnapShotId = MV.Id
			INNER JOIN SMVolSnapMap MAP (NOLOCK) ON MV.SMVolumeId = MAP.SMVolumeId
			INNER JOIN SMSnap SNAP (NOLOCK) ON MAP.SMSnapId = SNAP.SMSnapId
			INNER JOIN SMSnapShotEngine ENG (NOLOCK) ON ENG.SnapShotEngineId = SNAP.SnapShotEngineId
WHERE MV.MountJobId = @JOBID_NA AND RES.Flags & 32 = 32
AND (MV.MountStatus = 58
OR ( MV.MountStatus = 59 AND
		(CASE
			WHEN RES.ExpiryInterval > 0 THEN (MV.MountStatusUpdateTime + RES.ExpiryInterval * 60)
			ELSE MV.MountStatusUpdateTime + (ENG.MountStatusUpdateExpiryInterval * 60)
		END) < @CurrentTime )
OR (MV.MountStatus < 58 AND MV.MountStatusUpdateTime + @DayInSeconds < @CurrentTime))
	-------------------------------------------------------
	-- SCSI Server Mount Cleanup
	-------------------------------------------------------
	DELETE RES
    FROM SMSnapResource RES
		-- MV has both parent & child SCSI mounts
        INNER JOIN SMMountVolume MV (READUNCOMMITTED) ON MV.Id = RES.SnapShotId
AND (MV.MountFlags & (32 /*CVSM_VOLUMEFLAGS_SCSI_SERVER_MOUNT_DB*/ | 64 /*CVSM_VOLUMEFLAGS_SCSI_SERVER_CLIENT_MOUNT_DB*/) > 0)
        LEFT OUTER JOIN JMJobInfo JOB (READUNCOMMITTED) ON JOB.jobId=MV.MountJobId
        LEFT OUTER JOIN SMEntityMap EMAP (READUNCOMMITTED) ON EMAP.ParentEntityId=MV.Id
        LEFT OUTER JOIN SMMountVolume CMV (READUNCOMMITTED) ON EMAP.ChildEntityId=CMV.Id
    WHERE
		MV.MountJobId > 0
        AND (JOB.jobId IS NULL OR JOB.State=@JOB_STATE_PENDING)
			--Job Mount of Completed/Failed or Pending Job
AND ((RES.Flags & 2 /*SNAPRES_FLAGS_GUI_MOUNT*/ <> 2)
               --Orphaned GUI Mount
            OR ( EMAP.ParentEntityId IS NOT NULL
                AND CMV.id is NULL)
            -- Failed GUI Mount/Unmount
OR MV.MountStatus <> 59 /*SM_VS_MNT_MOUNTED*/
OR CMV.MountStatus <> 59/*SM_VS_MNT_MOUNTED*/)
	SELECT DISTINCT A.MountHostId, A.JobId, B.SMVolSnapMapId, B.SMVolumeId, B.SMSnapId, B.MetaDataId,
			CONVERT(VARCHAR(16), A.MountHostId) + '_' + CONVERT(VARCHAR(16),IIF(A.MasterJobId > 0,A.MasterJobid , A.SnapJobId)) + '_' + CONVERT(VARCHAR(16), A.JobId)
	FROM #tblValidated A INNER JOIN SMVolSnapMap B WITH (NOLOCK)
		ON A.SMVolumeId = B.SMVolumeId
	WHERE B.SMVolSnapMapId NOT IN (SELECT SMVolSnapMapId FROM @tblMetroVolumesMap)
	ORDER BY A.MountHostId, B.SMVolumeId, B.SMSnapId, B.MetaDataId
	GOTO CLEANUP_AND_RETURN
	RETURN
CX_ERROR_EXIT:
	ROLLBACK TRANSACTION CleanupVolumeMountsTran
	GOTO ERROR_EXIT
CLONE_ENV_CLEANUP_EXIT:
	ROLLBACK TRANSACTION CleanupClonesTran
ERROR_EXIT:
	SELECT 0, 0, 0, 0, 0, 0, ''
CLEANUP_AND_RETURN:
	IF OBJECT_ID('tempdb.dbo.#tblVolList') IS NOT NULL
		DROP TABLE #tblVolList
	IF OBJECT_ID('tempdb.dbo.#tblUnmount') IS NOT NULL
		DROP TABLE #tblUnmount
	IF OBJECT_ID('tempdb.dbo.#tblValidated') IS NOT NULL
		DROP TABLE #tblValidated
	IF OBJECT_ID('tempdb.dbo.#tblValidateResult') IS NOT NULL
		DROP TABLE #tblValidateResult
	IF OBJECT_ID('tempdb.dbo.#tblRunningVol') IS NOT NULL
		DROP TABLE #tblRunningVol
	IF OBJECT_ID('tempdb.dbo.#tbl_CleanupTestMNM_VolList') IS NOT NULL
		DROP TABLE #tbl_CleanupTestMNM_VolList
	IF OBJECT_ID('tempdb.dbo.#tbl_CleanupTestMNM_Unmount') IS NOT NULL
		DROP TABLE #tbl_CleanupTestMNM_Unmount
	IF OBJECT_ID('tempdb.dbo.#tbl_CleanupTestMNM_Validated') IS NOT NULL
		DROP TABLE #tbl_CleanupTestMNM_Validated
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMCleanupVolumeMounts')
	delete from GxQscripts where name = 'MM_SMCleanupVolumeMounts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMCleanupVolumeMounts')
	delete from GXDBVersions where aliasname = 'MM_SMCleanupVolumeMounts'
GO

insert into GXDBVersions values(2, 'MM_SMCleanupVolumeMounts',  'v1.48.2.37.12.1', 'MM_SMCleanupVolumeMounts', 'v1.48.2.37.12.1')
GO

