

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMCleanupTestCloneMNM.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMCleanupTestCloneMNM.sp,v $ $Id: MM_SMCleanupTestCloneMNM.sp,v 1.1.2.4 2019/02/02 04:28:13 bbrindavan Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MM_SMCleanupTestCloneMNM')
BEGIN
	print '>>> Drop Stored Procedure: MM_SMCleanupTestCloneMNM <<<'
	drop procedure MM_SMCleanupTestCloneMNM
END
IF EXISTS (select * from GxQscripts where name='MM_SMCleanupTestCloneMNM')
	delete from GxQscripts where name = 'MM_SMCleanupTestCloneMNM'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMCleanupTestCloneMNM')
	delete from GXDBVersions where aliasname = 'MM_SMCleanupTestCloneMNM'
GO
print '... Creating Procedure: MM_SMCleanupTestCloneMNM'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MM_SMCleanupTestCloneMNM
  @dummy integer
AS
  DECLARE @o_MountHostId integer
  DECLARE @o_JobId integer
  DECLARE @o_SMVolSnapMapId integer
  DECLARE @o_SMVolumeId integer
  DECLARE @o_SMSnapId integer
  DECLARE @o_MetaDataId integer
  DECLARE @o_GroupingKey varchar(1024)
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	DECLARE @VOL_TO_UNMOUNT integer
	SET @VOL_TO_UNMOUNT = 4
	DECLARE @RetryParam integer
SET @RetryParam = ISNULL((select Value from MMConfigs(NOLOCK) where name = 'MMS2_CONFIG_VOLSNAP_RETRY_COUNT'), 50)
	DECLARE @CloneCleanupRetryFactor INTEGER
SET @CloneCleanupRetryFactor = ISNULL((select Value from MMConfigs(NOLOCK) where name = 'MMS2_CONFIG_CLONE_CLEANUP_RETRY_FACTOR'), 3)
	IF OBJECT_ID('tempdb.dbo.#tbl_CleanupTestMNM_VolList') IS NOT NULL
		DROP TABLE #tbl_CleanupTestMNM_VolList
	IF OBJECT_ID('tempdb.dbo.#tbl_CleanupTestMNM_Unmount') IS NOT NULL
		DROP TABLE #tbl_CleanupTestMNM_Unmount
	IF OBJECT_ID('tempdb.dbo.#tbl_CleanupTestMNM_Validated') IS NOT NULL
		DROP TABLE #tbl_CleanupTestMNM_Validated
	CREATE TABLE #tbl_CleanupTestMNM_VolList (
		SMVolumeId		integer,
		MountHostId		integer,
		MountStatus		integer,
		Flags			integer,
		UpdateTime		integer,
		RetryCount		integer,
		ExpirationTime	integer
		)
	CREATE TABLE #tbl_CleanupTestMNM_Unmount (
		SMVolumeId integer,
		MountHostId integer,
		JobId integer,
		RetryCount integer
		)
	CREATE TABLE #tbl_CleanupTestMNM_Validated (
		SMVolumeId integer,
		MountHostId integer,
		JobId integer,
		SnapJobId integer
		)
	-- Job State - Pending (Include\CvLib\EvLookup.h)
	DECLARE @JOB_STATE_PENDING INTEGER;
	SET @JOB_STATE_PENDING = 2
	-- Job Status - Killed (Include\JobManager\CVjob.h)
	DECLARE @JOB_STATUS_KILLED INTEGER;
	SET @JOB_STATUS_KILLED = 4
	DECLARE @JOB_STATUS_FAILED INTEGER;
	SET @JOB_STATUS_FAILED = 2
	DECLARE @JOB_STATUS_SUCCESS INTEGER;
	SET @JOB_STATUS_SUCCESS = 1
	DECLARE @CurrentTime INTEGER;
	SET @CurrentTime = dbo.GetUnixTime(GetUTCDate())
	DECLARE @tblRtnSP TABLE (MountHostId INTEGER, JobId INTEGER, MapId INTEGER, VolumeId INTEGER, SnapId INTEGER, MetadataId INTEGER)
	DECLARE @retVal INT = 0
IF @dummy = 64
	BEGIN
		INSERT INTO @tblRtnSP
		EXEC @retVal = MM_SMCleanupVolumeMountsMNM 0
		IF EXISTS(SELECT * FROM @tblRtnSP)
			SELECT	*, '' FROM @tblRtnSP
		ELSE
		SELECT 0, 0, 0, 0, 0, 0, ''
		GOTO CLEANUP_AND_RETURN
	END
IF @dummy = 128
	BEGIN
		INSERT INTO @tblRtnSP
		EXEC @retVal = MM_SMCleanupSCSIVolumeMounts 0
		IF EXISTS(SELECT * FROM @tblRtnSP)
			SELECT	*, '' FROM @tblRtnSP
		ELSE
		SELECT 0, 0, 0, 0, 0, 0, ''
		GOTO CLEANUP_AND_RETURN
	END
	-- ELSE Test Clone Cleanup
	-- Failed Mount & Unmount Volumes
       INSERT INTO #tbl_CleanupTestMNM_VolList
       SELECT MV.Id, MV.MountHostId, MV.MountStatus, @VOL_TO_UNMOUNT, MV.MountStatusUpdateTime, MV.RetryCount, (MV.MountStatusUpdateTime + (ENG.MountStatusUpdateExpiryInterval * 60))
       FROM   SMMountVolume MV WITH (NOLOCK) INNER JOIN SMVolSnapMap MAP WITH (NOLOCK) ON MV.SMVolumeId = MAP.SMVolumeId
					INNER JOIN SMVolume VOL (NOLOCK) ON MV.SMVolumeId = VOL.SMVolumeId
                     INNER JOIN SMSnap SNAP WITH (NOLOCK) ON MAP.SMSnapId = SNAP.SMSnapId
                     INNER JOIN SMSnapShotEngine ENG WITH (NOLOCK) ON ENG.SnapShotEngineId = SNAP.SnapShotEngineId
					 LEFT JOIN JMRestoreStats RSTATS (NOLOCK) ON RSTATS.JobId = MV.MountJobId AND RSTATS.CommCellId = MV.CommcellId
WHERE		MV.MountFlags & 2048 = 2048
AND (MV.MountFlags & (32 | 64) = 0
OR MV.MountFlags & 64 = 64)
AND MV.MountStatus <> 79
                     AND    MV.RetryCount < @RetryParam
                     AND
                     (
                           (
                                  (
                                         -- Already attempted Clone Cleanups
( MV.MountStatus > 59 AND (MV.MountStatusUpdateTime + (ENG.MountStatusUpdateExpiryInterval * @CloneCleanupRetryFactor * 60)) < @CurrentTime )
                                         -- For expired clone cleanup
OR ( MV.MountStatus = 59 AND MV.ExpireTime < @CurrentTime )
                                  )
                                  AND
								  -- Successful Jobs
                                  (
                                         MV.MountJobId NOT IN (SELECT DISTINCT jobId FROM JMJobInfo WITH (NOLOCK))
                                         AND ( RSTATS.JobId IS NULL OR RSTATS.status = @JOB_STATUS_SUCCESS )
                                  )
                           )
                           OR
                           (
                                  (
( MV.MountStatus > 59 AND (MV.MountStatusUpdateTime + (ENG.MountStatusUpdateExpiryInterval * @CloneCleanupRetryFactor * 60)) < @CurrentTime )
OR ( MV.MountStatus <= 59 )
                                  )
                                  AND
                                  (
										-- Failed Jobs, Killed Jobs
										(
											MV.MountJobId NOT IN (SELECT DISTINCT jobId FROM JMJobInfo WITH (NOLOCK))
											AND ( (RSTATS.JobId IS NOT NULL AND RSTATS.status IN (@JOB_STATUS_FAILED, @JOB_STATUS_KILLED)) OR (MV.ExpireTime < @CurrentTime) )
										)
										OR	-- Pending Jobs
										(
											MV.MountJobId IN (	SELECT	DISTINCT jobId FROM JMJobInfo WITH (NOLOCK)
WHERE	STATE = @JOB_STATE_PENDING AND VOL.appTypeId NOT IN (22 /*CV_APPTYPE_ORACLE8*/, 80/*CV_APPTYPE_ORACLE_RAC*/ ) )
											OR MV.MountJobId IN ( SELECT DISTINCT jobId FROM JMJobInfo WITH (NOLOCK)
WHERE	STATE = @JOB_STATE_PENDING AND  VOL.appTypeId  IN (22 /*CV_APPTYPE_ORACLE8*/, 80 /*CV_APPTYPE_ORACLE_RAC*/ ) AND currentPhase <=3 /*Restore*/ )
										)
                                  )
                           )
                     )
AND (CASE WHEN (MV.MountFlags & 262144 = 262144 /* CVSM_VOLUMEFLAGS_VSA_VSA_SNAP_DB */) /*AppAware TestClone Parent Snap Entry*/
						THEN ( CASE WHEN EXISTS(SELECT TOP 1 id  /* Case - AppAware TestClone Child Entry Exists */
												FROM SMMountVolume (NOLOCK)
												WHERE MountJobId = MV.MountJobId
AND (MountFlags & 262144 =0 /* CVSM_VOLUMEFLAGS_VSA_VSA_SNAP_DB */)
AND (MountFlags & 131072 = 131072 /*CVSM_VOLUMEFLAGS_VSA_IDA_SNAP_DB */))
								THEN 0
								ELSE 1
								END)
						ELSE 1
						END
						) = 1
	/*
	-- Expired Mounted Volumes
	INSERT	INTO #tbl_CleanupTestMNM_VolList
	SELECT	MV.Id, MV.MountHostId, MV.MountStatus, @VOL_TO_UNMOUNT, MV.MountStatusUpdateTime, MV.RetryCount, MV.ExpireTime
	FROM	SMMountVolume MV WITH (NOLOCK)
	WHERE	MV.MountStatus = 59 AND MV.ExpireTime < @CurrentTime
	*/
	-- Clone Envs to be cleaned-up
	INSERT	INTO #tbl_CleanupTestMNM_Unmount
	SELECT	MV.Id, MV.MountHostId, MV.MountJobId, MV.RetryCount
	FROM	#tbl_CleanupTestMNM_VolList VL INNER JOIN SMMountVolume MV WITH (NOLOCK) ON VL.SMVolumeId = MV.Id
	INSERT	INTO #tbl_CleanupTestMNM_Validated
	SELECT	SMVolumeId, MountHostId, JobId, 0 FROM #tbl_CleanupTestMNM_Unmount
	DELETE	FROM #tbl_CleanupTestMNM_Validated
	FROM	#tbl_CleanupTestMNM_Validated A
			LEFT OUTER JOIN MMHost B ON A.MountHostId = B.ClientId
	WHERE	B.ClientId IS NULL OR B.MmHostSoftState = 0 OR B.MmHostEnabled = 0
	INSERT	INTO @tblRtnSP
	SELECT	DISTINCT MV.MountHostId, MV.MountJobId, MAP.SMVolSnapMapId, MV.Id, MS.Id, MMAP.MetaDataId
	FROM	#tbl_CleanupTestMNM_Validated VAL INNER JOIN SMMountVolume MV WITH (NOLOCK) ON VAL.SMVolumeId = MV.Id AND VAL.JobId = MV.MountJobId
			INNER JOIN SMVolSnapMap MAP WITH (NOLOCK) ON MV.SMVolumeId = MAP.SMVolumeId
			INNER JOIN SMMountSnap MS WITH (NOLOCK) ON MAP.SMSnapId = MS.SMSnapId AND MV.MountJobId = MS.ReserveField4
			INNER JOIN SMMountMap MMAP (NOLOCK) ON MMAP.SMMountVolumeId = MV.Id AND MMAP.SMMountSnapId = MS.Id
				AND MMAP.SMVolSnapMapId = MAP.SMVolSnapMapId
	ORDER BY MV.MountHostId, MV.Id, MS.Id, MMAP.MetaDataId
	/*
	SELECT	DISTINCT MV.MountHostId, MV.MountJobId, MAP.SMVolSnapMapId, MV.Id, MS.Id, MAP.MetaDataId
	FROM	#tbl_CleanupTestMNM_Validated VAL, SMMountVolume MV WITH (NOLOCK), SMVolSnapMap MAP WITH (NOLOCK), SMMountSnap MS WITH (NOLOCK)
	WHERE	VAL.SMVolumeId = MV.Id AND VAL.JobId = MV.MountJobId
			AND MV.SMVolumeId = MAP.SMVolumeId
			AND MAP.SMSnapId = MS.SMSnapId AND MV.MountJobId = MS.ReserveField4
	ORDER BY MV.MountHostId, MV.Id, MS.Id, MAP.MetaDataId
	*/
	IF EXISTS(SELECT * FROM @tblRtnSP)
		SELECT	*, '' FROM @tblRtnSP
	ELSE
		SELECT 0, 0, 0, 0, 0, 0, ''
CLEANUP_AND_RETURN:
	IF OBJECT_ID('tempdb.dbo.#tbl_CleanupTestMNM_VolList') IS NOT NULL
		DROP TABLE #tbl_CleanupTestMNM_VolList
	IF OBJECT_ID('tempdb.dbo.#tbl_CleanupTestMNM_Unmount') IS NOT NULL
		DROP TABLE #tbl_CleanupTestMNM_Unmount
	IF OBJECT_ID('tempdb.dbo.#tbl_CleanupTestMNM_Validated') IS NOT NULL
		DROP TABLE #tbl_CleanupTestMNM_Validated
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMCleanupTestCloneMNM')
	delete from GxQscripts where name = 'MM_SMCleanupTestCloneMNM'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMCleanupTestCloneMNM')
	delete from GXDBVersions where aliasname = 'MM_SMCleanupTestCloneMNM'
GO

insert into GXDBVersions values(2, 'MM_SMCleanupTestCloneMNM',  '00010001000200040000', 'MM_SMCleanupTestCloneMNM', '00010001000200040000')
GO

