

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMCleanupSCSIVolumeMounts.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMCleanupSCSIVolumeMounts.sp,v $ $Id: MM_SMCleanupSCSIVolumeMounts.sp,v 1.1.2.6 2018/08/26 16:38:32 bbrindavan Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MM_SMCleanupSCSIVolumeMounts <<<'

IF EXISTS (select * from sysobjects where name='MM_SMCleanupSCSIVolumeMounts')
	drop procedure MM_SMCleanupSCSIVolumeMounts
IF EXISTS (select * from GxQscripts where name='MM_SMCleanupSCSIVolumeMounts')
	delete from GxQscripts where name = 'MM_SMCleanupSCSIVolumeMounts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMCleanupSCSIVolumeMounts')
	delete from GXDBVersions where aliasname = 'MM_SMCleanupSCSIVolumeMounts'
GO
print '... Creating Procedure: MM_SMCleanupSCSIVolumeMounts'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MM_SMCleanupSCSIVolumeMounts
  @dummy integer
AS
  DECLARE @o_MountHostId integer
  DECLARE @o_JobId integer
  DECLARE @o_SMVolSnapMapId integer
  DECLARE @o_SMVolumeId integer
  DECLARE @o_SMSnapId integer
  DECLARE @o_MetaDataId integer
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @RetryParam integer
SET @RetryParam = ISNULL((select Value from MMConfigs(READUNCOMMITTED) where name = 'MMS2_CONFIG_VOLSNAP_RETRY_COUNT'), 50)
IF object_id('tempdb.dbo.#tblSCSIVolList') IS NOT NULL DROP TABLE #tblSCSIVolList
CREATE TABLE #tblSCSIVolList
(
	SMVolumeId		integer,
	MntVolumeId		integer,
	MountHostId		integer,
	MountStatus		integer,
	MountJobId		integer,
	UpdateTime		integer,
	RetryCount		integer,
	ExpirationTime	integer,
	SnapJobId		integer,
	CopyId			integer,
	VolMountHostId	integer,
	SourceClientId	integer,
	isSnapCenterSC	integer
)
IF object_id('tempdb.dbo.#tblSCSILinkedVols') IS NOT NULL DROP TABLE #tblSCSILinkedVols
CREATE TABLE #tblSCSILinkedVols
(
	SCSIMountVolId	INTEGER,
	ClientMntVolId	INTEGER
)
-- Job State - Pending (Include\CvLib\EvLookup.h)
DECLARE @JOB_STATE_PENDING INTEGER;
SET @JOB_STATE_PENDING = 2
-- Constant Definition as in EvDebug.h
DECLARE @JOBID_NA INTEGER;
SET @JOBID_NA = -123456
DECLARE @CurrentTime INTEGER;
SET @CurrentTime = dbo.GetUnixTime(GetUTCDate())
DECLARE @retVal INT = 0
BEGIN TRY
	-- Failed Mount & Unmount Volumes
	INSERT	INTO #tblSCSIVolList
	SELECT	MV.SMVolumeId, MV.Id, MV.MountHostId, MV.MountStatus, MV.MountJobId, MV.MountStatusUpdateTime, MV.RetryCount,
			(MV.MountStatusUpdateTime + (ENG.MountStatusUpdateExpiryInterval * 60)),
			VOL.JobId, VOL.CopyId, VOL.MountHostId,
			VOL.SourceClientId, ISNULL(PROP.attrVal, 0)
	FROM	SMMountVolume MV (READUNCOMMITTED) INNER JOIN SMVolSnapMap MAP (READUNCOMMITTED) ON MV.SMVolumeId = MAP.SMVolumeId
			INNER JOIN SMVolume VOL (READUNCOMMITTED) ON VOL.SMVolumeId = MV.SMVolumeId
			INNER JOIN SMSnap SNAP (READUNCOMMITTED) ON MAP.SMSnapId = SNAP.SMSnapId
			INNER JOIN SMSnapShotEngine ENG (READUNCOMMITTED) ON ENG.SnapShotEngineId = SNAP.SnapShotEngineId
			LEFT OUTER JOIN APP_SubClientProp PROP (READUNCOMMITTED) ON PROP.componentNameId = VOL.AppId AND PROP.modified = 0 AND PROP.attrName = 'Snap Center Subclient'
WHERE   MV.MountFlags & (32 | 64) > 0
AND MV.MountStatus < 79
			AND MV.RetryCount < @RetryParam
AND (CASE WHEN MV.MountFlags & 2048 = 2048 THEN
CASE WHEN MV.MountFlags & 32 = 32
AND NOT EXISTS (SELECT ChildEntityId FROM SMEntityMap WHERE EntityMappingType = 10 AND ParentEntityId = MV.Id) THEN 1
					ELSE 0 END
				ELSE 1 END) = 1
AND ( MV.MountStatus <= 59 OR (MV.MountStatus > 59 AND (MV.MountStatusUpdateTime + (ENG.MountStatusUpdateExpiryInterval * 60)) < @CurrentTime))
			AND NOT EXISTS (SELECT 1 FROM SMSnapResource RES (READUNCOMMITTED) WHERE RES.SMVolumeId = MV.SMVolumeId AND
									(CASE WHEN MV.MountJobId = @JOBID_NA THEN 1
									ELSE
CASE WHEN ((MV.MountStatus <> 58 /*SM_VS_MNT_FAILED*/ AND MV.MountStatus <> 78 /*SM_VS_UMT_FAILED*/ AND RES.JobId <> MV.MountJobId )
OR (MV.MountStatus = 59/*SM_VS_MNT_MOUNTED*/ AND RES.Flags & 2  = 2 /*SNAPRES_FLAGS_GUI_MOUNT*/ )) THEN 1
										ELSE 0 END
									END) = 1)
			AND (MV.MountJobId = @JOBID_NA
				OR (MV.MountJobId > 0
					AND (MV.MountJobId NOT IN (SELECT jobId FROM JMJobInfo (READUNCOMMITTED) WHERE CommCellID = 2 AND State != @JOB_STATE_PENDING))))
	;WITH CTE_MountTables
	AS
	(
		SELECT MV.id,MV.MountFlags,MV.MountStatus,MS.UniqueIdentifier,MV.MountJobId
		FROM  #tblSCSIVolList TMP
			JOIN SMMountVolume MV (READUNCOMMITTED) ON TMP.SMVolumeId=MV.SMVolumeId
			JOIN SMMountMap MMAP (READUNCOMMITTED) ON MV.id=MMAP.SMMountVolumeId
			JOIN SMMountSnap MS (READUNCOMMITTED) ON MS.Id=MMAP.SMMountSnapId
	)
	DELETE TMP
	FROM #tblSCSIVolList TMP
		JOIN CTE_MountTables CTE_MT ON TMP.MntVolumeId=CTE_MT.Id
	WHERE CTE_MT.UniqueIdentifier IN(
		SELECT DISTINCT UniqueIdentifier
		FROM CTE_MountTables
			JOIN SMSnapResource RES (READUNCOMMITTED) ON RES.SnapShotId=id
			LEFT JOIN JMJobInfo Job (READUNCOMMITTED) ON Job.jobId=MountJobId
WHERE  MountStatus= 59/*SM_VS_MNT_MOUNTED*/
AND MountFlags & 64 =64 /*CVSM_VOLUMEFLAGS_SCSI_SERVER_CLIENT_MOUNT_DB*/
			AND ((Job.jobId is NOT NULL AND Job.State <> @JOB_STATE_PENDING)
OR RES.Flags & 2 = 2 /*SNAPRES_FLAGS_GUI_MOUNT*/
				OR MountJobId = @JOBID_NA)
	)
	DELETE  T
	FROM    #tblSCSIVolList T
			INNER JOIN #tblSCSIVolList V ON V.SnapJobId = T.SnapJobId AND V.CopyId = T.CopyId
	WHERE   V.VolMountHostId > 0
	INSERT	INTO #tblSCSILinkedVols
	SELECT	MAP.ParentEntityId, MAP.ChildEntityId
	FROM	#tblSCSIVolList TMP1
			INNER JOIN SMEntityMap MAP ON MAP.ParentEntityId = TMP1.MntVolumeId
			INNER JOIN #tblSCSIVolList TMP2 ON MAP.ChildEntityId = TMP2.MntVolumeId
	DELETE	A
	FROM	#tblSCSIVolList A
			INNER JOIN #tblSCSILinkedVols L ON A.MntVolumeId = L.SCSIMountVolId
	SELECT	DISTINCT MV.MountHostId, MV.MountJobId, MMAP.SMVolSnapMapId, MV.Id, MS.Id, MMAP.MetaDataId
	FROM	#tblSCSIVolList TMP INNER JOIN SMMountVolume MV (READUNCOMMITTED) ON TMP.MntVolumeId = MV.Id AND TMP.MountJobId = MV.MountJobId
			INNER JOIN SMMountMap MMAP (READUNCOMMITTED) ON MV.Id = MMAP.SMMountVolumeId
			INNER JOIN SMMountSnap MS (READUNCOMMITTED) ON MMAP.SMMountSnapId = MS.Id AND MV.MountJobId = MS.ReserveField4
			INNER JOIN MMHost HOST(READUNCOMMITTED) ON HOST.ClientId = (CASE WHEN TMP.isSnapCenterSC = 0 THEN TMP.MountHostId ELSE TMP.SourceClientId END)
	WHERE	HOST.MmHostEnabled = 1 AND HOST.MmHostSoftState = 1 AND HOST.OfflineReason = 0
	ORDER BY MV.MountHostId, MV.Id, MS.Id, MMAP.MetaDataId
END TRY
BEGIN CATCH
	SET @retVal = ERROR_NUMBER()
END CATCH
IF object_id('tempdb.dbo.#tblSCSIVolList') IS NOT NULL DROP TABLE #tblSCSIVolList
IF object_id('tempdb.dbo.#tblSCSILinkedVols') IS NOT NULL DROP TABLE #tblSCSILinkedVols
RETURN @retVal
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMCleanupSCSIVolumeMounts')
	delete from GxQscripts where name = 'MM_SMCleanupSCSIVolumeMounts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMCleanupSCSIVolumeMounts')
	delete from GXDBVersions where aliasname = 'MM_SMCleanupSCSIVolumeMounts'
GO

insert into GXDBVersions values(2, 'MM_SMCleanupSCSIVolumeMounts',  '00010001000200060000', 'MM_SMCleanupSCSIVolumeMounts', '00010001000200060000')
GO

