

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMCleanupDuplicateSnapMetadata.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMCleanupDuplicateSnapMetadata.sp,v $ $Id: MM_SMCleanupDuplicateSnapMetadata.sp,v 1.1.4.4 2018/03/20 00:00:13 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MM_SMCleanupDuplicateSnapMetadata <<<'

IF EXISTS (select * from sysobjects where name='MM_SMCleanupDuplicateSnapMetadata')
	drop procedure MM_SMCleanupDuplicateSnapMetadata
IF EXISTS (select * from GxQscripts where name='MM_SMCleanupDuplicateSnapMetadata')
	delete from GxQscripts where name = 'MM_SMCleanupDuplicateSnapMetadata'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMCleanupDuplicateSnapMetadata')
	delete from GXDBVersions where aliasname = 'MM_SMCleanupDuplicateSnapMetadata'
GO
print '... Creating Procedure: MM_SMCleanupDuplicateSnapMetadata'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMCleanupDuplicateSnapMetadata
  @i_jobId INTEGER,
  @i_options INTEGER
AS
SET NOCOUNT ON
-- 1 - Show duplicates
-- 2 - Show cleaned up result, don't update SMMetadata
-- 3 - Update SMMetadata
if (@i_options < 1 or @i_options > 3)
	SET @i_options = 1 -- show duplicates if no option set
declare @tblDupMetadata table (MetaDataID int)
insert into @tblDupMetadata
select distinct md.MetadataId
from SMvolume vol (nolock)
	inner join SMvolSnapMap map (nolock) on map.SMvolumeId = vol.SMvolumeId
	inner join SMMetadata md (nolock) on ((map.SMSnapId = md.RefId and md.RefType = 2)
			or (map.SMVolumeId = md.RefId and md.RefType = 1)) and md.PruneFlags = 4
where (@i_jobid = 0 OR vol.jobid = @i_jobId)
	and convert(int, SUBSTRING(md.MetaData, 0, CHARINDEX('#', md.MetaData))) > 15
If object_id('tempdb.dbo.#tblSnapMDResult') IS NOT Null drop table #tblSnapMDResult
create table #tblSnapMDResult (metadataId int, Metadata nvarchar(max), DupCount int)
insert into #tblSnapMDResult
select T.MetadataId, R.Data, count(*)
from
	(Select tmp.MetadataId,
			SUBSTRING(md.metadata, CHARINDEX('#',  md.metadata) + 1, LEN( md.metadata)) as Metadata
				from @tblDupMetadata TMP inner join SMMetaData md on tmp.MetadataId = md.MetadataId) T
cross apply SplitStringMaxLen(T.Metadata, '|..|' ) R
group by T.MetadataId, R.Data
order by T.MetadataId
IF @i_options = 1
BEGIN
	select *
	from #tblSnapMDResult
END
IF @i_options = 2 -- Show cleanup metadata
BEGIN
	select distinct TMP.MetadataId as MetadataId, convert(nvarchar(10), GRP.MdCount) + '#' + T_STR.partMD as FinalMetadata
	from #tblSnapMDResult TMP
		   inner join
		   (select MetaDataId, count(*) as MdCount
		   from #tblSnapMDResult
		   group by MetadataId) GRP
		   ON GRP.MetadataId = TMP.MetadataId
		   INNER JOIN
		   (SELECT MetadataId,
				  stuff((select  metadata + '|..|'
						 from #tblSnapMDResult
						 where metadataId = T.metadataId
						 for xml path('')), 1, 0, '') as partMD
				  from #tblSnapMDResult AS T
				  group by MetadataId) T_STR
				  on TMP.MetadataId = T_STR.MetadataId
	order by TMP.MetadataId
END
IF @i_options = 3
BEGIN
	begin try
		begin tran CleanupMdTran
		update SMMetadata
		set Metadata = RES.FinalMetadata
		from SMMetadata md
			inner join
			(select distinct TMP.MetadataId as MetadataId, convert(nvarchar(10), GRP.MdCount) + '#' + T_STR.partMD as FinalMetadata
			from #tblSnapMDResult TMP
				   inner join
				   (select MetaDataId, count(*) as MdCount
				   from #tblSnapMDResult
				   group by MetadataId) GRP
				   ON GRP.MetadataId = TMP.MetadataId
				   INNER JOIN
				   (SELECT MetadataId,
						  stuff((select metadata + '|..|'
								 from #tblSnapMDResult
								 where metadataId = T.metadataId
								 for xml path('')), 1, 0, '') as partMD
						  from #tblSnapMDResult AS T
						  group by MetadataId) T_STR
						  on TMP.MetadataId = T_STR.MetadataId
			) RES
			on RES.MetaDataId = md.MetadataId
		commit tran CleanupMdTran
	end try
	begin catch
		select ERROR_NUMBER(), ERROR_MESSAGE()
		IF XACT_STATE() <> 0
			rollback tran CleanupMdTran
	end catch
END
drop table #tblSnapMDResult

IF EXISTS (select * from GxQscripts where name = 'MM_SMCleanupDuplicateSnapMetadata')
	delete from GxQscripts where name = 'MM_SMCleanupDuplicateSnapMetadata'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMCleanupDuplicateSnapMetadata')
	delete from GXDBVersions where aliasname = 'MM_SMCleanupDuplicateSnapMetadata'
GO

insert into GXDBVersions values(2, 'MM_SMCleanupDuplicateSnapMetadata',  '00010001000400040000', 'MM_SMCleanupDuplicateSnapMetadata', '00010001000400040000')
GO

