

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMCleanupAppAwareVolumeMounts.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMCleanupAppAwareVolumeMounts.sp,v $ $Id: MM_SMCleanupAppAwareVolumeMounts.sp,v 1.3.12.13 2020/09/26 02:40:53 rksingh Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MM_SMCleanupAppAwareVolumeMounts')
BEGIN
	print '>>> Drop Stored Procedure: MM_SMCleanupAppAwareVolumeMounts <<<'
	drop procedure MM_SMCleanupAppAwareVolumeMounts
END
IF EXISTS (select * from GxQscripts where name='MM_SMCleanupAppAwareVolumeMounts')
	delete from GxQscripts where name = 'MM_SMCleanupAppAwareVolumeMounts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMCleanupAppAwareVolumeMounts')
	delete from GXDBVersions where aliasname = 'MM_SMCleanupAppAwareVolumeMounts'
GO
print '... Creating Procedure: MM_SMCleanupAppAwareVolumeMounts'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MM_SMCleanupAppAwareVolumeMounts
  @dummy integer
AS
  DECLARE @o_MountHostId integer
  DECLARE @o_JobId integer
  DECLARE @o_SMVolSnapMapId integer
  DECLARE @o_SMVolumeId integer
  DECLARE @o_SMSnapId integer
  DECLARE @o_SMMetaDataId integer
  DECLARE @o_KeyForDel varchar(1024)
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	DECLARE @VOL_TO_UNMOUNT integer
	SET @VOL_TO_UNMOUNT = 4
	DECLARE @RetryParam integer
SET @RetryParam = ISNULL((select Value from MMConfigs(READUNCOMMITTED) where name = 'MMS2_CONFIG_VOLSNAP_RETRY_COUNT'), 50)
DECLARE @AppAwareChildSnapFlag BIGINT	=	131072 /*CVSM_VOLUMEFLAGS_VSA_IDA_SNAP_DB)*/
DECLARE @AppAwareParentSnapFlag BIGINT	=	262144 /*CVSM_VOLUMEFLAGS_VSA_VSA_SNAP_DB)*/
	DECLARE @tblVolList TABLE (
		SMVolumeId		integer,
		MountHostId		integer,
		MountStatus		integer,
		Flags			integer,
		UpdateTime		bigint,
		RetryCount		integer,
		ExpirationTime	bigint,
		VolumeFlags		bigint,
		JobId			integer,
		CopyId			integer,
		KeyForDel		varchar(1024)
		)
	DECLARE @tblUnmount TABLE (
		SMVolumeId integer,
		MountHostId integer,
		JobId integer,
		CopyId integer,
		RetryCount integer,
		VolumeFlags bigint,
		KeyForDel varchar(1024)
		)
	DECLARE @tblValidated TABLE (
		SMVolumeId integer,
		MountHostId integer,
		JobId integer,
		KeyForDel varchar(1024)
		)
	DECLARE @tblVolSnapInfo TABLE (
		MountHostID INT,
		JobID INT,
		SMVolSnapMapId INT,
		SMVolumeId INT,
		SMSnapId INT,
		MetaDataId INT,
		KeyForDel varchar(1024)
	)
	DECLARE @tblRunningVol TABLE (
			SMVolumeId		integer
		)
	-- Job State - Pending (Include\CvLib\EvLookup.h)
	DECLARE @JOB_STATE_PENDING INTEGER;
	SET @JOB_STATE_PENDING = 2
	-- Job Status - Killed (Include\JobManager\CVjob.h)
	DECLARE @JOB_STATUS_KILLED INTEGER;
	SET @JOB_STATUS_KILLED = 4
	DECLARE @JOB_STATUS_FAILED INTEGER;
	SET @JOB_STATUS_FAILED = 2
	DECLARE @JOB_STATUS_SUCCESS INTEGER;
	SET @JOB_STATUS_SUCCESS = 1
	-- Constant Definition as in EvDebug.h
	DECLARE @JOBID_NA INTEGER;
	SET @JOBID_NA = -123456
	DECLARE @CurrentTime INTEGER;
	SET @CurrentTime = dbo.GetUnixTime(GetUTCDate())
	DECLARE @DayInSeconds INTEGER;
	SET @DayInSeconds = 86400
	-- Get all volumes reserved by running, waiting and suspended jobs
	INSERT INTO @tblRunningVol
	SELECT DISTINCT A.SMVolumeId
	FROM SMSnapResource A (READUNCOMMITTED), JMJobInfo B (READUNCOMMITTED)
	WHERE A.JobId = B.JobId
	AND B.state in (1, 3, 5)
	INSERT INTO @tblVolList
	SELECT SMVolumeId, MountHostId, MountStatus, @VOL_TO_UNMOUNT, MountStatusUpdateTime, RetryCount, 0, VolumeFlags, JobId, CopyId, ''
	FROM  SMVolume (READUNCOMMITTED)
	WHERE MountHostId > 0
	AND SMVolumeId NOT IN (SELECT SMVolumeId FROM @tblRunningVol)
	AND MountStatus >= 40 AND MountStatus < 79
	AND RetryCount < @RetryParam
	AND	( VolumeFlags & @AppAwareChildSnapFlag > 0
			OR VolumeFlags & @AppAwareParentSnapFlag  > 0)
	IF @@ERROR != 0 GOTO CX_ERROR_EXIT
	------------------------------------------------------------------
	-- Calculate ExpirationTime
	------------------------------------------------------------------
	UPDATE @tblVolList SET ExpirationTime = UpdateTime + D.MountStatusUpdateExpiryInterval * 60
	FROM  @tblVolList A, SMVolSnapMap B (READUNCOMMITTED),
		  SMSnap C (READUNCOMMITTED), SMSnapShotEngine D (READUNCOMMITTED)
	WHERE A.SMVolumeId = B.SMVolumeId
	AND B.SMSnapId = C.SMSnapId
	AND C.SnapShotEngineId = D.SnapShotEngineId
	IF @@ERROR != 0 GOTO CX_ERROR_EXIT
	UPDATE @tblVolList SET ExpirationTime = UpdateTime + RES.ExpiryInterval * 60
	FROM  @tblVolList A INNER JOIN SMSnapResource RES (READUNCOMMITTED)
		ON A.SMVolumeId = RES.SMVolumeId
WHERE A.MountStatus = 59 AND RES.ExpiryInterval > 0
	IF @@ERROR != 0 GOTO CX_ERROR_EXIT
	------------------------------------------------------------------
	------------------------------------------------------------------
	-- Get volumes of to be unmounted
	------------------------------------------------------------------
	INSERT INTO @tblUnmount
	SELECT SMVolumeId, MountHostId, JobId, CopyId, RetryCount, VolumeFlags, ''
	FROM @tblVolList
	WHERE Flags = @VOL_TO_UNMOUNT
	AND SMVolumeId NOT IN (SELECT SMVolumeId FROM SMSnapResource B (READUNCOMMITTED))
	AND ExpirationTime < @CurrentTime
	IF @@ERROR != 0 GOTO CX_ERROR_EXIT
	------------------------------------------------------------------
	-- Get volumes of reserved but partially mounted
	------------------------------------------------------------------
	INSERT INTO @tblUnmount
	SELECT A.SMVolumeId, A.MountHostId, A.JobId, A.CopyId, A.RetryCount, A.VolumeFlags, ''
	FROM @tblVolList A, SMSnapResource B (READUNCOMMITTED)
	WHERE A.SMVolumeId = B.SMVolumeId
	AND A.Flags = @VOL_TO_UNMOUNT
	AND (
			(
				-- Expired mount or unmount
				ExpirationTime < @CurrentTime
			)
			OR
			(	-- Application Mounts for non-running job
B.JobId != @JOBID_NA AND B.FLAGS & 2  <> 2 AND
				B.JobId NOT IN (SELECT DISTINCT jobId FROM JMJOBINFO (READUNCOMMITTED))
			)
			OR
			(	-- Application Mounts incomplete for pending job
				B.JobId != @JOBID_NA AND
				B.JobId IN (SELECT DISTINCT jobId FROM JMJOBINFO (READUNCOMMITTED) WHERE STATE = @JOB_STATE_PENDING)
			)
		)
	IF @@ERROR != 0 GOTO CX_ERROR_EXIT
	/* Do not unmount a GUI mount.
Do not unmount any reservation that has neither 32 nor 256 flag set */
	DELETE FROM @tblUnmount
	FROM @tblUnmount A, @tblVolList B, SMSnapResource C (READUNCOMMITTED)
WHERE  A.SMVolumeId = B.SMVolumeId AND ( C.JobId = @JOBID_NA OR C.FLAGS & 2  = 2 )AND B.MountStatus = 59
AND C.SMVolumeId = A.SMVolumeId AND C.Flags & (32 | 256 ) = 0
	--------------------------------------------------------------------------------
	--Find linked Volumes [ All child volumes]
	--------------------------------------------------------------------------------
	DECLARE @tblAppAwareLinkedVols TABLE (ParentVolumeId integer, ChildVolumeId integer, ParentIndexAFId integer)
	-- Find Child Volumes
	INSERT	INTO @tblAppAwareLinkedVols
	SELECT  tblVol1.SMVolumeId,tblVol2.SMVolumeId, AF.id
	FROM	@tblUnmount tblVol1 INNER JOIN JMVSAAppJobLink jobLink (READUNCOMMITTED) ON tblVol1.JobId = jobLink.parentJobId
			INNER JOIN SMVolume(READUNCOMMITTED) tblVol2 ON tblVol2.JobId = jobLink.childJobId AND tblVol1.CopyId = tblVol2.CopyId
			INNER JOIN archFile AF ON AF.jobId = tblVol1.jobId
	WHERE	tblVol1.VolumeFlags & @AppAwareParentSnapFlag > 0
			AND tblVol2.VolumeFlags & @AppAwareChildSnapFlag > 0
			AND AF.fileType = 6
	-- Skip parent volume if
	-- A child has reservation
	-- Any child of this parent is in mounted/mounting/unmounting state
	DELETE A FROM @tblUnmount A INNER JOIN @tblAppAwareLinkedVols B ON A.SMVolumeId = B.ParentVolumeId
	WHERE B.ChildVolumeId IN ( SELECT DISTINCT SMVolumeId FROM SMSnapResource (READUNCOMMITTED))
	AND B.ChildVolumeId NOT IN ( SELECT SMVolumeId FROM @tblUnmount)
	DELETE A FROM @tblUnmount A INNER JOIN @tblAppAwareLinkedVols B ON A.SMVolumeId = B.ParentVolumeId
	INNER JOIN SMVolume VOL ON VOL.SMVolumeId = B.ChildVolumeId
	WHERE VOL.MountStatus >= 40 AND VOL.MountStatus <= 78
	AND B.ChildVolumeId NOT IN ( SELECT SMVolumeId FROM @tblUnmount)
	-- Skip Parent Volumes whose child Volumes are present in this cleanup list
	-- Parent Vol unmount is initiated via child unmount.
	DELETE A FROM @tblUnmount A INNER JOIN @tblAppAwareLinkedVols B ON A.SMVolumeId = B.ParentVolumeId
	AND B.ChildVolumeId IN ( SELECT SMVolumeId FROM @tblUnmount)
	---------------------------------------------------------------------------------------------------------
	-- Grouping
	-- Child Volumes belogning to same ParentIndexAFId -  MA_ParentIndexAFId
	-- Remaining parent Vols - MA_PARENT
	--#DEVNOTE: The existing query was not setting key for parent volumes due to join condition on child job from link table
	-- To keep it simple, setting KeyForDel in separate statements for different conditions
	---------------------------------------------------------------------------------------------------------
	UPDATE	tblVol
	SET		tblVol.KeyForDel = (CAST(tblvol.MountHostId AS VARCHAR(10)) + '_' +
	CASE WHEN linkVols.ParentIndexAFId IS NULL THEN CAST(JMLINK.parentJobId AS VARCHAR(10)) + '_JOB'
				ELSE CAST(linkVols.ParentIndexAFId AS VARCHAR(10)) + '_AF'  END)
	FROM	@tblUnmount tblVol
	INNER JOIN JMVSAAppJobLink JMLINK (READUNCOMMITTED) ON JMLINK.childJobId = tblVol.JobId
	LEFT OUTER JOIN @tblAppAwareLinkedVols linkVols ON tblVol.SMVolumeId = linkVols.ChildVolumeId
	WHERE tblVol.VolumeFlags & @AppAwareChildSnapFlag > 0
	----------------------------------------------------------------------
	-- Key for Parent volumes: MA_PARENT
	----------------------------------------------------------------------
	UPDATE	@tblUnmount
	SET		KeyForDel = (CAST(MountHostId AS VARCHAR(10)) + '_' + 'PARENT')
	WHERE VolumeFlags & @AppAwareParentSnapFlag > 0
	AND KeyForDel = ''
	---------------------------------------------------------------------
 	-- Key for Child volumes having no entry in link table: MA_CHILD
	---------------------------------------------------------------------
	UPDATE tblVol
	SET tblVol.KeyForDel = ( CAST( tblvol.MountHostId AS VARCHAR)+ '_' + 'CHILD' )
	FROM @tblUnmount tblVol LEFT OUTER JOIN JMVSAAppJobLink JMLINK (READUNCOMMITTED) ON JMLINK.childJobId = tblVol.JobId
	WHERE  JMLINK.childJobId IS NULL
	AND tblVol.VolumeFlags & @AppAwareChildSnapFlag > 0
	AND tblVol.KeyForDel = ''
	INSERT INTO @tblValidated (SMVolumeId, MountHostId, JobId)
	SELECT SMVolumeId, MountHostId, JobId FROM @tblUnmount
	DELETE FROM @tblValidated
	FROM @tblValidated A, MMHost B
	WHERE A.MountHostId = B.ClientId AND (B.MmHostSoftState = 0 OR B.MmHostEnabled = 0)
	-- Filter volumes for array that have automatic cleanup activity disabled
	DELETE	A
	FROM	@tblValidated A
			INNER JOIN SMVolSnapMap MAP (READUNCOMMITTED) ON MAP.SMVolumeId = A.SMVolumeId
			INNER JOIN SMSnap SNAP (READUNCOMMITTED) ON SNAP.SMSnapId = MAP.SMSnapId
			INNER JOIN SMControlHost CTRL(READUNCOMMITTED) ON CTRL.ControlHostId = SNAP.ControlHostId
WHERE	( (CTRL.Flags & 2) = 2)
	UPDATE A
	SET A.KeyForDel = B.KeyForDel
	FROM @tblValidated A INNER JOIN @tblUnmount B ON A.SMVolumeId = B.SMVolumeId
	INSERT INTO @tblVolSnapInfo
	SELECT A.MountHostId, A.JobId, B.SMVolSnapMapId, B.SMVolumeId, B.SMSnapId, B.MetaDataId, A.KeyForDel
	FROM @tblValidated A, SMVolSnapMap B (READUNCOMMITTED)
	WHERE A.SMVolumeId = B.SMVolumeId
	-- Get all metadata for volumes
    INSERT  INTO @tblVolSnapInfo
    SELECT  0, 0, 0, MD.RefId, 0, MD.MetaDataId, TMP.KeyForDel
    FROM    @tblVolSnapInfo TMP
			INNER JOIN SMMetaData MD (READUNCOMMITTED)
ON MD.RefType = 1 AND TMP.SMVolumeId = MD.RefId
	-- Get all metadata for snaps
    INSERT  INTO @tblVolSnapInfo
    SELECT  0, 0, 0, 0, MD.RefId, MD.MetaDataId, TMP.KeyForDel
    FROM    @tblVolSnapInfo TMP
			INNER JOIN SMMetaData MD (READUNCOMMITTED)
ON MD.RefType = 2 AND TMP.SMSnapId = MD.RefId
	SELECT	MountHostID, JobID, SMVolSnapMapId, SMVolumeId, SMSnapId, MetaDataId, KeyForDel
	FROM	@tblVolSnapInfo
	ORDER	BY KeyForDel
	RETURN
CX_ERROR_EXIT:
	ROLLBACK TRANSACTION CleanupVolumeMountsTran
	SELECT 0, 0, 0, 0, 0, 0
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMCleanupAppAwareVolumeMounts')
	delete from GxQscripts where name = 'MM_SMCleanupAppAwareVolumeMounts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMCleanupAppAwareVolumeMounts')
	delete from GXDBVersions where aliasname = 'MM_SMCleanupAppAwareVolumeMounts'
GO

insert into GXDBVersions values(2, 'MM_SMCleanupAppAwareVolumeMounts',  '00010003001200130000', 'MM_SMCleanupAppAwareVolumeMounts', '00010003001200130000')
GO

