

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMAuxCopyUpdateExt.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMAuxCopyUpdateExt.sp,v $ $Id: MM_SMAuxCopyUpdateExt.sp,v 1.5.60.3 2018/03/20 00:01:46 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MM_SMAuxCopyUpdateExt <<<'

IF EXISTS (select * from sysobjects where name='MM_SMAuxCopyUpdateExt')
	drop procedure MM_SMAuxCopyUpdateExt
IF EXISTS (select * from GxQscripts where name='MM_SMAuxCopyUpdateExt')
	delete from GxQscripts where name = 'MM_SMAuxCopyUpdateExt'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMAuxCopyUpdateExt')
	delete from GXDBVersions where aliasname = 'MM_SMAuxCopyUpdateExt'
GO
print '... Creating Procedure: MM_SMAuxCopyUpdateExt'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMAuxCopyUpdateExt
  @i_xmlText XML,
  @i_ReserveField INTEGER,
  @i_ReserveFieldStr VARCHAR(MAX)
AS
  DECLARE @o_retCode INTEGER
  DECLARE @o_retString VARCHAR(1024)
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
-- Do not use SM related tables in this SP as the lock is acquired only for DFM related tables.
DECLARE	@i_auxCopyJobId				INTEGER
DECLARE	@i_smSnapId					INTEGER
DECLARE	@i_extBackupVersion			INTEGER
DECLARE	@i_extBackupVersionSID		VARCHAR(512)
DECLARE	@i_extBackupInstanceId		INTEGER
DECLARE	@i_extBackupInstanceSID		VARCHAR(512)
DECLARE	@i_extJobId					INTEGER
DECLARE	@i_extJobSID				VARCHAR(512)
DECLARE	@i_dataSetId				INTEGER
DECLARE	@i_dataSetSID				VARCHAR(512)
DECLARE @CopyId smallint
DECLARE @AppId INTEGER
DECLARE @JobId INTEGER
DECLARE @CommCellId INTEGER
DECLARE @DataSetId INTEGER
DECLARE @DFMHostId INTEGER
DECLARE @DFMVersion INTEGER
set @o_retCode = 0
set @o_retString = ''
SET @i_auxCopyJobId = ISNULL ( ( SELECT R.ref.value('.', 'INTEGER') FROM @i_xmlText.nodes ( '/MM_SMAuxCopyUpdateExt/AuxCopyJobId' ) R ( ref ) ), 0 )
SET @i_smSnapId = ISNULL ( ( SELECT R.ref.value('.', 'INTEGER') FROM @i_xmlText.nodes ( '/MM_SMAuxCopyUpdateExt/SMSnapId' ) R ( ref ) ), 0 )
SET @i_extBackupVersion = ISNULL ( ( SELECT R.ref.value('.', 'INTEGER') FROM @i_xmlText.nodes ( '/MM_SMAuxCopyUpdateExt/ExtBackupVersion' ) R ( ref ) ), 0 )
SET @i_extBackupVersionSID = ISNULL ( ( SELECT R.ref.value('.', 'VARCHAR(512)') FROM @i_xmlText.nodes ( '/MM_SMAuxCopyUpdateExt/ExtBackupVersionSID' ) R ( ref ) ), '' )
SET @i_extBackupInstanceId = ISNULL ( ( SELECT R.ref.value('.', 'INTEGER') FROM @i_xmlText.nodes ( '/MM_SMAuxCopyUpdateExt/ExtBackupInstanceId' ) R ( ref ) ), 0 )
SET @i_extBackupInstanceSID = ISNULL ( ( SELECT R.ref.value('.', 'VARCHAR(512)') FROM @i_xmlText.nodes ( '/MM_SMAuxCopyUpdateExt/ExtBackupInstanceSID' ) R ( ref ) ), '' )
SET @i_extJobId = ISNULL ( ( SELECT R.ref.value('.', 'INTEGER') FROM @i_xmlText.nodes ( '/MM_SMAuxCopyUpdateExt/ExtJobId' ) R ( ref ) ), 0 )
SET @i_extJobSID = ISNULL ( ( SELECT R.ref.value('.', 'VARCHAR(512)') FROM @i_xmlText.nodes ( '/MM_SMAuxCopyUpdateExt/ExtJobSID' ) R ( ref ) ), '' )
SET @i_dataSetId = ISNULL ( ( SELECT R.ref.value('.', 'INTEGER') FROM @i_xmlText.nodes ( '/MM_SMAuxCopyUpdateExt/DataSetId' ) R ( ref ) ), 0 )
SET @i_dataSetSID = ISNULL ( ( SELECT R.ref.value('.', 'VARCHAR(512)') FROM @i_xmlText.nodes ( '/MM_SMAuxCopyUpdateExt/DataSetSID' ) R ( ref ) ), '' )
SELECT @CopyId = a.copyId, @AppId = a.appId, @JobId = a.jobId, @CommCellId = a.commcellId
FROM SMVolume a with (nolock), SMVolSnapMap b with (nolock), SMSnap c with (nolock)
WHERE a.SMVolumeId = b.SMVolumeId AND b.SMSnapId = c.SMSnapId
and c.SMSnapId = @i_smSnapId
IF @CopyId IS null
BEGIN
	SET @o_retCode = -1
	SET @o_retString = 'Volume does not exist.'
	GOTO CX_EXIT
END
SELECT	@DFMHostId = ControlHostId
FROM	ArchGroupControlHost (NOLOCK) a, ArchGroupCopy (NOLOCK) b
WHERE	a.ArchGroupId = b.ArchGroupId
AND		b.id = @CopyId
IF @DFMHostId IS null
BEGIN
	SET @o_retCode = -1
	SET @o_retString = 'DFM host info is not found.'
	GOTO CX_EXIT
END
SELECT	@DFMVersion = SMHostOption
FROM	SMControlHost (NOLOCK)
WHERE	ControlHostId = @DFMHostId
AND		(SMHostFlags & 1) = 1
IF @DFMVersion < 2
BEGIN
	SET @i_dataSetId = CONVERT(INTEGER, @i_dataSetSID)
	SET @i_extBackupInstanceId = CONVERT(INTEGER, @i_extBackupInstanceSID)
	SET @i_extBackupVersion = CONVERT(INTEGER, @i_extBackupVersionSID)
	SET @i_extJobId = CONVERT(INTEGER, @i_extJobId)
END
DECLARE @SMRelationId INTEGER = 0
SELECT	@SMRelationId = DS.SMRelationId
FROM	SMDataSet DS (NOLOCK)
		INNER JOIN SMDataSetToSubClientMap MAP (NOLOCK) ON DS.DataSetId = MAP.DataSetId
			AND DS.SMRelationId = MAP.SMRelationId
WHERE	DS.ExtDataSetId = @i_dataSetSID
AND		MAP.AppId = @AppId
IF NOT EXISTS (
	SELECT *
	FROM SMExternalJobMapHistSID (NOLOCK)
	WHERE
		AuxCopyJobId = @i_auxCopyJobId AND
		CommCellId = @CommCellId AND
		ArchGroupCopyId = @CopyId AND
		ControlHostId = @DFMHostId AND
		DataSetSID = @i_dataSetSID AND
		ExtJobSID = @i_extJobSID
	)
BEGIN
	INSERT INTO SMExternalJobMapHistSID
	(AuxCopyJobId, CommCellId, ArchGroupCopyId, ControlHostId, DataSetId, DataSetSID,
	ExtBackupInstanceId, ExtBackupInstanceSID, ExtBackupVersion, ExtBackupVersionSID,
	ExtJobId, ExtJobSID, Flags, FailureReason, Status, BytesTransfered, LastModifiedTime, ReserveField1, ReserveField2, ReserveFieldStr)
	VALUES (@i_auxCopyJobId, @CommCellId, @CopyId, @DFMHostId, @i_dataSetId,@i_dataSetSID,
	@i_ExtBackupInstanceId, @i_extBackupInstanceSID, @i_ExtBackupVersion, @i_extBackupVersionSID,
	@i_ExtJobId, @i_ExtJobSID, 0, '', 0, 0, getdate(), 0, 0, '')
END
ELSE
BEGIN
	UPDATE SMExternalJobMapHistSID
	SET	ExtBackupVersion = @i_ExtBackupVersion,
		ExtBackupInstanceId	= @i_ExtBackupInstanceId
	WHERE AuxCopyJobId = @i_auxCopyJobId
	AND	CommCellId = @CommCellId
	AND	ArchGroupCopyId = @CopyId
	AND	ControlHostId = @DFMHostId
	AND	DataSetSID = @i_dataSetSID
	AND	ExtJobSID = @i_ExtJobSID
END
IF NOT EXISTS (
	SELECT *
	FROM SMJobCopyToBackupSIDMap (NOLOCK)
	WHERE
		JobId = @JobId AND
		CommCellId = @CommCellId AND
		ArchGroupCopyId = @CopyId AND
		ControlHostId = @DFMHostId AND
		DataSetSID = @i_dataSetSID
	)
BEGIN
	INSERT INTO SMJobCopyToBackupSIDMap
	(JobId, CommCellId, ArchGroupCopyId, ControlHostId, SMRelationId, DataSetId, DataSetSID,
	ExtBackupVersion, ExtBackupVersionSID, ExtBackupInstanceId, ExtBackupInstanceSID,
	Flags, ReserveField1, ReserveField2, ReserveFieldStr)
	VALUES (@JobId, @CommCellId, @CopyId, @DFMHostId, @SMRelationId, @i_dataSetId, @i_dataSetSID,
	@i_extBackupVersion, @i_extBackupVersionSID, @i_extBackupInstanceId, @i_extBackupInstanceSID,
	0, 0, 0, '')
END
UPDATE SMSnap
SET ReserveField1 = @DFMHostId
FROM SMSnap
WHERE SMSnapId = @i_smSnapId
AND ReserveField1 = 0
CX_EXIT:
	SELECT @o_retCode, @o_retString
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMAuxCopyUpdateExt')
	delete from GxQscripts where name = 'MM_SMAuxCopyUpdateExt'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMAuxCopyUpdateExt')
	delete from GXDBVersions where aliasname = 'MM_SMAuxCopyUpdateExt'
GO

insert into GXDBVersions values(2, 'MM_SMAuxCopyUpdateExt',  '00010005006000030000', 'MM_SMAuxCopyUpdateExt', '00010005006000030000')
GO

