

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMAuxCopyCloseAF.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMAuxCopyCloseAF.sp,v $ $Id: MM_SMAuxCopyCloseAF.sp,v 1.2.210.1 2018/03/20 00:04:55 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MM_SMAuxCopyCloseAF <<<'

IF EXISTS (select * from sysobjects where name='MM_SMAuxCopyCloseAF')
	drop procedure MM_SMAuxCopyCloseAF
IF EXISTS (select * from GxQscripts where name='MM_SMAuxCopyCloseAF')
	delete from GxQscripts where name = 'MM_SMAuxCopyCloseAF'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMAuxCopyCloseAF')
	delete from GXDBVersions where aliasname = 'MM_SMAuxCopyCloseAF'
GO
print '... Creating Procedure: MM_SMAuxCopyCloseAF'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MM_SMAuxCopyCloseAF
  @i_copyId INTEGER,
  @i_archFileId INTEGER,
  @i_commCellId INTEGER
AS
  DECLARE @o_retCode INTEGER
  DECLARE @o_retString VARCHAR(1024)
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @defaultSnapCopy INTEGER
DECLARE @isSnapCopy INTEGER
DECLARE @isMirrorCopy INTEGER
DECLARE @isValidAFC INTEGER
SET @o_retCode = 0
SET @o_retString = ''
SELECT	@isSnapCopy = agc.isSnapCopy,
		@isMirrorCopy = agc.isMirrorCopy,
		@defaultSnapCopy = ag.defaultSnapCopy
FROM	ArchGroupCopy agc WITH (NOLOCK), ArchGroup ag WITH (NOLOCK)
WHERE	agc.id = @i_copyId AND ag.id = agc.ArchGroupId
IF @isSnapCopy IS NULL
BEGIN
	SET @o_retCode = -1
	SET @o_retString = 'Invalid CopyId input.'
	GOTO CX_EXIT
END
IF @isSnapCopy = 0
BEGIN
	SET @o_retCode = -1
	SET @o_retString = 'It is not a snap copy.'
	GOTO CX_EXIT
END
IF @i_copyId = @defaultSnapCopy
BEGIN
	SET @o_retString = 'It is a primary snap copy.'
	GOTO CX_EXIT
END
IF @i_commCellId = 0
	SET @i_commCellId = 2
SELECT	@isValidAFC = afc.isValid
FROM	ArchFileCopy afc WITH (NOLOCK)
WHERE	afc.ArchCopyId = @i_copyId
AND		afc.ArchFileId = @i_archFileId
AND		afc.CommCellId = @i_commCellId
IF @isValidAFC IS NULL
BEGIN
	SET @o_retCode = -1
	SET @o_retString = 'Archive file is not found on copy.'
	GOTO CX_EXIT
END
IF @isValidAFC = 1
BEGIN
	SET @o_retString = 'Archive file has been closed.'
	GOTO CX_EXIT
END
UPDATE ArchFileCopy SET isValid = 1
FROM	ArchFileCopy afc
WHERE	afc.ArchCopyId = @i_copyId
AND		afc.ArchFileId = @i_archFileId
AND		afc.CommCellId = @i_commCellId
CX_EXIT:
	SELECT @o_retCode, @o_retString
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMAuxCopyCloseAF')
	delete from GxQscripts where name = 'MM_SMAuxCopyCloseAF'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMAuxCopyCloseAF')
	delete from GXDBVersions where aliasname = 'MM_SMAuxCopyCloseAF'
GO

insert into GXDBVersions values(2, 'MM_SMAuxCopyCloseAF',  '00010002021000010000', 'MM_SMAuxCopyCloseAF', '00010002021000010000')
GO

