

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMAuxCopyCleanup.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMAuxCopyCleanup.sp,v $ $Id: MM_SMAuxCopyCleanup.sp,v 1.4.42.4 2020/05/02 00:59:16 kkumar Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MM_SMAuxCopyCleanup')
BEGIN
	print '>>> Drop Stored Procedure: MM_SMAuxCopyCleanup <<<'
	drop procedure MM_SMAuxCopyCleanup
END
IF EXISTS (select * from GxQscripts where name='MM_SMAuxCopyCleanup')
	delete from GxQscripts where name = 'MM_SMAuxCopyCleanup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMAuxCopyCleanup')
	delete from GXDBVersions where aliasname = 'MM_SMAuxCopyCleanup'
GO
print '... Creating Procedure: MM_SMAuxCopyCleanup'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMAuxCopyCleanup
  @i_xmlTextInput XML,
  @i_reserveInt INTEGER,
  @i_reserveStr VARCHAR(255)
AS
-- Following are the "columns" returned, in the order in which they are returned
-- Column of NVARCHAR_UTF8(MAX) type should be at the end
  DECLARE @o_errCode INT
  DECLARE @o_errMsg VARCHAR(255)
SET NOCOUNT ON
BEGIN
	DECLARE @tblAFC TABLE (archFileId int, commCellId int, copyId int)
	DECLARE @tblSMVolSnap TABLE (SMVolumeId INT, SMSnapId INT, SMVolSnapMapId INT,
								MetaDataId INT, archFileId INT, copyId INT, appId INT)
	DECLARE @errCode	INT = 0
	DECLARE @errMsg		VARCHAR(255) = ''
	SET @errCode = 0
	SET @errMsg = ''
    INSERT  INTO @tblAFC
    SELECT  ref.value('@ArchFileId', 'int') AS ArchFileId,
			ref.value('@CommCellId', 'int') AS CommCellId,
			ref.value('@CopyId', 'int') AS CopyId
    FROM @i_xmlTextInput.nodes('/MM_SMAuxCopyCleanup/ArchFileList/ArchFileCopy') R(ref)
	INSERT	INTO @tblSMVolSnap
	SELECT	DISTINCT VOL.SMVolumeId, SNAP.SMSnapId, MAP.SMVolSnapMapId,
			MAP.MetaDataId, VOL.ArchFileId, VOL.copyId, VOL.AppTypeId
	FROM	SMVolume VOL (NOLOCK)
			INNER JOIN @tblAFC AFC ON VOL.ArchFileId = AFC.archFileId
				AND VOL.CommCellId = AFC.commCellId
				AND VOL.CopyId = AFC.copyId
			INNER JOIN SMVolSnapMap MAP (NOLOCK) ON VOL.SMVolumeId = MAP.SMVolumeId
			INNER JOIN SMSnap SNAP (NOLOCK) ON SNAP.SMSnapId = MAP.SMSnapId
	-- Check whether there are volumes to cleanup. If not, bail out
	IF NOT EXISTS (SELECT * FROM @tblSMVolSnap)
	BEGIN
		SELECT @errCode, @errMsg
		RETURN
	END
	-- Delete Map details
	DELETE	SMVolSnapMap
	FROM	SMVolSnapMap MAP, @tblSMVolSnap T_MAP
	WHERE	MAP.SMVolSnapMapId = T_MAP.SMVolSnapMapId
	SET @errCode = @@ERROR
	IF @errCode <> 0
	BEGIN
		SET	@errMsg = 'Failed to delete VolSnapMaps for failed AuxCopy attempts.'
		GOTO ERR_EXIT
	END
	-- Delete MetaData associated with Map
	DELETE	SMMetaData
	FROM	SMMetaData MD, @tblSMVolSnap T_MAP
	WHERE	MD.MetaDataId = T_MAP.MetaDataId AND MD.MetaDataId > 0
	SET @errCode = @@ERROR
	IF @errCode <> 0
	BEGIN
		SET	@errMsg = 'Failed to delete VolSnapMap Metadata for failed AuxCopy attempts.'
		GOTO ERR_EXIT
	END
	-- delete only if no other map exist after deleting current ones. As snap can be reused with other volumes.
	IF  NOT EXISTS(SELECT 1 FROM SMVolSnapMap MAP, @tblSMVolSnap T_MAP where MAP.SMSnapId = T_MAP.SMSnapId )
	BEGIN
		-- Delete Metadata associated with Snaps
		DELETE	SMMetaData
		FROM	SMMetaData MD, @tblSMVolSnap T_MAP
WHERE	MD.RefType = 2 AND MD.RefId = T_MAP.SMSnapId
		SET @errCode = @@ERROR
		IF @errCode <> 0
		BEGIN
			SET	@errMsg = 'Failed to delete Snap Metadata for failed AuxCopy attempts.'
			GOTO ERR_EXIT
		END
		-- Delete Snap details
		DELETE	SMSnap
		FROM	SMSnap SNAP, @tblSMVolSnap T_MAP
		WHERE	SNAP.SMSnapId = T_MAP.SMSnapId
		SET @errCode = @@ERROR
		IF @errCode <> 0
		BEGIN
			SET	@errMsg = 'Failed to delete Snaps for failed AuxCopy attempts.'
			GOTO ERR_EXIT
		END
	END  -- Del snap metadata and snap only if no volsnapmap entry exist for the snap.
	-- Delete Metadata associated with Volumes
	DELETE	SMMetaData
	FROM	SMMetaData MD, @tblSMVolSnap T_MAP
WHERE	MD.RefType = 1 AND MD.RefId = T_MAP.SMVolumeId
	SET @errCode = @@ERROR
	IF @errCode <> 0
	BEGIN
		SET	@errMsg = 'Failed to delete Volume Metadata for failed AuxCopy attempts.'
		GOTO ERR_EXIT
	END
	-- Delete Volume details
	DELETE	SMVolume
	FROM	SMVolume VOL, @tblSMVolSnap T_MAP
	WHERE	VOL.SMVolumeId = T_MAP.SMVolumeId
	SET @errCode = @@ERROR
	IF @errCode <> 0
	BEGIN
		SET	@errMsg = 'Failed to delete Volumes for failed AuxCopy attempts.'
		GOTO ERR_EXIT
	END
ERR_EXIT:
	SELECT @errCode, @errMsg
	RETURN
END
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMAuxCopyCleanup')
	delete from GxQscripts where name = 'MM_SMAuxCopyCleanup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMAuxCopyCleanup')
	delete from GXDBVersions where aliasname = 'MM_SMAuxCopyCleanup'
GO

insert into GXDBVersions values(2, 'MM_SMAuxCopyCleanup',  '00010004004200040000', 'MM_SMAuxCopyCleanup', '00010004004200040000')
GO

