

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMAddSnapToDatasetMap.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMAddSnapToDatasetMap.sp,v $ $Id: MM_SMAddSnapToDatasetMap.sp,v 1.1.2.4 2018/03/20 00:06:03 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MM_SMAddSnapToDatasetMap <<<'

IF EXISTS (select * from sysobjects where name='MM_SMAddSnapToDatasetMap')
	drop procedure MM_SMAddSnapToDatasetMap
IF EXISTS (select * from GxQscripts where name='MM_SMAddSnapToDatasetMap')
	delete from GxQscripts where name = 'MM_SMAddSnapToDatasetMap'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMAddSnapToDatasetMap')
	delete from GXDBVersions where aliasname = 'MM_SMAddSnapToDatasetMap'
GO
print '... Creating Procedure: MM_SMAddSnapToDatasetMap'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMAddSnapToDatasetMap
  @i_xmlTextInput XML,
  @i_reserveInt INTEGER,
  @i_reserveStr VARCHAR(255)
AS
-- Following are the "columns" returned, in the order in which they are returned
-- Column of NVARCHAR_UTF8(MAX) type should be at the end
  DECLARE @o_errCode INT
  DECLARE @o_errMsg VARCHAR(255)
SET NOCOUNT ON
DECLARE @errCode	INT = 0
DECLARE @errMsg		VARCHAR(255) = ''
SET @errCode = 0
SET @errMsg = ''
IF OBJECT_ID('tempdb.dbo.#tblAddSnapToDSMap') IS NOT NULL DROP TABLE #tblAddSnapToDSMap
CREATE TABLE #tblAddSnapToDSMap (SMSnapId INT, ExtDataSetId NVARCHAR(512), DataSetId INT, AppId INT)
DECLARE @currentTime INT = dbo.getUnixTime(GETUTCDATE())
DECLARE @i_adminJobId INT = 0
INSERT  INTO #tblAddSnapToDSMap
SELECT	R.ref.value('./SMSnapId[1]', 'int') AS SMSnapId,
		R.ref.value('./ExtDataSetId[1]', 'NVARCHAR(512)') AS ExtDataSetId, 0, 0
FROM @i_xmlTextInput.nodes('/MM_SMAddSnapToDatasetMap/SnapToDatasetMap') R(ref)
SET @i_adminJobId = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlTextInput.nodes('/MM_SMAddSnapToDatasetMap/JobId') R(ref)), 0)
UPDATE	TMP
SET		TMP.AppId = VOL.AppId
FROM	#tblAddSnapToDSMap TMP
		INNER JOIN SMVolSnapMap MAP (NOLOCK) ON TMP.SMSnapId = MAP.SMSnapId
		INNER JOIN SMVolume VOL (NOLOCK) ON MAP.SMVolumeId = VOL.SMVolumeId
		INNER JOIN archGroupCopy AGC (NOLOCK) ON AGC.id = VOL.CopyId
		INNER JOIN archGroup AG (NOLOCK) ON AGC.archGroupId = AG.id
		INNER JOIN ArchGroupControlHost AGCH (NOLOCK) ON AG.id = AGCH.ArchGroupId
WHERE   AGC.isSnapCopy = 1
AND ( (AGC.id <> AG.defaultSnapCopy AND (AGC.extendedFlags & 256 <> 256))
		OR (AGCH.SMReplicationProtocolType = 1 AND AGC.id = AG.defaultSnapCopy ) )
DELETE FROM #tblAddSnapToDSMap
WHERE AppId = 0
UPDATE	TMP
SET		TMP.DatasetId = DS.DatasetId
FROM	#tblAddSnapToDSMap TMP
		INNER JOIN SMDataSet DS (NOLOCK) ON TMP.ExtDataSetId = DS.ExtDataSetId
DELETE	TMP
FROM	#tblAddSnapToDSMap TMP
		INNER JOIN SMSnapToDatasetMap MAP (NOLOCK)
			ON MAP.SMSnapId = TMP.SMSnapId AND MAP.DataSetId = TMP.DataSetId
IF NOT EXISTS (SELECT * FROM #tblAddSnapToDSMap)
	GOTO ERR_EXIT
INSERT	INTO SMSnapToDatasetMap
SELECT	DISTINCT SMSnapId, AppId, DatasetId
		FROM #tblAddSnapToDSMap
SET @errCode = @@ERROR
IF @errCode <> 0
BEGIN
	SET	@errMsg = 'Failed to insert mapping in SMSnapToDatasetMap.'
	GOTO ERR_EXIT
END
ERR_EXIT:
	IF OBJECT_ID('tempdb.dbo.#tblAddSnapToDSMap') IS NOT NULL DROP TABLE #tblAddSnapToDSMap
	SELECT @errCode, @errMsg
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMAddSnapToDatasetMap')
	delete from GxQscripts where name = 'MM_SMAddSnapToDatasetMap'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMAddSnapToDatasetMap')
	delete from GXDBVersions where aliasname = 'MM_SMAddSnapToDatasetMap'
GO

insert into GXDBVersions values(2, 'MM_SMAddSnapToDatasetMap',  '00010001000200040000', 'MM_SMAddSnapToDatasetMap', '00010001000200040000')
GO

