

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMAddSnapDataSetMemberMap.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMAddSnapDataSetMemberMap.sp,v $ $Id: MM_SMAddSnapDataSetMemberMap.sp,v 1.3.52.1 2018/03/19 23:58:20 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MM_SMAddSnapDataSetMemberMap <<<'

IF EXISTS (select * from sysobjects where name='MM_SMAddSnapDataSetMemberMap')
	drop procedure MM_SMAddSnapDataSetMemberMap
IF EXISTS (select * from GxQscripts where name='MM_SMAddSnapDataSetMemberMap')
	delete from GxQscripts where name = 'MM_SMAddSnapDataSetMemberMap'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMAddSnapDataSetMemberMap')
	delete from GXDBVersions where aliasname = 'MM_SMAddSnapDataSetMemberMap'
GO
print '... Creating Procedure: MM_SMAddSnapDataSetMemberMap'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMAddSnapDataSetMemberMap
  @i_xmlTextInput XML,
  @i_reserveInt INTEGER,
  @i_reserveStr VARCHAR(255)
AS
-- Following are the "columns" returned, in the order in which they are returned
-- Column of NVARCHAR_UTF8(MAX) type should be at the end
  DECLARE @o_errCode INT
  DECLARE @o_errMsg VARCHAR(255)
SET NOCOUNT ON
BEGIN
	DECLARE @tblSnapDSMembers TABLE
		(	SMSnapId				int,
			DataSetMemberId			int	)
	DECLARE @errCode	INT = 0
	DECLARE @errMsg		VARCHAR(255) = ''
    INSERT  INTO @tblSnapDSMembers
    SELECT  ref.value('./SMSnapId[1]', 'int') AS SMSnapId,
			ref.value('./DataSetMemberId[1]', 'int') AS DataSetMemberId
    FROM @i_xmlTextInput.nodes('/MM_SMAddSnapDataSetMemberMap/SnapDataSetMemberMap') R(ref)
	DELETE	@tblSnapDSMembers
	FROM	@tblSnapDSMembers TMP
			INNER JOIN SMSnapToDatasetMemberMap MAP
			ON TMP.SMSnapId = MAP.SMSnapId
			AND TMP.DataSetMemberId = MAP.DSMemberId
	INSERT	INTO SMSnapToDatasetMemberMap (SMSnapId, DSMemberId, Flags)
	SELECT	SMSnapId, DataSetMemberId, 0
	FROM	@tblSnapDSMembers
	SET @errCode = @@ERROR
	IF @errCode > 0
	BEGIN
		SET @errMsg = 'Failed to add SMSnap to DataSetMemberId map.'
		GOTO ERR_EXIT
	END
	SELECT 0, ''
	RETURN
ERR_EXIT:
	SELECT	@errCode, @errMsg
	RETURN
END
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMAddSnapDataSetMemberMap')
	delete from GxQscripts where name = 'MM_SMAddSnapDataSetMemberMap'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMAddSnapDataSetMemberMap')
	delete from GXDBVersions where aliasname = 'MM_SMAddSnapDataSetMemberMap'
GO

insert into GXDBVersions values(2, 'MM_SMAddSnapDataSetMemberMap',  '00010003005200010000', 'MM_SMAddSnapDataSetMemberMap', '00010003005200010000')
GO

