

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMAddSnapAction.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMAddSnapAction.sp,v $ $Id: MM_SMAddSnapAction.sp,v 1.1.2.2 2018/03/20 00:03:01 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MM_SMAddSnapAction <<<'

IF EXISTS (select * from sysobjects where name='MM_SMAddSnapAction')
	drop procedure MM_SMAddSnapAction
IF EXISTS (select * from GxQscripts where name='MM_SMAddSnapAction')
	delete from GxQscripts where name = 'MM_SMAddSnapAction'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMAddSnapAction')
	delete from GXDBVersions where aliasname = 'MM_SMAddSnapAction'
GO
print '... Creating Procedure: MM_SMAddSnapAction'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMAddSnapAction
  @i_inputXML XML,
  @i_options INTEGER
AS
  DECLARE @o_ErrorCode INTEGER
  DECLARE @o_ErrorStr VARCHAR(1024)
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
/*
<MM_SMAddSnapAction>
	<JobId>12345</JobId>
	<RequestId>2345</RequestId>
	<SnapOpType>7</SnapOpType>
	<HostId>5</HostId>
	<SnapList>
		<SMSnap SMSnapId="7" Status="97"/>
		<SMSnap SMSnapId="8" Status="97"/>
	</SnapList>
</MM_SMAddSnapAction>
*/
DECLARE @currentTime INTEGER = dbo.GetUnixTime(GETUTCDATE())
DECLARE @tblSnaps TABLE (SMSnapId INT, Status INT)
INSERT INTO @tblSnaps
SELECT  ref.value('@SMSnapId', 'int') AS SMSnapId,
		ref.value('@Status', 'int') AS Status
		FROM @i_inputXML.nodes('/MM_SMAddSnapAction/SnapList/SMSnap') R(ref)
DECLARE @i_jobId INT = 0
SET @i_jobId = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_inputXML.nodes('/MM_SMAddSnapAction/JobId') R(ref)), 0)
DECLARE @i_snapOpType INT = 0
SET @i_snapOpType = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_inputXML.nodes('/MM_SMAddSnapAction/SnapOpType') R(ref)), 0)
DECLARE @i_requestId INT = 0
SET @i_requestId = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_inputXML.nodes('/MM_SMAddSnapAction/RequestId') R(ref)), 0)
DECLARE @i_HostId INT = 0
SET @i_HostId = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_inputXML.nodes('/MM_SMAddSnapAction/HostId') R(ref)), 0)
BEGIN TRY
	BEGIN TRANSACTION AddSnapActionTran
		INSERT	INTO SMSnapAction (SMSnapId, JobId, CommCellId, HostId, SnapOpType, RequestId, ActionStatus, StartTime)
		SELECT	SMSnapId, @i_jobId, 2, @i_HostId, @i_snapOpType, @i_requestId, 0, @currentTime
		FROM	@tblSnaps
	COMMIT TRANSACTION AddSnapActionTran
END TRY
BEGIN CATCH
	IF XACT_STATE() <> 0
		ROLLBACK TRANSACTION AddSnapActionTran
	SET @o_ErrorCode = ERROR_NUMBER()
	SET @o_ErrorStr = ERROR_MESSAGE()
END CATCH
SELECT @o_ErrorCode, @o_ErrorStr
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMAddSnapAction')
	delete from GxQscripts where name = 'MM_SMAddSnapAction'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMAddSnapAction')
	delete from GXDBVersions where aliasname = 'MM_SMAddSnapAction'
GO

insert into GXDBVersions values(2, 'MM_SMAddSnapAction',  '00010001000200020000', 'MM_SMAddSnapAction', '00010001000200020000')
GO

