

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMAddReplicaChildForInlineSnap.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MM_SMAddReplicaChildForInlineSnap')
BEGIN
	print '>>> Drop Stored Procedure: MM_SMAddReplicaChildForInlineSnap <<<'
	drop procedure MM_SMAddReplicaChildForInlineSnap
END
IF EXISTS (select * from GxQscripts where name='MM_SMAddReplicaChildForInlineSnap')
	delete from GxQscripts where name = 'MM_SMAddReplicaChildForInlineSnap'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMAddReplicaChildForInlineSnap')
	delete from GXDBVersions where aliasname = 'MM_SMAddReplicaChildForInlineSnap'
GO
print '... Creating Procedure: MM_SMAddReplicaChildForInlineSnap'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMAddReplicaChildForInlineSnap
  @i_xmlTextInput XML
AS
  DECLARE @o_errorcode INTEGER  
  DECLARE @o_errorstr VARCHAR(255)
--
--   responsibility of this SP is to create Children entries for given child smvolumeid and copyid for VSA V2 only.
--   there can be multiple smvolumeid but always single copyid ( as we are calling this from a single VM snapbackup inline context which
--   may have multiple snaps but single copy.
--
-----------------------------------------------------------------------------
-- Process Input XML
-----------------------------------------------------------------------------
-- XML Structure for MM_SMAddReplicaChildForInlineSnap
/*
    <MM_SMAddReplicaChildForInlineSnap>
        <SMVolumeId></SMVolumeId>
		<ReplicaCopyId></ReplicaCopyId>
    </MM_SMAddReplicaChildForInlineSnap>
*/
SET NOCOUNT ON
BEGIN TRY
	-- Initialize the Output Parameters
	SET @o_ErrorCode = 0
	SET @o_ErrorStr = ''
	DECLARE @ReplicaCopyId INT = 0
	DECLARE @TBL_SMVOLUME_TMP TABLE (SMVolumeId INT);
	--get snapids into table
	INSERT INTO @TBL_SMVOLUME_TMP
	SELECT r.ref.value('.', 'int')
	FROM @i_xmlTextInput.nodes('/MM_SMAddReplicaChildForInlineSnap/SMVolumeId') R(ref)
	-- get ReplicaCopyId
	SET @ReplicaCopyId = Isnull((
				SELECT r.ref.value('.', 'int')
				FROM @i_xmlTextInput.nodes('/MM_SMAddReplicaChildForInlineSnap/ReplicaCopyId') R(ref)
				), 0)
	IF EXISTS (
			SELECT 1
			FROM @TBL_SMVOLUME_TMP
			)
	BEGIN
		IF Object_id('tempdb.dbo.#TEMP_CHILD_VOL') IS NOT NULL
			DROP TABLE #TEMP_CHILD_VOL
		--
		-- find child entries for source copy
		-- find Children entries for same *master job , find it for *source copy of current copy and it should be for same LUN (*snapsourcedevice)
		-- and as we are dealing here with only VSA V2 volumes add that check too VSA_V2_SNAP
		SELECT *
		INTO #TEMP_CHILD_VOL
		FROM (
			SELECT DISTINCT vol.*
				,map2.smsnapid AS map_smsnapid /*current smsnapid*/
				,map2.metadataid AS map_metadataid
				,map2.groupid AS map_groupid
				,map2.pruneflags AS map_pruneflags
				,map2.origccid AS map_origccid
				,map2.guid AS map_guid
				,map2.reservefield1 AS map_reservefield1
				,map2.reservefield2 AS map_reservefield2
				,map2.reservefieldstr AS map_reservefieldstr
				,map2.flags AS map_flags
				,map2.grouptype AS map_grouptype
			FROM smvolume VOL(READUNCOMMITTED)
			INNER JOIN @TBL_SMVOLUME_TMP VOLTmp ON VOL.smvolumeid = VOLTmp.smvolumeid
			INNER JOIN smvolsnapmap map ON map.smvolumeid = VOLTmp.smvolumeid
				AND VOL.volumeflags & Cast(4294967296 AS BIGINT) > 0 /*CVSM_VOLUMEFLAGS_VSA_V2_SNAP_DB */
			INNER JOIN smsnap snap ON map.smsnapid = snap.smsnapid
			INNER JOIN smvolume vol2 ON vol.masterjobid = vol2.masterjobid
				AND VOL2.volumeflags & Cast(4294967296 AS BIGINT) > 0 /*CVSM_VOLUMEFLAGS_VSA_V2_SNAP_DB */
			INNER JOIN smvolsnapmap map2 ON map2.smvolumeid = vol2.smvolumeid
			INNER JOIN smsnap snap2 ON map2.smsnapid = snap2.smsnapid
			WHERE vol2.copyid = @ReplicaCopyId AND snap.snapsourcedevice != ''
				AND snap.snapsourcedevice = snap2.snapsourcedevice
			) AS Output1
		DECLARE @child_vol_count INT = 0
		SELECT @child_vol_count = count(*)
		FROM #TEMP_CHILD_VOL
		--
		-- reset :-  mountstatus , creation time , copyid , mounthost , prune and volume flags
		-- which are cloned from source copy Children volume entry.
		--
		IF @child_vol_count > 0
		BEGIN -- child count > 0
			DECLARE @archfileid INT = 0
			DECLARE @commcellid INT = 0
			SELECT TOP 1 @archfileid = archfileid
				,@commcellid = commcellid
			FROM #TEMP_CHILD_VOL
			-- Only single VM volume is sent with single afile id so this is ok
			EXEC ArchFileCopyCreate @archfileid
				,@commcellid
				,@ReplicaCopyId
				,0 --flags always 0
				,1 --isvalid
				,2 --always set stream id = 2 for snap
			UPDATE #TEMP_CHILD_VOL
			SET mountstatus = 39 /*created*/
				,creationtime = dbo.Getunixtime(Getutcdate())
				,copyid = @ReplicaCopyId
				,mounthostid = 0
				,pruneflags = 1
,volumeflags = volumeflags | 1048576 /*CVSM_VOLUMEFLAGS_REPLICA_SNAP_VOL_DB=1048576*/
			--
			-- table to keep newsly inserted smvolume and smvolsnapmap entries.
			--
			DECLARE @TEMP_SMVOLSNAPMAP TABLE (
				smvolumeid_Del INT
				,smvolumeid_Ins INT
				,map_old_smvolumeid INT -- which is mapped to #TEMP_CHILD_VOL
				,map_smsnapid INT
				,map_metadataid INT
				,map_groupid INT
				,map_pruneflags INT
				,map_origccid INT
				,map_reservefield1 INT
				,map_reservefield2 INT
				,map_reservefieldstr NVARCHAR
				,map_flags INT
				,map_grouptype INT
				)
			BEGIN TRANSACTION TXN_ADDREPLICACHILDFORINLINESNAP
			--
			-- insert new smvolume entry for cloned Children volume entry for given copy and snapid.
			-- and keep newly inserted volumeid into above table for adding smvolsnapmap.
			--
			MERGE SMVolume vol
			USING (
				SELECT DISTINCT tVol.smvolumeid
					,tVol.sourceclientid
					,tVol.mounthostid
					,tVol.commcellid
					,tVol.jobid
					,tVol.archfileid
					,tVol.copyid
					,tVol.appid
					,tVol.apptypeid
					,tVol.pruneflags
					,tVol.volumeflags
					,tVol.volumestatus
					,tVol.volumestatusupdatetime
					,tVol.mountstatus
					,tVol.mountstatusupdatetime
					,tVol.logicalunmounttime
					,tVol.creationtime
					,tVol.retrycount
					,tVol.devmode
					,tVol.userid
					,tVol.groupid
					,tVol.snapsource
					,tVol.mountproxyid
					,tVol.remoteop
					,tVol.remoteopstatus
					,tVol.vmhostid
					,tVol.recoverypointid
					,tVol.originclientid
					,tVol.sourcepath
					,tVol.mountpath
					,tVol.sourceguid
					,tVol.mountguid
					,tVol.sourcedevice
					,tVol.mountdevice
					,tVol.mountoptions
					,tVol.shadowsetid
					,tVol.shadowcopyid
					,tVol.repbasepath
					,tVol.reprelativepath
					,tVol.originsourcepath
					,tVol.reservefield1
					,tVol.reservefield2
					,tVol.reservefieldstr
					,tVol.sourcevolumeid
					,tVol.masterjobid
					,tVol.partitionnum
					,tVol.usedspacebytes
					,tVol.totalspacebytes
					,tVol.pseudoclientid
					,tVol.requestid
					,tVol.totalretrycount
					,tVol.groupingid
				FROM #TEMP_CHILD_VOL tVol
				WHERE tVol.JobId != tVol.MasterJobId
					AND tVol.VolumeFlags & cast(4294967296 AS BIGINT) /*CVSM_VOLUMEFLAGS_VSA_V2_SNAP_DB */ > 0
					AND tVol.JobId > 0
				) AS tVol1
				ON vol.jobid = tvol1.jobid
					AND vol.archfileid = tvol1.archfileid
					AND vol.copyid = tvol1.copyid
					AND vol.appid = tvol1.appid
					AND vol.apptypeid = tvol1.apptypeid
					AND vol.sourceclientid = tvol1.sourceclientid
					AND vol.commcellid = tvol1.commcellid
			WHEN MATCHED
				THEN
					UPDATE
					SET volumestatusupdatetime = tvol1.volumestatusupdatetime
			WHEN NOT MATCHED BY TARGET
				THEN
					INSERT (
						[sourceclientid]
						,[mounthostid]
						,[commcellid]
						,[jobid]
						,[archfileid]
						,[copyid]
						,[appid]
						,[apptypeid]
						,[pruneflags]
						,[volumeflags]
						,[volumestatus]
						,[volumestatusupdatetime]
						,[mountstatus]
						,[mountstatusupdatetime]
						,[logicalunmounttime]
						,[creationtime]
						,[retrycount]
						,[devmode]
						,[userid]
						,[groupid]
						,[snapsource]
						,[mountproxyid]
						,[remoteop]
						,[remoteopstatus]
						,[vmhostid]
						,[recoverypointid]
						,[originclientid]
						,[sourcepath]
						,[mountpath]
						,[sourceguid]
						,[mountguid]
						,[sourcedevice]
						,[mountdevice]
						,[mountoptions]
						,[shadowsetid]
						,[shadowcopyid]
						,[repbasepath]
						,[reprelativepath]
						,[originsourcepath]
						,[reservefield1]
						,[reservefield2]
						,[reservefieldstr]
						,[sourcevolumeid]
						,[masterjobid]
						,[partitionnum]
						,[usedspacebytes]
						,[totalspacebytes]
						,[pseudoclientid]
						,[requestid]
						,[totalretrycount]
						,[groupingid]
						)
					VALUES (
						tVol1.sourceclientid
						,tVol1.mounthostid
						,tVol1.commcellid
						,tVol1.jobid
						,tVol1.archfileid
						,tVol1.copyid
						,tVol1.appid
						,tVol1.apptypeid
						,tVol1.pruneflags
						,tVol1.volumeflags
						,tVol1.volumestatus
						,tVol1.volumestatusupdatetime
						,tVol1.mountstatus
						,tVol1.mountstatusupdatetime
						,tVol1.logicalunmounttime
						,tVol1.creationtime
						,tVol1.retrycount
						,tVol1.devmode
						,tVol1.userid
						,tVol1.groupid
						,tVol1.snapsource
						,tVol1.mountproxyid
						,tVol1.remoteop
						,tVol1.remoteopstatus
						,tVol1.vmhostid
						,tVol1.recoverypointid
						,tVol1.originclientid
						,tVol1.sourcepath
						,tVol1.mountpath
						,tVol1.sourceguid
						,tVol1.mountguid
						,tVol1.sourcedevice
						,tVol1.mountdevice
						,tVol1.mountoptions
						,tVol1.shadowsetid
						,tVol1.shadowcopyid
						,tVol1.repbasepath
						,tVol1.reprelativepath
						,tVol1.originsourcepath
						,tVol1.reservefield1
						,tVol1.reservefield2
						,tVol1.reservefieldstr
						,tVol1.sourcevolumeid
						,tVol1.masterjobid
						,tVol1.partitionnum
						,tVol1.usedspacebytes
						,tVol1.totalspacebytes
						,tVol1.pseudoclientid
						,tVol1.requestid
						,tVol1.totalretrycount
						,tVol1.groupingid
						)
			OUTPUT deleted.smvolumeid
				,inserted.smvolumeid
				,tVol1.smvolumeid
				,0
				,0
				,0
				,0
				,0
				,0
				,0
				,0
				,0
				,0
			INTO @TEMP_SMVOLSNAPMAP;
			--
			-- Update variable table @TEMP_SMVOLSNAPMAP using temp table #TEMP_CHILD_VOL
			-- wrt newly inserted smvolume & oldsmvolume and smsnapid etc.
			--
			MERGE @TEMP_SMVOLSNAPMAP tMap
			USING (
				SELECT tVOl.*
					,tMap2.smvolumeid_Ins
				FROM #TEMP_CHILD_VOL tVol
					,@TEMP_SMVOLSNAPMAP tMap2
				WHERE tVol.SMVolumeId = tMap2.map_old_smvolumeid
				) AS tVol
				ON tVol.SMVolumeId = tMap.map_old_smvolumeid
					AND tVol.map_smsnapid = tMap.map_smsnapid
			WHEN MATCHED
				THEN
					UPDATE
					SET map_smsnapid = tvol.map_smsnapid
						,map_metadataid = tVol.map_metadataid
						,map_groupid = tVol.map_groupid
						,map_pruneflags = tVol.map_pruneflags
						,map_origccid = tVol.map_origccid
						,map_reservefield1 = tVol.map_reservefield1
						,map_reservefield2 = tVol.map_reservefield2
						,map_reservefieldstr = tVol.map_reservefieldstr
						,map_flags = tVol.map_flags
						,map_grouptype = tVol.map_grouptype
			WHEN NOT MATCHED BY TARGET
				THEN
					INSERT (
						smvolumeid_Del
						,smvolumeid_Ins
						,map_old_smvolumeid
						,map_smsnapid
						,map_metadataid
						,map_groupid
						,map_pruneflags
						,map_origccid
						,map_reservefield1
						,map_reservefield2
						,map_reservefieldstr
						,map_flags
						,map_grouptype
						)
					VALUES (
						0 -- smvolumeid_Del
						,tvol.smvolumeid_Ins
						,tvol.smvolumeid
						,tvol.map_smsnapid
						,tVol.map_metadataid
						,tVol.map_groupid
						,tVol.map_pruneflags
						,tVol.map_origccid
						,tVol.map_reservefield1
						,tVol.map_reservefield2
						,tVol.map_reservefieldstr
						,tVol.map_flags
						,tVol.map_grouptype
						);
			--
			-- add volsnapmap entry using newly inserted volume id and smsnapid ( original )
			-- copy all other values from previous copy Children entry , modify smvolume ( new ) and smsnap original.
			--
			MERGE SMVolSnapMap map
			USING (
				SELECT DISTINCT *
				FROM @TEMP_SMVOLSNAPMAP tMap
				WHERE tmap.map_smsnapid > 0
				) AS tMap
				ON map.smvolumeid = tmap.smvolumeid_Ins
					AND map.smsnapid = tmap.map_smsnapid
			WHEN NOT MATCHED BY TARGET
				THEN
					INSERT (
						[smvolumeid] -- this is newly added entry
						,[smsnapid] -- this is given smsnapid whose Children we added.
						,[metadataid]
						,[groupid]
						,[pruneflags]
						,[origccid]
						,[reservefield1]
						,[reservefield2]
						,[reservefieldstr]
						,[flags]
						,[grouptype]
						)
					VALUES (
						tMap.smvolumeid_Ins
						,tMap.map_smsnapid
						,tMap.map_metadataid
						,tMap.map_groupid
						,tMap.map_pruneflags
						,tMap.map_origccid
						,tMap.map_reservefield1
						,tMap.map_reservefield2
						,tMap.map_reservefieldstr
						,tMap.map_flags
						,tMap.map_grouptype
						);
		END -- child count > 0
	END
	IF Object_id('tempdb.dbo.#TEMP_CHILD_VOL') IS NOT NULL
		DROP TABLE #TEMP_CHILD_VOL
	COMMIT TRANSACTION TXN_ADDREPLICACHILDFORINLINESNAP
END TRY
BEGIN CATCH
	ROLLBACK TRANSACTION TXN_ADDREPLICACHILDFORINLINESNAP
	IF Object_id('tempdb.dbo.#TEMP_CHILD_VOL') IS NOT NULL
		DROP TABLE #TEMP_CHILD_VOL
	SET @o_errorcode = Error_number()
	SET @o_errorstr = Error_message()
END CATCH
SELECT @o_errorcode
	,@o_errorstr
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMAddReplicaChildForInlineSnap')
	delete from GxQscripts where name = 'MM_SMAddReplicaChildForInlineSnap'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMAddReplicaChildForInlineSnap')
	delete from GXDBVersions where aliasname = 'MM_SMAddReplicaChildForInlineSnap'
GO

insert into GXDBVersions values(2, 'MM_SMAddReplicaChildForInlineSnap',  '00000000000000000000', 'MM_SMAddReplicaChildForInlineSnap', '00000000000000000000')
GO

