

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMAddDefaultArrayEntries.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMAddDefaultArrayEntries.sp,v $ $Id: MM_SMAddDefaultArrayEntries.sp,v 1.1.4.5 2020/09/23 03:34:32 vimalkumar Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MM_SMAddDefaultArrayEntries')
BEGIN
	print '>>> Drop Stored Procedure: MM_SMAddDefaultArrayEntries <<<'
	drop procedure MM_SMAddDefaultArrayEntries
END
IF EXISTS (select * from GxQscripts where name='MM_SMAddDefaultArrayEntries')
	delete from GxQscripts where name = 'MM_SMAddDefaultArrayEntries'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMAddDefaultArrayEntries')
	delete from GXDBVersions where aliasname = 'MM_SMAddDefaultArrayEntries'
GO
print '... Creating Procedure: MM_SMAddDefaultArrayEntries'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMAddDefaultArrayEntries
AS
SET NOCOUNT ON
DECLARE @ResultSet table (oemId INT)
INSERT INTO @ResultSet
EXEC GetOEMId
IF NOT EXISTS (SELECT 1 FROM @ResultSet WHERE oemId IN (105 /*Netapp*/,115 /*IntelliSnap for NetApp*/))
BEGIN
	/*Default Microsoft Azure and Amazon AWS entries with empty creds*/
	DECLARE @amazonArrayId VARCHAR(40) = 'AWS-DefaultUseIAMRoleArray'
IF NOT EXISTS (SELECT 1 FROM SMControlHost WITH (READUNCOMMITTED) WHERE SMArrayId = @amazonArrayId AND SnapVendorName = 'Amazon'/*SM_SNAPSHOT_ENGINE_AMAZON_VENDORNAME*/)
	BEGIN
		INSERT INTO SMControlHost(SnapShotEngineId, SnapVendorName, SMArrayId, SMHostPortNumber, SMHostFlags, SMHostStatus, SnapShotEngineName, SMHostOption)
values (0, 'Amazon'/*SM_SNAPSHOT_ENGINE_AMAZON_VENDORNAME*/, @amazonArrayId, 0, 0, 1, 'Amazon Web Services'/*SM_SNAPSHOT_ENGINE_AMAZON_AWS_NAME*/ ,0)
	END
	DECLARE @azureArrayId VARCHAR(40) = 'Azure-Default-MSI'
IF NOT EXISTS (SELECT 1 FROM SMControlHost WITH (READUNCOMMITTED) WHERE SMArrayId = @azureArrayId AND SnapVendorName = 'Microsoft Azure'/*SM_SNAPSHOT_ENGINE_MS_AZURE_VENDORNAME*/)
	BEGIN
		INSERT INTO SMControlHost(SnapShotEngineId, SnapVendorName, SMArrayId, SMHostPortNumber, SMHostFlags, SMHostStatus, SnapShotEngineName, SMHostOption)
values (0, 'Microsoft Azure'/*SM_SNAPSHOT_ENGINE_MS_AZURE_VENDORNAME*/, @azureArrayId, 0, 0, 1, 'Microsoft Azure Snap'/*SM_SNAPSHOT_ENGINE_MS_AZURE_SNAP_NAME*/ ,0)
	END
	DECLARE @OldGCPArrayId VARCHAR(40) = 'Google-Default'
	DECLARE @GCPArrayId VARCHAR(40) = 'GCP-Default-IAM'
IF EXISTS (SELECT 1 FROM SMControlHost WITH (READUNCOMMITTED) WHERE SMArrayId = @OldGCPArrayId AND SnapVendorName = 'Google Cloud Platform'/*SM_SNAPSHOT_ENGINE_GOOGLE_GCP_VENDORNAME*/)
	BEGIN
		UPDATE	SMControlHost
		SET 	SMArrayId = @GCPArrayId
		WHERE	SMArrayId = @OldGCPArrayId
AND SnapVendorName = 'Google Cloud Platform'
	END
IF NOT EXISTS (SELECT 1 FROM SMControlHost WITH (READUNCOMMITTED) WHERE SMArrayId = @GCPArrayId AND SnapVendorName = 'Google Cloud Platform'/*SM_SNAPSHOT_ENGINE_GOOGLE_GCP_VENDORNAME*/)
	BEGIN
		INSERT INTO SMControlHost(SnapShotEngineId, SnapVendorName, SMArrayId, SMHostPortNumber, SMHostFlags, SMHostStatus, SnapShotEngineName, SMHostOption)
values (0, 'Google Cloud Platform'/*SM_SNAPSHOT_ENGINE_GOOGLE_GCP_VENDORNAME*/, @GCPArrayId, 0, 0, 1, 'Google Cloud Platform Snap'/*SM_SNAPSHOT_ENGINE_GOOGLE_GCP_SNAP_NAME*/ ,0)
	END
	DECLARE @nowTime 	int = datediff(second, '01/01/1970', GetUTCdate())
	-- This SQL below will add the SMConfig entries for all the array configs for GCP-Default-IAM.
	BEGIN
	INSERT  INTO    SMConfigs ( MasterConfigId, ArrayId, AssocId, AssocType, ShowInGUI, IsValid,
								EngineId, ValueInt, ValueLL, ValueStr, Created, Modified, OrigCCId,
								GUID, ReserveFieldInt1, ReserveFieldInt2, ReserveFieldInt3, ReserveFieldInt4, ReserveFieldStr)
SELECT  MC.Id, ARR.ControlHostId, ARR.ControlHostId, 3, 1, 1, 0, MC.DefaultInt, MC.DefaultLL, MC.DefaultStr, @nowTime, 0, 2, newid(), 0, 0, 0, 0, N''
	FROM    SMMasterConfigs MC WITH (NOLOCK),
			(   SELECT      CH.ControlHostId, CH.SMArrayId,VEN.Id SnapVendorId, CH.SnapVendorName
				FROM        SMControlHost CH WITH (NOLOCK), SMVendor VEN WITH (NOLOCK)
				WHERE       CH.SnapVendorName = VEN.Name
AND		VEN.Name = 'Google Cloud Platform'
							AND     CH.SMArrayId = @GCPArrayId) ARR
	WHERE   MC.VendorId = ARR.SnapVendorId
AND     MC.Type <> 10
	AND     ARR.ControlHostId > 0
	AND     NOT EXISTS  (   SELECT  1
							FROM    SMConfigs SC WITH (READUNCOMMITTED)
							WHERE   SC.MasterConfigId = MC.Id
							AND     SC.ArrayId = ARR.ControlHostId )
	END
	/* Default Microsoft Azure NetApp Files array entry with empty creds*/
	DECLARE @ANFArrayId VARCHAR(40) = 'AzureNetAppFiles-Default-MI'
IF NOT EXISTS (SELECT 1 FROM SMControlHost WITH (READUNCOMMITTED) WHERE SMArrayId = @ANFArrayId AND SnapVendorName = 'Microsoft Azure'/*SM_SNAPSHOT_ENGINE_MS_AZURE_VENDORNAME*/)
	BEGIN
		INSERT INTO SMControlHost(SnapShotEngineId, SnapVendorName, SMArrayId, SMHostPortNumber, SMHostFlags, SMHostStatus, SnapShotEngineName, SMHostOption)
VALUES (0, 'Microsoft Azure'/*SM_SNAPSHOT_ENGINE_MS_AZURE_VENDORNAME*/, @ANFArrayId, 0, 0, 1, 'Microsoft Azure'/*SM_SNAPSHOT_ENGINE_MS_AZURE_VENDORNAME*/ ,0)
	END
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMAddDefaultArrayEntries')
	delete from GxQscripts where name = 'MM_SMAddDefaultArrayEntries'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMAddDefaultArrayEntries')
	delete from GXDBVersions where aliasname = 'MM_SMAddDefaultArrayEntries'
GO

insert into GXDBVersions values(2, 'MM_SMAddDefaultArrayEntries',  '00010001000400050000', 'MM_SMAddDefaultArrayEntries', '00010001000400050000')
GO

