

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMAddDFMDataSetMembers.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMAddDFMDataSetMembers.sp,v $ $Id: MM_SMAddDFMDataSetMembers.sp,v 1.5.2.3 2018/03/20 00:01:37 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MM_SMAddDFMDataSetMembers <<<'

IF EXISTS (select * from sysobjects where name='MM_SMAddDFMDataSetMembers')
	drop procedure MM_SMAddDFMDataSetMembers
IF EXISTS (select * from GxQscripts where name='MM_SMAddDFMDataSetMembers')
	delete from GxQscripts where name = 'MM_SMAddDFMDataSetMembers'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMAddDFMDataSetMembers')
	delete from GXDBVersions where aliasname = 'MM_SMAddDFMDataSetMembers'
GO
print '... Creating Procedure: MM_SMAddDFMDataSetMembers'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMAddDFMDataSetMembers
  @i_xmlTextInput XML,
  @i_reserveInt INTEGER,
  @i_reserveStr VARCHAR(255)
AS
-- Following are the "columns" returned, in the order in which they are returned
-- Column of NVARCHAR_UTF8(MAX) type should be at the end
  DECLARE @o_Id INT
  DECLARE @o_DataSetMemberId INT
  DECLARE @o_DataSetId INT
  DECLARE @o_errCode INT
  DECLARE @o_errMsg VARCHAR(255)
SET NOCOUNT ON
BEGIN
	DECLARE @tblDSMembers TABLE
		(	Id						int,
			ControlHostId			int,
			SMRelationId			int,
			AppId					int,
			DataSetId				int,
			ExtDataSetId			NVARCHAR(512),
			DataSetMemberId			int,
			ExtDataSetMemberId		NVARCHAR(512),
			ExtDataSetMemberName	NVARCHAR(512),
			Flags					int	)
	DECLARE @errCode	INT = 0
	DECLARE @errMsg		VARCHAR(255) = ''
    INSERT  INTO @tblDSMembers
    SELECT  ref.value('./Id[1]', 'int') AS Id,
			ref.value('./ControlHostId[1]', 'int') AS ControlHostId,
			0 AS SMRelationId,
			ref.value('./AppId[1]', 'int') AS AppId,
			ISNULL(ref.value('./DataSetId[1]', 'int'), 0) AS DataSetId,
			ref.value('./ExtDataSetId[1]', 'NVARCHAR(512)') AS ExtDataSetId,
			ISNULL(ref.value('./DataSetMemberId[1]', 'int'), 0) AS DataSetMemberId,
			ref.value('./ExtDataSetMemberId[1]', 'NVARCHAR(512)') AS ExtDataSetMemberId,
			ref.value('./ExtDataSetMemberName[1]', 'NVARCHAR(255)') AS ExtDataSetMemberName,
			ref.value('./Flags[1]', 'int') AS Flags
    FROM @i_xmlTextInput.nodes('/MM_SMAddDFMDataSetMembers/DataSetMember') R(ref)
	UPDATE 	@tblDSMembers
	SET		DataSetId = DS.DataSetId,
			SMRelationId = DS.SMRelationId
	FROM	@tblDSMembers TMP
			INNER JOIN SMDataSet DS ON DS.ControlHostId = TMP.ControlHostId
				AND DS.ExtDataSetId = TMP.ExtDataSetId
	UPDATE	@tblDSMembers
	SET		DataSetMemberId = DS_MEM.DataSetMemberId
	FROM	@tblDSMembers TMP
			INNER JOIN SMDataSetMember DS_MEM (NOLOCK) ON DS_MEM.DataSetId = TMP.DataSetId
				AND TMP.ExtDataSetMemberId = DS_MEM.ExtDataSetMemberId
				AND TMP.ExtDataSetMemberName = DS_MEM.ExtDataSetMemberName
				AND TMP.AppId = DS_MEM.Appid
	IF EXISTS (SELECT * FROM SMDataSetMember (NOLOCK)
				WHERE DataSetMemberId IN (SELECT DataSetMemberId FROM @tblDSMembers)
AND Flags & 256 = 256)
	BEGIN
SET @errCode = 60916
		SET @errMsg = 'Failed to add dataset members to DB, since they are already aged.'
		GOTO ERR_EXIT
	END
	UPDATE	DS_MEM
	SET		DS_MEM.Flags = DS_MEM.Flags | TMP.Flags
	FROM	@tblDSMembers TMP
			INNER JOIN SMDataSetMember DS_MEM ON TMP.DataSetMemberId = DS_MEM.DataSetMemberId
	WHERE	DS_MEM.Flags & TMP.Flags <> TMP.Flags
	DECLARE @currentTime INT = dbo.GetUnixTime(GETUTCDATE())
	INSERT	INTO SMDataSetMember (DataSetId, AppId, ExtDataSetMemberId, ExtDataSetMemberName,
			SMRelationId, Flags, CreatedTime, ModifiedTime, AgedTime, AgedBy)
	SELECT	DataSetId, AppId, ExtDataSetMemberId, ExtDataSetMemberName, SMRelationId, Flags,
			@currentTime, @currentTime, 0, 0
	FROM	@tblDSMembers
	WHERE	DataSetMemberId = 0
	SET @errCode = @@ERROR
	IF @errCode > 0
	BEGIN
SET @errCode = 60913
		SET @errMsg = 'Failed to insert DFM DataSet Members into SMDataSetMember.'
		GOTO ERR_EXIT
	END
	UPDATE	@tblDSMembers
	SET		DataSetMemberId = DS_MEM.DataSetMemberId
	FROM	@tblDSMembers TMP
			INNER JOIN SMDataSetMember DS_MEM (NOLOCK) ON DS_MEM.DataSetId = TMP.DataSetId
				AND TMP.ExtDataSetMemberId = DS_MEM.ExtDataSetMemberId
				AND TMP.ExtDataSetMemberName = DS_MEM.ExtDataSetMemberName
				AND TMP.AppId = DS_MEM.Appid
	WHERE	TMP.DataSetMemberId = 0
	SET @errCode = @@ERROR
	IF @errCode > 0
	BEGIN
SET @errCode = 60913
		SET @errMsg = 'Error in getting DataSetMember Ids from SMDataSetMember.'
		GOTO ERR_EXIT
	END
	SELECT	Id, DataSetMemberId, DataSetId, @errCode, @errMsg
	FROM	@tblDSMembers
	RETURN
ERR_EXIT:
	SELECT	0, 0, 0, @errCode, @errMsg
	RETURN
END
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMAddDFMDataSetMembers')
	delete from GxQscripts where name = 'MM_SMAddDFMDataSetMembers'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMAddDFMDataSetMembers')
	delete from GXDBVersions where aliasname = 'MM_SMAddDFMDataSetMembers'
GO

insert into GXDBVersions values(2, 'MM_SMAddDFMDataSetMembers',  '00010005000200030000', 'MM_SMAddDFMDataSetMembers', '00010005000200030000')
GO

