

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_SMActiveSnapOperation.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_SMActiveSnapOperation.sp,v $ $Id: MM_SMActiveSnapOperation.sp,v 1.4.40.3 2019/12/31 23:04:49 rksingh Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MM_SMActiveSnapOperation')
BEGIN
	print '>>> Drop Stored Procedure: MM_SMActiveSnapOperation <<<'
	drop procedure MM_SMActiveSnapOperation
END
IF EXISTS (select * from GxQscripts where name='MM_SMActiveSnapOperation')
	delete from GxQscripts where name = 'MM_SMActiveSnapOperation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMActiveSnapOperation')
	delete from GXDBVersions where aliasname = 'MM_SMActiveSnapOperation'
GO
print '... Creating Procedure: MM_SMActiveSnapOperation'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MM_SMActiveSnapOperation
  @i_opType INTEGER,
  @i_xmlTextInput XML,
  @i_reserveInt INTEGER,
  @i_reserveStr VARCHAR(255)
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_SMSnapId INT
  DECLARE @o_ArrayName NVARCHAR(1024)
  DECLARE @o_SourceDevice NVARCHAR(1024)
  DECLARE @o_TargetDevice NVARCHAR(1024)
  DECLARE @o_Status INT
  DECLARE @o_Flags INT
  DECLARE @o_ErrCode INT
  DECLARE @o_ErrString VARCHAR(255)
SET NOCOUNT ON
BEGIN
	DECLARE @errCode	INT = 0
	DECLARE @errString	VARCHAR(255) = ''
	DECLARE @SM_GET_ACTIVE_SNAP_REQ		INT = 1
	DECLARE @SM_SET_ACTIVE_SNAP_REQ		INT = 3
	DECLARE @SM_DELETE_ACTIVE_SNAP_REQ	INT = 5
	DECLARE @tblInputParams TABLE
	(
		SMSnapId		INT,
		ArrayName		NVARCHAR(1024),
		SourceDevice	NVARCHAR(1024),
		TargetDevice	NVARCHAR(1024),
		Status			INT DEFAULT 0,
		Flags			INT DEFAULT 0,
		ControlHostId	INT DEFAULT 0
	)
	IF @i_opType = @SM_GET_ACTIVE_SNAP_REQ
	BEGIN
		-- Get ArrayIds from input
		INSERT  INTO @tblInputParams
		SELECT  DISTINCT 0 AS SMSnapId,
				ref.value('@ArrayName', 'NVARCHAR(1024)') AS ArrayName,
				NULL AS SourceDevice,
				NULL AS TargetDevice,
				0 AS Status,
				0 AS Flags,
				0 AS ControlHostId
		FROM	@i_xmlTextInput.nodes('/MM_SMActiveSnapOperation') R(ref)
		-- Get active snaps for input ArrayIds
		SELECT	DISTINCT ACT.SMSnapId, CH.SMArrayId, ACT.SourceDevice, ACT.TargetDevice, ACT.Status, ACT.Flags, @errCode, @errString
		FROM	@tblInputParams INP
				JOIN SMControlHost CH ON CH.SMArrayId = INP.ArrayName
				JOIN SMActiveSnap ACT ON ACT.ArrayNum = CH.ControlHostId
		RETURN
	END
	ELSE IF @i_opType = @SM_SET_ACTIVE_SNAP_REQ
	BEGIN
		-- Get ArrayId-SrcDev-TgtDev rows from input
		INSERT  INTO @tblInputParams
		SELECT  DISTINCT ref.value('@SMSnapId', 'INT') AS SMSnapId,
				ref.value('@ArrayName', 'NVARCHAR(1024)') AS ArrayName,
				ref.value('@SourceDevice', 'NVARCHAR(1024)') AS SourceDevice,
				ref.value('@TargetDevice', 'NVARCHAR(1024)') AS TargetDevice,
				0 AS Status,
				ref.value('@Flags', 'INT') AS Flags,
				0 AS ControlHostId
		FROM	@i_xmlTextInput.nodes('/MM_SMActiveSnapOperation/ActiveSnapList/ActiveSnap') R(ref)
		-- Fill ControlHostId
		UPDATE	INPUT
		SET		ControlHostId = CH.ControlHostId
		FROM	@tblInputParams INPUT
				JOIN SMControlHost CH ON CH.SMArrayId = INPUT.ArrayName
		-- Mark snaps that are not in SMActiveSnap
		UPDATE	INPUT
		SET		Status = 1
		FROM	@tblInputParams INPUT INNER JOIN SMSnap SNAP ON SNAP.SMSnapId = INPUT.SMSnapId
		WHERE	INPUT.TargetDevice NOT IN (SELECT TargetDevice FROM SMActiveSnap WHERE ArrayNum = INPUT.ControlHostId)
		-- Add marked snaps to SMActiveSnap
		INSERT	INTO SMActiveSnap (SMSnapId, ArrayNum, SourceDevice, TargetDevice, Status, Flags, CreationTime)
		SELECT	INP.SMSnapId, INP.ControlHostId, INP.SourceDevice, INP.TargetDevice, INP.Status, INP.Flags, dbo.GetUnixTime(GetUTCDate())
		FROM	@tblInputParams INP
		WHERE	INP.Status = 1
		-- Output
		SELECT	INP.SMSnapId, INP.ArrayName, INP.SourceDevice, INP.TargetDevice, INP.Status, INP.Flags, @errCode, @errString
		FROM	@tblInputParams INP
		RETURN
	END
	ELSE IF @i_opType = @SM_DELETE_ACTIVE_SNAP_REQ
	BEGIN
		-- Get ArrayId-SrcDev-TgtDev rows from input
		INSERT  INTO @tblInputParams
		SELECT  DISTINCT ref.value('@SMSnapId', 'INT') AS SMSnapId,
				ref.value('@ArrayName', 'NVARCHAR(1024)') AS ArrayName,
				ref.value('@SourceDevice', 'NVARCHAR(1024)') AS SourceDevice,
				ref.value('@TargetDevice', 'NVARCHAR(1024)') AS TargetDevice,
				0 AS Status,
				ref.value('@Flags', 'INT') AS Flags,
				0 AS ControlHostId
		FROM	@i_xmlTextInput.nodes('/MM_SMActiveSnapOperation/ActiveSnapList/ActiveSnap') R(ref)
		-- Fill ControlHostId
		UPDATE	INPUT
		SET		ControlHostId = CH.ControlHostId
		FROM	@tblInputParams INPUT
				JOIN SMControlHost CH ON CH.SMArrayId = INPUT.ArrayName
		-- Delete reservation entry for mathcing target devices in SMActiveSnap
		DELETE ACT FROM SMActiveSnap ACT INNER JOIN @tblInputParams INP ON ACT.SMSnapId = INP.SMSnapId
		AND ACT.ArrayNum = INP.ControlHostId
		AND ACT.TargetDevice = INP.TargetDevice
		AND ACT.SourceDevice = INP.SourceDevice
		-- Output
		SELECT	INP.SMSnapId, INP.ArrayName, INP.SourceDevice, INP.TargetDevice, INP.Status, INP.Flags, @errCode, @errString
		FROM	@tblInputParams INP
		RETURN
	END
	ELSE
	BEGIN
SET @errCode = 60293
		SET @errString = 'Invalid operation type passed to stored procedure MM_SMActiveSnapOperation'
		GOTO ERR_EXIT
	END
ERR_EXIT:
	SELECT	0, '', '', '', 0, 0, @errCode, @errString
	RETURN
END
GO

IF EXISTS (select * from GxQscripts where name = 'MM_SMActiveSnapOperation')
	delete from GxQscripts where name = 'MM_SMActiveSnapOperation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_SMActiveSnapOperation')
	delete from GXDBVersions where aliasname = 'MM_SMActiveSnapOperation'
GO

insert into GXDBVersions values(2, 'MM_SMActiveSnapOperation',  '00010004004000030000', 'MM_SMActiveSnapOperation', '00010004004000030000')
GO

