

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_GUIAuditHybridCloudOp.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_GUIAuditHybridCloudOp.sp,v $ $Id: MM_GUIAuditHybridCloudOp.sp,v 1.1.2.3 2019/06/04 21:17:05 aselvanayagam Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MM_GUIAuditHybridCloudOp')
BEGIN
	print '>>> Drop Stored Procedure: MM_GUIAuditHybridCloudOp <<<'
	drop procedure MM_GUIAuditHybridCloudOp
END
IF EXISTS (select * from GxQscripts where name='MM_GUIAuditHybridCloudOp')
	delete from GxQscripts where name = 'MM_GUIAuditHybridCloudOp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_GUIAuditHybridCloudOp')
	delete from GXDBVersions where aliasname = 'MM_GUIAuditHybridCloudOp'
GO
print '... Creating Procedure: MM_GUIAuditHybridCloudOp'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MM_GUIAuditHybridCloudOp
  @in_userId integer,
  @in_hybridCloudOpId integer,
  @in_cloudLibId integer,
  @in_diskLibId integer,
  @in_oldDiskLibId integer
AS
SET NOCOUNT ON
-- Declare temp variables for Gui Audit
DECLARE @opMsgId INTEGER
DECLARE @userId INTEGER
DECLARE @opEvMsgId INTEGER
DECLARE @opId INTEGER
DECLARE @paramMsgId INTEGER
DECLARE @paramData NVARCHAR(1024)
DECLARE @dataIsEvent INTEGER
-- Set Gui Audit Operation
SET @opMsgId = (106 | (CAST(POWER(2, 24) AS BIGINT) * 84))
SET @userId = @in_userId
EXEC EvGuiAuditSetOperation @opMsgId, @userId, @opEvMsgId OUTPUT, @opId OUTPUT
IF @in_hybridCloudOpId = 0
BEGIN
	-- Hybrid Cloud Option was disabled
SET @paramMsgId = (1561 | (CAST(POWER(2, 24) AS BIGINT) * 85))
	EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
END
ELSE IF @in_hybridCloudOpId = 1
BEGIN
	-- Hybrid Cloud Option was enabled
SET @paramMsgId = (1562 | (CAST(POWER(2, 24) AS BIGINT) * 85))
	EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
END
ELSE IF @in_hybridCloudOpId = 2
BEGIN
	-- Hybrid Cloud Option was modified
SET @paramMsgId = (1563 | (CAST(POWER(2, 24) AS BIGINT) * 85))
	EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
END
-- Cloud Library
IF (@in_cloudLibId <> 0)
BEGIN
SET @paramMsgId = (1559 | (CAST(POWER(2, 24) AS BIGINT) * 85))
	-- Set data for Cloud Library
	SET @paramData = (SELECT AliasName FROM MMLibrary WHERE LibraryId = @in_cloudLibId)
	SET @dataIsEvent = 0
	EXEC EvGuiAuditSetParamData @opId, @paramData, @dataIsEvent
	EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
END
-- Disk Library
IF (@in_diskLibId <> 0)
BEGIN
SET @paramMsgId = (1560 | (CAST(POWER(2, 24) AS BIGINT) * 85))
	-- Set data for Disk Library
	SET @paramData = (SELECT AliasName FROM MMLibrary WHERE LibraryId = @in_diskLibId)
	SET @dataIsEvent = 0
	EXEC EvGuiAuditSetParamData @opId, @paramData, @dataIsEvent
	EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
END
-- Old Disk Library
IF (@in_hybridCloudOpId = 2 AND (@in_oldDiskLibId <> 0))
BEGIN
SET @paramMsgId = (1564 | (CAST(POWER(2, 24) AS BIGINT) * 85))
	-- Set data for Old Disk Library
	SET @paramData = (SELECT AliasName FROM MMLibrary WHERE LibraryId = @in_oldDiskLibId)
    SET @dataIsEvent = 0
    EXEC EvGuiAuditSetParamData @opId, @paramData, @dataIsEvent
EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
END
GO

IF EXISTS (select * from GxQscripts where name = 'MM_GUIAuditHybridCloudOp')
	delete from GxQscripts where name = 'MM_GUIAuditHybridCloudOp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_GUIAuditHybridCloudOp')
	delete from GXDBVersions where aliasname = 'MM_GUIAuditHybridCloudOp'
GO

insert into GXDBVersions values(2, 'MM_GUIAuditHybridCloudOp',  '00010001000200030000', 'MM_GUIAuditHybridCloudOp', '00010001000200030000')
GO

