

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MM_DDBMoveCheckISBackupOrAuxCopyRunning.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MM_DDBMoveCheckISBackupOrAuxCopyRunning.sp,v $ $Id: MM_DDBMoveCheckISBackupOrAuxCopyRunning.sp,v 1.5.12.9 2020/11/17 13:27:09 shubhamagrawal Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='MM_DDBMoveCheckISBackupOrAuxCopyRunning')
BEGIN
	print '>>> Drop Stored Procedure: MM_DDBMoveCheckISBackupOrAuxCopyRunning <<<'
	drop procedure MM_DDBMoveCheckISBackupOrAuxCopyRunning
END
IF EXISTS (select * from GxQscripts where name='MM_DDBMoveCheckISBackupOrAuxCopyRunning')
	delete from GxQscripts where name = 'MM_DDBMoveCheckISBackupOrAuxCopyRunning'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_DDBMoveCheckISBackupOrAuxCopyRunning')
	delete from GXDBVersions where aliasname = 'MM_DDBMoveCheckISBackupOrAuxCopyRunning'
GO
print '... Creating Procedure: MM_DDBMoveCheckISBackupOrAuxCopyRunning'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure MM_DDBMoveCheckISBackupOrAuxCopyRunning
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @storeid integer,
  @DoNotIncludeCloudLaptopBackupJobs integer = 0,
  @DoNotIncludePseudoVMChildJobs integer = 0
AS
--:DECLARE  isBkpOrAuxCopyRunning    int
  DECLARE @JobId int
--set @isBkpOrAuxCopyRunning=0
DECLARE  @tmpJobsRunningTbl TABLE(jobId integer)
DECLARE  @copiesOfStore TABLE( copyid integer )
declare  @jobsRunningToSp Table(spid  integer,jobid integer)
declare  @jobsRunningToPrimaryCopies table (primaryCopyid integer)
declare @auxCopyRunninngTosp table (archGrpiD integer,jobid integer)
declare @auxCopyRunninngToCopies table (copyid integer,jobid integer)
insert into @copiesOfStore select CopyId from archCopySIDBStore where SIDBStoreId=@storeid
/* Getting running backup jobs */
insert into @tmpJobsRunningTbl
select 	JBKP.JobId
from 	JMBkpJobInfo JBKP WITH(READUNCOMMITTED)
		INNER JOIN JMJobInfo JINFO WITH(READUNCOMMITTED) ON JINFO.JobId = JBKP.JobId
		INNER JOIN archSubclientCopyDDBMap SD WITH(READUNCOMMITTED) ON JBKP.applicationId = SD.appId AND SD.SIDBStoreId = @storeid
		INNER JOIN archGroup AG WITH(READUNCOMMITTED) ON SD.copyId = AG.defaultCopy
		INNER JOIN App_Application A (READUNCOMMITTED) ON A.id = SD.appId AND AG.id IN (A.logarchGrpId, A.dataarchGrpId)
WHERE 	JINFO.State <> 5
		AND (@DoNotIncludeCloudLaptopBackupJobs = 0 OR JINFO.opType <> 116) --STATELESS_BACKUP =116, filter the cloud laptop backup jobs if filter is enabled
AND (@DoNotIncludePseudoVMChildJobs = 0 OR (JBKP.bkpAttributesEx & 0x4000000) = 0)
/* Getting running AuxCopy jobs */
--Old Auxcopy jobs
insert into @tmpJobsRunningTbl
select 	DISTINCT J.jobid
from 	JMAdminJobInfoTable J WITH(READUNCOMMITTED),
		JMJobInfo JINFO WITH(READUNCOMMITTED),
		archGroupCopy AGC WITH(READUNCOMMITTED),
		archCopySIDBStore CS WITH(READUNCOMMITTED)
where 	CS.SIDBStoreId = @storeid
		AND J.opType = 13
		AND J.jobId = JINFO.jobId
		AND JINFO.State <> 5
		AND J.archGrpID = AGC.archGroupId
		AND AGC.Id = CS.copyId
		AND
		(
			J.archGrpCopyID = AGC.id
			OR
			EXISTS(SELECT 1 FROM archChunkToCopy WITH(READUNCOMMITTED) WHERE adminJobId = J.jobId AND destCopyId = AGC.id)
		)
--Scalable Auxcopy jobs
insert into @tmpJobsRunningTbl
select 	DISTINCT J.jobid
from 	JMAdminJobInfoTable J WITH(READUNCOMMITTED),
		JMJobInfo JINFO WITH(READUNCOMMITTED)
where 	J.opType = 104
		AND J.jobId = JINFO.jobId
		AND JINFO.State <> 5
		AND EXISTS(SELECT 1 FROM ArchChunkToReplicate WITH(READUNCOMMITTED) WHERE adminJobId = J.jobId AND destSIDBStoreId = @storeid)
/*  Getting running data verification jobs, this is moved from job manager.
	If DV2 job is running and trying to move DDB for multiple partition, getting same error pop up multiple times(one pop up for each partition).
	Because if we try to move 2 partition of the same store at the same time, submitting 2 DDB move job for 2 partition. So each job will show the error pop-up.
	To avoiding this issue moving this check from job manager. And modified this check like allowing DDB move job if DV2 job is in suspended state.
	MR - 146748, 146845.
*/
-- opType ARCHIVECHECK = 31(Data Verification job)
-- state  STOPPED = 5 (suspended jobs)
insert into @tmpJobsRunningTbl
select 	AJobInfo.jobId
from 	JMAdminJobInfoTable AS AJobInfo WITH(READUNCOMMITTED)
		INNER JOIN JMJobInfo JobInfo WITH(READUNCOMMITTED) ON JobInfo.jobId = AJobInfo.jobId
where 	AJobInfo.opType = 31
		AND AJobInfo.cloudId = @storeid
		AND JobInfo.state <> 5
select jobId from @tmpJobsRunningTbl
SET NOCOUNT OFF
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  END
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
GO

IF EXISTS (select * from GxQscripts where name = 'MM_DDBMoveCheckISBackupOrAuxCopyRunning')
	delete from GxQscripts where name = 'MM_DDBMoveCheckISBackupOrAuxCopyRunning'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MM_DDBMoveCheckISBackupOrAuxCopyRunning')
	delete from GXDBVersions where aliasname = 'MM_DDBMoveCheckISBackupOrAuxCopyRunning'
GO

insert into GXDBVersions values(2, 'MM_DDBMoveCheckISBackupOrAuxCopyRunning',  '00010005001200090000', 'MM_DDBMoveCheckISBackupOrAuxCopyRunning', '00010005001200090000')
GO

