

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMXMLChangeLibraryForMediaList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMXMLChangeLibraryForMediaList <<<'

IF EXISTS (select * from sysobjects where name='MMXMLChangeLibraryForMediaList')
	drop procedure MMXMLChangeLibraryForMediaList
IF EXISTS (select * from GxQscripts where name='MMXMLChangeLibraryForMediaList')
	delete from GxQscripts where name = 'MMXMLChangeLibraryForMediaList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMXMLChangeLibraryForMediaList')
	delete from GXDBVersions where aliasname = 'MMXMLChangeLibraryForMediaList'
GO
print '... Creating Procedure: MMXMLChangeLibraryForMediaList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MMXMLChangeLibraryForMediaList
  @i_ChangeLibForMedia XML
AS
  DECLARE @errorCode INT
  DECLARE @errorString VARCHAR(512)
SET NOCOUNT ON
--Locale variables
 DECLARE @l_MediaList		TABLE(mediaId INT)
 DECLARE @l_SpareGrpTab		TABLE(srcLibId INT, spareGrpType INT DEFAULT 0, mediaTypeId INT)
 DECLARE @l_DestSpareGrp	TABLE(srcLibId INT, srcSpareGroupType INT,  srcMediaType INT, destSpareGroupId INT DEFAULT 0)
DECLARE @l_LibraryName		nvarchar(128)
 DECLARE @l_ValidateLib		INT
 DECLARE @l_DestLibId		INT
 DECLARE @l_DestSGId		INT
 DECLARE @l_ArgIdx		INT
 DECLARE @l_FullFmtSpecLen	INT
 DECLARE @disassociate 		INT
BEGIN
 SET @errorCode = 0
 SET @errorString = ' '
select	@l_LibraryName = Node.value('@libraryName','nvarchar(128)'),
	--FROM	@i_ChangeLibForMedia.nodes('/EVGui_MMChangeLibraryForMediaReq') Tmpxml(Node)
 	@disassociate = ISNULL(Node.value('@disassociateMediaFromAllOtherLibraries','INT'), 0)
FROM	@i_ChangeLibForMedia.nodes('/EVGui_MMChangeLibraryForMediaReq') Tmpxml(Node)
 INSERT INTO @l_MediaList(mediaID)
 SELECT ID.value('@val','INT')
 FROM @i_ChangeLibForMedia.nodes('/EVGui_MMChangeLibraryForMediaReq/mediaIdList') AS  ParamValues(ID)
 SELECT @l_ValidateLib = Count(*) from MMLibrary where AliasName = @l_LibraryName AND LibraryTypeId <> 3
 SELECT @l_DestLibId = LibraryId FROM MMLibrary where AliasName = @l_LibraryName AND LibraryTypeId <> 3
 IF @l_ValidateLib = 0
 BEGIN
 SET @errorCode = -1
 SET @errorString = 'Incompatible destination library '+@l_LibraryName+'.'
 END
 INSERT @l_SpareGrpTab(srcLibId, spareGrpType, mediaTypeId)
	select MD.LibraryId,MS.SpareGroupType, MD.MediaTypeId FROM MMMedia MD
			INNER JOIN @l_MediaList LM ON MD.mediaId = LM.mediaId
			INNER JOIN 	MMSpareGroup MS ON MD.SpareGroupId = MS.SpareGroupId
INSERT @l_DestSpareGrp(srcLibId, srcSpareGroupType,  srcMediaType, destSpareGroupId )
    SELECT LS.srcLibId, LS.spareGrpType, LS.mediaTypeId, MS.SpareGroupId
	FROM @l_SpareGrpTab LS
				LEFT OUTER JOIN MMSpareGroup MS ON MS.LibraryId = @l_DestLibId
								AND MS.spareGroupType = LS.spareGrpType
								AND (MS.MediaTypeId = LS.MediaTypeID OR LS.spareGrpType > 2)
Update 	@l_DestSpareGrp
	SET destSpareGroupId = MS.SpareGroupId
FROM @l_DestSpareGrp LDS,MMSpareGroup MS WHERE LDS.destSpareGroupId IS NULL AND MS.LibraryId = @l_DestLibId
																			AND MS.SpareGroupType = 2
 UPDATE MMMedia
 	Set SpareGroupId = LD.destSpareGroupId ,
 	LibraryId = @l_DestLibId,
	--LastWriteLibraryId =
	--(
	--case
	--    when @disassociate >0
	--    then
	--       0
	--	when  MMD.MediaLocation = 3 and MMD.LibraryId = 0
	--	then
	--		@l_DestLibId
	--	when MMD.isAged <> 0 OR MMD.isInMediaGroup <> 0
	--	then
	--		LD.srcLibId
	--	else
	--		0
	--END
	--),
	MediaLocation = 3
	FROM MMMedia MMD
	Inner join  MMSpareGroup msg on msg.SpareGroupId = MMD.SpareGroupId
	INNER JOIN @l_DestSpareGrp LD ON LD.srcLibId = MMD.LibraryId AND LD.srcMediaType = MMD.MediaTypeId
																AND LD.srcSpareGroupType = msg.SpareGroupType
	 WHERE  MediaId IN (select mediaId from @l_MediaList)
					AND	MediaId <> 0
					 --AND MMD.LibraryId <> @l_DestLibId
IF( @disassociate > 0)
BEGIN
	UPDATE MMMedia
	SET LastWriteLibraryId = 0
	WHERE MediaId in (select MediaId from @l_MediaList)
END
IF(@@ERROR <> 0)
BEGIN
	SET 	@errorCode = -1
	SET		@errorString	=	'Failed to update MMMedia table.'
END
 SELECT @errorCode, @errorString
 END
GO

IF EXISTS (select * from GxQscripts where name = 'MMXMLChangeLibraryForMediaList')
	delete from GxQscripts where name = 'MMXMLChangeLibraryForMediaList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMXMLChangeLibraryForMediaList')
	delete from GXDBVersions where aliasname = 'MMXMLChangeLibraryForMediaList'
GO

insert into GXDBVersions values(2, 'MMXMLChangeLibraryForMediaList',  '00000000000000000000', 'MMXMLChangeLibraryForMediaList', '00000000000000000000')
GO

