

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMWebScaleStorageInfoForMPAndHost.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2011  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMWebScaleStorageInfoForMPAndHost.sp,v $ $Id: MMWebScaleStorageInfoForMPAndHost.sp,v 1.1.2.5 2018/03/27 09:09:38 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMWebScaleStorageInfoForMPAndHost <<<'

IF EXISTS (select * from sysobjects where name='MMWebScaleStorageInfoForMPAndHost')
	drop procedure MMWebScaleStorageInfoForMPAndHost
IF EXISTS (select * from GxQscripts where name='MMWebScaleStorageInfoForMPAndHost')
	delete from GxQscripts where name = 'MMWebScaleStorageInfoForMPAndHost'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMWebScaleStorageInfoForMPAndHost')
	delete from GXDBVersions where aliasname = 'MMWebScaleStorageInfoForMPAndHost'
GO
print '... Creating Procedure: MMWebScaleStorageInfoForMPAndHost'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMWebScaleStorageInfoForMPAndHost
  @i_hostId integer,
  @i_datapath varchar(1024),
  @i_reserveParam integer
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_MAClientId integer
  DECLARE @o_libId integer
  DECLARE @o_mountPathId integer
  DECLARE @o_drivePoolId integer
  DECLARE @o_deviceId integer
  DECLARE @o_deviceControllerId integer
  DECLARE @o_distributedStorageType integer
  DECLARE @o_storageConfigured integer
  DECLARE @o_flags integer
  DECLARE @o_numHostsInGroup integer
  DECLARE @o_replicationFactor integer
  DECLARE @o_disperseFactor integer
  DECLARE @o_redundancyFactor integer
  DECLARE @o_clientGroupName nvarchar(1024)
  DECLARE @o_MediaAgentName nvarchar(1024)
  DECLARE @o_clientGroupId integer
  DECLARE @o_numHostsInGroupToConfigure integer
  DECLARE @o_hostsFactor integer
  DECLARE @o_numTotalDisksToConfigure integer
  DECLARE @o_numDisksPerHost integer
DECLARE @tblWebScaleForHost  TABLE (	clientId INT, clientGroupId INT, libId INT, mountPathId INT, drivePoolId INT, deviceId INT, deviceControllerId INT, distStorageType INT,
					storageConfigured INT, flags INT, numHostsInGroup INT,  repFactor INT, dispFactor INT, redFactor INT,clientGroupName nvarchar(1024),
					mediaAgentName nvarchar(1024), numHostsInGroupToConfigure INT, hostsFactor INT, numTotalDisksToConfigure INT, numDisksPerHost INT
				    )
DECLARE @tblClientsInGroup TABLE (clientGroupId INT, clientId INT)
-------------TBD------------------------------
----------------------------------------------
    INSERT INTO @tblWebScaleForHost
    SELECT A.ClientId, A.clientGroupId, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, B.name, '', 0, 0, 0, 0
    FROM APP_ClientGroupAssoc A, APP_ClientGroup B, APP_AdvanceSettings S
    WHERE A.ClientId = @i_hostId
    AND A.ClientGroupId = B.id
AND S.EntityType = 28
    AND S.EntityId = B.id
AND S.keyName = 'StoragePool'
    AND CONVERT(nvarchar(max),S.value) = 'true'
    AND S.enabled = 1
AND S.relativePath= 'CommServDB.MediaAgent'
    AND S.deleted = 0
-----------------------------------------------
-----------------------------------------------
-- Get all the clients in all the groups
INSERT INTO @tblClientsInGroup
SELECT A.clientGroupId, A.ClientId
FROM APP_ClientGroupAssoc A, @tblWebScaleForHost T
WHERE A.ClientGroupId = T.clientGroupId
-- Update the number of clients in each group
UPDATE @tblWebScaleForHost
SET numHostsInGroup = Tmp.numHosts
FROM @tblWebScaleForHost T,
	(SELECT COUNT(*) as numHosts, clientGroupId FROM @tblClientsInGroup GROUP BY clientGroupId) Tmp
WHERE T.clientGroupId = Tmp.clientGroupId
-- Update the number of clients configured
UPDATE T
SET numHostsInGroupToConfigure = Tmp.numHostsToConfig
FROM @tblWebScaleForHost T,
(SELECT COUNT(DISTINCT HW.hostId) as numHostsToConfig FROM @tblClientsInGroup TCG, MMDiskHWInfo HW WHERE HW.hostId = TCG.clientId AND (HW.flags & 1) = 0) Tmp
-- Update the number of disks to configure
UPDATE T
SET numTotalDisksToConfigure = Tmp.numDiskToConfig
FROM @tblWebScaleForHost T,
(SELECT COUNT(DISTINCT HW.diskId) as numDiskToConfig FROM @tblClientsInGroup TCG, MMDiskHWInfo HW WHERE HW.hostId = TCG.clientId AND (HW.flags & 1) = 0) Tmp
-- Update disks for this host
UPDATE T
SET numDisksPerHost = Tmp.numDisksPerHost
FROM @tblWebScaleForHost T,
	(SELECT COUNT(DISTINCT HW.diskId) as numDisksPerHost FROM MMDiskHWInfo HW WITH (READUNCOMMITTED) WHERE HW.hostId = @i_hostId) Tmp
-- Update the mediaAgent name
UPDATE T
SET T.mediaAgentName = C.name
FROM @tblWebScaleForHost T, APP_Client C WITH (READUNCOMMITTED)
WHERE T.clientId = C.id
    UPDATE @tblWebScaleForHost
    SET repFactor = ISNULL((SELECT value
			    FROM MMConfigs WITH (READUNCOMMITTED)
WHERE name = 'MMCONFIG_WEBSCALE_STORAGE_REPLICATION_FACTOR'), 0)
    WHERE repFactor = 0
    UPDATE @tblWebScaleForHost
    SET redFactor = ISNULL((SELECT value
			    FROM MMConfigs WITH (READUNCOMMITTED)
WHERE name = 'MMCONFIG_WEBSCALE_STORAGE_REDUNDANCY_FACTOR'), 2)
    WHERE redFactor = 0
    UPDATE @tblWebScaleForHost
    SET dispFactor = ISNULL((SELECT value
			    FROM MMConfigs WITH (READUNCOMMITTED)
WHERE name = 'MMCONFIG_WEBSCALE_STORAGE_DISPERSE_FACTOR'), 6)
    WHERE dispFactor = 0
    -- For now return GlusterFS for all. We can extend this to other types by setting appropriate types of distributed storages.
    UPDATE @tblWebScaleForHost
    SET distStorageType = 1 /*GlusterFS*/
    FROM @tblWebScaleForHost
    -- Check if this given mount path is already configured on this commcell.
    -- either the mountpath is configured with this path and hostId or this host is configured as device controller in shared config.
    -- in either case, get the mountpath.
      IF EXISTS (SELECT 1 FROM MMDiskHWInfo H WITH (READUNCOMMITTED) WHERE deviceOSPath = @i_datapath AND hostId = @i_hostId) -- when the same node reports the brick a second time.
      BEGIN
		-- Case 1 : when the same node reports a brick a second time.
		---         Select MP,Device,DC for a brick already configured on the CS.
		UPDATE T
		SET T.mountPathId = S.mountPathId,
		DeviceId = S.DeviceId,
		T.deviceControllerId = C.DeviceControllerId
		FROM @tblWebScaleForHost T, MMDeviceController C WITH (READUNCOMMITTED), MMDiskHWInfo H WITH (READUNCOMMITTED), MMMountPathTOStorageDevice S WITH (READUNCOMMITTED)
		WHERE T.clientId = H.HostId
		AND T.clientId = @i_hostId
		AND H.deviceOSPath = @i_datapath
		AND H.DeviceId = C.DeviceId
		AND C.DeviceId = S.DeviceId
		AND T.mountPathId = 0
      END
      IF EXISTS (SELECT 1 FROM MMDiskHWInfo H WITH (READUNCOMMITTED) WHERE deviceOSPath = @i_datapath AND hostId IN (SELECT DISTINCT clientId FROM @tblClientsInGroup)) -- the brick is reported again by the second MA.
      BEGIN
		-- Case 2: the known brick is reported by the nth MA(n <> 1).
		-- Select the MP, Dev, DC for the device configured already.
		UPDATE T
		SET T.mountPathId = S.mountPathId,
		DeviceId = S.DeviceId
		FROM @tblWebScaleForHost T, @tblClientsInGroup TCL, MMDiskHWInfo H WITH (READUNCOMMITTED), MMDeviceController C WITH (READUNCOMMITTED), MMMountPathToStorageDevice S WITH (READUNCOMMITTED)
		WHERE T.clientId = @i_hostId
		AND T.clientGroupId = TCL.clientGroupId
		AND TCL.clientId = C.clientId
		AND C.DeviceId = S.DeviceId
		AND H.deviceOSPath = @i_datapath
		AND C.DeviceId = H.DeviceId
		AND T.mountPathId = 0
		UPDATE T
		SET T.deviceControllerId = C.DeviceControllerId
		FROM @tblWebScaleForHost T, MMDeviceController C WITH (READUNCOMMITTED)
		WHERE T.clientId = @i_hostId
		AND   T.clientId = C.ClientId
		AND   C.DeviceId = T.DeviceId
		AND   T.mountPathId > 0
      END
      IF EXISTS (SELECT 1 FROM MMDiskHWInfo C WITH (READUNCOMMITTED) WHERE C.hostId = @i_hostId) --IN (SELECT DISTINCT clientId FROM @tblClientsInGroup) ) -- newly brick reported for the first time.
      BEGIN
	--Case 3: A brick from a node for which a device/MP is already created is reported.
	--	  This condition would fail if we allow creating libraries other than the storage pool on these MAs. Decide later.
	UPDATE T
	SET T.mountPathId = S.mountPathId,
	DeviceId = S.DeviceId,
	T.deviceControllerId = C.DeviceControllerId
	FROM @tblWebScaleForHost T, @tblClientsInGroup TCL, MMDiskHWInfo H WITH (READUNCOMMITTED), MMDeviceController C WITH (READUNCOMMITTED), MMMountPathToStorageDevice S WITH (READUNCOMMITTED)
	WHERE T.clientId = @i_hostId
	AND T.clientGroupId = TCL.clientGroupId
	AND TCL.clientId = C.clientId
	AND C.DeviceId = S.DeviceId
	AND C.DeviceId = H.DeviceId
	AND C.ClientId = T.clientId
	AND T.mountPathId = 0
    END
     	-- If the library was created for the storagepool/client group, the MMEntity Prop value should be set with deviceId and client group Id.
IF EXISTS(SELECT 1 from MMEntityProp ME WITH (READUNCOMMITTED), @tblWebScaleForHost T WHERE ME.EntityType = 8 and ME.intVal = T.clientGroupId and ME.propertyName = 'DeviceClientGroup')
	  BEGIN
		UPDATE T
		SET T.mountPathId = MP.mountPathId,
		DeviceId = D.DeviceId
		FROM @tblWebScaleForHost T, MMEntityProp ME WITH (READUNCOMMITTED), MMDevice D WITH (READUNCOMMITTED), MMMountPathToStorageDevice MPSD WITH (READUNCOMMITTED), MMMountPath MP WITH (READUNCOMMITTED)
WHERE ME.propertyName = 'DeviceClientGroup'
AND ME.EntityType = 8
		AND T.clientGroupId = ME.intVal
		AND D.DeviceId = ME.EntityId
		AND D.DeviceId = MPSD.DeviceId
		AND MPSD.MountPathId = MP.MountPathId
		AND T.mountPathId = 0
	  END
    -- get the libId and drivePoolId for this mountPath
	-- Set out column as GFS volume configured. So that we inform the MA to join the gluster volume.
	UPDATE T
	SET T.libId = M.libraryId,
	T.drivePoolId = D.DrivePoolId,
storageConfigured = (Attribute & 64)
	FROM @tblWebScaleForHost T, MMMountPath M WITH (READUNCOMMITTED), MMDrivePool D WITH (READUNCOMMITTED)
	WHERE T.mountPathId = M.MountPathId
	AND M.MasterpoolId = D.MasterPoolId
	AND T.mountPathId > 0
    UPDATE T
    SET dispFactor = cast (value as nvarchar)
    FROM @tblWebScaleForHost T, APP_AdvanceSettings S WITH (READUNCOMMITTED)
WHERE S.keyName IN ('Disperse Factor', 'Nodes per block') AND S.relativePath='CommServDB.MediaAgent'
AND S.entityType = 28 AND S.enabled=1 AND S.entityId = T.clientGroupId
				AND S.deleted = 0
    UPDATE T
    SET redFactor = cast (value as nvarchar)
    FROM @tblWebScaleForHost T, APP_AdvanceSettings S WITH (READUNCOMMITTED)
WHERE S.keyName = 'Redundancy factor' AND S.relativePath='CommServDB.MediaAgent'
AND S.entityType = 28 AND S.enabled=1 AND S.entityId = T.clientGroupId
				AND S.deleted = 0
    UPDATE T
    SET hostsFactor = cast (value as nvarchar)
    FROM @tblWebScaleForHost T, APP_AdvanceSettings S WITH (READUNCOMMITTED)
WHERE S.keyName = 'No. of MediaAgents' AND S.relativePath='CommServDB.MediaAgent'
AND S.entityType = 28 AND S.enabled=1 AND S.entityId = T.clientGroupId
				AND S.deleted = 0
    -- If the device is configured, see if the disperse factor is set. Maintain that disperse factor.
    UPDATE T
    SET dispFactor = E.intVal
    FROM @tblWebScaleForHost T, MMEntityProp E
    WHERE T.deviceId > 0
    AND T.deviceId = E.EntityId
AND E.EntityType = 8
    AND E.propertyName = 'DeviceDisperseFactor' -- MM_ENTITY_PROP_DEVICE_DISPERSE_FACTOR
    UPDATE T
    SET hostsFactor = E.intVal
    FROM @tblWebScaleForHost T, MMEntityProp E
    WHERE T.deviceId > 0
    AND T.deviceId = E.EntityId
AND E.EntityType = 8
    AND E.propertyName = 'DeviceHostsFactor' -- MM_ENTITY_PROP_DEVICE_HOSTS_FACTOR
SELECT  clientId, libId, mountPathId, drivePoolId, deviceId, deviceControllerId, distStorageType, storageConfigured, flags, numHostsInGroup, repFactor, dispFactor, redFactor, clientGroupName, mediaAgentName, clientGroupId, numHostsInGroupToConfigure, hostsFactor, numTotalDisksToConfigure, numDisksPerHost
FROM @tblWebScaleForHost
GO

IF EXISTS (select * from GxQscripts where name = 'MMWebScaleStorageInfoForMPAndHost')
	delete from GxQscripts where name = 'MMWebScaleStorageInfoForMPAndHost'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMWebScaleStorageInfoForMPAndHost')
	delete from GXDBVersions where aliasname = 'MMWebScaleStorageInfoForMPAndHost'
GO

insert into GXDBVersions values(2, 'MMWebScaleStorageInfoForMPAndHost',  '00010001000200050000', 'MMWebScaleStorageInfoForMPAndHost', '00010001000200050000')
GO

