

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMWebScaleStorageInfoForDDBAndHost.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2011  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMWebScaleStorageInfoForDDBAndHost.sp,v $ $Id: MMWebScaleStorageInfoForDDBAndHost.sp,v 1.1.2.6 2019/08/27 17:27:10 pnara Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMWebScaleStorageInfoForDDBAndHost')
BEGIN
	print '>>> Drop Stored Procedure: MMWebScaleStorageInfoForDDBAndHost <<<'
	drop procedure MMWebScaleStorageInfoForDDBAndHost
END
IF EXISTS (select * from GxQscripts where name='MMWebScaleStorageInfoForDDBAndHost')
	delete from GxQscripts where name = 'MMWebScaleStorageInfoForDDBAndHost'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMWebScaleStorageInfoForDDBAndHost')
	delete from GXDBVersions where aliasname = 'MMWebScaleStorageInfoForDDBAndHost'
GO
print '... Creating Procedure: MMWebScaleStorageInfoForDDBAndHost'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMWebScaleStorageInfoForDDBAndHost
  @i_hostId integer,
  @i_ddbpath varchar(1024),
  @i_GDSPId integer
AS
  DECLARE @o_MAClientId integer
  DECLARE @o_libId integer
  DECLARE @o_drivePoolId integer
  DECLARE @o_GDSPId integer
  DECLARE @o_GDSPCopyId integer
  DECLARE @o_SIDBStoreId integer
  DECLARE @o_StoragePolicyId integer
  DECLARE @o_MediaAgentName nvarchar(1024)
DECLARE @tblWebScaleForHost  TABLE (clientId INT, mountPathId INT, libId INT, drivePoolId INT, GDSPId INT, GDSPCopyId INT, SIDBStoreId INT, StoragePolicyId INT, mediaAgentName nvarchar(1024))
DECLARE @tblClientsInGroup TABLE (clientGroupId INT, clientId INT)
-------------TBD------------------------------
----------------------------------------------
    INSERT INTO @tblWebScaleForHost(clientId, mountPathId, libId, drivePoolId, GDSPId, GDSPCopyId, SIDBStoreId, StoragePolicyId, mediaAgentName)
    SELECT @i_hostId, 0, 0, 0, @i_GDSPId, 0, 0, 0, ''
-----------------------------------------------
-----------------------------------------------
-- Update the mediaAgent name
UPDATE T
SET T.mediaAgentName = C.name
FROM @tblWebScaleForHost T, APP_Client C WITH (READUNCOMMITTED)
WHERE T.clientId = C.id
-- Get the mountPathId configured for this gluster volume.
UPDATE T
SET T.mountPathId = MPSD.MountPathId
FROM @tblWebScaleForHost T,MMDiskHWInfo HW WITH (READUNCOMMITTED),MMDevice D WITH (READUNCOMMITTED), MMMountPathToStorageDevice MPSD WITH (READUNCOMMITTED)
WHERE T.clientId = HW.hostId and HW.deviceId = D.DeviceId and HW.hostId = @i_hostId and D.DeviceId = MPSD.DeviceId
IF @i_GDSPId > 0
BEGIN
	UPDATE 	T
	SET 	GDSPCopyId = AG.defaultCopy,
			SIDBStoreId = ACS.SIDBStoreId
	FROM 	@tblWebScaleForHost T,
			archGroup AG WITH(READUNCOMMITTED),
			archCopySIDBStore ACS WITH (READUNCOMMITTED)
	WHERE 	T.GDSPId = AG.id
			AND AG.defaultCopy = ACS.copyId
AND ACS.flags & (4 | 2) = (4 | 2)
AND AG.flags & 256 > 0
END
-- Check if this given ddb path is already configured on this commcell.
ELSE IF EXISTS (SELECT 1 FROM IdxAccessPath A WITH (READUNCOMMITTED) WHERE A.ClientId = @i_hostId AND A.Path = @i_ddbpath) OR
	-- OR check if there exists any GDSP with given mountPath in its datapath.
	EXISTS (SELECT 1 FROM MMDataPath D, MMMountPath M, MMDrivePool P, @tblWebScaleForHost T WHERE T.mountPathId > 0 AND T.mountPathId = M.mountPathId
				AND M.masterPoolId = P.masterPoolId AND P.DrivePoolId = D.DrivePoolId)
BEGIN
	UPDATE @tblWebScaleForHost
	SET SIDBStoreId = I.SIDBStoreId
	FROM IdxSIDBSubStore I WITH (READUNCOMMITTED), IdxAccessPath A WITH (READUNCOMMITTED)
	WHERE I.IdxAccessPathId = A.IdxAccessPathId
	AND A.ClientId = @i_hostId AND A.Path = @i_ddbpath
	AND I.SealedTime = 0
	--If unable to get the store with above logic, then see if there exists a GDSP for this clientGroup with some other MA
	UPDATE T
	SET GDSPId = AGC.archGroupId,
	GDSPCopyId = AGC.id,
	SIDBStoreId = ACS.SIDBStoreId
	FROM archGroupCopy AGC, MMDataPath D, MMMountPath M, MMDrivePool P, @tblWebScaleForHost T, archCopySIDBStore ACS WITH (READUNCOMMITTED)
	WHERE T.mountPathId = M.mountPathId
	AND M.masterPoolId = P.masterPoolId
	AND P.DrivePoolId = D.DrivePoolId
	AND AGC.id = D.copyId
AND ACS.copyID = AGC.id AND ACS.flags & (4 | 2) = (4 | 2)
AND AGC.dedupeFlags & 268435456 > 0
	-- Get the GDSP policy and copy Ids
	UPDATE T
	SET GDSPId = AGC.archGroupId,
	GDSPCopyId = AGC.id
	FROM @tblWebScaleForHost T, archCopySIDBStore ACS WITH (READUNCOMMITTED), archGroupCopy AGC WITH (READUNCOMMITTED)
	WHERE T.SIDBStoreId = ACS.SIDBStoreId AND ACS.copyId = AGC.id
AND AGC.dedupeFlags & 268435456 > 0
	AND T.GDSPCopyId = 0
	AND T.SIDBStoreId > 0
END
-- Get the dependent policy Id
UPDATE 	T
SET 	StoragePolicyId = AGC.archGroupId
FROM 	@tblWebScaleForHost T, archCopyToGlobalPolicy CGP WITH (READUNCOMMITTED), archGroupCopy AGC WITH (READUNCOMMITTED)
WHERE 	T.GDSPId = CGP.globalPolicyId
		AND CGP.copyId = AGC.id
SELECT clientId,libId, drivePoolId, GDSPId, GDSPCopyId, SIDBStoreId, StoragePolicyId, mediaAgentName
FROM 	@tblWebScaleForHost
GO

IF EXISTS (select * from GxQscripts where name = 'MMWebScaleStorageInfoForDDBAndHost')
	delete from GxQscripts where name = 'MMWebScaleStorageInfoForDDBAndHost'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMWebScaleStorageInfoForDDBAndHost')
	delete from GXDBVersions where aliasname = 'MMWebScaleStorageInfoForDDBAndHost'
GO

insert into GXDBVersions values(2, 'MMWebScaleStorageInfoForDDBAndHost',  '00010001000200060000', 'MMWebScaleStorageInfoForDDBAndHost', '00010001000200060000')
GO

