

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMWebScaleStorageInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2011  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMWebScaleStorageInfo.sp,v $ $Id: MMWebScaleStorageInfo.sp,v 1.1.2.6 2018/03/27 09:13:35 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMWebScaleStorageInfo <<<'

IF EXISTS (select * from sysobjects where name='MMWebScaleStorageInfo')
	drop procedure MMWebScaleStorageInfo
IF EXISTS (select * from GxQscripts where name='MMWebScaleStorageInfo')
	delete from GxQscripts where name = 'MMWebScaleStorageInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMWebScaleStorageInfo')
	delete from GXDBVersions where aliasname = 'MMWebScaleStorageInfo'
GO
print '... Creating Procedure: MMWebScaleStorageInfo'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMWebScaleStorageInfo
  @i_hostId integer,
  @i_datapath varchar(1024),
  @i_ddbpath varchar(1024),
  @i_reserveParam integer
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_MAClientId integer
  DECLARE @o_libId integer
  DECLARE @o_mountPathId integer
  DECLARE @o_drivePoolId integer
  DECLARE @o_deviceId integer
  DECLARE @o_deviceControllerId integer
  DECLARE @o_GDSPId integer
  DECLARE @o_GDSPCopyId integer
  DECLARE @o_SIDBStoreId integer
  DECLARE @o_StoragePolicyId integer
  DECLARE @o_distributedStorageType integer
  DECLARE @o_storageConfigured integer
  DECLARE @o_flags integer
  DECLARE @o_numHostsInGroup integer
  DECLARE @o_replicationFactor integer
  DECLARE @o_disperseFactor integer
  DECLARE @o_redundancyFactor integer
  DECLARE @o_clientGroupName nvarchar(1024)
  DECLARE @o_MediaAgentName nvarchar(1024)
  DECLARE @o_clientGroupId integer
  DECLARE @o_numHostsInGroupToConfigure integer
DECLARE @tblWebScaleForHost  TABLE (clientId INT, clientGroupId INT, libId INT, mountPathId INT, drivePoolId INT, deviceId INT, deviceControllerId INT, GDSPId INT, GDSPCopyId INT,
	SIDBStoreId INT, StoragePolicyId INT, distStorageType INT, storageConfigured INT, flags INT, numHostsInGroup INT,  repFactor INT, dispFactor INT, redFactor INT,
	clientGroupName nvarchar(1024), mediaAgentName nvarchar(1024), numHostsInGroupToConfigure INT)
DECLARE @tblClientsInGroup TABLE (clientGroupId INT, clientId INT)
-------------TBD------------------------------
----------------------------------------------
    INSERT INTO @tblWebScaleForHost
    SELECT A.ClientId, A.clientGroupId, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, B.name, '', 0
    FROM APP_ClientGroupAssoc A, APP_ClientGroup B, APP_AdvanceSettings S
    WHERE A.ClientId = @i_hostId
    AND A.ClientGroupId = B.id
AND S.EntityType = 28
    AND S.EntityId = B.id
AND S.keyName = 'StoragePool'
    AND CONVERT(nvarchar(max),S.value) = 'true'
    AND S.enabled = 1
AND S.relativePath= 'CommServDB.MediaAgent'
    AND S.deleted = 0
-----------------------------------------------
-----------------------------------------------
-- Get all the clients in all the groups
INSERT INTO @tblClientsInGroup
SELECT A.clientGroupId, A.ClientId
FROM APP_ClientGroupAssoc A, @tblWebScaleForHost T
WHERE A.ClientGroupId = T.clientGroupId
-- Update the number of clients in each group
UPDATE @tblWebScaleForHost
SET numHostsInGroup = Tmp.numHosts
FROM @tblWebScaleForHost T,
	(SELECT COUNT(*) as numHosts, clientGroupId FROM @tblClientsInGroup GROUP BY clientGroupId) Tmp
WHERE T.clientGroupId = Tmp.clientGroupId
-- Update the number of clients configured
UPDATE T
SET numHostsInGroupToConfigure = Tmp.numHostsToConfig
FROM @tblWebScaleForHost T,
(SELECT COUNT(*) as numHostsToConfig FROM @tblClientsInGroup TCG, MMDiskHWInfo HW WHERE HW.hostId = TCG.clientId AND (HW.flags & 1) = 0) Tmp
-- Update the mediaAgent name
UPDATE T
SET T.mediaAgentName = C.name
FROM @tblWebScaleForHost T, APP_Client C WITH (READUNCOMMITTED)
WHERE T.clientId = C.id
    UPDATE @tblWebScaleForHost
    SET repFactor = ISNULL((SELECT value
			    FROM MMConfigs WITH (READUNCOMMITTED)
WHERE name = 'MMCONFIG_WEBSCALE_STORAGE_REPLICATION_FACTOR'), 0)
    WHERE repFactor = 0
    UPDATE @tblWebScaleForHost
    SET redFactor = ISNULL((SELECT value
			    FROM MMConfigs WITH (READUNCOMMITTED)
WHERE name = 'MMCONFIG_WEBSCALE_STORAGE_REDUNDANCY_FACTOR'), 2)
    WHERE redFactor = 0
    UPDATE @tblWebScaleForHost
    SET dispFactor = ISNULL((SELECT value
			    FROM MMConfigs WITH (READUNCOMMITTED)
WHERE name = 'MMCONFIG_WEBSCALE_STORAGE_DISPERSE_FACTOR'), 6)
    WHERE dispFactor = 0
    -- For now return GlusterFS for all. We can extend this to other types by setting appropriate types of distributed storages.
    UPDATE @tblWebScaleForHost
    SET distStorageType = 1 /*GlusterFS*/
    FROM @tblWebScaleForHost
    -- Check if this given mount path is already configured on this commcell.
    -- either the mountpath is configured with this path and hostId or this host is configured as device controller in shared config.
    -- in either case, get the mountpath.
    IF EXISTS (SELECT 1 FROM MMDeviceController C WITH (READUNCOMMITTED) WHERE C.ClientId = @i_hostId AND C.Folder = @i_datapath) OR
	EXISTS (SELECT 1 FROM MMDiskHWInfo H WITH (READUNCOMMITTED) WHERE deviceOSPath = @i_datapath AND hostId = @i_hostId) OR
	-- check if any of the MA in the clientGroup has mountPath already configured. in that case this will be just another deviceController to that mountPath.
	EXISTS (SELECT 1 FROM MMDeviceController C WITH (READUNCOMMITTED) WHERE C.ClientId IN (SELECT DISTINCT clientId FROM @tblClientsInGroup))
    BEGIN
	-- pick the mountpath which belongs to this clientId.
	UPDATE T
	SET T.mountPathId = S.mountPathId,
	DeviceId = S.DeviceId,
	T.deviceControllerId = C.DeviceControllerId
	FROM @tblWebScaleForHost T, MMDeviceController C WITH (READUNCOMMITTED), MMMountPathToStorageDevice S WITH (READUNCOMMITTED)
	WHERE T.clientId = @i_hostId
	AND C.ClientId = T.clientId
	AND C.Folder = @i_datapath
	AND C.DeviceId = S.DeviceId
	-- incase gluster FS is already configured, then consider that we may or may not get the original path.
	-- have a secondary check as follows.
	-- if did not find MPId using above method. Try to find using HW info path
	UPDATE T
	SET T.mountPathId = S.mountPathId,
	DeviceId = S.DeviceId,
	T.deviceControllerId = C.DeviceControllerId
	FROM @tblWebScaleForHost T, MMDeviceController C WITH (READUNCOMMITTED), MMDiskHWInfo H WITH (READUNCOMMITTED), MMMountPathTOStorageDevice S WITH (READUNCOMMITTED)
	WHERE T.clientId = H.HostId
	AND T.clientId = @i_hostId
	AND H.deviceOSPath = @i_datapath
	AND H.DeviceId = C.DeviceId
	AND C.DeviceId = S.DeviceId
	AND T.mountPathId = 0
	-- We did not find any. Means no mp configured using this MA and path. Find if any MP is configured using any MA in this clientGroup. We use that MP to join this MA as deviceController.
	UPDATE T
	SET T.mountPathId = S.mountPathId,
	DeviceId = S.DeviceId
	FROM @tblWebScaleForHost T, @tblClientsInGroup TCL, MMDiskHWInfo H WITH (READUNCOMMITTED), MMDeviceController C WITH (READUNCOMMITTED), MMMountPathToStorageDevice S WITH (READUNCOMMITTED)
	WHERE T.clientId = @i_hostId
	AND T.clientGroupId = TCL.clientGroupId
	AND TCL.clientId = C.clientId
	AND C.DeviceId = S.DeviceId
	AND H.deviceOSPath = @i_datapath
	AND C.DeviceId = H.DeviceId
	AND T.mountPathId = 0
	-- get the libId and drivePoolId for this mountPath
	-- Set out column as GFS volume configured. So that we inform the MA to join the gluster volume.
	UPDATE T
	SET T.libId = M.libraryId,
	T.drivePoolId = D.DrivePoolId,
storageConfigured = (Attribute & 64)
	FROM @tblWebScaleForHost T, MMMountPath M WITH (READUNCOMMITTED), MMDrivePool D WITH (READUNCOMMITTED)
	WHERE T.mountPathId = M.MountPathId
	AND M.MasterpoolId = D.MasterPoolId
	AND T.mountPathId > 0
    END
    UPDATE T
    SET dispFactor = cast (value as nvarchar)
    FROM @tblWebScaleForHost T, APP_AdvanceSettings S WITH (READUNCOMMITTED)
WHERE S.keyName = 'Disperse Factor' AND S.relativePath='CommServDB.MediaAgent'
AND S.entityType = 28 AND S.enabled=1 AND S.entityId = T.clientGroupId
				AND S.deleted = 0
    UPDATE T
    SET redFactor = cast (value as nvarchar)
    FROM @tblWebScaleForHost T, APP_AdvanceSettings S WITH (READUNCOMMITTED)
WHERE S.keyName = 'Redundancy factor' AND S.relativePath='CommServDB.MediaAgent'
AND S.entityType = 28 AND S.enabled=1 AND S.entityId = T.clientGroupId
				AND S.deleted = 0
    -- If the device is configured, see if the disperse factor is set. Maintain that disperse factor.
    UPDATE T
    SET dispFactor = E.intVal
    FROM @tblWebScaleForHost T, MMEntityProp E
    WHERE T.deviceId > 0
    AND T.deviceId = E.EntityId
AND E.EntityType = 8
    AND E.propertyName = 'DeviceDisperseFactor' -- MM_ENTITY_PROP_DEVICE_DISPERSE_FACTOR
    -- Check if this given ddb path is already configured on this commcell.
    IF EXISTS (SELECT 1 FROM IdxAccessPath A WITH (READUNCOMMITTED) WHERE A.ClientId = @i_hostId AND A.Path = @i_ddbpath) OR
	-- OR check if there exists any GDSP with given mountPath in its datapath.
	EXISTS (SELECT 1 FROM MMDataPath D, MMMountPath M, MMDrivePool P, @tblWebScaleForHost T WHERE T.mountPathId > 0 AND T.mountPathId = M.mountPathId
		AND M.masterPoolId = P.masterPoolId AND P.DrivePoolId = D.DrivePoolId)
    BEGIN
	UPDATE @tblWebScaleForHost
	SET SIDBStoreId = I.SIDBStoreId
	FROM IdxSIDBSubStore I WITH (READUNCOMMITTED), IdxAccessPath A WITH (READUNCOMMITTED)
	WHERE I.IdxAccessPathId = A.IdxAccessPathId
	AND A.ClientId = @i_hostId AND A.Path = @i_ddbpath
	AND I.SealedTime = 0
	--If unable to get the store with above logic, then see if there exists a GDSP for this clientGroup with some other MA
	UPDATE T
	SET GDSPId = AGC.archGroupId,
	GDSPCopyId = AGC.id,
	SIDBStoreId = AGC.SIDBStoreId
	FROM archGroupCopy AGC, MMDataPath D, MMMountPath M, MMDrivePool P, @tblWebScaleForHost T
	WHERE T.mountPathId = M.mountPathId
	AND M.masterPoolId = P.masterPoolId
	AND P.DrivePoolId = D.DrivePoolId
	AND AGC.id = D.copyId
AND AGC.dedupeFlags & 268435456 > 0
	-- Get the GDSP policy and copy Ids
	UPDATE T
	SET GDSPId = AGC.archGroupId,
	GDSPCopyId = AGC.id
	FROM @tblWebScaleForHost T, archGroupCopy AGC WITH (READUNCOMMITTED)
	WHERE T.SIDBStoreId = AGC.SIDBStoreId
AND AGC.dedupeFlags & 268435456 > 0
	AND T.GDSPCopyId = 0
	AND T.SIDBStoreId > 0
	-- Get the dependent policy Id
	UPDATE T
	SET StoragePolicyId = AGC.archGroupId
	FROM @tblWebScaleForHost T, archGroupCopy AGC WITH (READUNCOMMITTED), archGroup AG WITH (READUNCOMMITTED)
	WHERE T.SIDBStoreId = AGC.SIDBStoreId
AND AGC.dedupeFlags & 134217728 > 0
	AND AG.defaultCopy = AGC.id
    END
SELECT  clientId, libId, mountPathId, drivePoolId, deviceId, deviceControllerId, GDSPId, GDSPCopyId, SIDBStoreId, StoragePolicyId, distStorageType, storageConfigured, flags, numHostsInGroup, repFactor, dispFactor, redFactor, clientGroupName, mediaAgentName, clientGroupId, numHostsInGroupToConfigure
FROM @tblWebScaleForHost
GO

IF EXISTS (select * from GxQscripts where name = 'MMWebScaleStorageInfo')
	delete from GxQscripts where name = 'MMWebScaleStorageInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMWebScaleStorageInfo')
	delete from GXDBVersions where aliasname = 'MMWebScaleStorageInfo'
GO

insert into GXDBVersions values(2, 'MMWebScaleStorageInfo',  '00010001000200060000', 'MMWebScaleStorageInfo', '00010001000200060000')
GO

