

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMVolReconcile.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMVolReconcile.sp,v $ $Id: MMVolReconcile.sp,v 1.12.54.2 2018/03/20 00:12:18 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMVolReconcile <<<'

IF EXISTS (select * from sysobjects where name='MMVolReconcile')
	drop procedure MMVolReconcile
IF EXISTS (select * from GxQscripts where name='MMVolReconcile')
	delete from GxQscripts where name = 'MMVolReconcile'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMVolReconcile')
	delete from GXDBVersions where aliasname = 'MMVolReconcile'
GO
print '... Creating Procedure: MMVolReconcile'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMVolReconcile
  @i_jobId integer,
  @i_copyId integer,
  @i_sidbStoreId integer,
  @i_mountPathId integer,
  @i_truncateTable integer,
  @i_reserveParam integer
AS
  DECLARE @o_errorCode integer;
  DECLARE @o_returnCode integer;
  DECLARE @o_returnString varchar(256);
  DECLARE @o_reserveParam1 integer;
  DECLARE @o_reserveParam2 integer;
  DECLARE @o_strReserveParam varchar(256);
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	-- Constant Definitions
	DECLARE @C_MM_MAG_LIB_RAV_CHUNKLIST_ONLY	integer
	SET @C_MM_MAG_LIB_RAV_CHUNKLIST_ONLY	= 2
	DECLARE @C_MM_MAG_LIB_RAV_SIDB_DUMP_ONLY	integer
	SET @C_MM_MAG_LIB_RAV_SIDB_DUMP_ONLY	= 3
	SET @o_errorCode = 0
	SET @o_returnCode = 0
	SET @o_returnString = N''
	DECLARE @SQL	VARCHAR(2048)
	SET @SQL = ''
	DECLARE	@volPruned INTEGER
	SET @volPruned = 0
	DECLARE	@chunkPruned INTEGER
	SET @chunkPruned = 0
	DECLARE	@archPruned INTEGER
	SET @archPruned = 0
	DECLARE @dummyVolumeId       INTEGER
	DECLARE @dummyMountPathId    INTEGER
	DECLARE @dbgMsg VARCHAR(100)
	CREATE TABLE #tmpVolume
	(
		VolumeId						integer,
		VolumeName						varchar(112),
		CreationTime					integer,
		VolumeFlags						integer,
		VolumeInitialized				integer,
		FlushBlockSizeKB				integer,
		NumberOfRestores				integer,
		NumberOfBackups					integer,
		NumberOfMounts					integer,
		NumberOfSoftErrors				integer,
		NumberOfHardErrors				integer,
		LastRestoreTime					integer,
		LastBackupTime					integer,
		LogicalBytesMB					integer,
		PhysicalBytesMB					integer,
		NumberOfActiveFiles				integer,
		LastFile						integer,
		RecordingFormatId				integer,
		ExternalGUID					varchar(33),
		OMLVersion						integer,
		VolumeState						integer,
		VolumeFullReason				integer,
		VolumeFullTime					integer,
		VolumeFullJobId					bigint ,
		origCCcommCellID				integer,
		origCCvolumeID					integer,
		MediaId							integer,
		MediaSideId						integer,
		Attributes						integer,
		MediaGroupId					integer,
		ReformatTime					integer,
		RMSpareStatus					integer,
		RMSpareStatusUpdateTime                         integer,
		SIDBStoreId                                     int    ,
		SiloStatus										int    ,
		CurrMountPathId									int	,
		FailureErrorCode					integer,
		MMSpareStatus					integer
	)
	CREATE TABLE #tmpMMDeletedAF
	(
		archFileId					integer,
		VolumeId						integer,
		Status							integer,
		Retry								integer,
		copyId							integer,
		cclip								varchar(255),
		CapacityFreedBytes	bigint,
		ArchChunkId					bigint,
		MountPathId					integer,
		SIDBStoreId					integer,
		CommCellId					integer,
		DeletedTime					integer,
		FailureErrorCode			integer,
		chunkCommCellId				integer
	)
	/*
	-- Query to get list of volumes to be re-populated
	INSERT INTO #tmpVolume
	SELECT TT.volumeId, 'V_'+ CAST(TT.volumeId AS VARCHAR(12)), dbo.getUnixTime(getUTCDate()),
	2, 1, 64, 0, 0, 1, 0, 0, 0, dbo.getUnixTime(getUTCDate()),
	0, 0, 0, 0, 10001, 'VolRecon', 2, 0, 0, 0, 0, 2, 0,
	MS.mediaId, MP.mediaSideId, 0, 0, 0, -1, 0, CASE TT.isSIVolume WHEN 1 THEN @dummySIDBStoredId ELSE 0 END, 0, TT.mountPathId, 0, 0
	FROM ( SELECT TMP.volumeId, TMP.mountPathId, TMP.isSIVolume
                FROM ( SELECT DISTINCT S.volumeId as volumeId, S.mountPathId as mountPathId, S.isSIVolume as isSIVolume
	            FROM MMVolReconChunkList S LEFT OUTER JOIN archChunk AC WITH (NOLOCK)
	            ON S.chunkId = AC.id AND AC.commCellId = 2
	            WHERE AC.id = 0) AS TMP LEFT OUTER JOIN MMVolume V WITH (NOLOCK)
                ON TMP.volumeId = V.volumeId
                WHERE V.volumeId = 0) TT, MMMountPath MP, MMMediaSide MS
	WHERE TT.mountPathId = MP.mountPathId
	AND       MP.mediaSideId = MS.mediaSideId
	SELECT	@o_errorCode = @@ERROR
	IF @o_errorCode > 0 GOTO CX_EXIT
	DECLARE @IdentInsQuery NVARCHAR(MAX)
	SET @IdentInsQuery = 'INSERT INTO MMVolume (VolumeId, VolumeName, CreationTime, VolumeFlags, VolumeInitialized,
		FlushBlockSizeKB, NumberOfRestores, NumberOfBackups, NumberOfMounts, NumberOfSoftErrors,
		NumberOfHardErrors, LastRestoreTime, LastBackupTime, LogicalBytesMB, PhysicalBytesMB,
		NumberOfActiveFiles, LastFile, RecordingFormatId, ExternalGUID, OMLVersion, VolumeState,
		VolumeFullReason, VolumeFullTime, VolumeFullJobId, origCCcommCellID, origCCvolumeID, MediaId,
		MediaSideId, Attributes,MediaGroupId, ReformatTime, RMSpareStatus, RMSpareStatusUpdateTime,
		SIDBStoreId, SiloStatus, CurrMountPathId, FailureErrorCode, MMSpareStatus)
		SELECT * FROM #tmpVolume'
	EXEC SQLUtilIdentityInsert @IdentInsQuery, 'MMVolume'
	SELECT	@o_errorCode = @@ERROR
	IF @o_errorCode > 0 GOTO CX_EXIT
	-- Query to re-populate the MMDeletedAF table entries
	SELECT TOP 1 @dummyVolumeId = volumeId, @dummyMountPathId = mountPathId FROM MMVolReconChunkList
	INSERT INTO #tmpMMDeletedAF
	SELECT DISTINCT 0, S.volumeId, 256, 0, 0, '', 0, S.chunkId, S.mountPathId, CASE S.isSIVolume WHEN 1 THEN @dummySIDBStoredId ELSE 0 END, 2, dbo.getUnixTime(getUTCDATE()), 0, AC.CommCellId
	FROM MMVolReconChunkList S LEFT OUTER JOIN archChunk AC WITH (NOLOCK)
	ON 	S.chunkId = AC.id
	AND AC.commCellId = 2
	WHERE AC.id = 0
	*/
	-- Update VACStatus to "volReconVACStatusOk" for those Volumes which are present in both MP & CSDB
	UPDATE MMVolReconChunkList SET VACStatus = 1
	FROM MMVolReconChunkList AS VR INNER JOIN MMVolume AS MV WITH (NOLOCK)
	ON VR.VolumeId = MV.VolumeId AND VR.AdminJobId = @i_jobId AND VR.IsSIVolume = 0
	SELECT	@o_errorCode = @@ERROR
	IF @o_errorCode > 0 GOTO CX_EXIT
	-- Update VACStatus to "volReconVACStatusOk" for those Chunks which are present in both MP & CSDB
	UPDATE MMVolReconChunkList SET VACStatus = 1
	FROM MMVolReconChunkList AS VR INNER JOIN ArchChunk AS AC WITH (NOLOCK)
	ON VR.ChunkId = AC.id AND VR.AdminJobId = @i_jobId AND VR.IsSIVolume = 0
	SELECT	@o_errorCode = @@ERROR
	IF @o_errorCode > 0 GOTO CX_EXIT
	-- Update VACStatus to "volReconVACStatusInMP" for those Volumes which are present only in MP
	-- UPDATE MMVolReconChunkList SET VACStatus = 2, PruneStatus = 1
	UPDATE MMVolReconChunkList SET VACStatus = 2
	FROM MMVolReconChunkList AS VR LEFT OUTER JOIN MMVolume AS MV WITH (NOLOCK)
	ON VR.VolumeId = MV.VolumeId AND VR.AdminJobId = @i_jobId AND VR.IsSIVolume = 0
	WHERE MV.VolumeId IS null and VR.AdminJobId = @i_jobId
	SELECT	@o_errorCode = @@ERROR
	IF @o_errorCode > 0 GOTO CX_EXIT
	-- Update VACStatus to "volReconVACStatusInMP" for those Chunks which are present only in MP
	-- UPDATE MMVolReconChunkList SET VACStatus = 2, PruneStatus = 3
	UPDATE MMVolReconChunkList SET VACStatus = 2
	FROM MMVolReconChunkList AS VR LEFT OUTER JOIN ArchChunk AS AC WITH (NOLOCK)
	ON VR.ChunkId = AC.id AND VR.AdminJobId = @i_jobId AND VR.IsSIVolume = 0
	-- WHERE AC.id IS null AND VR.VACStatus <> 2 AND VR.PruneStatus <> 1
	WHERE AC.id IS null and VR.AdminJobId = @i_jobId
	SELECT	@o_errorCode = @@ERROR
	IF @o_errorCode > 0 GOTO CX_EXIT
	declare @tblCSDBVolChunks table (volId int, chunkId bigint)
	insert into @tblCSDBVolChunks
	select mv.VolumeId, acm.archchunkid from archChunkMapping acm, archchunk ac, mmvolume mv
	where mv.CurrMountPathId = @i_mountPathId and acm.archcopyid = @i_copyId
		and ac.volumeId = mv.VolumeId and ac.id = acm.archChunkId
	-- delete all the chunks which are present in both MP & CS
	delete from @tblCSDBVolChunks
	from @tblCSDBVolChunks tmp, MMVolReconChunkList vr
	where tmp.volid = vr.volumeid and tmp.chunkid = vr.chunkid and vr.adminJobId = @i_jobId
	-- delete all the volumes which are present in both MP & CS
	delete from @tblCSDBVolChunks
	from @tblCSDBVolChunks tmp, MMVolReconChunkList vr
	where tmp.volid = vr.volumeid and vr.chunkid = 0 and vr.adminJobId = @i_jobId
	-- Insert into MMVolReconChunkList
	insert into MMVolReconChunkList
	select chunkid, volid, @i_mountPathId, 0, 0, getUTCDate(), @i_copyId, @i_jobId, 3, 0, 0
	from @tblCSDBVolChunks
	/*
	-- Update VACStatus to "volReconVACStatusInCSDB" for those Volumes which are present only in CSDB
	-- UPDATE MMVolReconChunkList SET VACStatus = 3, PruneStatus = 1
	UPDATE MMVolReconChunkList SET VACStatus = 3
	FROM MMVolReconChunkList AS VR RIGHT OUTER JOIN MMVolume AS MV WITH (NOLOCK)
	ON VR.VolumeId = MV.VolumeId AND VR.AdminJobId = @i_jobId AND VR.IsSIVolume = 0
	WHERE MV.VolumeId IS null
	SELECT	@o_errorCode = @@ERROR
	IF @o_errorCode > 0 GOTO CX_EXIT
	-- Update VACStatus to "volReconVACStatusInCSDB" for those Chunks which are present only in CSDB
	-- UPDATE MMVolReconChunkList SET VACStatus = 3, PruneStatus = 3
	UPDATE MMVolReconChunkList SET VACStatus = 3
	FROM MMVolReconChunkList AS VR LEFT OUTER JOIN ArchChunk AS AC WITH (NOLOCK)
	ON VR.ChunkId = AC.id AND VR.AdminJobId = @i_jobId AND VR.IsSIVolume = 0
	-- WHERE AC.id IS null AND VR.VACStatus <> 2 AND VR.PruneStatus <> 1
	WHERE AC.id IS null
	SELECT	@o_errorCode = @@ERROR
	IF @o_errorCode > 0 GOTO CX_EXIT
	*/
	/*
	-- Do Volume Prune - Add Volumes with "volReconVACStatusInMP" as VACStatus to MMDeletedAF Table
	INSERT INTO #tmpVolume
	SELECT DISTINCT VR.volumeId, 'V_'+ CAST(VR.volumeId AS VARCHAR(12)), dbo.getUnixTime(getUTCDate()),
	6, 1, 64, 0, 0, 1, 0, 0, 0, dbo.getUnixTime(getUTCDate()),
	0, 0, 0, 0, 10001, 'VolRecon', 2, 0, 0, 0, 0, 2, 0,
	MS.mediaId, MP.mediaSideId, 0, 0, 0, -1, 0, CASE VR.isSIVolume WHEN 1 THEN @i_sidbStoreId ELSE 0 END, 0, VR.mountPathId, 0, 0
	FROM MMVolReconChunkList AS VR, MMMountPath AS MP, MMMediaSide AS MS WITH (NOLOCK)
	WHERE VR.VACStatus = 2 AND VR.PruneStatus = 1 AND VR.AdminJobId = @i_jobId AND
		MP.MountPathId = VR.MountPathId AND MS.MediaSideId = MP.MediaSideId
	SELECT	@o_errorCode = @@ERROR
	IF @o_errorCode > 0 GOTO CX_EXIT
	-- Insert into MMVolume table
	SET @IdentInsQuery = 'INSERT INTO MMVolume (VolumeId, VolumeName, CreationTime, VolumeFlags, VolumeInitialized,
		FlushBlockSizeKB, NumberOfRestores, NumberOfBackups, NumberOfMounts, NumberOfSoftErrors,
		NumberOfHardErrors, LastRestoreTime, LastBackupTime, LogicalBytesMB, PhysicalBytesMB,
		NumberOfActiveFiles, LastFile, RecordingFormatId, ExternalGUID, OMLVersion, VolumeState,
		VolumeFullReason, VolumeFullTime, VolumeFullJobId, origCCcommCellID, origCCvolumeID, MediaId,
		MediaSideId, Attributes,MediaGroupId, ReformatTime, RMSpareStatus, RMSpareStatusUpdateTime,
		SIDBStoreId, SiloStatus, CurrMountPathId, FailureErrorCode, MMSpareStatus)
		SELECT * FROM #tmpVolume'
	EXEC SQLUtilIdentityInsert @IdentInsQuery, 'MMVolume'
	SELECT	@o_errorCode = @@ERROR
	IF @o_errorCode > 0 GOTO CX_EXIT
	INSERT INTO #tmpMMDeletedAF
	SELECT DISTINCT 0, TV.VolumeId, 256, 0, 0, '', 0, 0, VR.MountPathId, CASE VR.IsSIVolume WHEN 1 THEN @i_sidbStoreId ELSE 0 END, 2, dbo.getUnixTime(getUTCDATE()), 0, 2
	FROM MMVolReconChunkList AS VR INNER JOIN #tmpVolume AS TV WITH (NOLOCK)
	ON VR.VolumeId = TV.VolumeId
	SELECT	@o_errorCode = @@ERROR
	IF @o_errorCode > 0 GOTO CX_EXIT
	INSERT INTO MMDeletedAF(archFileId, VolumeId, Status, Retry, copyId, cclip,
	CapacityFreedBytes, ArchChunkId, MountPathId, SIDBStoreId, CommCellId, DeletedTime, FailureErrorCode, subStoreBitField, sidbPruningFlag, appSizeFreedBytes, reserveInt, chunkCommCellId)
	SELECT archFileId, VolumeId, Status, Retry, copyId, cclip,
		   CapacityFreedBytes, ArchChunkId, MountPathId, SIDBStoreId, CommCellId, DeletedTime, FailureErrorCode, 0, 0, 0, 0, chunkCommCellId
	 FROM #tmpMMDeletedAF
	SET @volPruned = @@ROWCOUNT
	SELECT	@o_errorCode = @@ERROR
	IF @o_errorCode > 0 GOTO CX_EXIT
	DELETE FROM #tmpVolume
	DELETE FROM #tmpMMDeletedAF
	-- Do Chunk Prune - Add Chunks with "volReconVACStatusInMP" as VACStatus to MMDeletedAF Table
	INSERT INTO #tmpMMDeletedAF
	SELECT DISTINCT 0, VolumeId, 256, 0, 0, '', 0, ChunkId, MountPathId, CASE IsSIVolume WHEN 1 THEN @i_sidbStoreId ELSE 0 END, 2, dbo.getUnixTime(getUTCDATE()), 0, 2
	FROM MMVolReconChunkList WITH (NOLOCK)
	WHERE VACStatus = 2 AND PruneStatus = 3 AND AdminJobId = @i_jobId
	SELECT	@o_errorCode = @@ERROR
	IF @o_errorCode > 0 GOTO CX_EXIT
	INSERT INTO MMDeletedAF(archFileId, VolumeId, Status, Retry, copyId, cclip,
	CapacityFreedBytes, ArchChunkId, MountPathId, SIDBStoreId, CommCellId, DeletedTime, FailureErrorCode, subStoreBitField, sidbPruningFlag, appSizeFreedBytes, reserveInt)
	SELECT archFileId, VolumeId, Status, Retry, copyId, cclip,
		   CapacityFreedBytes, ArchChunkId, MountPathId, SIDBStoreId, CommCellId, DeletedTime, FailureErrorCode, 0, 0, 0, 0, chunkCommCellId
	FROM #tmpMMDeletedAF
	SET @chunkPruned = @@ROWCOUNT
	SELECT	@o_errorCode = @@ERROR
	IF @o_errorCode > 0 GOTO CX_EXIT
	DELETE FROM #tmpVolume
	DELETE FROM #tmpMMDeletedAF
	-- Do Archive File Prune for SI Volumes
	IF EXISTS (SELECT VolumeId FROM MMVolReconChunkList)
		SELECT TOP 1 @dummyVolumeId = VolumeId FROM MMVolReconChunkList order by VolumeId desc
	ELSE
		SELECT TOP 1 @dummyVolumeId = VolumeId FROM MMVolume order by VolumeId desc
	INSERT INTO #tmpMMDeletedAF
	SELECT DISTINCT VR.archFileId, @dummyVolumeId, 256, 0, VR.archCopyId, '', 0, 0, @i_mountPathId, @i_sidbStoreId, 2, dbo.getUnixTime(getUTCDATE()), 0, 2
	FROM MMVolReconSISecondary AS VR LEFT OUTER JOIN archFileCopy AS AFC WITH (NOLOCK)
	ON VR.archFileId = AFC.archFileId AND VR.archCopyId = AFC.archCopyId AND
		VR.SIDBStoreId = @i_sidbStoreId AND VR.commCellId = AFC.commCellId AND VR.AdminJobId = @i_jobId
	WHERE AFC.archFileId IS null
	SELECT	@o_errorCode = @@ERROR
	IF @o_errorCode > 0 GOTO CX_EXIT
	INSERT INTO MMDeletedAF(archFileId, VolumeId, Status, Retry, copyId, cclip,
	CapacityFreedBytes, ArchChunkId, MountPathId, SIDBStoreId, CommCellId, DeletedTime, FailureErrorCode, subStoreBitField, sidbPruningFlag, appSizeFreedBytes, reserveInt)
	SELECT archFileId, VolumeId, Status, Retry, copyId, cclip,
		   CapacityFreedBytes, ArchChunkId, MountPathId, SIDBStoreId, CommCellId, DeletedTime, FailureErrorCode, 0, 0, 0, 0, chunkCommCellId
	FROM #tmpMMDeletedAF
	SET @archPruned = @@ROWCOUNT
	SELECT	@o_errorCode = @@ERROR
	IF @o_errorCode > 0 GOTO CX_EXIT
	*/
	SET @o_returnCode = SUM(@volPruned + @chunkPruned + @archPruned)
CX_EXIT:
	DROP TABLE #tmpVolume
	DROP TABLE #tmpMMDeletedAF
PROC_EXIT:
	SELECT @o_errorCode, @o_returnCode, @o_returnString, 0, 0, ''
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MMVolReconcile')
	delete from GxQscripts where name = 'MMVolReconcile'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMVolReconcile')
	delete from GXDBVersions where aliasname = 'MMVolReconcile'
GO

insert into GXDBVersions values(2, 'MMVolReconcile',  '00010012005400020000', 'MMVolReconcile', '00010012005400020000')
GO

