

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMViewJobsOnStore.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='MMViewJobsOnStore')
BEGIN
	print '>>> Drop Stored Procedure: MMViewJobsOnStore <<<'
	drop procedure MMViewJobsOnStore
END
IF EXISTS (select * from GxQscripts where name='MMViewJobsOnStore')
	delete from GxQscripts where name = 'MMViewJobsOnStore'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMViewJobsOnStore')
	delete from GXDBVersions where aliasname = 'MMViewJobsOnStore'
GO
print '... Creating Procedure: MMViewJobsOnStore'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure MMViewJobsOnStore
  @xmlTextInput XML 
AS
SET NOCOUNT ON
-- Bit map for @o_jobCopyStatus
-- 0 = show all
-- bit 0 (=1) = Available
-- bit 1 (=2) = To be copied
-- bit 2 (=4) = Do Not Copy
-- bit 8 (=256)= Aged
-- bit 9 (=512)= Pruned
-- Bit map for @dataState
-- 0 = show all
-- bit 0 (=1) = show available
-- bit 2 (=4) = show to be copied
-- bit 3 (=8) = show not to be copied
-- bit 4 (=16)= show extended retained
-- bit 5 (=32)= show to be copied snap jobs
-- bit 6 (=64)= show not to be copied snap jobs
-- The values of status column of JMJobDataStats table
--   2 = NODATA
--   3 = INVALIODDATA
-- 100 = READY
-- 101 = NO DATA COPIED
-- 102 = NO DATA VALID
-- 103 = PARTIAL DATA
--Bit map for options
-- bit 0 (=1) = Apply specify TimeZone
-- bit 2 (=2) = Show Minor
-- bit 3 (=4) = Show Major
-- bit 4 (=8)= show Critical
if (OBJECT_ID('tempdb.dbo.#tempAppList') IS NOT NULL) DROP TABLE #tempAppList
if (OBJECT_ID('tempdb.dbo.#tempJobStats') IS NOT NULL) DROP TABLE #tempJobStats
if (OBJECT_ID('tempdb.dbo.#tempJobData') IS NOT NULL) DROP TABLE #tempJobData
if (OBJECT_ID('tempdb.dbo.#tempJobAFList') IS NOT NULL) DROP TABLE #tempJobAFList
if (OBJECT_ID('tempdb.dbo.#realInstanceNames') IS NOT NULL) DROP TABLE #realInstanceNames
if (OBJECT_ID('tempdb.dbo.#tempJobCopyAttr') IS NOT NULL) DROP TABLE #tempJobCopyAttr
if (OBJECT_ID('tempdb.dbo.#jobCRC') IS NOT NULL) DROP TABLE #jobCRC
if (OBJECT_ID('tempdb.dbo.#tempTimeZone') IS NOT NULL) DROP TABLE #tempTimeZone
if (OBJECT_ID('tempdb.dbo.#tempClientList') IS NOT NULL) DROP TABLE #tempClientList
if (OBJECT_ID('tempdb.dbo.#JobsOnStore') IS NOT NULL) DROP TABLE #JobsOnStore
if (OBJECT_ID('tempdb.dbo.#viewJobs') IS NOT NULL) DROP TABLE #viewJobs
if (OBJECT_ID('tempdb.dbo.#SPCopyList') IS NOT NULL) DROP TABLE #SPCopyList
CREATE TABLE #tempClientList(clientID int)
CREATE TABLE #tempAppList
(
	appId				int,
	clientId			int,
	appTypeId			int,
	instance			int,
	backupSet			int,
clientName			nvarchar(255),
appTypeName			varchar(255),
instanceName		nvarchar(255),
backupSetName		nvarchar(255),
subclientName		nvarchar(255),
clientDisplayName   nvarchar(255),
	PRIMARY KEY(appId)
	)
CREATE TABLE #tempJobStats
(
	copyId				int,
	jobId				int,
	commCellId			int,
	appId				int,
	applicationSize		bigint,
	compressedAppSize	bigint,
	totalBackupSize		bigint,
	nwTransferSize		bigint,
	startTime			int,
	endTime				int,
	opType				int,
	level				int,
	jobStatus			int,
	fullCycleNum		int,
	seqNumInCycle		int,
	duration			int,
	numStreams			int,
	numObjects			bigint,
	initFrom			int,
	attributes			bigint,
userName			nvarchar(255),
	totalWriteTime		int,
	scanFileFailures	int,
	scanFolderFailures	int,
	bkpFileFailures		int,
	bkpFolderFailures	int,
	PRIMARY KEY(copyId,jobId, commCellId)
)
CREATE TABLE #tempJobData
(
	jobId				int,
	commCellId			int,
	appId				int,
	minStatus			int,
	maxStatus			int,
	disabled			int,
	toBeCopied			int,
	jobCopyAttributes	int,
	sizeOnMedia			bigint,
	errorCode			int,
	archCheckEndTime	int,
	archCheckStatus		int,
	extRetentionFlags	int,
	retentionDays		bigint,
	retentionEndTime	bigint,
	copiedTime			int,
	agedTime			bigint,
	jobDescription		nvarchar(MAX),
	retainedBy	int,
	dedupSaving			bigint,
	retentionJobs		int,
	isDDBBackup			int,
	jobCopyStatus		bigint,
	spId                int,
	copyId				int,
	PRIMARY KEY(copyId, jobId, commCellId)
)
CREATE TABLE #tempJobAFList
(
	archFileId			int,
	jobId				int,
	commCellId			int,
	isDeduped			int,
	dedupSaving			bigint,
	PRIMARY KEY(archFileId, commCellId)
)
CREATE TABLE #realInstanceNames
(
	jobId				int,
	commCellId			int,
name				nvarchar(255)
)
CREATE TABLE #tempJobCopyAttr
(
	jobId				int,
	commCellId			int,
	encKeyType			int,
	isDeduped			int,
	PRIMARY KEY(jobId, commCellId)
)
CREATE TABLE #jobCRC
(
	jobId				int,
	commCellId			int,
	minCRC				int,
	maxHwEnc			int,
	PRIMARY KEY(jobId, commCellId)
)
CREATE TABLE #tempTimeZone(
clientId INT,spId INT,TimeZone VARCHAR(255))
CREATE TABLE #JobsOnStore(
	storeId INT,copyId INT, spId INT,jobId INT ,commcellId INT)
CREATE TABLE  #SPCopyList
(
	spId      INT,
	copyId    INT,
	defCopyId  INT,
	defSnapCopyId INT,
	srcCopyId  INT,
	regularAge  INT,
	archiverAge INT,
	dedupeFlags INT,
	dataState INT,
	retentionJobs INT,
	timeZoneType INT,
TimeZone    Varchar(255),
spName      Varchar(255),
copyName    Varchar(255)
)
CREATE TABLE  #SidbStoreList
(
 sidbStoreId  INT
)
	DECLARE @storeId	   INT
	DECLARE @forAllClients INT
DECLARE	@l_csTimeZone	VARCHAR(255)
    DECLARE @theBackupLevel INT
    DECLARE @timeRangeBegin INT=0
    DECLARE @timeRangeEnd INT=0
	DECLARE @dataState  INT
	DECLARE @copyId	   INT
--	DECLARE @options	   INT
	DECLARE @showAll	   BIT
	DECLARE @showAvailable BIT
	DECLARE @showToBeCopied BIT
	DECLARE @showNotToBeCopied BIT
	DECLARE @showExtendedRetained BIT
	DECLARE @applySpecifiedTimeZone BIT
	DECLARE @showMinor BIT
	DECLARE @showMajor BIT
	DECLARE @showCritical BIT
	DECLARE @MinorVal INTEGER
	DECLARE @MajorVal INTEGER
	DECLARE @CriticalVal INTEGER
	DECLARE @today INTEGER = dbo.GetUnixTime(GetUTCDate())
	DECLARE @isAged INTEGER
	DECLARE @userId INTEGER
--------------------------------------------------
--SET	@dataState = 1
SET	@l_csTimeZone = dbo.GetClientTimeZone(2)
---------------------------------------------------------------------------------------------------------
-- Set all inputs from XML string
---------------------------------------------------------------------------------------------------------
   	SET @storeId = ISNULL(( SELECT @xmlTextInput.value('(/JobManager_GetJobsOnStoreReq/entity/@sidbStoreId)[1]','int')  ),0)
	SET @copyId = ISNULL(( SELECT @xmlTextInput.value('(/JobManager_GetJobsOnStoreReq/entity/@copyId)[1]','int')  ),0)
   	SET @timeRangeBegin = ISNULL(( SELECT @xmlTextInput.value('(/JobManager_GetJobsOnStoreReq/timeRange/@fromTime)[1]','int')  ),0)
   	SET @timeRangeEnd = ISNULL(( SELECT @xmlTextInput.value('(/JobManager_GetJobsOnStoreReq/timeRange/@toTime)[1]','int')  ),0)
	SET @theBackupLevel = ISNULL(( SELECT @xmlTextInput.value('(/JobManager_GetJobsOnStoreReq/@backupLevel)[1]','int')  ),0)
	--SET @dataState =  ISNULL(( SELECT @xmlTextInput.value('(/JobManager_GetJobsOnStoreReq/@copyStateFilter)[1]','int')  ),0)
	--SET @options =  ISNULL(( SELECT @xmlTextInput.value('(/JobManager_GetJobsOnStoreReq/@options)[1]','int')  ),0)
	SET @isAged =  ISNULL(( SELECT @xmlTextInput.value('(/JobManager_GetJobsOnStoreReq/@isAged)[1]','int')  ),0)
	SET @showAll =  ISNULL(( SELECT @xmlTextInput.value('(/JobManager_GetJobsOnStoreReq/copyStateFilter/@showAll)[1]','bit')  ),0)
	SET @showAvailable =  ISNULL(( SELECT @xmlTextInput.value('(/JobManager_GetJobsOnStoreReq/copyStateFilter/@showAvailable)[1]','bit')  ),0)
	SET @showToBeCopied =  ISNULL(( SELECT @xmlTextInput.value('(/JobManager_GetJobsOnStoreReq/copyStateFilter/@showToBeCopied)[1]','bit')  ),0)
	SET @showExtendedRetained =  ISNULL(( SELECT @xmlTextInput.value('(/JobManager_GetJobsOnStoreReq/copyStateFilter/@showExtendedRetained)[1]','bit')  ),0)
	SET @applySpecifiedTimeZone =  ISNULL(( SELECT @xmlTextInput.value('(/JobManager_GetJobsOnStoreReq/options/@applySpecifiedTimeZone)[1]','bit')  ),0)
	SET @showMinor =  ISNULL(( SELECT @xmlTextInput.value('(/JobManager_GetJobsOnStoreReq/options/@showMinor)[1]','bit')  ),0)
	SET @showMajor =  ISNULL(( SELECT @xmlTextInput.value('(/JobManager_GetJobsOnStoreReq/options/@showMajor)[1]','bit')  ),0)
	SET @showCritical =  ISNULL(( SELECT @xmlTextInput.value('(/JobManager_GetJobsOnStoreReq/options/@showCritical)[1]','bit')  ),0)
	SET @userId = ISNULL(( SELECT @xmlTextInput.value('(/JobManager_GetJobsOnStoreReq/processinginstructioninfo/user/@userId)[1]','int')  ),1)
-----------------------------------------------------------------------------------------------------------
-- User Association
-------------------------------------------------------------------------------------------------------------
if (OBJECT_ID('tempdb.dbo.#lt_subclientList') IS NOT NULL) DROP TABLE #lt_subclientList
CREATE TABLE #lt_subclientList (t_clientId INT, t_appTypeId INT, t_instanceId INT, t_backupsetId INT, t_subclientId INT)
EXEC sec_getIdaObjectsForUser @userId, 7 , 0, 0, #lt_subclientList
if (OBJECT_ID('tempdb.dbo.#lt_StoragePolicyCopies') IS NOT NULL) DROP TABLE #lt_StoragePolicyCopies
CREATE TABLE #lt_StoragePolicyCopies (CopyId INT)
EXEC sec_getNonIdaObjectsForThisUser @userId, 18, 0, '#lt_StoragePolicyCopies'
----------------------------------------------------------------------------------------------------------
-- insert clients list in '#tempClientList' table based on user-selction whether "All clients"/Selected clients
----------------------------------------------------------------------------------------------------------
IF @showAll = 0 AND @showAvailable = 0 AND @showToBeCopied = 0 AND @showExtendedRetained = 0
	SET @showAll = 1
IF  @showAll = 1
BEGIN
    --SET @dataState = (1+4+8)
	SET @showAvailable = 1
	SET @showToBeCopied = 1
	SET @showNotToBeCopied = 1
END
ELSE
IF  @showExtendedRetained = 1
    SET @showAvailable = 1
if (@storeId>0)
  BEGIN
     INSERT INTO #SidbStoreList
     SELECT @storeId
  END
ELSE
  BEGIN
     INSERT INTO #SidbStoreList
     SELECT SIDBStoreId FROM archCopySIDBStore WITH (NOLOCK) WHERE CopyId = @copyId
  END
SELECT	@MinorVal = (value * 3600)
FROM	MMConfigs
WHERE NAME = 'HOURS_TO_CONSIDER_TO_BE_COPIED_DATA_HAS_MET_MINOR_CRITERIA'
		AND	nConfigSubSystemId = 3
SELECT	@MajorVal = (value * 3600)
FROM	MMConfigs
WHERE NAME = 'HOURS_TO_CONSIDER_TO_BE_COPIED_DATA_HAS_MET_MAJOR_CRITERIA'
		AND nConfigSubSystemId = 3
SELECT	@CriticalVal = (value * 3600)
FROM	MMConfigs
WHERE	NAME = 'HOURS_TO_CONSIDER_TO_BE_COPIED_DATA_HAS_MET_CRITICAL_CRITERIA'
		AND	nConfigSubSystemId = 3
  --IF @@ROWCOUNT = 0
	INSERT  INTO #tempClientList
	SELECT req.client.value('@clientId', 'INT') as ClientId
	from @xmlTextInput.nodes('/JobManager_GetJobsOnStoreReq/clients') as req(client)
	IF ((SELECT COUNT(*) from #tempClientList) > 0) -- means All clients option is not selected
	BEGIN
		SET @forAllClients = 0 --Setting this value to '0', identifying as list of clients are selected
		INSERT	INTO #tempAppList
		SELECT	A.id, A.clientId, A.appTypeId, A.instance, A.backupSet,
				'',
				(select name from APP_iDAType WITH (NOLOCK) where type = A.appTypeId),
				(select name from APP_InstanceName WITH (NOLOCK) where id = A.instance),
				(select name from APP_BackupSetName WITH (NOLOCK) where id = A.backupSet),
				A.subclientName, ''
		FROM	APP_Application A WITH (NOLOCK), #tempClientList T
		WHERE	A.clientId = T.clientID
		UPDATE #tempAppList SET clientName = cl.name, clientDisplayName = cl.displayName FROM APP_CLIENT AS cl
		WHERE clientId = cl.id
	END
	ELSE
		SET @forAllClients = 1
------------------------------------------------------------------------------------------------------
-- Inserting actual Jobs on Store
-------------------------------------------------------------------------------------------------------
    INSERT INTO #JobsOnStore
	SELECT  DISTINCT  AFD.SIDBStoreId,
					  AFD.archCopyId ,AF.archGroupId,
                      AF.jobId AS "JobId",
                      AF.commCellId AS "CommCellId"
    FROM archFile AF WITH (NOLOCK), archFileCopyDedup AFD WITH (NOLOCK), archFileCopy AFC WITH (NOLOCK), #SidbStoreList S, #lt_subclientList TSC, #lt_StoragePolicyCopies TSP
    WHERE AF.id = AFD.archFileId
	AND AF.appId = TSC.t_subclientId
	AND AFC.archCopyId = TSP.CopyId
    AND AF.commCellId = AFD.commCellId
    AND (AFD.SIDBStoreId > 0 AND AFD.SIDBStoreId = S.sidbStoreId)
    AND AFD.archFileId = AFC.archFileId
    AND AFD.CommCellId = AFC.CommCellId
    AND AFD.archCopyId = AFC.archCopyId
    AND AFC.lastChunkNumber > 0
------------------------------------------------------------------------------------------------------------------
--Initialize all required variable based on CopyID
-------------------------------------------------------------------------------------------------------------------
    CREATE INDEX SPCopyList_JobId on #SPCopyList (spId,copyId)
	INSERT INTO #SPCopyList
	SELECT DISTINCT j.spId,j.copyId,AG.defaultCopy,AG.defaultSnapCopy,0,0,0,0,1,0,AG.TimeZoneType,
	CASE WHEN AG.TimeZone = ''
	     THEN @l_csTimeZone
		 ELSE AG.TimeZone
	END,AG.name,''
	FROM #JobsOnStore AS j,archGroup AG WITH (NOLOCK)
	WHERE AG.id=j.spId
	UPDATE #SPCopyList SET regularAge =  A.retentionDays, archiverAge = A.archiverRetDays, copyName = AGC.name
    FROM    archAgingRule A WITH (NOLOCK) INNER JOIN #SPCopyList s ON A.copyId = s.copyId
	INNER JOIN  archGroupCopy AGC WITH (NOLOCK) ON AGC.id = s.copyId
	--UPDATE #SPCopyList SET copyName = AGC.name FROM archGroupCopy AGC WITH (NOLOCK),#SPCopyList s WHERE AGC.id = s.copyId
	IF	@timeRangeBegin <= 0 AND @timeRangeEnd <= 0 AND @theBackupLevel <= 0
	BEGIN
		IF	@forAllClients = 1
		BEGIN
			INSERT	INTO #tempJobData
			SELECT	J.jobId, J.commCellId, J.appId,
					MIN(J.status), MAX(J.status), dbo.BitwiseOR(J.disabled), 0, 0, SUM(J.sizeOnMedia), 0,
					MAX(J.archCheckEndTime), MAX(J.archCheckStatus),
					MAX(J.retentionFlags), T.regularAge, MAX(J.manualRetentionEndTime),
					MAX(J.copiedTime), MAX(J.agedTime), '', 0, 0, 0, 0,
					MAX(CASE WHEN J.status IN (2, 100) THEN 1 ELSE 0 END) |
					MAX(CASE WHEN J.status IN (101, 102, 103) THEN 2 ELSE 0 END) |
					MAX(J.disabled & 256) |
					MAX(CASE WHEN J.status IN (1000) THEN 512 ELSE 0 END) |
					MAX(J.disabled & 4) AS Flags,T.spId,T.copyId
			FROM	JMJobDataStats J WITH (NOLOCK) INNER JOIN #JobsOnStore JS ON (J.jobId = JS.jobId  AND JS.commcellId = J.commCellId AND J.archGrpCopyId = JS.copyId )
			         INNER JOIN #SPCopyList T on (JS.copyId = T.copyId )
			GROUP BY J.jobId, J.commCellId, J.appId,T.regularAge,T.spId,T.copyId
		END
		ELSE
			INSERT	INTO #tempJobData
			SELECT	J.jobId, J.commCellId, J.appId,
					MIN(J.status), MAX(J.status), dbo.BitwiseOR(J.disabled), 0, 0, SUM(J.sizeOnMedia), 0,
					MAX(J.archCheckEndTime), MAX(J.archCheckStatus),
					MAX(J.retentionFlags), SP.regularAge, MAX(J.manualRetentionEndTime),
					MAX(J.copiedTime), MAX(J.agedTime), '', 0, 0, 0, 0,
					MAX(CASE WHEN J.status IN (2, 100) THEN 1 ELSE 0 END) |
					MAX(CASE WHEN J.status IN (101, 102, 103) THEN 2 ELSE 0 END) |
					MAX(J.disabled & 256) |
					MAX(CASE WHEN J.status IN (1000) THEN 512 ELSE 0 END) |
					MAX(J.disabled & 4) AS Flags,SP.spId,SP.copyId
			FROM	JMJobDataStats J WITH (NOLOCK) INNER JOIN #JobsOnStore AS S ON (J.jobId = S.jobId AND J.commCellId =s.commcellId AND J.archGrpCopyId = S.copyId)
			        INNER JOIN #SPCopyList SP ON SP.copyId = J.archGrpCopyId
			INNER JOIN  #tempAppList AS T ON J.appId = T.appId
			GROUP BY J.jobId, J.commCellId, J.appId,SP.regularAge,SP.spId,SP.copyId
		END
	ELSE
	--------------------------------------------------
	--This code executes for ("Snap Policy" && "With backup copy filter" && "with Primary copy")
	--------------------------------------------------
	BEGIN
		IF	@timeRangeEnd <= 0
			SET @timeRangeEnd = dbo.getUnixTime(GetUTCDate())
		IF	@forAllClients = 0
            -- This code is to populate fields for 'ALL CLIENTS' based on 'Time Range' and 'Backup Level'
			INSERT	INTO #tempJobStats
			SELECT	DISTINCT JS.copyId, J.jobId, J.commCellId, J.appId,
					case when J.dataArchGrpId > 1 and J.logArchGrpId > 1 and J.dataArchGrpId <> J.logArchGrpId
						then ISNULL((select sum(unCompBytes) from JMBkpAtmptStats WITH (NOLOCK)
								where jobId = J.jobId and commCellId = J.commCellId and archGrpId = JS.spId and status in (1,3,14,16)), 0)
						else J.totalUncompBytes end,
					case when J.dataArchGrpId > 1 and J.logArchGrpId > 1 and J.dataArchGrpId <> J.logArchGrpId
						then ISNULL((select sum(compBytes) from JMBkpAtmptStats WITH (NOLOCK)
								where jobId = J.jobId and commCellId = J.commCellId and archGrpId = JS.spId and status in (1,3,14,16)), 0)
						else J.totalCompBytes end,
					J.totalBackupSize,
					case when J.dataArchGrpId > 1 and J.logArchGrpId > 1 and J.dataArchGrpId <> J.logArchGrpId
						then ISNULL((select sum(nwTransBytes) from JMBkpAtmptStats WITH (NOLOCK)
								where jobId = J.jobId and commCellId = J.commCellId and archGrpId = JS.spId and status in (1,3,14,16)), 0)
						else J.nwTransBytes end,
					J.servStartDate, J.servEndDate, J.opType, J.bkpLevel, J.status,
					J.fullCycleNum, J.cycleSequence, J.duration, J.numStreams,
					(select sum(numObjects) from JMBkpAtmptStats where jobId = J.jobId and commCellId = J.commCellId),
					J.initFrom, J.bkpAttributes, J.username, J.totalWriteTime,
					J.scanFileFailures, J.scanFolderFailures, J.backupFileFailures, J.backupFolderFailures
			FROM	JMBkpStats J WITH(NOLOCK)INNER JOIN  #tempAppList T ON J.appId = T.appId INNER JOIN #JobsOnStore JS ON (J.jobId = JS.jobId  AND JS.commcellId = J.commCellId )
			WHERE J.servStartDate >= @timeRangeBegin AND J.servStartDate < @timeRangeEnd
				AND J.status IN (1, 3, 14, 16)
				--AND (J.dataArchGrpId =  JS.spId OR J.logArchGrpId =  JS.spId OR J.diffArchGrpId =  JS.spId)
				AND (	@theBackupLevel <= 0
					OR	@theBackupLevel = J.bkpLevel
					OR	@theBackupLevel = 1 AND J.bkpLevel IN (1, 64, 128, 1024, 16384, 32768)
					OR	@theBackupLevel = 2 AND J.bkpLevel IN (2, 256)
					)
		ELSE
			INSERT	INTO #tempJobStats
			SELECT	DISTINCT JS.copyId,J.jobId, J.commCellId, J.appId,
					case when J.dataArchGrpId > 1 and J.logArchGrpId > 1 and J.dataArchGrpId <> J.logArchGrpId
						then ISNULL((select sum(unCompBytes) from JMBkpAtmptStats WITH (NOLOCK)
								where jobId = J.jobId and commCellId = J.commCellId and archGrpId = JS.spId and status in (1,3,14,16)), 0)
						else J.totalUncompBytes end,
					case when J.dataArchGrpId > 1 and J.logArchGrpId > 1 and J.dataArchGrpId <> J.logArchGrpId
						then ISNULL((select sum(compBytes) from JMBkpAtmptStats WITH (NOLOCK)
								where jobId = J.jobId and commCellId = J.commCellId and archGrpId = JS.spId and status in (1,3,14,16)), 0)
						else J.totalCompBytes end,
					J.totalBackupSize,
					case when J.dataArchGrpId > 1 and J.logArchGrpId > 1 and J.dataArchGrpId <> J.logArchGrpId
						then ISNULL((select sum(nwTransBytes) from JMBkpAtmptStats WITH (NOLOCK)
								where jobId = J.jobId and commCellId = J.commCellId and archGrpId = JS.spId and status in (1,3,14,16)), 0)
						else J.nwTransBytes end,
					J.servStartDate, J.servEndDate, J.opType, J.bkpLevel, J.displayStatus,
					J.fullCycleNum, J.cycleSequence, J.duration, J.numStreams,
					(select sum(numObjects) from JMBkpAtmptStats where jobId = J.jobId and commCellId = J.commCellId),
					J.initFrom, J.bkpAttributes, J.username, J.totalWriteTime,
					J.scanFileFailures, J.scanFolderFailures, J.backupFileFailures, J.backupFolderFailures
			FROM	JMBkpStats J WITH(NOLOCK) INNER JOIN #JobsOnStore JS ON (J.jobId = JS.jobId  AND JS.commcellId = J.commCellId )
			WHERE	J.servStartDate >= @timeRangeBegin AND J.servStartDate < @timeRangeEnd
				AND J.status IN (1, 3, 14, 16)
				--AND (J.dataArchGrpId =  JS.spId OR J.logArchGrpId =  JS.spId OR J.diffArchGrpId =  JS.spId)
				AND (	@theBackupLevel <= 0
					OR	@theBackupLevel = J.bkpLevel
					OR	@theBackupLevel = 1 AND J.bkpLevel IN (1, 64, 128, 1024, 16384, 32768)
					OR	@theBackupLevel = 2 AND J.bkpLevel IN (2, 256)
					)
		INSERT	INTO #tempJobStats
		SELECT	DISTINCT JS.copyId,J.jobId, J.commCellId, J.appId, (case when J.uncompBytes > 0 then J.uncompBytes else J.totalBackupSize end),
				(case when J.TotalSize > 0 then J.TotalSize else J.totalBackupSize end), J.totalBackupSize, J.nwTransBytes,
				J.servStart, J.servEnd, J.opType, J.ER_BkpLevel, J.status,
				J.fullCycleNum, 0/*J.cycleSequence*/, 0/*J.duration*/, J.noOfStreams, 1/*numObjects*/,
				J.initFrom, 0/*J.bkpAttributes*/, J.username, J.totalWriteTime,
				0/*J.scanFileFailures*/, 0/*J.scanFolderFailures*/, 0/*J.backupFileFailures*/, 0/*J.backupFolderFailures*/
		FROM	JMAdminJobStatsTable J WITH (NOLOCK) INNER JOIN #JobsOnStore JS ON (J.jobId = JS.jobId  AND JS.commcellId = J.commCellId )
		WHERE	J.servStart >= @timeRangeBegin AND J.servStart < @timeRangeEnd
			AND J.opType IN (11, 64)
			AND J.ArchGrpId = JS.spId
			AND (	@theBackupLevel <= 0
				OR	@theBackupLevel = J.ER_BkpLevel
				OR	@theBackupLevel = 1 AND J.ER_BkpLevel IN (1, 64, 128, 1024, 16384, 32768)
				OR	@theBackupLevel = 2 AND J.ER_BkpLevel IN (2, 256)
				)
		INSERT	INTO #tempJobData
		SELECT	J.jobId, J.commCellId, J.appId,
				MIN(J.status), MAX(J.status), MAX(J.disabled), 0, 0, SUM(J.sizeOnMedia), 0,
				MAX(J.archCheckEndTime), MAX(J.archCheckStatus),
				MAX(J.retentionFlags), S.regularAge, MAX(J.manualRetentionEndTime),
				MAX(J.copiedTime), MAX(J.agedTime), '', 0, 0, 0, 0,
					MAX(CASE WHEN J.status IN (2, 100) THEN 1 ELSE 0 END) |
					MAX(CASE WHEN J.status IN (101, 102, 103) THEN 2 ELSE 0 END) |
					MAX(J.disabled & 256) |
					MAX(CASE WHEN J.status IN (1000) THEN 512 ELSE 0 END) |
					MAX(J.disabled & 4) AS Flags,S.spId,S.copyId
		FROM	JMJobDataStats J WITH (NOLOCK)
		    INNER JOIN #JobsOnStore JS ON  (JS.jobId = J.jobId AND J.archGrpCopyId =JS.copyId AND JS.commcellId = J.commCellId)
			INNER JOIN #SPCopyList S ON J.archGrpCopyId = S.copyId
		    INNER JOIN #tempJobStats T ON (JS.jobId = T.jobId AND JS.commCellId = T.commCellId)
		GROUP BY J.jobId, J.commCellId, J.appId, S.regularAge,S.spId,S.copyId
	END
	DELETE FROM #tempJobData
	WHERE 	NOT		((	@showAvailable = 1 AND (#tempJobData.jobCopyStatus & 1 = 1)
					OR	@showToBeCopied = 1  AND (#tempJobData.jobCopyStatus & 2 = 2) AND #tempJobData.disabled & (1+256) = 0
					OR	@showNotToBeCopied = 1 AND (#tempJobData.jobCopyStatus & 2 = 2) AND #tempJobData.disabled & (1+256) <> 0)
				AND (	@showExtendedRetained = 0 OR #tempJobData.extRetentionFlags <> 0)
				AND (	@isAged = 0 AND (#tempJobData.disabled & 256 = 0 OR (#tempJobData.jobCopyStatus & 1024 = 1024))
				OR	@isAged = 1 AND #tempJobData.disabled & 256 <> 0
				OR	@isAged = 2))
	INSERT	INTO #tempJobStats
		SELECT	DISTINCT JS.copyId,J.jobId, J.commCellId, J.appId,
				case when J.dataArchGrpId > 1 and J.logArchGrpId > 1 and J.dataArchGrpId <> J.logArchGrpId
					then ISNULL((select sum(unCompBytes) from JMBkpAtmptStats WITH (NOLOCK)
							where jobId = J.jobId and commCellId = J.commCellId and archGrpId = JS.spId and status in (1,3,14)), 0)
					else J.totalUncompBytes end,
				case when J.dataArchGrpId > 1 and J.logArchGrpId > 1 and J.dataArchGrpId <> J.logArchGrpId
					then ISNULL((select sum(compBytes) from JMBkpAtmptStats WITH (NOLOCK)
							where jobId = J.jobId and commCellId = J.commCellId and archGrpId = JS.spId and status in (1,3,14)), 0)
					else J.totalCompBytes end,
				J.totalBackupSize,
				case when J.dataArchGrpId > 1 and J.logArchGrpId > 1 and J.dataArchGrpId <> J.logArchGrpId
					then ISNULL((select sum(nwTransBytes) from JMBkpAtmptStats WITH (NOLOCK)
							where jobId = J.jobId and commCellId = J.commCellId and archGrpId = JS.spId and status in (1,3,14)), 0)
					else J.nwTransBytes end,
				J.servStartDate, J.servEndDate, J.opType, J.bkpLevel, J.displayStatus,
				J.fullCycleNum, J.cycleSequence, J.duration, J.numStreams,
				(select sum(numObjects) from JMBkpAtmptStats where jobId = J.jobId and commCellId = J.commCellId),
				J.initFrom, J.bkpAttributes, J.username, J.totalWriteTime,
				J.scanFileFailures, J.scanFolderFailures, J.backupFileFailures, J.backupFolderFailures
		FROM	JMBkpStats J WITH(NOLOCK)
		        INNER JOIN #JobsOnStore JS ON  (J.jobId = JS.jobId AND J.commCellId =JS.commcellId)
		        --INNER JOIN #SPCopyList S ON J.jobId = S.jobId
				INNER JOIN /*(SELECT DISTINCT jobId, commCellId FROM #tempJobData)*/ #tempJobData A ON J.jobId = A.jobId AND J.commCellId = A.commCellId
				LEFT OUTER JOIN #tempJobStats B ON J.jobId = B.jobId AND J.commCellId = B.commCellId
		WHERE	B.jobId IS null
		        AND J.status IN (1, 3, 14, 16)
   		        AND j.jobId IN (JS.jobId)
		INSERT	INTO #tempJobStats
		SELECT	DISTINCT JS.copyId,J.jobId, J.commCellId, J.appId, (case when J.uncompBytes > 0 then J.uncompBytes else J.totalBackupSize end),
				(case when J.TotalSize > 0 then J.TotalSize else J.totalBackupSize end), J.totalBackupSize, J.nwTransBytes,
				J.servStart, J.servEnd, J.opType, J.ER_BkpLevel, J.status,
				J.fullCycleNum, 0/*J.cycleSequence*/, 0/*J.duration*/, J.noOfStreams, 1/*numObjects*/,
				J.initFrom, 0/*J.bkpAttributes*/, J.username, J.totalWriteTime,
				0/*J.scanFileFailures*/, 0/*J.scanFolderFailures*/, 0/*J.backupFileFailures*/, 0/*J.backupFolderFailures*/
		FROM	JMAdminJobStatsTable J WITH (NOLOCK)
		        INNER JOIN #JobsOnStore JS ON (J.jobId = JS.jobId AND JS.commcellId = J.commCellId)
				INNER JOIN /*(SELECT DISTINCT jobId, commCellId FROM #tempJobData)*/#tempJobData A ON J.jobId = A.jobId AND J.commCellId = A.commCellId
				LEFT OUTER JOIN #tempJobStats B ON J.jobId = B.jobId AND J.commCellId = B.commCellId
		WHERE	B.jobId IS null AND J.status IN (1, 3, 14)
/*		UPDATE #tempJobData SET copyId = J.copyId, spId = J.spId
		FROM #JobsOnStore J , #tempJobData T WHERE T.jobId = J.jobId
*/
       --Delete all aged Jobs, do not show aged jobs in view jobs on store
       /*DELETE FROM #tempJobData
       WHERE disabled&256 <> 0*/
        DROP TABLE #JobsOnStore
		CREATE INDEX JobStats_appId on #tempJobStats (appId)
		INSERT	INTO #tempAppList
		SELECT	A.id, A.clientId, A.appTypeId, A.instance, A.backupSet,
				(select name from APP_Client WITH (NOLOCK) where id = A.clientId),
				(select name from APP_iDAType WITH (NOLOCK) where type = A.appTypeId),
				(select name from APP_InstanceName WITH (NOLOCK) where id = A.instance),
				(select name from APP_BackupSetName WITH (NOLOCK) where id = A.backupSet),
				A.subclientName,
				(select displayName from APP_Client WITH (NOLOCK) where id = A.clientId)
		FROM	APP_Application A WITH (NOLOCK)
				INNER JOIN (SELECT DISTINCT appId FROM #tempJobStats) B ON A.id = B.appId
				LEFT OUTER JOIN #tempAppList C ON C.appId = B.appId
		WHERE	C.appId IS null
		----------------------------------------------
		--IF	@dataState != 8
			-- Update retentionDays based on extended retention rules.
					CREATE	TABLE #tempAgingRulesExt(copyId INT,retentionDays INT, retentionRule INT, graceRule INT)
					INSERT	INTO #tempAgingRulesExt
					SELECT	S.copyId,retentionDays, retentionRule, 0
					FROM	archAgingRuleExtended  A WITH (NOLOCK) INNER JOIN #SPCopyList S
					ON A.copyId = S.copyId
					WHERE	S.dataState != 8  AND S.regularAge >=0
					IF @@ERROR = 0 AND @@ROWCOUNT > 0
						BEGIN
								UPDATE #tempAgingRulesExt
								SET    graceRule =  CASE
															WHEN retentionRule = 64 THEN 4096
															WHEN retentionRule = 32 THEN 2048
															WHEN retentionRule = 16 THEN 1024
															WHEN retentionRule = 8 THEN 512
															WHEN retentionRule = 4 THEN 256
															WHEN retentionRule = 524288 THEN 8388608
															WHEN retentionRule = 262144 THEN 4194304
															ELSE 0
													END
							DECLARE @l_ExtRetentionRuleSum	INT
							SELECT	@l_ExtRetentionRuleSum = SUM(retentionRule+graceRule) FROM #tempAgingRulesExt GROUP BY copyId
							UPDATE	#tempJobData
							SET		extRetentionFlags = (
									case
									when extRetentionFlags & (64|4096) <> 0 then 64
									when extRetentionFlags & (32|2048) <> 0 then 32
									when extRetentionFlags & (16|1024) <> 0 then 16
									when extRetentionFlags & (8 | 512) <> 0 then 8
									when extRetentionFlags & (4 | 256) <> 0 then 4
									when extRetentionFlags & (524288 | 8388608) <> 0 then 524288
									when extRetentionFlags & (262144 | 4194304) <> 0 then 262144
									when extRetentionFlags & 2 <> 0 then 2
									end)
							WHERE	extRetentionFlags & @l_ExtRetentionRuleSum <> 0
							UPDATE	#tempJobData
							SET		retentionDays = b.retentionDays
							FROM	#tempJobData a, #tempAgingRulesExt b
							WHERE	b.retentionRule = a.extRetentionFlags
								AND (b.retentionDays < 0 OR b.retentionDays > a.retentionDays)
						END
					DROP TABLE #tempAgingRulesExt
			--END
			UPDATE	#tempJobData
			SET		retentionDays = S.archiverAge
			FROM	#tempJobData a
			        INNER JOIN #SPCopyList S ON S.copyId=a.copyId,
					(SELECT appId
					FROM	#tempAppList APP, APP_IDATypeHandlingInfo IDA WITH (NOLOCK)
					WHERE	IDA.appTypeId = APP.appTypeId AND IDA.isDMAppType = 1) b
			WHERE	a.appId = b.appId
			--Update retentionJobs for those appType and copy that honors Job Based Retention
			IF EXISTS (SELECT AAR.copyId FROM archAgingRule AAR WITH (NOLOCK)
INNER JOIN #SPCopyList S  ON (AAR.copyId = S.copyId) AND (AAR.flags & 128) > 0)
				BEGIN
				    UPDATE #SPCopyList
					SET retentionJobs = AAR.retentionJobs
					FROM archAgingRule AAR WITH (NOLOCK)
INNER JOIN #SPCopyList S  ON (AAR.copyId = S.copyId) AND (AAR.flags & 128) > 0
					UPDATE #tempJobData
					SET retentionJobs = S.retentionJobs
					FROM	#tempJobData T, App_Application A WITH (NOLOCK),#SPCopyList S
					WHERE	T.appId = A.id
					AND		S.retentionJobs > 0
					AND		A.appTypeId NOT IN (
									SELECT appTypeId
									FROM APP_IDATypeHandlingInfo
									WHERE ignoreJobRetention = 1
								)
				END
			--Update isDDBBackup = 1 for DDB subclients
			UPDATE #tempJobData
			SET isDDBBackup = 1
			FROM	#tempJobData T, App_SubclientProp B WITH (NOLOCK)
			WHERE	T.appId = B.componentNameId
			AND		B.attrName = 'DDB Backup'
			AND		B.attrVal = '1'
			AND		B.modified = 0
			--The retentionEndTime here is the one we get from manualRetentionEndTime column of JMJobDataStats so if it is -1 or greater than the one we calculate from aging rule consider it retained by user
			UPDATE	#tempJobData
			SET		retainedBy = case when (A.retentionEndTime > (B.startTime + A.retentionDays*24*3600) OR A.retentionEndTime = -1) then 1
											else 0 end
			FROM	#tempJobData A, #tempJobStats B
			WHERE	B.jobId = A.jobId AND B.commCellId = A.commCellId
			--Set retentionEndTime = -2 to show N/A in GUI
			UPDATE	#tempJobData
			SET		retentionEndTime = case when (A.retentionEndTime = 0 AND A.retentionJobs > 0) then -2
											when (A.retentionEndTime = 0 AND A.isDDBBackup > 0) then -2
											when A.retentionDays < 0 then -1
											when A.retentionEndTime >(B.startTime + A.retentionDays*24*3600) then A.retentionEndTime
											else (B.startTime + A.retentionDays*24*3600) end
			FROM	#tempJobData A, #tempJobStats B
			WHERE	B.jobId = A.jobId AND B.commCellId = A.commCellId AND A.retentionEndTime > -1
			UPDATE	#tempJobData SET archCheckStatus = 4
			FROM	JMJobDataStats B WITH (NOLOCK)
				INNER JOIN  #tempJobData A ON (B.jobId = A.jobId AND B.commCellId = A.commCellId)
				INNER JOIN  #SPCopyList S ON B.archGrpCopyId = S.copyId
			WHERE A.archCheckStatus = 5 AND B.archCheckStatus < 5
		INSERT	INTO #tempJobAFList
		SELECT	distinct A.id, A.jobId, A.commCellId, 0, 0
		FROM	archFile A WITH (NOLOCK)INNER JOIN #tempJobData T ON (A.jobId = T.jobId AND A.commCellId = T.commCellId )
		INNER JOIN #SPCopyList S ON (A.archGroupId = S.spId)
		WHERE A.isValid = 1
        -- EXECUTE THIS ALWAYS AS DEDUPE FLAG WILL BE SET
		UPDATE	#tempJobAFList
		SET		isDeduped = 1,
		dedupSaving = ISNULL(A.secondaryObjSize, 0) + ISNULL(A.secondaryMetaDataSize, 0) + ISNULL(A.primaryMetaDataSize, 0)
		FROM	archFileCopyDedup A WITH (NOLOCK)
		INNER JOIN #tempJobAFList T ON (A.archFileId = T.archFileId AND A.commCellId = T.commCellId )
		INNER JOIN #SPCopyList S ON  A.archCopyId = S.copyId
		WHERE A.secondaryObjSize > 0
		UPDATE #tempJobData
		SET	dedupSaving = (SELECT SUM(dedupSaving) FROM #tempJobAFList T WHERE T.jobId = #tempJobData.jobId AND T.commCellId = #tempJobData.commCellId)
		DECLARE	@l_jobId		INT
		DECLARE	@l_commCellId	INT
DECLARE	@l_instanceName	VARCHAR(255)
		DECLARE	@l_len			INT
		DECLARE	@t_jobId		INT
		DECLARE	@t_commCellId	INT
DECLARE	@t_instanceName	VARCHAR(255)
		DECLARE	@t_len			INT
		SET	@l_jobId		= 0
		SET	@l_commCellId	= 0
		SET	@l_len			= 0
		--Setting instance name
		DECLARE	GetInstanceNameCur CURSOR FOR
		SELECT	T.jobId, T.commCellId,
		CASE WHEN I.name LIKE '%'+nchar(0x12)+'%' THEN  (SUBSTRING(I.name,0,PATINDEX('%'+nchar(0x12)+'%', I.name)))
			 ELSE  I.name
		END
		FROM	archFileOracle A WITH (NOLOCK), APP_InstanceName I WITH (NOLOCK), APP_Application APP WITH (NOLOCK), JMBkpStats J WITH (NOLOCK), #tempJobAFList T
		WHERE	A.archFileId = T.archFileId AND A.commCellId = T.commCellId AND I.id = A.instanceId
			AND J.jobId = T.jobId AND J.commCellId = T.commCellId AND (J.bkpAttributes & 0x20000) > 0
			AND APP.id = A.appId AND APP.instance <> A.instanceId
		GROUP BY T.jobId, T.commCellId, I.name
		ORDER BY T.jobId, T.commCellId, I.name
		OPEN	GetInstanceNameCur
		FETCH	FROM GetInstanceNameCur
		INTO	@t_jobId, @t_commCellId, @t_instanceName
		WHILE @@FETCH_STATUS = 0
		BEGIN
			SELECT @t_len = LEN(@t_instanceName)
			IF	@l_jobId = @t_jobId AND @l_commCellId = @t_commCellId
			BEGIN
IF	@l_len < (255 - 6)
				BEGIN
IF	(@l_len + @t_len) < (255 - 6)
					BEGIN
						SET @l_instanceName = @l_instanceName + ', ' + @t_instanceName
						SET @l_len = @l_len + @t_len + 2
					END
					ELSE
					BEGIN
						SET @l_instanceName = @l_instanceName + ', ...)'
SET @l_len = 255
					END
				END
			END
			ELSE
			BEGIN
				IF	@l_jobId > 0
					INSERT	INTO #realInstanceNames
					SELECT	@l_jobId, @l_commCellId, @l_instanceName + ')'
				SET @l_jobId		= @t_jobId
				SET @l_commCellId	= @t_commCellId
				SET	@l_instanceName	= 'On Demand Instance (' + @t_instanceName
				SET @l_len			= @t_len + 20
			END
			FETCH	FROM GetInstanceNameCur
			INTO	@t_jobId, @t_commCellId, @t_instanceName, @t_len
		END
		IF	@l_jobId > 0
			INSERT	INTO #realInstanceNames
			SELECT	@l_jobId, @l_commCellId, @l_instanceName + ')'
		CLOSE		GetInstanceNameCur
		DEALLOCATE	GetInstanceNameCur
		-- Set jobCopyAttributes
		--need to work
		INSERT INTO #tempJobCopyAttr
		SELECT	T.jobId, T.commCellId, MAX(A.encKeyType), MAX(T.isDeduped)
		FROM	#tempJobAFList T
				INNER JOIN archFileCopy A WITH (NOLOCK)	ON (A.archFileId = T.archFileId AND A.commCellId = T.commCellId)
				INNER JOIN #tempJobData S ON (A.archCopyId = S.copyId AND T.jobId = S.jobId)
		GROUP BY T.jobId, T.commCellId
		UPDATE	#tempJobData
SET		jobCopyAttributes = (A.jobCopyAttributes | B.isDeduped * 1)
		FROM	#tempJobData A, #tempJobCopyAttr B
		WHERE	A.commCellId = B.commCellId AND A.jobId = B.jobId
		UPDATE	#tempJobData
SET		jobCopyAttributes = (A.jobCopyAttributes | 2)
		FROM	#tempJobData A, #tempJobCopyAttr B
		WHERE	A.commCellId = B.commCellId AND A.jobId = B.jobId AND B.encKeyType <> 0
		--IF (@dedupeFlags & (2097152)) = (2097152) by default flag 'CVA_SIDB_STORE_ENABLED_FLAG' will be set
		--BEGIN
			CREATE TABLE #tempJobChunk (jobId INT, archChunkId bigint, commCellId int, isSiloed int)
			INSERT	INTO #tempJobChunk
			SELECT	T.jobId, ACM.archChunkId, ACM.commCellId, 0
			FROM	#tempJobAFList T, archChunkMapping ACM WITH (NOLOCK)
					INNER JOIN #SPCopyList S ON ACM.archCopyId = S.copyId
			WHERE	ACM.archFileId = T.archFileId
			        AND ACM.commCellId = T.commCellId
AND (S.dedupeFlags & (2097152)) = (2097152)
			if(@@ROWCOUNT > 0)
			BEGIN
				UPDATE	#tempJobChunk
				SET		isSiloed = 1
				FROM	#tempJobChunk T, archChunkToSilo AC WITH (NOLOCK), archFileSiloVolume SV WITH (NOLOCK)
				WHERE	AC.archChunkId = T.archChunkId AND AC.commCellId = T.commCellId
					AND AC.volumeId = SV.siloVolumeId
AND AC.archChunkId <= SV.lastSiloChunkId AND (SV.flags & (1 | 2)) <> 0
				DELETE	#tempJobChunk
				FROM	#tempJobChunk T, (SELECT DISTINCT jobId, commCellId FROM #tempJobChunk WHERE isSiloed = 0) B
				WHERE	T.jobId = B.jobId AND T.commCellId = B.commCellId
				UPDATE	#tempJobData
SET		jobCopyAttributes = (A.jobCopyAttributes | 16)
				FROM	#tempJobData A, (SELECT DISTINCT jobId, commCellId FROM #tempJobChunk WHERE isSiloed = 1) B
				WHERE	A.jobId = B.jobId AND A.commCellId = B.commCellId
			END
			DROP TABLE #tempJobChunk
		--END
		INSERT	INTO #jobCRC
SELECT	T.jobId, T.commCellId, MIN(AC.flags & 16),
(MAX(AC.flags & 1048576) | MAX(LEN(hwEncKey)))
		FROM	#tempJobAFList T
		        INNER JOIN #tempJobData S ON  T.jobId = S.jobId
				INNER JOIN archChunkMapping ACM WITH (NOLOCK) ON (ACM.archFileId = T.archFileId AND ACM.commCellId = T.commCellId AND ACM.archCopyId = S.copyId)
				INNER JOIN archChunk AC WITH (NOLOCK) ON AC.id = ACM.archChunkId AND AC.commCellId = ACM.commCellId
		GROUP BY T.jobId, T.commCellId
		UPDATE	#tempJobData
SET		jobCopyAttributes = (A.jobCopyAttributes | 4)
		FROM	#tempJobData A, #jobCRC B
		WHERE	A.jobId = B.jobId AND A.commCellId = B.commCellId AND B.minCRC <> 0
		UPDATE	#tempJobData
SET		jobCopyAttributes = (A.jobCopyAttributes | 8)
		FROM	#tempJobData A, #jobCRC B
		WHERE	A.jobId = B.jobId AND A.commCellId = B.commCellId AND B.maxHwEnc <> 0
		DROP TABLE #jobCRC
		DROP TABLE #tempJobAFList
		DROP TABLE #tempJobCopyAttr
		INSERT INTO  #tempTimeZone
		SELECT DISTINCT A.clientId,spId,'' FROM #tempJobData T INNER JOIN #tempAppList A ON A.appId = T.appId
		UPDATE #tempTimeZone
		SET #tempTimeZone.TimeZone = CASE WHEN AG.TimeZoneType = 0  THEN @l_csTimeZone
		                                 WHEN AG.TimeZoneType = 1  THEN dbo.archGroupTimeZone(spId, TZ.clientId)
										 ELSE AG.TimeZone
									END
		FROM archGroup AG WITH(NOLOCK) INNER JOIN #tempTimeZone TZ ON TZ.spId = id
		UPDATE	#tempJobStats
		SET		startTime		= J.startTime + dbo.GetDiffFromCSTimeZone(J.startTime, TZ.TimeZone, @l_csTimeZone),
				endTime			= J.endTime + dbo.GetDiffFromCSTimeZone(J.endTime, TZ.TimeZone, @l_csTimeZone)
		FROM	#tempJobStats J INNER JOIN #tempJobData T ON (T.jobId =J.jobId  AND T.commCellId = J.commCellId)
		        INNER JOIN #tempAppList A ON A.appid = T.appId
				INNER JOIN #tempTimeZone TZ ON (A.clientId = TZ.clientId AND T.spId = TZ.spId)
		WHERE	TZ.TimeZone <> '' AND TZ.TimeZone <> @l_csTimeZone
		-- Delete the foreign jobs if they are already prepared
		DELETE	#tempJobStats
		FROM	#tempJobStats, JMPreparedJob
		WHERE	#tempJobStats.jobId = JMPreparedJob.jobId AND #tempJobStats.commCellId = JMPreparedJob.commCellId
				AND JMPreparedJob.status = 3
		UPDATE	#tempJobData
		SET		archCheckEndTime= case when J.archCheckEndTime = 0 then 0 else
								J.archCheckEndTime + dbo.GetDiffFromCSTimeZone(J.archCheckEndTime, TZ.TimeZone, @l_csTimeZone) end,
				retentionEndTime= case 	when J.retentionEndTime = -2 then -2
																when J.retentionEndTime = -1 then -1
													else 	J.retentionEndTime + dbo.GetDiffFromCSTimeZone(J.retentionEndTime, TZ.TimeZone, @l_csTimeZone) end,
				copiedTime		= case when J.copiedTime = 0 then 0 else
								J.copiedTime + dbo.GetDiffFromCSTimeZone(J.copiedTime, TZ.TimeZone, @l_csTimeZone) end,
				agedTime		= case when J.agedTime = 0 then 0 else
								J.agedTime + dbo.GetDiffFromCSTimeZone(J.agedTime, TZ.TimeZone, @l_csTimeZone) end
		FROM	#tempJobData J INNER JOIN #tempAppList A ON A.appid = J.appId
				INNER JOIN #tempTimeZone TZ ON (A.clientId = TZ.clientId AND J.spId = TZ.spId)
		WHERE	TZ.TimeZone <> '' AND TZ.TimeZone <> @l_csTimeZone
		UPDATE #tempJobData
		SET jobDescription = JMJS.jobDescription
		FROM JMJobStats JMJS
		WHERE #tempJobData.jobId = JMJS.jobId and #tempJobData.commCellId = JMJS.commCellId
	CREATE TABLE #viewJobs
	(
	   copyId int,
	   jobId int,
	   commCellId int,
	   appId int,
	   sizeOfApplication  bigint, --BYTES_UNCOMPRESSED_ITEM
	   sizeOfAppCompressed bigint, --BYTES_COMPRESSED_ITEM
	   totalBackupSize bigint,
	   nwTransferSize bigint,
	   startTime int,
	   endTime int,
	   opType int,
	   level int,
	   jobStatus int,
	   fullCycleNum int,
	   seqNumInCycle int,
	   duration int,
	   numStreams int,
	   numObjects bigint,
	   initFrom int,
	   attributes bigint,
userName nvarchar(255),
	   totalWriteTime int,
	   scanFileFailures int,
	   scanFolderFailures int,
	   bkpFileFailures int,
	   bkpFolderFailures int,
	   subClientId int,
	   clientId int,
	   appTypeId int,
	   instanceId int,
	   backupSetId int,
clientName nvarchar(255),
appTypeName varchar(255),
instanceName nvarchar(255),
backupSetName nvarchar(255),
subclientName nvarchar(255),
	   storagePolicyId int,
storagePolicyName nvarchar(255),
commCellName nvarchar(255),
	   status int,
	   disabled int,
	   toBeCopied int,
	   jobCopyAttributes int,
	   sizeOnMedia bigint,
	   archCheckEndTime int,
	   archCheckStatus int,
	   extRetentionFlags int,
	   retentionEndTime bigint,
	   copiedTime int,
	   agedTime bigint,
	   errorCode int,
	   retainedBy int,
copyName nvarchar(255),
	   dedupSaving bigint,
	   jobCopyStatus int,
	   jobDescription nvarchar(MAX),
clientDisplayName nvarchar(255)
	 )
  INSERT INTO #viewJobs
	SELECT	B.* , A.appId , A.clientId, A.appTypeId, A.instance, A.backupSet,	A.clientName, A.appTypeName,
			InstName = (CASE WHEN I.name IS NULL THEN (
			CASE
				WHEN A.instanceName LIKE '%'+nchar(0x12)+'%' THEN (SUBSTRING(A.instanceName,0,PATINDEX('%'+nchar(0x12)+'%', A.instanceName)))
				ELSE  A.instanceName
			END) ELSE I.name END), A.backupSetName, A.subclientName,J.spId,'',
			(select aliasName from APP_CommCell WITH (NOLOCK) where id=J.commCellId)  AS 'CommCell Name',
			(case when (J.minStatus = 100 and J.maxStatus = 101) then 103 when (J.minStatus < 1000 and J.maxStatus = 1000) then J.minStatus else J.maxStatus end) AS 'Status',
			J.disabled, J.toBeCopied, J.jobCopyAttributes, J.sizeOnMedia, J.archCheckEndTime, J.archCheckStatus,
			J.extRetentionFlags, J.retentionEndTime, J.copiedTime , J.agedTime, J.errorCode, J.retainedBy ,'', J.dedupSaving, J.jobCopyStatus, J.jobDescription, A.clientDisplayName
	FROM	#tempAppList A, #tempJobStats B, #tempJobData J
			LEFT OUTER JOIN #realInstanceNames AS I ON I.jobId = J.jobId AND I.commcellId = J.CommcellId
	WHERE	J.jobId = B.jobId AND J.commCellId = B.commCellId AND A.appId = B.appId
	AND ((@showMinor = 0 AND @showMajor = 0 AND @showCritical = 0) OR (( J.jobCopyStatus & 2 = 0 ) OR ( J.jobCopyStatus & 2 > 0 AND (((@showMinor = 1) AND (@today - B.StartTime) BETWEEN @MinorVal AND @MajorVal)
		OR ((@showMajor = 1) AND (@today - B.StartTime) BETWEEN @MajorVal AND @CriticalVal)
		OR ((@showCritical = 1) AND (@today - B.StartTime) >= @CriticalVal)))))
	AND B.copyId = J.copyId
	ORDER BY J.commCellId DESC, J.jobId DESC
	UPDATE #viewJobs  SET copyName = J.copyName ,
						  storagePolicyName = J.spName
	FROM #SPCopyList J, #viewJobs S WHERE J.copyId = S.copyId
UPDATE #viewJobs
SET jobStatus =   T2.jobDisplayFlags
FROM #viewJobs T1 INNER JOIN
(
SELECT JDS1.jobId, JDS1.commcellId, (
MAX(CASE WHEN JDS2.status = 100 AND (JDS2.disabled & 1) = 0 THEN 1 ELSE 0 END) |
MAX(CASE WHEN JDS2.status = 100 AND (JDS2.disabled & 1) > 0 THEN 2 ELSE 0 END) |
MAX(CASE WHEN JDS2.status IN (102, 103) AND (JDS2.disabled & 1) = 0 THEN 4 ELSE 0 END) |
MAX(CASE WHEN JDS2.status IN (102, 103) AND (JDS2.disabled & 1) > 0 THEN 8 ELSE 0 END) |
MAX(CASE WHEN JDS2.status = 101 AND (JDS2.disabled & 1) = 0 THEN 16 ELSE 0 END) |
MAX(CASE WHEN JDS2.status = 101 AND (JDS2.disabled & 1) > 0 THEN 32 ELSE 0 END) |
MAX(CASE WHEN JDS2.status = 1000 THEN 64 ELSE 0 END) |
MAX(CASE WHEN (JDS2.disabled & 64) > 0 THEN 128 ELSE 0 END) |
MAX(CASE WHEN (JDS2.disabled & 256) > 0 THEN 256 ELSE 0 END) |
MAX(CASE WHEN (JDS2.disabled & 256) = 0 THEN 512 ELSE 0 END) |
MAX(CASE WHEN (JDS2.disabled & 2) > 0 THEN 1024 ELSE 0 END) |
MAX(CASE WHEN (JDS2.disabled & 1) > 0 THEN 2048 ELSE 0 END) |
MAX(CASE WHEN (JDS2.disabled & 16384) > 0 THEN 8192 ELSE 0 END) |
MAX(CASE WHEN JDS2.jobId IS NULL THEN 16384 ELSE 0 END)
                            ) "jobDisplayFlags"
                    FROM #viewJobs JDS1 INNER JOIN JMJobDataStats JDS2 WITH(NOLOCK) ON JDS1.jobId = JDS2.jobId AND JDS1.commcellId = JDS2.commcellId AND JDS2.archGrpCopyId = JDS1.copyId
                    GROUP BY JDS1.jobId, JDS1.commcellId
                    ) T2 ON T1.jobId = T2.jobId AND T1.commcellId = T2.commcellId
DECLARE @xmlQuery XML
BEGIN
SET @xmlQuery =
                  (SELECT
                     (SELECT
							  JobsOnStore.jobId  AS jobId,
							  JobsOnStore.jobStatus  AS status,
							  cast((SELECT JobsOnStore.instanceId AS instanceId, JobsOnStore.instanceName AS instanceName , JobsOnStore.backupSetId AS backupsetId , JobsOnStore.backupSetName AS backupsetName,
							               JobsOnStore.subClientId AS subclientId, JobsOnStore.subclientName AS subclientName,JobsOnStore.appTypeId AS applicationId, JobsOnStore.appTypeName AS appName,
							               JobsOnStore.clientId AS clientId, JobsOnStore.clientName AS clientName,JobsOnStore.commCellId AS commCellId, JobsOnStore.clientDisplayName AS displayName
								     FROM #viewJobs AS v where v.jobId =JobsOnStore.jobId FOR XML RAW('subclient')) AS xml),
							  cast((SELECT JobsOnStore.storagePolicyId AS storagePolicyId, JobsOnStore.storagePolicyName AS storagePolicyName  FROM #viewJobs AS v where v.jobId =JobsOnStore.jobId FOR XML RAW('storagePolicy')) AS xml),
							  cast((SELECT JobsOnStore.copyId AS copyId, JobsOnStore.copyName AS copyName  FROM #viewJobs AS v where v.jobId =JobsOnStore.jobId FOR XML RAW('copy')) AS xml),
							  cast((SELECT JobsOnStore.initFrom AS userId, JobsOnStore.userName AS userName  FROM #viewJobs AS v where v.jobId =JobsOnStore.jobId FOR XML RAW('userName')) AS xml),
                              --JobsOnStore.level AS jobType,
							  JobsOnStore.opType AS opType,
							  JobsOnStore.fullCycleNum AS fullCycleNum,
							  JobsOnStore.seqNumInCycle AS seqNumInCycle,
							  JobsOnStore.startTime AS jobStartTime,
							  JobsOnStore.endTime AS jobEndTime,
							  JobsOnStore.sizeOfApplication AS sizeOfApplication,
							  JobsOnStore.sizeOnMedia AS sizeOfMediaOnDisk,
							  JobsOnStore.retentionEndTime AS retainUntil,
							  --JobsOnStore.   AS dataVerificationStatus, -- This set at GUI 'contVerStatusString'
							  --JobsOnStore. AS lastVerifiedOn,           -- This is set 'verificationTime'
							  JobsOnStore.copiedTime AS copiedTime,
							   JobsOnStore.duration AS jobElapsedTime,
							  JobsOnStore.userName AS userName,
							  JobsOnStore.disabled AS disabled,
							  JobsOnStore.errorCode AS errorCode,
							  JobsOnStore.totalWriteTime AS transferTime,
							  JobsOnStore.agedTime AS  agedTime,
							  JobsOnStore.jobDescription AS description,
							  JobsOnStore.retainedBy AS retainedBy,
							  JobsOnStore.level AS  backupLevel,
							  --JobsOnStorebEncrypted. AS encrypted,  -- bEncrypted = ((bitVec & GUIMessage.CVA_JOB_COPY_ATTR_ENCRYPTED) == GUIMessage.CVA_JOB_COPY_ATTR_ENCRYPTED) ? true : false;
							  --JobsOnStore.deduplicated AS deduplicated,  --bSingleInstanced = ((bitVec & GUIMessage.CVA_JOB_COPY_ATTR_SIDB) == GUIMessage.CVA_JOB_COPY_ATTR_SIDB) ? true : false;
							  --JobsOnStore.bCRCchecked AS crcChecked,  -- bCRCchecked = ((bitVec & GUIMessage.CVA_JOB_COPY_ATTR_CRC_CHECKED) == GUIMessage.CVA_JOB_COPY_ATTR_CRC_CHECKED) ? true : false;
							  --JobsOnStore.SystemState AS systemState  --((this.getJobAttributes()& GUIMessage.JMBKP_WITH_SYSTEM_STATE)>=1)
							  --JobsOnStore. AS percentSavings, -- Calculated in GUI   '(bytesUncompressed - totalSizeofJob) / bytesUncompressed'
						      --JobsOnStore. AS StubDataSize,                Not applicable for copy
							  JobsOnStore.attributes AS backupAttributes,
							  JobsOnStore.jobCopyAttributes AS jobCopyAttributes,
							  JobsOnStore.extRetentionFlags AS extRetentionFlags,
							  JobsOnStore.archCheckStatus AS archCheckStatus,
							  JobsOnStore.archCheckEndTime AS archCheckEndTime,
							  JobsOnStore.numStreams AS numOfStreams,
							  JobsOnStore.numObjects AS totalNumOfFiles,
							  JobsOnStore.scanFileFailures AS scanFileFailures ,
							  JobsOnStore.scanFolderFailures AS  scanFolderFailures ,
							  JobsOnStore.bkpFileFailures AS  totalFailedFiles,
							  JobsOnStore.bkpFolderFailures AS  totalFailedFolders
					 FROM #viewJobs AS JobsOnStore Where JobsOnStore.jobId = j2.jobId
					 AND j2.storagePolicyId = JobsOnStore.storagePolicyId
					 FOR XML RAW('jobSummary'),TYPE) FROM #viewJobs AS j2
					 FOR XML RAW('jobs'),TYPE)
END
SET @xmlQuery = (select @xmlQuery
    FOR XML PATH(''),ROOT('JobManager_JobListResponse'))
SELECT @xmlQuery AS ReturnResult
    if (OBJECT_ID('tempdb.dbo.#tempClientList') IS NOT NULL) DROP TABLE #tempClientList
	if (OBJECT_ID('tempdb.dbo.#tempAppList') IS NOT NULL) DROP TABLE #tempAppList
	if (OBJECT_ID('tempdb.dbo.#tempJobStats') IS NOT NULL) DROP TABLE #tempJobStats
	if (OBJECT_ID('tempdb.dbo.#tempJobData') IS NOT NULL) DROP TABLE #tempJobData
	if (OBJECT_ID('tempdb.dbo.#tempJobAFList') IS NOT NULL) DROP TABLE #tempJobAFList
	if (OBJECT_ID('tempdb.dbo.#realInstanceNames') IS NOT NULL) DROP TABLE #realInstanceNames
	if (OBJECT_ID('tempdb.dbo.#tempJobCopyAttr') IS NOT NULL) DROP TABLE #tempJobCopyAttr
	if (OBJECT_ID('tempdb.dbo.#jobCRC') IS NOT NULL) DROP TABLE #jobCRC
	if (OBJECT_ID('tempdb.dbo.#tempTimeZone') IS NOT NULL) DROP TABLE #tempTimeZone
	if (OBJECT_ID('tempdb.dbo.#JobsOnStore') IS NOT NULL) DROP TABLE #JobsOnStore
	if (OBJECT_ID('tempdb.dbo.#viewJobs') IS NOT NULL) DROP TABLE #viewJobs
	if (OBJECT_ID('tempdb.dbo.#lt_subclientList') IS NOT NULL) DROP TABLE #lt_subclientList
	if (OBJECT_ID('tempdb.dbo.#lt_StoragePolicyCopies') IS NOT NULL) DROP TABLE #lt_StoragePolicyCopies
RETURN;
GO


IF EXISTS (select * from GxQscripts where name = 'MMViewJobsOnStore')
	delete from GxQscripts where name = 'MMViewJobsOnStore'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMViewJobsOnStore')
	delete from GXDBVersions where aliasname = 'MMViewJobsOnStore'
GO

insert into GXDBVersions values(2, 'MMViewJobsOnStore',  '00000000000000000000', 'MMViewJobsOnStore', '00000000000000000000')
GO

