

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMViewDDBListing.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMViewDDBListing <<<'

IF EXISTS (select * from sysobjects where name='MMViewDDBListing')
	drop procedure MMViewDDBListing
IF EXISTS (select * from GxQscripts where name='MMViewDDBListing')
	delete from GxQscripts where name = 'MMViewDDBListing'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMViewDDBListing')
	delete from GXDBVersions where aliasname = 'MMViewDDBListing'
GO
print '... Creating Procedure: MMViewDDBListing'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMViewDDBListing
  @i_listSIDBInput int
AS
-- i_listDIDBInput -- 0 -- Show All SIDB stores
-- i_listDIDBInput -- 1 -- Show only sealed SIDB stores
  DECLARE @o_MediaAgentName NVARCHAR(256)               
  DECLARE @o_SIDBPath char(1024)
  DECLARE @o_SIDBStoreName varchar(256)
  DECLARE @o_StoragePolicyName NVARCHAR(144)
  DECLARE @o_StoragePolicyCopyName NVARCHAR(64)
  DECLARE @o_BlockSizeUsed integer
  DECLARE @o_SIDBCreateTime integer               
  DECLARE @o_SIDBSealedTime integer
  DECLARE @o_TotalSIDBSizeGB integer               
  DECLARE @o_IntancedSIDBSizeGB integer               
SET NOCOUNT ON
IF @i_listSIDBInput > 0
BEGIN
	SELECT
		(select APPC.net_hostname from APP_Client APPC where APPC.id = SIDB.ClientId) as MediaAgentName,
		(select AP.Path from IdxAccessPath AP where AP.IdxAccessPathId = SIDB.IdxAccessPathId) as Path,
		SIDB.SIDBStoreName as SIDBStoreName,
		AG.name as StoragePolicyName,
		AGC.name as StoragePolicyCopyName,
		AG.SIBlockSizeKB,
		dbo.getDateTime(SIDB.CreatedTime) as SIDBCreateTime,
		dbo.getDateTime(SIDB.SealedTime) as SIDBSealedTime,
		CAST((SIDB.TotalDataSizeBytes * 1.0) / (1024 * 1024 * 1024) as decimal(18,2)) as TotalDataSizeGB,
		CAST((SIDB.InstancedDataSizeBytes * 1.0) / (1024 * 1024 * 1024) as decimal(18,2)) as InstancedDataSizeGB
	FROM IdxSIDBStore SIDB, archGroup AG, archGroupCopy AGC, archCopySIDBStore ACSS
	WHERE SIDB.SealedTime > 0 and SIDB.SIDBStoreId <> 0 and
	AG.id = AGC.archGroupId and AGC.id = ACSS.CopyId and ACSS.SIDBStoreId = SIDB.SIDBStoreId
END
ELSE
BEGIN
	SELECT
		(select APPC.net_hostname from APP_Client APPC where APPC.id = SIDB.ClientId) as mediaAgentName,
		(select AP.Path from IdxAccessPath AP where AP.IdxAccessPathId = SIDB.IdxAccessPathId) as Path,
                SIDB.SIDBStoreName as SIDBStoreName,
		AG.name as StoragePolicyName,
		AGC.name as StoragePolicyCopyName,
		AG.SIBlockSizeKB as BlockSizeUsed,
		dbo.getDateTime(SIDB.CreatedTime) as SIDBCreateTime,
		dbo.getDateTime(SIDB.SealedTime) as SIDBSealedTime,
		CAST((SIDB.TotalDataSizeBytes * 1.0) / (1024 * 1024 * 1024) as decimal(18,2)) as TotalDataSizeGB,
		CAST((SIDB.InstancedDataSizeBytes * 1.0) / (1024 * 1024 * 1024) as decimal(18,2)) as InstancedDataSizeGB
	FROM IdxSIDBStore SIDB, archGroup AG, archGroupCopy AGC, archCopySIDBStore ACSS
	WHERE SIDB.SIDBStoreId <> 0 and
	AG.id = AGC.archGroupId and AGC.id = ACSS.CopyId and ACSS.SIDBStoreId = SIDB.SIDBStoreId
END
RETURN;
GO


IF EXISTS (select * from GxQscripts where name = 'MMViewDDBListing')
	delete from GxQscripts where name = 'MMViewDDBListing'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMViewDDBListing')
	delete from GXDBVersions where aliasname = 'MMViewDDBListing'
GO

insert into GXDBVersions values(2, 'MMViewDDBListing',  '00000000000000000000', 'MMViewDDBListing', '00000000000000000000')
GO

