

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMUpdateWritersForSANDataServerConfiguredMountPath.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMUpdateWritersForSANDataServerConfiguredMountPath.sp,v $ $Id: MMUpdateWritersForSANDataServerConfiguredMountPath.sp,v 1.1.2.4 2018/03/20 00:00:19 jiechen Exp $";
--  +========================================================================+
--  | Stored Proc:  MMUpdateWritersForSANDataServerConfiguredMountPath
--  |
--  | Description: Updates writers for SAN DataServer.
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMUpdateWritersForSANDataServerConfiguredMountPath <<<'

IF EXISTS (select * from sysobjects where name='MMUpdateWritersForSANDataServerConfiguredMountPath')
	drop procedure MMUpdateWritersForSANDataServerConfiguredMountPath
IF EXISTS (select * from GxQscripts where name='MMUpdateWritersForSANDataServerConfiguredMountPath')
	delete from GxQscripts where name = 'MMUpdateWritersForSANDataServerConfiguredMountPath'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMUpdateWritersForSANDataServerConfiguredMountPath')
	delete from GXDBVersions where aliasname = 'MMUpdateWritersForSANDataServerConfiguredMountPath'
GO
print '... Creating Procedure: MMUpdateWritersForSANDataServerConfiguredMountPath'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MMUpdateWritersForSANDataServerConfiguredMountPath
  @i_MountPathId INT
AS
SET NOCOUNT ON
DECLARE @localTran INT = 0
BEGIN TRY
	IF (@@TRANCOUNT = 0)
	BEGIN
		BEGIN TRANSACTION localTran
		SET @localTran = 1
	END
	DECLARE @configParamWritersForSANDataServer  INT = 0
	SELECT  TOP 1 @configParamWritersForSANDataServer = value
	FROM    MMConfigs WITH (READUNCOMMITTED)
	WHERE   name = 'MMS2_CONFIG_NUM_WRITERS_FOR_MOUNTPATH_WITH_SAN_DATASERVER'
	UPDATE MP
	SET MP.MaxConcurrentWriters = @configParamWritersForSANDataServer
	FROM MMMountPath MP
	INNER JOIN MMMountPathToStorageDevice MSD WITH (READUNCOMMITTED) ON MP.MountPathId = MSD.MountPathId AND MP.MountPathId = @i_MountPathId
	INNER JOIN MMDeviceController DC WITH (READUNCOMMITTED) ON DC.DeviceId = MSD.DeviceId
WHERE DC.DeviceAccessType & (32 | 128) > 0 AND MP.MaxConcurrentWriters >= 1000 AND @configParamWritersForSANDataServer > 0
	IF (@localTran = 1)
	BEGIN
		COMMIT TRANSACTION localTran
		SET @localTran = 0
	END
END TRY
BEGIN CATCH
DECLARE @ErrorMessage NVARCHAR(4000) = ERROR_MESSAGE() ;
DECLARE @ErrorSeverity INT = ERROR_SEVERITY();
DECLARE @ErrorState INT = ERROR_STATE();
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
RAISERROR(@ErrorMessage,@ErrorSeverity,@ErrorState)
IF (XACT_STATE() <> 0 AND @localTran = 1)
BEGIN
    ROLLBACK TRANSACTION localTran
    SET @localTran = 0
END
END CATCH
GO

IF EXISTS (select * from GxQscripts where name = 'MMUpdateWritersForSANDataServerConfiguredMountPath')
	delete from GxQscripts where name = 'MMUpdateWritersForSANDataServerConfiguredMountPath'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMUpdateWritersForSANDataServerConfiguredMountPath')
	delete from GXDBVersions where aliasname = 'MMUpdateWritersForSANDataServerConfiguredMountPath'
GO

insert into GXDBVersions values(2, 'MMUpdateWritersForSANDataServerConfiguredMountPath',  '00010001000200040000', 'MMUpdateWritersForSANDataServerConfiguredMountPath', '00010001000200040000')
GO

