

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMUpdateSpaceInfoForSamePathMPs.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2017  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMUpdateSpaceInfoForSamePathMPs.sp,v $ $Id: MMUpdateSpaceInfoForSamePathMPs.sp,v 1.1.2.3 2018/03/27 08:44:17 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMUpdateSpaceInfoForSamePathMPs <<<'

IF EXISTS (select * from sysobjects where name='MMUpdateSpaceInfoForSamePathMPs')
	drop procedure MMUpdateSpaceInfoForSamePathMPs
IF EXISTS (select * from GxQscripts where name='MMUpdateSpaceInfoForSamePathMPs')
	delete from GxQscripts where name = 'MMUpdateSpaceInfoForSamePathMPs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMUpdateSpaceInfoForSamePathMPs')
	delete from GXDBVersions where aliasname = 'MMUpdateSpaceInfoForSamePathMPs'
GO
print '... Creating Procedure: MMUpdateSpaceInfoForSamePathMPs'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MMUpdateSpaceInfoForSamePathMPs
  @i_MPIds xml,
  @reserveInt integer
AS
  DECLARE @o_ListOfLibs varchar (256)
	declare			@inputMPs				table (inputMPId int)
	declare			@MPs					table (deviceId int, mpid int, libId int, sideId int, dirname varchar(255))
	declare			@libsWithSameDirname	table (libId int, mpid int, sideId int)
	declare			@libsToMPCount			table (libId int, mpcount int)
	set @o_ListOfLibs = ''
	INSERT INTO @inputMPs
		SELECT  T.c.value('@MPId', 'int')
		FROM    @i_MPIds.nodes('/r/h') T(c)
	insert into @MPs
		select distinct mptodev.DeviceId, mptodev.MountPathId, mp.LibraryId, mp.mediasideid, devc.Folder
		from @inputMPs inMPs, MMMountPath MP with (readuncommitted), MMMountPathToStorageDevice MPToDev with (readuncommitted), MMDeviceController DEVC with (readuncommitted)
		where inMPs.inputMPId = MP.MountPathId and MP.MountPathId = MPToDev.MountPathId and DEVC.DeviceId = MPToDev.DeviceId
		and MP.MountPathTypeId in (4,5) -- 4 - MOUNT_PATH_SHARED_STATIC, 5 - MOUNT_PATH_SHARED_REPLICA,  7 - MOUNT_PATH_EXTERNAL_REMOTE_HOST
		-- only UNC Paths
		and charindex ('\', DEVC.folder) = 1
	-- only work on libs that have more than 1 MP
	delete from @MPs
	where libId in
		(
			select mps2.libId
			from @MPs mps2
			group by mps2.libId
			having count (distinct mpid) <= 1
		)
	update @MPs
	set dirname = SUBSTRING(dirname,1,LEN(dirname)-(CHARINDEX('\',REVERSE(dirname))-1))
	insert into @libsWithSameDirname
		select distinct mps1.libId, mps1.mpid, mps1.sideId
		from @MPs mps1, @MPs mps2
		where mps1.mpid <> mps2.mpid
		and mps1.libid = mps2.libid
		and mps1.dirname = mps2.dirname
	if not exists (select 1 from @libsWithSameDirname)
	begin
		-- nothing to do
		goto proc_exit
	end
	insert into @libsToMPCount
		select libs.libId, count(*)
		from @libsWithSameDirname libs
		group by libs.libId
		having count(*) > 1
	update mmmediaside
	set FreeBytesMB = FreeBytesMB/libsToMP.mpcount, TotalSpaceMB = TotalSpaceMB/libsToMP.mpcount
	from @libsToMPCount libsToMP, @libsWithSameDirname libs
	where libsToMP.libId = libs.libId and libs.sideId = MediaSideId
	SELECT
		@o_ListOfLibs = COALESCE(@o_ListOfLibs + ',', '') + cast (Libs.LibId as varchar(32))
	FROM @libsToMPCount Libs
proc_exit:
	select @o_ListOfLibs
GO

IF EXISTS (select * from GxQscripts where name = 'MMUpdateSpaceInfoForSamePathMPs')
	delete from GxQscripts where name = 'MMUpdateSpaceInfoForSamePathMPs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMUpdateSpaceInfoForSamePathMPs')
	delete from GXDBVersions where aliasname = 'MMUpdateSpaceInfoForSamePathMPs'
GO

insert into GXDBVersions values(2, 'MMUpdateSpaceInfoForSamePathMPs',  '00010001000200030000', 'MMUpdateSpaceInfoForSamePathMPs', '00010001000200030000')
GO

