

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMUpdateScaleOutHealthInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMUpdateScaleOutHealthInfo.sp,v $ $Id: MMUpdateScaleOutHealthInfo.sp,v 1.1.2.4 2018/08/20 16:27:11 vvarghese Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMUpdateScaleOutHealthInfo <<<'

IF EXISTS (select * from sysobjects where name='MMUpdateScaleOutHealthInfo')
	drop procedure MMUpdateScaleOutHealthInfo
IF EXISTS (select * from GxQscripts where name='MMUpdateScaleOutHealthInfo')
	delete from GxQscripts where name = 'MMUpdateScaleOutHealthInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMUpdateScaleOutHealthInfo')
	delete from GXDBVersions where aliasname = 'MMUpdateScaleOutHealthInfo'
GO
print '... Creating Procedure: MMUpdateScaleOutHealthInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MMUpdateScaleOutHealthInfo
  @input xml
AS
  DECLARE @o_retCode integer = 0
IF OBJECT_ID('tempdb..#tmpDiskHwInfo') IS NOT NULL DROP TABLE #tmpDiskHwInfo
CREATE TABLE #tmpDiskHwInfo
(
	hostId			integer,
	diskId			integer,
	blockCount		bigint,
	SubVolume		varchar(1024),
	BrickPath		varchar(1024),
	BrickFullPath	varchar(1024),
	BackingDevice	varchar(1024),
	BlockDevice		varchar(1024),
Vendor			varchar(16),
	FileSystem		varchar(32),
	SerialAddress	varchar(1024),
Product			varchar(32),
MountOptions	varchar(1024),
	BrickHealth		integer,
	BlockDevHealth	integer
)
INSERT INTO #tmpDiskHwInfo
SELECT	R.col.value('@hostId','INTEGER'),
		R.col.value('@diskId','INTEGER'),
		R.col.value('@blockCount','BIGINT'),
		R.col.value('@SubVolume','VARCHAR(1024)'),
		R.col.value('@BrickPath','VARCHAR(1024)'),
		R.col.value('@BrickFullPath','VARCHAR(1024)'),
		R.col.value('@BackingDevice','VARCHAR(1024)'),
		R.col.value('@BlockDevice','VARCHAR(1024)'),
R.col.value('@Vendor','VARCHAR(16)'),
		R.col.value('@FileSystem','VARCHAR(1024)'),
		R.col.value('@SerialAddress','VARCHAR(1024)'),
R.col.value('@Product','VARCHAR(32)' ),
R.col.value('@MountOptions','VARCHAR(1024)' ),
		R.col.value('@BrickHealth','INTEGER'),
		R.col.value('@BlockDevHealth','INTEGER')
FROM  @input.nodes('MediaManager_MMScaleOutVolumeHealthInfo/healthList') as R(col)
UPDATE MMDiskHWInfo
SET SubVolume = T2.SubVolume, backingDevice = T2.BackingDevice, blockDeviceUUID = T2.BlockDevice, Vendor = T2.Vendor, FileSystem = T2.FileSystem, diskSerialNum = T2.SerialAddress, BrickHealth = T2.BrickHealth, BlockDeviceHealth = T2.BlockDevHealth,
Product = T2.Product, MountOptions = T2.MountOptions, numBlocks = blockCount, flags = flags & ~16
FROM MMDiskHWInfo T1
INNER JOIN #tmpDiskHwInfo T2
ON T1.diskId = T2.diskId and T1.hostId = T2.hostId
and T1.flags & 1 = 1
and T2.Vendor <> 'Unknown'
UPDATE MMDiskHWInfo
SET flags = flags | 16, BrickHealth = T2.BrickHealth, BlockDeviceHealth = T2.BlockDevHealth
FROM MMDiskHWInfo T1
INNER JOIN #tmpDiskHwInfo T2
ON T1.diskId = T2.diskId AND T1.hostId = T2.hostId and T1.flags & 1 = 1
WHERE T1.mountPathUsageType = 2
AND T2.vendor = 'Unknown'-- update the disks missing in the current health with a missing flag.
set @o_retCode = @@ROWCOUNT
select @o_retCode

IF EXISTS (select * from GxQscripts where name = 'MMUpdateScaleOutHealthInfo')
	delete from GxQscripts where name = 'MMUpdateScaleOutHealthInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMUpdateScaleOutHealthInfo')
	delete from GXDBVersions where aliasname = 'MMUpdateScaleOutHealthInfo'
GO

insert into GXDBVersions values(2, 'MMUpdateScaleOutHealthInfo',  '00010001000200040000', 'MMUpdateScaleOutHealthInfo', '00010001000200040000')
GO

