

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMUpdateSILOCopy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2006  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMUpdateSILOCopy.sp,v $ $Id: MMUpdateSILOCopy.sp,v 1.4.200.4 2018/11/14 19:56:56 pnara Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMUpdateSILOCopy')
BEGIN
	print '>>> Drop Stored Procedure: MMUpdateSILOCopy <<<'
	drop procedure MMUpdateSILOCopy
END
IF EXISTS (select * from GxQscripts where name='MMUpdateSILOCopy')
	delete from GxQscripts where name = 'MMUpdateSILOCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMUpdateSILOCopy')
	delete from GXDBVersions where aliasname = 'MMUpdateSILOCopy'
GO
print '... Creating Procedure: MMUpdateSILOCopy'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MMUpdateSILOCopy
  @i_SIDBStoreId integer,
  @i_copyId integer,
  @i_silosInCache integer,
  @i_siloRestoreMAClientId integer,
  @i_siloRestoreClientId integer,
  @i_flags integer,
  @i_reserve1 integer,
  @i_reserve2 integer
AS
  DECLARE @o_RetVal integer
  DECLARE @o_DbErrorCode integer
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	SET @o_RetVal = 0
	SET @o_DbErrorCode = 0
	SET NOCOUNT ON
	DECLARE @l_archGroupId	integer
	DECLARE @l_dedupeFlags	integer
	DECLARE @l_sourceCopyId integer
	SELECT	@l_archGroupId = AG.id, @l_dedupeFlags = AGC.dedupeFlags, @l_sourceCopyId = sourceCopyId
	FROM	ArchGroup as AG, ArchGroupCopy as AGC
	WHERE	AGC.id = @i_copyId AND AGC.ArchGroupId = AG.id
	if object_id('tempdb.dbo.#activeStores') is not null DROP TABLE #activeStores
	CREATE TABLE #activeStores (sidbStoreId INT)
	INSERT INTO #activeStores
	SELECT SIDBStoreId
	FROM archCopySIDBStore
	WHERE copyID = @l_sourceCopyId
AND flags & 4 > 0
IF (@l_dedupeFlags & 4194304) <> 0 AND @i_silosInCache < 1
		SET	@i_silosInCache = 1
	-- When Silo Archive is just enabled for the storage policy copy,
	-- set siloStatus = SILO_VOLUME_TO_BE_MIGRATED for volumes in stores that are enabled for Silo Archive.
	UPDATE	MMVolume SET siloStatus = 1
	WHERE	SIDBStoreId IN (SELECT SIDBStoreID FROM  #activeStores) AND SiloStatus <= 0
	--update the silo copy
	UPDATE archGroupCopy
	SET silosInCache = @i_silosInCache,
	siloRestoreMAClientId	= @i_siloRestoreMAClientId,
	siloRestoreClientId		= @i_siloRestoreClientId
	WHERE Id = @i_copyId
	AND (silosInCache <> @i_silosInCache
		OR siloRestoreMAClientId<> @i_siloRestoreMAClientId
		OR siloRestoreClientId	<> @i_siloRestoreClientId
		)
	--also update the source copy for this silo copy
	UPDATE 	archGroupCopy
	SET 	silosInCache = @i_silosInCache,
			siloRestoreMAClientId	= @i_siloRestoreMAClientId,
			siloRestoreClientId		= @i_siloRestoreClientId
	WHERE 	Id = @l_sourceCopyId
	--update the main store row
	UPDATE IdxSIDBStore
SET flags = flags | 2097152
	WHERE SIDBStoreId IN (SELECT SIDBStoreID FROM  #activeStores)
	--update substores rows also with flag
	UPDATE IdxSIDBSubStore
SET flags = flags | 2097152
	WHERE SIDBStoreId IN (SELECT SIDBStoreID FROM  #activeStores)
	UPDATE archGroupCopy
SET dedupeFlags = dedupeFlags | (@l_dedupeFlags & (4194304 | 16777216 | 2097152))
	WHERE Id = @l_sourceCopyId
	SET @o_DbErrorCode = @@ERROR
	SET @o_RetVal = 0
	if object_id('tempdb.dbo.#activeStores') is not null DROP TABLE #activeStores
	SELECT @o_RetVal, @o_DbErrorCode
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MMUpdateSILOCopy')
	delete from GxQscripts where name = 'MMUpdateSILOCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMUpdateSILOCopy')
	delete from GXDBVersions where aliasname = 'MMUpdateSILOCopy'
GO

insert into GXDBVersions values(2, 'MMUpdateSILOCopy',  '00010004020000040000', 'MMUpdateSILOCopy', '00010004020000040000')
GO

