

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMUpdateSIDBStore.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMUpdateSIDBStore.sp,v $ $Id: MMUpdateSIDBStore.sp,v 1.38.34.11 2020/11/06 16:44:11 abilbrey Exp $";
--
--  +========================================================================+
--  |      SP:  MMUpdateSIDBStore
--  |
--  | Description:  Update the SIDB Store for giving id
--  |
--  |       Input:  all the columes
--  |
--  |      Output:  always returns the SIDB Store id
--  |
--  |      Notes:	None at this time
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  |   	         cliu
--  +========================================================================+
--
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='MMUpdateSIDBStore')
BEGIN
	print '>>> Drop Stored Procedure: MMUpdateSIDBStore <<<'
	drop procedure MMUpdateSIDBStore
END
IF EXISTS (select * from GxQscripts where name='MMUpdateSIDBStore')
	delete from GxQscripts where name = 'MMUpdateSIDBStore'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMUpdateSIDBStore')
	delete from GXDBVersions where aliasname = 'MMUpdateSIDBStore'
GO
print '... Creating Procedure: MMUpdateSIDBStore'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure MMUpdateSIDBStore
  @i_SIDBStoreId integer,
  @i_SIDBStoreName varchar(255),
  @i_SIDBStoreAliasName varchar(255),
  @i_commCellId integer,
  @i_copyId integer,
  @i_nDataInstance integer,
  @i_silosIncache integer,
  @i_siloRestoreMAClientId integer,
  @i_siloRestoreClientId integer,
  @i_blockCacheValidDays integer,
  @i_SIDBSnapIntervalHours integer,
  @i_idxCacheId integer,
  @i_idxAPId integer,
  @i_clientId integer,
  @i_firstBackupTime integer,
  @i_minObjSizeKB bigint,
  @i_oldestEligibleObjArchiveTime integer,
  @i_signatureType integer,
  @i_flags integer,
  @i_TotalDataSizeBytes bigint,
  @i_InstancedDataSizeBytes bigint,
  @i_diskFreeThresholdMB integer,
  @i_diskFreeWarningThreshholdMB integer,
  @i_numberOfRetries integer,
  @i_DDBLimitExtensionTimeStamp integer,
  @i_ExtendedFlags bigint
AS
  DECLARE @o_SIDBStoreId integer
-- These lines represent the actual SQL code that will get executed.  Note
-- The "printf" style substitutions.  These should match up exactly with
-- .. :PARAM input lines
	SET NOCOUNT ON
	DECLARE @l_archGroupId	integer
	DECLARE @l_dedupeFlags	integer
    DECLARE @iSiloFlagMask int =0
    DECLARE @tempDedupFlags int = 0
	DECLARE @DecryptedString VARCHAR(1024) = ''
	DECLARE @EncryptNoOfDDBLimitExtensionRetriesEncr VARCHAR(1024) = ''
	DECLARE @EncryptDDBLimitExtensionTimeStampEncr VARCHAR(1024) = ''
SET @iSiloFlagMask = 131072 | 2097152 | 4194304 | 16777216
	SELECT	@l_archGroupId = AG.id, @l_dedupeFlags = AGC.dedupeFlags
	FROM	ArchGroup as AG, ArchGroupCopy as AGC
	WHERE	AGC.id = @i_copyId AND AGC.ArchGroupId = AG.id
IF (@l_dedupeFlags & 2097152) <> 0
	BEGIN
IF (@l_dedupeFlags & 4194304) <> 0 AND @i_silosInCache < 1
			SET	@i_silosInCache = 1
		-- When Silo Archive is just enabled for the storage policy copy,
		-- set siloStatus = SILO_VOLUME_TO_BE_MIGRATED for volumes in stores that are enabled for Silo Archive.
		UPDATE	MMVolume SET siloStatus = 1
WHERE	SIDBStoreId IN (SELECT SIDBStoreId FROM archCopySIDBStore WHERE copyId = @i_copyId AND flags & 4 > 0)
				AND SiloStatus <= 0
	END
	UPDATE ArchGroupCopy
	SET		nDataInstance			= @i_nDataInstance,
			silosInCache			= @i_silosInCache,
			siloRestoreMAClientId	= @i_siloRestoreMAClientId,
			siloRestoreClientId		= @i_siloRestoreClientId,
			blockCacheValidDays		= @i_blockCacheValidDays,
			SIDBSnapIntervalHours	= @i_SIDBSnapIntervalHours
	WHERE	Id = @i_copyId
		AND (nDataInstance			<> @i_nDataInstance
			OR silosInCache			<> @i_silosInCache
			OR siloRestoreMAClientId<> @i_siloRestoreMAClientId
			OR siloRestoreClientId	<> @i_siloRestoreClientId
			OR blockCacheValidDays	<> @i_blockCacheValidDays
			OR SIDBSnapIntervalHours<> @i_SIDBSnapIntervalHours)
    --sync the dedupeFlags on silo copy and source copy.
	DECLARE @siloDedupFlags int = 0
SET @siloDedupFlags = ISNULL((SELECT dedupeFlags FROM archGroupCopy where sourceCopyId = @i_copyId AND (flags & 524288) > 0), 0)
	SET @tempDedupFlags = ISNULL((SELECT dedupeFlags FROM archGroupCopy where id = @i_copyId), 0)
	--if silo backup is turned off/on on dedup copy.
IF (((@tempDedupFlags & 2097152) ^ (@siloDedupFlags & 2097152)) >  0)
	BEGIN
SET @siloDedupFlags = @siloDedupFlags & ~(2097152) | (@tempDedupFlags & 2097152)
		UPDATE archGroupCopy
		SET dedupeFlags = @siloDedupFlags
		WHERE sourceCopyId = @i_copyId
AND flags & 524288 > 0
		UPDATE IdxSIDBSubStore
SET flags = flags & ~(2097152) | (case when (@tempDedupFlags & 2097152) > 0 then 2097152 else 0 end)
WHERE SIDBStoreId IN (SELECT SIDBStoreId FROM archCopySIDBStore WHERE copyId = @i_copyId AND flags & 4 > 0)
		UPDATE IdxSIDBStore
SET flags = flags & ~(2097152) | (case when (@tempDedupFlags & 2097152) > 0 then 2097152 else 0 end)
WHERE SIDBStoreId IN (SELECT SIDBStoreId FROM archCopySIDBStore WHERE copyId = @i_copyId AND flags & 4 > 0)
	END
	SET @tempDedupFlags = @tempDedupFlags & ~(@iSiloFlagMask)
	SET @tempDedupFlags = @tempDedupFlags | @siloDedupFlags
	UPDATE archGroupCopy
	SET dedupeFlags = @tempDedupFlags
	WHERE id = @i_copyId
	-- update the silo copy's source dedup copy
	UPDATE archGroupCopy
	SET silosInCache = @i_silosInCache,
	siloRestoreMAClientId	= @i_siloRestoreMAClientId,
	siloRestoreClientId		= @i_siloRestoreClientId
	WHERE sourceCopyId = @i_copyId
AND flags & 524288 > 0
	IF 	@i_SIDBStoreId > 0
	BEGIN
		--if mark and sweep got enabled create MMEntityProp entry
		IF EXISTS(
					SELECT TOP 1 1 FROM IdxSIDBStore S (NOLOCK)
					WHERE S.SIDBStoreId = @i_SIDBStoreId
AND S.ExtendedFlags & 4 = 0 AND @i_ExtendedFlags & 4 > 0
				)
		BEGIN
IF NOT EXISTS( SELECT TOP 1 1 FROM MMEntityProp WHERE propertyName = 'DDBMarkAndSweepOpTime' AND EntityId = @i_SIDBStoreId AND EntityType = 3 AND CommCellId = 2)
			BEGIN
				DECLARE @now int = dbo.getUnixTime(GETUTCDATE())
				INSERT INTO 	MMEntityProp (EntityId, EntityType, propertyName, propDataType, intVal, longlongVal, stringVal, created, modified, CommCellId)
VALUES 		(@i_SIDBStoreId, 3, 'DDBMarkAndSweepOpTime', 1, 24, 0, '', @now, @now, 2)
			END
		END
		-- update the SIDB Store
		UPDATE	IdxSIDBStore
		SET		SIDBStoreName	= @i_SIDBStoreName,
				IdxCacheId		= @i_idxCacheId,
				IdxAccessPathId	= @i_idxAPId,
				ClientId		= @i_clientId,
				FirstBackupTime	= @i_firstBackupTime,
				MinObjSizeKB	= @i_minObjSizeKB,
				oldestEligibleObjArchiveTime	= @i_oldestEligibleObjArchiveTime,
				SignatureType	= @i_signatureType,
				flags			= @i_flags,
				TotalDataSizeBytes		= @i_TotalDataSizeBytes,
				InstancedDataSizeBytes	= @i_InstancedDataSizeBytes,
				ExtendedFlags	= @i_ExtendedFlags
		WHERE	SIDBStoreId = @i_SIDBStoreId
	--  TODO for Global Dedup: update the total size and saving for the store and copy separately
		UPDATE	archCopySIDBStore
		SET		TotalDataSizeBytes		= @i_TotalDataSizeBytes,
				InstancedDataSizeBytes	= @i_InstancedDataSizeBytes
		WHERE	CopyId = @i_copyId AND SIDBStoreId = @i_SIDBStoreId
	END
	SELECT @i_SIDBStoreId
	SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MMUpdateSIDBStore')
	delete from GxQscripts where name = 'MMUpdateSIDBStore'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMUpdateSIDBStore')
	delete from GXDBVersions where aliasname = 'MMUpdateSIDBStore'
GO

insert into GXDBVersions values(2, 'MMUpdateSIDBStore',  '00010038003400110000', 'MMUpdateSIDBStore', '00010038003400110000')
GO

