

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMUpdateResvValidStatusForRCIdResvIdPairs.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2006  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMUpdateResvValidStatusForRCIdResvIdPairs.sp,v $ $Id: MMUpdateResvValidStatusForRCIdResvIdPairs.sp,v 1.8.88.2 2018/03/20 20:04:39 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMUpdateResvValidStatusForRCIdResvIdPairs <<<'

IF EXISTS (select * from sysobjects where name='MMUpdateResvValidStatusForRCIdResvIdPairs')
	drop procedure MMUpdateResvValidStatusForRCIdResvIdPairs
IF EXISTS (select * from GxQscripts where name='MMUpdateResvValidStatusForRCIdResvIdPairs')
	delete from GxQscripts where name = 'MMUpdateResvValidStatusForRCIdResvIdPairs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMUpdateResvValidStatusForRCIdResvIdPairs')
	delete from GXDBVersions where aliasname = 'MMUpdateResvValidStatusForRCIdResvIdPairs'
GO
print '... Creating Procedure: MMUpdateResvValidStatusForRCIdResvIdPairs'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MMUpdateResvValidStatusForRCIdResvIdPairs
  @dummy integer,
  @i_ResvAndRCIdXml xml
AS
  DECLARE @o_RCId integer
  DECLARE @o_ReservationId integer
  DECLARE @o_IsReservationValid integer
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	CREATE TABLE #tmpRCIdAndResvIdPairs
	(
		RCId				integer,
		ReservationId		integer,
		isReservationValid	integer
	)
	INSERT INTO #tmpRCIdAndResvIdPairs
	SELECT
		(T.c.value ('@RCId', 'int')), (T.c.value ('@ResId', 'int')), 0
	FROM
		@i_ResvAndRCIdXml.nodes ('/ResAndRCIds/ResAndRCId') T(c)
	declare @JM_RESERVED integer
	declare @DM_RESERVED integer
	declare @MM_RESERVED integer
	set @JM_RESERVED = 1
	set @DM_RESERVED = 2
	set @MM_RESERVED = 4
	declare @cachetimeout int
	set @cachetimeout = 10
	select @cachetimeout = isnull(value * 2, 10) from MMConfigs with (readuncommitted) where (name = 'MMCONFIG_RESOURCEMANAGER_BACKUP_CACHING_TIMEOUT_MINTUES')
	-- Update the isReservationValid flag in the temp table
	-- for all those resourceToJob entries that are existing
	-- for the reservationId or RCId AND whose reservebitmask is set to JM or MM reserved
	-- or ReleaseTime is as 0.
	-- One special case is for Backup Caching. The resource will be released but still remain in cache. The check will be based on timeout setting.
	UPDATE #tmpRCIdAndResvIdPairs
	SET isReservationValid = 1
	FROM MMResourceToJob RJ WITH (READUNCOMMITTED)
	WHERE
	(
		-- If reservatioNid is specified
		( (#tmpRCIdAndResvIdPairs.ReservationId > 0) AND #tmpRCIdAndResvIdPairs.ReservationId = RJ.ReservationId )
		OR
		-- If RCId is specified
		( (#tmpRCIdAndResvIdPairs.RCId > 0) AND #tmpRCIdAndResvIdPairs.RCId = RJ.RCId )
		AND
		(
			(RJ.ReleaseTime = 0) OR
			((RJ.ReserveBitMask & @JM_RESERVED) > 0) OR
			((RJ.ReserveBitMask & @MM_RESERVED) > 0) OR
			((
(RJ.ReleaseTime > 0 AND 0 < cast(dbo.GetJobOption(RJ.JobId_l, 1793771816) as int))
				OR
				(exists (select c.Id from MMResource a with (readuncommitted), ArchGroupCopy b with (readuncommitted),
										ArchGroup c with (readuncommitted)
						where	a.ReservationId = RJ.ReservationId
						and		a.CopyId = b.Id
						and		c.Id = b.archGroupId
and		c.Flags & 1048576 > 0)
				)
			 )
			 AND datediff(s, dbo.GetDateTime(RJ.ReleaseTime), getutcdate()) <= (@cachetimeout * 60)
			)
		)
	)
-- fall through
proc_exit:
		select RCId, ReservationId, isReservationValid
		from #tmpRCIdAndResvIdPairs
		DELETE FROM #tmpRCIdAndResvIdPairs
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MMUpdateResvValidStatusForRCIdResvIdPairs')
	delete from GxQscripts where name = 'MMUpdateResvValidStatusForRCIdResvIdPairs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMUpdateResvValidStatusForRCIdResvIdPairs')
	delete from GXDBVersions where aliasname = 'MMUpdateResvValidStatusForRCIdResvIdPairs'
GO

insert into GXDBVersions values(2, 'MMUpdateResvValidStatusForRCIdResvIdPairs',  '00010008008800020000', 'MMUpdateResvValidStatusForRCIdResvIdPairs', '00010008008800020000')
GO

