

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMUpdateMountPathMoveStats.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMUpdateMountPathMoveStats <<<'

IF EXISTS (select * from sysobjects where name='MMUpdateMountPathMoveStats')
	drop procedure MMUpdateMountPathMoveStats
IF EXISTS (select * from GxQscripts where name='MMUpdateMountPathMoveStats')
	delete from GxQscripts where name = 'MMUpdateMountPathMoveStats'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMUpdateMountPathMoveStats')
	delete from GXDBVersions where aliasname = 'MMUpdateMountPathMoveStats'
GO
print '... Creating Procedure: MMUpdateMountPathMoveStats'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MMUpdateMountPathMoveStats
  @i_transferStreamId INTEGER,
  @i_dataToCopyMB BIGINT,
  @i_dataCopiedMB BIGINT,
  @i_currentTransferSpeed INTEGER,
  @i_percentVerified INTEGER,
  @i_totalNumberOfFiles INTEGER,
  @i_numberOfFilesProcessed INTEGER
AS
  DECLARE @o_errorCode INTEGER
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @transferStreamId			INTEGER = @i_transferStreamId
DECLARE @dataToCopyMB				BIGINT  = @i_dataToCopyMB
DECLARE @dataCopiedMB				BIGINT	= @i_dataCopiedMB
DECLARE @currentTransferSpeed		INTEGER = @i_currentTransferSpeed
DECLARE @percentVerified			INTEGER = @i_percentVerified
DECLARE @totalNumberOfFiles			INTEGER = @i_totalNumberOfFiles
DECLARE @numberOfFilesProcessed		INTEGER = @i_numberOfFilesProcessed
DECLARE @errorCode INTEGER= 0;
--update specific mpmovebatch row
UPDATE mpb
SET DataToCopyMB = @dataToCopyMB,
	DataCopiedMB = @dataCopiedMB,
	CurrentTransferSpeed = @currentTransferSpeed,
	PercentVerified = @percentVerified,
	TotalNumberOfFiles = @totalNumberOfFiles,
	NumberOfFilesProcessed = @numberOfFilesProcessed
FROM MMMountPathMoveBatches mpb
INNER JOIN MMMountPathMove mpm ON mpm.MoveId = mpb.MoveId AND mpm.CurrBatchId = mpb.BatchId
WHERE mpm.StreamId = @transferStreamId
--update aggregrate data
;WITH batchAggregrate_cte(totalDataToCopy,totalDataCopied,totalNoOfFiles,totalFilesProcessed)
AS 	(
	SELECT sum(DataToCopyMB), sum(DataCopiedMB), sum(TotalNumberOfFiles), sum(NumberOfFilesProcessed) from MMMountPathMoveBatches mpb
	WHERE mpb.StreamId = @transferStreamId
),
perBatchPercentage_cte(perBatchPercentage, noOfCompletedBatch)
AS 	(
SELECT (80/CAST(mpm.TotalNoOfBatches AS FLOAT)), CurrBatchId	--batchId starts from 0, so current batchId= no of batches completed
	FROM MMMountPathMove mpm
	WHERE mpm.StreamId = @transferStreamId
),
percentCompleted_cte(percentCompleted)
AS 	(
	SELECT FLOOR((perBatchPercentage * noOfCompletedBatch) + ((@percentVerified /100.0)*perBatchPercentage))
	FROM perBatchPercentage_cte
),
totalDataToCopy_cte (totalDataToCopy)
AS 	(
	SELECT
		CASE
			WHEN (mpm.PhaseId=1) THEN IIF(mpm.TotalDataSizeMB > (SELECT TOP 1 totalDataToCopy FROM batchAggregrate_cte ),mpm.TotalDataSizeMB,(SELECT TOP 1 totalDataToCopy FROM batchAggregrate_cte))
			ELSE (SELECT TOP 1 totalDataToCopy FROM batchAggregrate_cte)
		END
	FROM MMMountPathMove 	mpm
	WHERE mpm.StreamId = @transferStreamId
)
UPDATE MMDataTransferStreams
SET DataToCopyMB = (SELECT TOP 1 totalDataToCopy FROM totalDataToCopy_cte),
	DataCopiedMB = (SELECT TOP 1 totalDataCopied FROM batchAggregrate_cte),
	CurrentTransferSpeed = @currentTransferSpeed,
	PercentVerified = (SELECT TOP 1 percentCompleted FROM percentCompleted_cte),
	TotalNumberOfFiles = (SELECT TOP 1 totalNoOfFiles FROM batchAggregrate_cte),
	NumberOfFilesProcessed = (SELECT TOP 1 totalFilesProcessed FROM batchAggregrate_cte),
	LastUpdateTime = dbo.getUnixTime(GETDATE())
WHERE TransferStreamId = @transferStreamId
SELECT @errorCode

IF EXISTS (select * from GxQscripts where name = 'MMUpdateMountPathMoveStats')
	delete from GxQscripts where name = 'MMUpdateMountPathMoveStats'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMUpdateMountPathMoveStats')
	delete from GXDBVersions where aliasname = 'MMUpdateMountPathMoveStats'
GO

insert into GXDBVersions values(2, 'MMUpdateMountPathMoveStats',  '00000000000000000000', 'MMUpdateMountPathMoveStats', '00000000000000000000')
GO

