

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMUpdateMetallicStorage.sp] ---------- 

/******************************************************************************/
/*  Copyright (c) CommVault Systems                                           */
/*  All Rights Reserved                                                       */
/*                                                                            */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems          */
/*  The copyright notice above does not evidence any                          */
/*  actual or intended publication of such source code.                       */
/*                                                                            */
/*  File name   :  MMUpdateMetallicStorage.sp                    				  */
/*                                                                            */
/*  Description :  Stored procedure to update row in MMMetallicStorage		  */
/*                                                                            */
/******************************************************************************/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMUpdateMetallicStorage.sp,v $ $Id: MMUpdateMetallicStorage.sp,v 1.1.4.5 2020/12/23 21:59:22 pnara Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='MMUpdateMetallicStorage')
BEGIN
	print '>>> Drop Stored Procedure: MMUpdateMetallicStorage <<<'
	drop procedure MMUpdateMetallicStorage
END
IF EXISTS (select * from GxQscripts where name='MMUpdateMetallicStorage')
	delete from GxQscripts where name = 'MMUpdateMetallicStorage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMUpdateMetallicStorage')
	delete from GXDBVersions where aliasname = 'MMUpdateMetallicStorage'
GO
print '... Creating Procedure: MMUpdateMetallicStorage'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure MMUpdateMetallicStorage
  @i_devices xml = '',
  @i_credentials xml = '',
  @i_adjustCapacity INT = 0,
  @i_licenseType INT = 0
AS
	--This will turn off message: "xxx rows affected".
	SET NOCOUNT ON
	--
	-- Update used space
	-- We get actual size on disk from metallic for each device
	--
	IF CAST(@i_devices as varchar(max)) <> ''
	BEGIN
		IF OBJECT_ID('tempdb..#lt_Device') IS NOT NULL DROP TABLE #lt_Device
		CREATE TABLE #lt_Device (DeviceId INT, UsedSpaceMB INT)
		UPDATE	MS
		SET		UsedSpaceInBytes = T.UsedSpace
		FROM	MMMetallicStorage MS,
				(
					SELECT DP.value('@deviceId', 'INT') DeviceId, DP.value('@usedSpace', 'BIGINT') UsedSpace
					FROM @i_devices.nodes('/Devices/device') D(DP)
				) AS T
		WHERE	MS.DeviceId = T.DeviceId
		IF OBJECT_ID('tempdb..#lt_Device') IS NOT NULL DROP TABLE #lt_Device
	END
	--
	-- Update app secret
	-- We rotate app secret every 3 months for each device's credential
	--
	IF CAST(@i_credentials as varchar(max)) <> ''
	BEGIN
		UPDATE	C
		SET		Password = T.Password,
				Created = dbo.GetUnixTime(GETUTCDATE())
		FROM	App_Credentials C,
				(
					SELECT CP.value('@credentialId', 'INT') CredentialId, CP.value('@password', 'varchar(2048)') Password
					FROM @i_credentials.nodes('/Credentials/credential') CN(CP)
				) AS T
		WHERE	C.CredentialId = T.CredentialId
	END
	--
	-- Adjust capacity to all devices for each license type
	-- Based on avg free space and used space of each device.
	-- Example:
	-- License Capacity :  100TB
	-- Used space:
	-- Device1 -  30TB
	-- Device2 – 20TB
	-- Total used space = 50TB
	-- Total free space = 50TB
	-- Avg free space =  Total free space / Device Conunt = 50TB / 2 = 25TB
	-- Adjusted Capacity: Device used space + Avg free space
	-- Container1 – 30TB + 25TB = 55TB
	-- Container2 – 20TB + 25TB = 45TB
	--
	-- Update free space = Capacity – Usage
	--
	IF @i_adjustCapacity > 0
	BEGIN
		IF OBJECT_ID('tempdb..#lt_Devices') IS NOT NULL DROP TABLE #lt_Devices
		CREATE TABLE #lt_Devices (LicenseType INT, DeviceId INT, MountPathId INT, CapacityMB BIGINT, UsedSpaceMB BIGINT)
		IF OBJECT_ID('tempdb..#lt_Licenses') IS NOT NULL DROP TABLE #lt_Licenses
		CREATE TABLE #lt_Licenses(LicenseType INT, TotalCapacityMB BIGINT, TotalUsedSpaceMB BIGINT, TotalDeviceCount INT, UsedDeviceCount INT, AvgFreeSpaceMB BIGINT)
		--Get used space of each device
		INSERT INTO #lt_Devices
		SELECT 	LicenseType, DeviceId, MountPathId, 0, UsedSpaceInBytes / (1024 * 1024)
		FROM	MMMetallicStorage WITH(READUNCOMMITTED)
		WHERE	@i_licenseType = 0 OR LicenseType = @i_licenseType
		--Get list of licenses in use and total used space for each license.
		--Also get total device count per license and how many devices got used.
		INSERT	#lt_Licenses
		SELECT	LicenseType, 0, SUM(UsedSpaceMB), COUNT(DeviceId), SUM(IIF(UsedSpaceMB > 0, 1, 0)), 0
		FROM	#lt_Devices
		GROUP BY LicenseType
		/*
		Get total capacity for each license from license tables.
		Compute avg free space,
		if total used space is higher than capacity then avg free space will be negative.
		in this case for new devices we set 0 as capacity so the total of adjusted capacity may not match with actual capacity.
		so to cover this case take avg free space only using used device count
		Example:
		Total Capacity 100TB
		Total Devices 4
		Case 1 (Total capacity > Total used space):
			Device 1 :  Used 50TB
			Device 2 :  Used 20TB
			Device 3 :  Used 10TB
			Device 4 :  Used 0  (New Device)
			Total Used = 80TB  <  Total capacity 100TB
			Total free = 100 - 80 = 20TB
			Avg free = 20 / 4 = 5TB
			Adjusted capacity for each device :  Used + Avg free
			Device 1 :  50 + 5 = 55TB
			Device 2 :  20 + 5 = 25TB
			Device 3 :  10 + 5 = 15TB
			Device 4 :  0 + 5 = 5TB
		Case 2 (Total capacity < Total used space):
			Device 1 :  Used 65TB
			Device 2 :  Used 25TB
			Device 3 :  Used 22TB
			Device 4 :  Used 0  (New Device)
			Total Used = 112TB > Total capacity 100TB
			Total free = 100 - 112 = -12TB
			Avg free (used device count) = -12 / 3 = -4TB
			Adjusted capacity for each device :  Used + Avg free
			Device 1 :  65 + (-4) = 61TB
			Device 2 :  25 + (-4) = 21TB
			Device 3 :  22 + (-4) = 18TB
			Device 4 :  0 + (-4) = -4 < 0  = 0TB
		 */
		DECLARE @TotalCapacityMB bigint = 0
		DECLARE @licType INT = 0
		DECLARE @licPermFld varchar(1024) = ''
		DECLARE @licEvalFld varchar(1024) = ''
		DECLARE @licTotalCapacityGB int
		DECLARE @licUsed int
		DECLARE @bEval int
		DECLARE @oldExpTime int
		DECLARE MetallicLicenseCur Cursor LOCAL FORWARD_ONLY FOR
		SELECT 	LicenseType
		FROM	#lt_Licenses
		OPEN MetallicLicenseCur
		FETCH NEXT FROM MetallicLicenseCur INTO @licType
		WHILE @@FETCH_STATUS = 0
		BEGIN
			SELECT 	@licPermFld = RTRIM(perm_fld1), @licEvalFld =  RTRIM(eval_fld1)
			FROM 	LicAAL WITH(READUNCOMMITTED)
			WHERE 	simLicAppTypeId = @licType AND commcellId = 2
			IF @licPermFld <> ''
			BEGIN
				SET @licTotalCapacityGB = 0
				EXEC xp_getAALInfo2 @licPermFld, @licTotalCapacityGB OUTPUT, @licUsed OUTPUT, @bEval OUTPUT, @oldExpTime OUTPUT
				SET @TotalCapacityMB = CAST(@licTotalCapacityGB AS bigint) * 1024
			END
			IF @licEvalFld <> ''
			BEGIN
				SET @licTotalCapacityGB = 0
				EXEC xp_getAALInfo2 @licEvalFld, @licTotalCapacityGB OUTPUT, @licUsed OUTPUT, @bEval OUTPUT, @oldExpTime OUTPUT
				SET @TotalCapacityMB += CAST(@licTotalCapacityGB AS bigint) * 1024
			END
			UPDATE 	#lt_Licenses
			SET		TotalCapacityMB = @TotalCapacityMB,
					AvgFreeSpaceMB = IIF(TotalUsedSpaceMB > @TotalCapacityMB, (@TotalCapacityMB - TotalUsedSpaceMB) / UsedDeviceCount, (@TotalCapacityMB - TotalUsedSpaceMB) / TotalDeviceCount)
			WHERE	LicenseType = @licType
			FETCH NEXT FROM MetallicLicenseCur INTO @licType
		END
		CLOSE MetallicLicenseCur
		DEALLOCATE MetallicLicenseCur
		UPDATE	D
		SET		CapacityMB = IIF((D.UsedSpaceMB + L.AvgFreeSpaceMB) < 0, 0, D.UsedSpaceMB + L.AvgFreeSpaceMB)
		FROM	#lt_Devices D, #lt_Licenses L
		WHERE	D.LicenseType = L.LicenseType
		--Now update MMMediaSide table for each device
		--if capacity is same as the dummy cloud capacity then add one extra MB so that we don't incorrectly treat it as dummy
		UPDATE 	MS
SET		TotalSpaceMB = IIF(T.CapacityMB = 1048576, T.CapacityMB + 1, T.CapacityMB),
FreeBytesMB = IIF(T.FreeBytesMB = 1048576, T.FreeBytesMB + 1, T.FreeBytesMB)
		FROM	MMMediaSide MS
				INNER JOIN
				(
					SELECT 	MP.MediaSideId,
							D.CapacityMB AS CapacityMB,
							IIF((D.CapacityMB - D.UsedSpaceMB) < 0, 0, D.CapacityMB - D.UsedSpaceMB) AS FreeBytesMB
					FROM	#lt_Devices D
							INNER JOIN MMMountPath MP WITH(READUNCOMMITTED) ON D.MountPathId = MP.MountPathId
				) AS T ON T.MediaSideId = MS.MediaSideId
		IF OBJECT_ID('tempdb..#lt_Devices') IS NOT NULL DROP TABLE #lt_Devices
		IF OBJECT_ID('tempdb..#lt_Licenses') IS NOT NULL DROP TABLE #lt_Licenses
	END
GO

IF EXISTS (select * from GxQscripts where name = 'MMUpdateMetallicStorage')
	delete from GxQscripts where name = 'MMUpdateMetallicStorage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMUpdateMetallicStorage')
	delete from GXDBVersions where aliasname = 'MMUpdateMetallicStorage'
GO

insert into GXDBVersions values(2, 'MMUpdateMetallicStorage',  '00010001000400050000', 'MMUpdateMetallicStorage', '00010001000400050000')
GO

