

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMUpdateMediaAgentRoles.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMUpdateMediaAgentRoles')
BEGIN
	print '>>> Drop Stored Procedure: MMUpdateMediaAgentRoles <<<'
	drop procedure MMUpdateMediaAgentRoles
END
IF EXISTS (select * from GxQscripts where name='MMUpdateMediaAgentRoles')
	delete from GxQscripts where name = 'MMUpdateMediaAgentRoles'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMUpdateMediaAgentRoles')
	delete from GXDBVersions where aliasname = 'MMUpdateMediaAgentRoles'
GO
print '... Creating Procedure: MMUpdateMediaAgentRoles'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MMUpdateMediaAgentRoles
  @i_clientId INTEGER	
AS
  DECLARE @clientId INTEGER
  DECLARE @rolesBitMask INTEGER
  DECLARE @isHostOnline INTEGER
IF object_id('tempdb.dbo.#tempMARoles') IS NOT NULL DROP TABLE #tempMARoles
CREATE TABLE #tempMARoles (
    clientId INT primary key,
    rolesBitMask INT,
)
If @i_clientId <= 1
	SET @i_clientId = NULL
INSERT INTO #tempMARoles(clientId, rolesBitMask)
	SELECT ClientId, RolesBitMask FROM MMHost WITH(NOLOCK) WHERE ClientId = ISNULL(@i_clientId, ClientId) AND ClientId > 1
-- Storage Media Agent
;WITH StorageMA_cte(clientId)
AS
(
	SELECT DISTINCT(ClientId) FROM MMlibraryController (NOLOCK)
)
UPDATE	MA
SET		rolesBitMask = IIF(C.ClientId IS NULL, (rolesBitMask & (~1)) , (rolesBitMask | 1))
FROM	#tempMARoles MA
		LEFT JOIN StorageMA_cte C ON C.ClientId = MA.ClientId
--DDB Media Agent
;WITH DDBMA_cte(clientId)
AS
(
	Select DISTINCT(P.ClientId)
	FROM 	IdxAccessPath P (NOLOCK)
			INNER JOIN IdxCache C (NOLOCK) ON C.IdxCacheId = P.IdxCacheId
WHERE C.IdxCacheType = 2
)
UPDATE	MA
SET		rolesBitMask = IIF(C.ClientId IS NULL, (rolesBitMask & (~4)) , (rolesBitMask | 4))
FROM	#tempMARoles MA
		LEFT JOIN DDBMA_cte C ON C.ClientId = MA.ClientId
--Index Media Agent
--Data Mover Media Agent
--Currently both are combined, if query getting complex, please separate them
;WITH DataMoverMA_cte(clientId)
AS
(
	SELECT DISTINCT(HostClientId) FROM MMDataPath (NOLOCK)
)
UPDATE	MA
SET		rolesBitMask = IIF(C.ClientId IS NULL, (rolesBitMask & (~(8 | 2))) , (rolesBitMask | 8 | 2))
FROM	#tempMARoles MA
		LEFT JOIN DataMoverMA_cte C ON C.ClientId = MA.ClientId
--CI Media Agent
;WITH SearchEngineMA_cte(clientId)
AS
(
SELECT DISTINCT(ClientId) FROM SimInstalledPackages (NOLOCK) WHERE simpackageid IN ( 257, 260)
)
UPDATE	MA
SET		rolesBitMask = IIF(C.ClientId IS NULL, (rolesBitMask & (~16)) , (rolesBitMask | 16))
FROM	#tempMARoles MA
		LEFT JOIN SearchEngineMA_cte C ON C.ClientId = MA.ClientId
--Snap Media Agent
;WITH SnapMA_cte(clientId)
AS
(
	SELECT hostId FROM SMMAStats (NOLOCK)
)
UPDATE	MA
SET		rolesBitMask = IIF(C.ClientId IS NULL, (rolesBitMask & (~64)) , (rolesBitMask | 64))
FROM	#tempMARoles MA
		LEFT JOIN SnapMA_cte C ON C.ClientId = MA.ClientId
--Hyper Scale Media Agent
;WITH HyperScaleMA_cte(clientId)
AS
(
SELECT DISTINCT(hostId)  FROM MMDiskHWInfo (NOLOCK) WHERE (flags & 1) = 1
)
UPDATE	MA
SET		rolesBitMask = IIF(C.ClientId IS NULL, (rolesBitMask & (~128)) , (rolesBitMask | 128))
FROM	#tempMARoles MA
		LEFT JOIN HyperScaleMA_cte C ON C.ClientId = MA.ClientId
--VSA Proxy Media Agent
;WITH VSAProxyMA_cte(clientId)
AS
(
SELECT DISTINCT(ClientId) FROM simInstalledPackages (NOLOCK) WHERE simPackageID in( 713,1136)
)
UPDATE	MA
SET		rolesBitMask = IIF(C.ClientId IS NULL, (rolesBitMask & (~32)) , (rolesBitMask | 32))
FROM	#tempMARoles MA
		LEFT JOIN VSAProxyMA_cte C ON C.ClientId = MA.ClientId
--NFS Media Agent
;WITH NFSMA_cte(clientId)
AS
(
	Select DISTINCT(P.ClientId)
	FROM 	IdxAccessPath P (NOLOCK)
			INNER JOIN IdxCache C (NOLOCK) ON C.IdxCacheId = P.IdxCacheId
WHERE C.IdxCacheType = 3
)
UPDATE	MA
SET		rolesBitMask = IIF(C.ClientId IS NULL, (rolesBitMask & (~256)) , (rolesBitMask | 256))
FROM	#tempMARoles MA
		LEFT JOIN NFSMA_cte C ON C.ClientId = MA.ClientId
UPDATE 	MA
SET		rolesBitMask = 0
FROM 	#tempMARoles MA
WHERE	NOT EXISTS(
			SELECT 	1
			FROM 	LicUsage  WITH (READUNCOMMITTED)
WHERE	cid = MA.ClientId AND appType = 1002
					AND lictype NOT IN (71, 10, 26, 33554432)
					AND optype = 'Install' AND InstallFlag = 0
		)
DELETE MA
FROM	#tempMARoles MA
		INNER JOIN MMHost H (NOLOCK) ON MA.clientId = H.ClientId
WHERE H.RolesBitMask = MA.RolesBitMask
UPDATE H
SET H.RolesBitMask = MA.RolesBitMask
FROM MMHost H INNER JOIN #tempMARoles MA ON MA.clientId = H.ClientId
SELECT MA.ClientId, MA.RolesBitMask, IIF(H.MmHostSoftState>0 and H.MmHostEnabled >0, 1, 0)
FROM	#tempMARoles MA
		INNER JOIN MMHost H (NOLOCK) ON MA.clientId = H.ClientId
IF object_id('tempdb.dbo.#tempMARoles') IS NOT NULL DROP TABLE #tempMARoles

IF EXISTS (select * from GxQscripts where name = 'MMUpdateMediaAgentRoles')
	delete from GxQscripts where name = 'MMUpdateMediaAgentRoles'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMUpdateMediaAgentRoles')
	delete from GXDBVersions where aliasname = 'MMUpdateMediaAgentRoles'
GO

insert into GXDBVersions values(2, 'MMUpdateMediaAgentRoles',  '00000000000000000000', 'MMUpdateMediaAgentRoles', '00000000000000000000')
GO

