

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMUpdateCloudVMPowerStatus.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMUpdateCloudVMPowerStatus.sp,v $ $Id: MMUpdateCloudVMPowerStatus.sp,v 1.1.2.11 2020/03/02 18:21:46 prasanthm Exp $";
--  +-----------------------------------------------------------------------+
--  |       PROCEDURE	:	"MMUpdateCloudVMPowerStatus"               		|
--  |       Author	    :	prasanthm                        				|
--  | Execute the System stored procedure to fetch the physical files   	|
--  | .. for the (current) database.                    					|
--  +-----------------------------------------------------------------------+
/*
This will update the VM power status of each step of the thread. (APP_ClientProp -> Cloud VM Managment Power Status)
1) If the RequestStatus in 1 then need to send power on request and should update power status as 1.
2) If the power status in 1 and received response like VMs Powered on then update power status as 2.
3) If the power status in 2, MM thread keep on checking the MMHost Softstate and if it is 1 then update power status as 3
4) If request comes for Power Off VMS then update the power status to 4.
5) After recevied the response for power off update power status as 5
*/
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMUpdateCloudVMPowerStatus')
BEGIN
	print '>>> Drop Stored Procedure: MMUpdateCloudVMPowerStatus <<<'
	drop procedure MMUpdateCloudVMPowerStatus
END
IF EXISTS (select * from GxQscripts where name='MMUpdateCloudVMPowerStatus')
	delete from GxQscripts where name = 'MMUpdateCloudVMPowerStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMUpdateCloudVMPowerStatus')
	delete from GXDBVersions where aliasname = 'MMUpdateCloudVMPowerStatus'
GO
print '... Creating Procedure: MMUpdateCloudVMPowerStatus'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMUpdateCloudVMPowerStatus
  @i_Status Integer,
  @i_HostId Integer
AS
  DECLARE @o_errorCode Integer
DECLARE @currentUTCTime BIGINT = dbo.GetUnixTime(GetUTCDate())
IF @i_Status = 1
BEGIN
	BEGIN TRANSACTION
		UPDATE PH
		SET PH.PowerStatus = @i_Status,
		PH.PowerStateTransitTime = @currentUTCTime
		FROM MMPowerMgmtHost PH
		INNER JOIN MMVMPowerMgmtReq VM ON PH.HostId = VM.HostId
WHERE PH.HostId = @i_HostId AND VM.RequestStatus = 1
		UPDATE MMVMPowerMgmtReq
SET RequestStatus = CASE WHEN RequestStatus = 1 THEN 2
							ELSE RequestStatus
							END,
FailureReason = CASE WHEN FailureReason = 1 AND RequestStatus = 2 THEN 0
							ELSE FailureReason
							END,
			LastUpdateTime = @currentUTCTime
		WHERE HostId = @i_HostId AND RetryCount < 3
	COMMIT
END
ELSE IF @i_Status = 2
BEGIN
		BEGIN TRANSACTION
		UPDATE PH
		SET PH.PowerStatus = @i_Status,
		PH.LastAccessTime = @currentUTCTime,
		PH.PowerStateTransitTime = @currentUTCTime
		FROM MMPowerMgmtHost PH
		WHERE PH.HostId = @i_HostId
		UPDATE MMVMPowerMgmtReq
SET RequestStatus = 3,
		ReqExpiryTime = @currentUTCTime,
		LastUpdateTime = @currentUTCTime
		WHERE HostId = @i_HostId
AND RequestStatus = 2
		COMMIT
END
ELSE IF @i_Status = 3
BEGIN
		UPDATE PH
		SET PH.PowerStatus = @i_Status,
		PH.LastAccessTime = @currentUTCTime,
		PH.PowerStateTransitTime = 0
		FROM MMPowerMgmtHost PH
		INNER JOIN MMHost H ON H.ClientId = PH.HostId
		WHERE H.MmHostSoftState = 1 AND H.MmHostEnabled = 1
AND PH.PowerStatus NOT IN (3, 4)
END
ELSE IF @i_Status = 4
BEGIN
		BEGIN TRANSACTION
		UPDATE PH
		SET PH.PowerStatus = @i_Status,
		PH.PowerStateTransitTime = @currentUTCTime
		FROM MMPowerMgmtHost PH
		WHERE PH.HostId = @i_HostId
		UPDATE MMVMPowerMgmtReq
SET RequestStatus = CASE WHEN RequestStatus = 1 THEN 2
							ELSE RequestStatus
						    END,
FailureReason = CASE WHEN FailureReason = 1 AND RequestStatus = 2 THEN 0
							ELSE FailureReason
							END,
			LastUpdateTime = @currentUTCTime
		WHERE HostId = @i_HostId
AND (Flags & 4) = 4
AND RequestStatus <> 3
		COMMIT
END
ELSE IF @i_Status = 5
BEGIN
		BEGIN TRANSACTION
		UPDATE PH
		SET PH.PowerStatus = @i_Status,
		PH.LastAccessTime = @currentUTCTime,
		PH.PowerStateTransitTime = 0
		FROM MMPowerMgmtHost PH
		WHERE PH.HostId = @i_HostId
		UPDATE MMVMPowerMgmtReq
SET RequestStatus = 3,
		ReqExpiryTime = @currentUTCTime,
		LastUpdateTime = @currentUTCTime
		WHERE HostId = @i_HostId
AND (Flags & 4) = 4
AND RequestStatus = 2
		COMMIT
END
SELECT @@ERROR
GO

IF EXISTS (select * from GxQscripts where name = 'MMUpdateCloudVMPowerStatus')
	delete from GxQscripts where name = 'MMUpdateCloudVMPowerStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMUpdateCloudVMPowerStatus')
	delete from GXDBVersions where aliasname = 'MMUpdateCloudVMPowerStatus'
GO

insert into GXDBVersions values(2, 'MMUpdateCloudVMPowerStatus',  '00010001000200110000', 'MMUpdateCloudVMPowerStatus', '00010001000200110000')
GO

