

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMTransformMountPathOfVolume.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2008  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMTransformMountPathOfVolume.sp,v $ $Id: MMTransformMountPathOfVolume.sp,v 1.10.190.2 2018/03/20 00:15:28 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 	SP: "MMTransformMountPathOfVolume"
--	|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMTransformMountPathOfVolume <<<'

IF EXISTS (select * from sysobjects where name='MMTransformMountPathOfVolume')
	drop procedure MMTransformMountPathOfVolume
IF EXISTS (select * from GxQscripts where name='MMTransformMountPathOfVolume')
	delete from GxQscripts where name = 'MMTransformMountPathOfVolume'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMTransformMountPathOfVolume')
	delete from GXDBVersions where aliasname = 'MMTransformMountPathOfVolume'
GO
print '... Creating Procedure: MMTransformMountPathOfVolume'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMTransformMountPathOfVolume
-- ------------------------------------------------------------------------------------------
-- This SP is used to Check if the given volumes currMountPathId is pointing to a mountpath
-- with enough space to hold this migrated volume.  If not, then get another mountpath associated
-- with this volumes library that has enough space (ordered by newest mountpathId), and set that
-- as the current MP Id.
-- ------------------------------------------------------------------------------------------
  @i_VolumeId integer,
  @i_reserveParam integer
AS
  DECLARE @o_spaceRequiredByVolumeMB integer
  DECLARE @o_transformedMPId integer
  DECLARE @o_freeSpaceOfTranformedMPMB bigint
  DECLARE @o_reserveOutput integer
SET NOCOUNT ON
	-- Note: All space variables are storing value in MB
	declare @l_spaceReqByVolMB		integer
	declare @l_oldCurrMPIdOfVol		integer
	declare @l_freeSpaceOfOldMP		bigint
	declare @l_origMPIdOfVol		integer
	declare @l_LibraryId			integer
	declare @l_transformedMPId			integer
	declare @l_freeSpaceOfTranformedMP		bigint
	-- Temporary table to hold the online mountpaths that have enough free space for the volume.
	declare @tbl_MountPaths		TABLE (MPId int, freeSpaceMB bigint, t_Attribute int)
	SELECT	@l_spaceReqByVolMB = V.PhysicalBytesMB,
				@l_oldCurrMPIdOfVol = CurrMountPathId,
				@l_origMPIdOfVol = MP.MountPathId,
				@l_LibraryId = MP.LibraryId
	FROM	MMVolume V WITH (READUNCOMMITTED), MMMountPath MP WITH (READUNCOMMITTED)
	WHERE	V.VolumeId = @i_VolumeId AND V.MediaSideId = MP.MediaSideId
	SELECT	@l_freeSpaceOfOldMP = (MS.FreeBytesMB - MP.MagneticSpaceRsrvInMB)
	FROM	MMMediaSide MS WITH (READUNCOMMITTED), MMMountPath MP WITH (READUNCOMMITTED)
	WHERE	MP.MountPathId = @l_oldCurrMPIdOfVol
		AND MP.MediaSideId = MS.MediaSideId
	--
	-- From 9.0, check if there exists a mountpath that has the attribute to set to use only for
	-- SILO restores.  If so, pick one of these and return if space available/online, etc.
	-- Otherwise, continue to rest of the logic.
	--
	-- Get all online mountpaths for this library.
	INSERT INTO @tbl_MountPaths
	SELECT	MP.MountPathId, (MS.FreeBytesMB - MP.MagneticSpaceRsrvInMB), MP.Attribute
	FROM	MMMountPath MP WITH (READUNCOMMITTED), MMMediaSide MS WITH (READUNCOMMITTED)
	WHERE	MP.LibraryId = @l_LibraryId
		AND MP.MediaSideId = MS.MediaSideId
		AND MP.IsEnabled = 1
		AND MP.IsOffline = 0
	IF EXISTS
	(
		SELECT TOP 1 MPId
		FROM @tbl_MountPaths
		WHERE freeSpaceMB > @l_spaceReqByVolMB
AND (t_Attribute & 2) > 0
	)
	BEGIN
		SELECT TOP 1 @l_transformedMPId = MPId, @l_freeSpaceOfTranformedMP = freeSpaceMB
		FROM @tbl_MountPaths
WHERE (t_Attribute & 2) > 0
		ORDER BY freeSpaceMB DESC
		--
		-- Update the volume table.
		--
		UPDATE	MMVolume
		SET		CurrMountPathId = @l_transformedMPId
		WHERE	VolumeId = @i_VolumeId
		GOTO TRANSFORMED
	END
	--
	-- Ok, if we reached here then there is either no mountpath with the SILO restore attribute
	-- set OR those mountpaths do not have enough free space.
	--
	--
	-- First, check the perfect world case where the volumes original mountpath itself has
	-- enough free space, just set that as the current mountpath of the volume and return
	--
	IF
	(
		(@l_origMPIdOfVol = @l_oldCurrMPIdOfVol) AND (@l_spaceReqByVolMB < @l_freeSpaceOfOldMP)
		AND EXISTS
		(
			SELECT TOP 1 MountPathId
			FROM MMMountPath WITH (READUNCOMMITTED)
			WHERE MountPathId = @l_origMPIdOfVol AND IsEnabled = 1 and IsOffline = 0
		)
	)
	BEGIN
		-- no changes, just exit after setting the variables to return.
		SET @l_transformedMPId			=	@l_origMPIdOfVol
		SET @l_freeSpaceOfTranformedMP	=	@l_freeSpaceOfOldMP
		GOTO TRANSFORMED
	END
	--
	-- Second case is if the currMPId of the volume is differetn than original
	-- (failed/killed job scenario), check if the volumes original MP has enough space and use that
	-- otherwise fall through the code path for case when currMPId of volume does not have enough space
	-- and we need to pick one that does.
	--
	--
	-- Always prefer the original mountpath of the volume.
	--
	IF EXISTS
	(
		SELECT	TOP 1 MPId
		FROM	@tbl_MountPaths
		WHERE	MPId = @l_origMPIdOfVol AND freeSpaceMB > @l_spaceReqByVolMB
	)
	BEGIN
		--
		-- Update the volume table.
		--
		UPDATE	MMVolume
		SET		CurrMountPathId = @l_origMPIdOfVol
		WHERE	VolumeId = @i_VolumeId
		SET @l_transformedMPId			=	@l_origMPIdOfVol
		SET @l_freeSpaceOfTranformedMP	=	(SELECT freeSpaceMB
											FROM @tbl_MountPaths
											WHERE MPId = @l_origMPIdOfVol)
		GOTO TRANSFORMED
	END
	--
	-- Pick the mountpath that has the most space available.
	--
	IF EXISTS
	(
		SELECT TOP 1 MPId
		FROM @tbl_MountPaths
		WHERE freeSpaceMB > @l_spaceReqByVolMB
	)
	BEGIN
		SELECT TOP 1 @l_transformedMPId = MPId, @l_freeSpaceOfTranformedMP = freeSpaceMB
		FROM @tbl_MountPaths
		ORDER BY freeSpaceMB DESC
		--
		-- Update the volume table.
		--
		UPDATE	MMVolume
		SET		CurrMountPathId = @l_transformedMPId
		WHERE	VolumeId = @i_VolumeId
		GOTO TRANSFORMED
	END
	ELSE
	BEGIN
		-- None, set the tranformedMPId to the same as before and set free space so that
		-- caller knows that we did not find another available mountpath.
		SET @l_transformedMPId			=	@l_oldCurrMPIdOfVol
		SET @l_freeSpaceOfTranformedMP	=	@l_freeSpaceOfOldMP
	END
-- fall through
TRANSFORMED:
	SELECT	@l_spaceReqByVolMB, @l_transformedMPId, @l_freeSpaceOfTranformedMP, 0
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MMTransformMountPathOfVolume')
	delete from GxQscripts where name = 'MMTransformMountPathOfVolume'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMTransformMountPathOfVolume')
	delete from GXDBVersions where aliasname = 'MMTransformMountPathOfVolume'
GO

insert into GXDBVersions values(2, 'MMTransformMountPathOfVolume',  '00010010019000020000', 'MMTransformMountPathOfVolume', '00010010019000020000')
GO

