

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMSummPageGetVaultTracker.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMSummPageGetVaultTracker.sp,v $ $Id: MMSummPageGetVaultTracker.sp,v 1.5.190.2 2018/03/20 00:14:57 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		STORED PROCEDURE : "MMSummPageGetVaultTracker"		|
--	|									|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMSummPageGetVaultTracker <<<'

IF EXISTS (select * from sysobjects where name='MMSummPageGetVaultTracker')
	drop procedure MMSummPageGetVaultTracker
IF EXISTS (select * from GxQscripts where name='MMSummPageGetVaultTracker')
	delete from GxQscripts where name = 'MMSummPageGetVaultTracker'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMSummPageGetVaultTracker')
	delete from GXDBVersions where aliasname = 'MMSummPageGetVaultTracker'
GO
print '... Creating Procedure: MMSummPageGetVaultTracker'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMSummPageGetVaultTracker
  @i_userId INTEGER,
  @i_localeId INTEGER
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @VTPolicyTbl		TABLE (t_policyId int)
DECLARE @VTShelfTbl		TABLE (t_shelfId int)
DECLARE @VTContainerTbl		TABLE (t_containerId int)
DECLARE @actionTbl		TABLE (t_actionId int, t_policyId int, t_actionType int)
INSERT INTO @VTPolicyTbl
SELECT	DISTINCT policyId
FROM	VTPolicy
WHERE	policyId > 1
INSERT INTO @VTShelfTbl
SELECT	DISTINCT LibraryId
FROM	MMLibrary
WHERE	libraryTypeId = 8
INSERT INTO @VTContainerTbl
SELECT	DISTINCT ContainerId
FROM	MMContainer
WHERE	containerId > 0
----------------------
-- VISIBILITY CHECK --
----------------------
IF @i_userId > 0
BEGIN
	IF object_id('tempdb.dbo.#MMSummUserObjects') IS NOT null DROP TABLE #MMSummUserObjects
create table  #MMSummUserObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	EXEC sec_getUserObjects @i_userId, 0, 0, '#MMSummUserObjects'
	DELETE #MMSummUserObjects
	WHERE clientGroupId <> 0 OR clientId <> 0 OR mediaAgentId <> 0 OR libraryID <> 0 OR archGroupID <> 0
	OR reviewSetId <> 0 OR querySetId <> 0 OR downloadSetId <> 0 OR tagId <> 0 OR legalHoldId <> 0 OR ermId <> 0 OR cdPolicyId <> 0 OR complianceReportId <> 0
	OR taskId <> 0 OR workflowId <> 0 OR logMonitoringPolicyId <> 0 OR arrayId <> 0
	OR cloudId <> 0 OR userGroupId <> 0 OR providerId <> 0 OR entityId1 <> 0
	OR entityId2 <> 0 OR entityId3 <> 0 OR entityId4 <> 0 OR entityId5 <> 0
	OR entityId6 <> 0 OR entityId7 <> 0 OR entityId8 <> 0 OR entityId9 <> 0
	DELETE @VTPolicyTbl
	WHERE NOT EXISTS (select * from #MMSummUserObjects where vtPolicyId in (0, t_policyId) and VtShelfId = 0 and vtContainerId = 0)
	DELETE @VTShelfTbl
	WHERE NOT EXISTS (select * from #MMSummUserObjects where VtShelfId in (0, t_shelfId) and vtPolicyId = 0 and vtContainerId = 0)
	DELETE @VTContainerTbl
	WHERE NOT EXISTS (select * from #MMSummUserObjects where vtContainerId in (0, t_containerId) and vtPolicyId = 0 and VtShelfId = 0)
	DROP TABLE #MMSummUserObjects
END
-----------------
-- GET ACTIONS --
-----------------
INSERT INTO @actionTbl
SELECT	DISTINCT actionId, policyId, actionType
FROM	VTAction
DELETE	@actionTbl
WHERE	t_policyId not in (select t_policyId from @VTPolicyTbl)
UPDATE	@actionTbl
SET	t_actionType = -1
FROM	VTPolicyToRule R, VTRuleToSchema S
WHERE	t_actionType <> 2 and t_policyId = R.policyId and R.ruleId = S.ruleId and S.schemaId = 7 and S.param <> -1
--------------------------
-- HERE IS THE RESPONSE --
--------------------------
SELECT  TAG									= 1,
	Parent									= null,
	[EVGui_SummPageGetVaultTracker!1!numberOfRunningActions]		= (select count(DISTINCT t_actionId) from @actionTbl),
	[EVGui_SummPageGetVaultTracker!1!numberOfRunningExportActions]		= (select count(DISTINCT t_actionId) from @actionTbl where t_actionType not in (-1, 2)),
	[EVGui_SummPageGetVaultTracker!1!numberOfRunningImportActions]		= (select count(DISTINCT t_actionId) from @actionTbl where t_actionType = -1),
	[EVGui_SummPageGetVaultTracker!1!numberOfRunningRecallActions]		= (select count(DISTINCT t_actionId) from @actionTbl where t_actionType = 2),
	[EVGui_SummPageGetVaultTracker!1!numberOfcontainers]			= (select count(*) from @VTContainerTbl),
	[EVGui_SummPageGetVaultTracker!1!numberOfIronMountainCustomerIds]	= null,
	[EVGui_SummPageGetVaultTracker!1!numberOfMediaRepositories]		= (select count(*) from @VTShelfTbl)
FOR XML EXPLICIT
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MMSummPageGetVaultTracker')
	delete from GxQscripts where name = 'MMSummPageGetVaultTracker'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMSummPageGetVaultTracker')
	delete from GXDBVersions where aliasname = 'MMSummPageGetVaultTracker'
GO

insert into GXDBVersions values(2, 'MMSummPageGetVaultTracker',  '00010005019000020000', 'MMSummPageGetVaultTracker', '00010005019000020000')
GO

