

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMSummPageGetTapeLibrary.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMSummPageGetTapeLibrary.sp,v $ $Id: MMSummPageGetTapeLibrary.sp,v 1.21.40.15 2018/08/08 15:23:14 pveeravalli Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		STORED PROCEDURE : "MMSummPageGetTapeLibrary"		|
--	|									|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMSummPageGetTapeLibrary <<<'

IF EXISTS (select * from sysobjects where name='MMSummPageGetTapeLibrary')
	drop procedure MMSummPageGetTapeLibrary
IF EXISTS (select * from GxQscripts where name='MMSummPageGetTapeLibrary')
	delete from GxQscripts where name = 'MMSummPageGetTapeLibrary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMSummPageGetTapeLibrary')
	delete from GXDBVersions where aliasname = 'MMSummPageGetTapeLibrary'
GO
print '... Creating Procedure: MMSummPageGetTapeLibrary'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MMSummPageGetTapeLibrary
  @i_userId INTEGER,
  @i_localeId INTEGER,
  @i_libraryId INTEGER
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @clientId		INT
DECLARE @lastBkpTime		INT
DECLARE @lastRstTime		INT
DECLARE @dataSizeInLast1H	BIGINT
DECLARE @durationInLast1H	BIGINT
DECLARE @dataSizeInLast24H	BIGINT
DECLARE @durationInLast24H	BIGINT
DECLARE @driveTbl		TABLE (t_id int, t_isOnline int)
DECLARE @slotTbl		TABLE (t_id int, t_type int, t_isOccupied int)
DECLARE	@exportSGId		TABLE (sgId int, libId int)
DECLARE	@exportMGId		TABLE (medId int, libId int)
DECLARE	@AUXCOPY                INT
DECLARE @DASHCOPY               INT
DECLARE @libraryStatusEventId	INT
DECLARE @isOnline		INT
SET @AUXCOPY  = 13
SET @DASHCOPY	= 104
IF OBJECT_ID('tempdb.dbo.#tmp_mediaTbl') IS NOT NULL DROP TABLE #tmp_mediaTbl
CREATE TABLE  #tmp_mediaTbl (t_id int, t_sparegroupId int, t_spareGroupType int, t_status1 int, t_status2 int,t_lastRstTime int, t_lastBkpTime int, mediaLocation int, isAged int)
CREATE CLUSTERED INDEX t_id_index1 ON #tmp_mediaTbl(t_id)
--media
-- media inside library
INSERT INTO #tmp_mediaTbl
SELECT DISTINCT MediaId, (CASE isInMediaGroup WHEN 1 THEN 0 ELSE sparegroupId END), 0, 0, 0,LastRestoreTime,LastBackupTime, MediaLocation, IsAged
FROM 	MMMedia WITH (NOLOCK)
WHERE 	LibraryId = @i_LibraryId AND MediaId > 0 AND mediaTypeId <> 10001 AND MediaLocation <> 3
		AND BarCode <> ('StdAln_' + CAST(MediaId as varchar(64))) --#define MMS2_STANDALONE_DUMMY_BARCODE     "StdAln"
-- media outside library
INSERT INTO @exportSGId
SELECT	SpareGroupId, LibraryId
FROM	MMSpareGroup WITH (NOLOCK)
WHERE	LibraryId = @i_LibraryId
INSERT INTO @exportMGId
SELECT	V.MediaId, T.libId
FROM	MMMediaGroup G WITH (NOLOCK)
	INNER JOIN MMVolume V WITH (NOLOCK) ON G.MediaGroupId = V.MediaGroupId AND V.MediaGroupId > 0
	INNER JOIN @exportSGId T ON G.SpareGroupId = T.sgId
INSERT INTO #tmp_mediaTbl
SELECT DISTINCT MediaId, (CASE isInMediaGroup WHEN 1 THEN 0 ELSE sparegroupId END), 0, 0, 0,LastRestoreTime,LastBackupTime, MediaLocation, IsAged
FROM	MMMedia WITH (NOLOCK)
WHERE	LastWriteLibraryId = @i_LibraryId AND MediaId > 0 AND mediaTypeId <> 10001 AND MediaLocation = 3
		AND BarCode <> ('StdAln_' + CAST(MediaId as varchar(64))) --#define MMS2_STANDALONE_DUMMY_BARCODE     "StdAln"
UNION
SELECT DISTINCT MediaId, (CASE isInMediaGroup WHEN 1 THEN 0 ELSE sparegroupId END), 0, 0, 0,LastRestoreTime,LastBackupTime, MediaLocation, IsAged
FROM	MMMedia WITH (NOLOCK)
	INNER JOIN @exportSGId SG ON MMMedia.SpareGroupId = SG.sgId
WHERE	LastWriteLibraryId <> @i_LibraryId AND MediaId > 0 AND mediaTypeId <> 10001 AND MediaLocation = 3
	AND IsInMediaGroup = 0
	AND BarCode <> ('StdAln_' + CAST(MediaId as varchar(64))) --#define MMS2_STANDALONE_DUMMY_BARCODE     "StdAln"
UNION
SELECT DISTINCT MediaId, (CASE isInMediaGroup WHEN 1 THEN 0 ELSE sparegroupId END), 0, 0, 0,LastRestoreTime,LastBackupTime, MediaLocation, IsAged
FROM	MMMedia WITH (NOLOCK)
	INNER JOIN @exportMGId MG ON MMMedia.MediaId = MG.medId
WHERE	LastWriteLibraryId <> @i_LibraryId AND MediaId > 0 AND mediaTypeId <> 10001 AND MediaLocation = 3
	AND IsInMediaGroup > 0 AND LastWriteLibraryId <> 0
	AND BarCode <> ('StdAln_' + CAST(MediaId as varchar(64))) --#define MMS2_STANDALONE_DUMMY_BARCODE     "StdAln"
UNION	-- Deconfigured libraries wont have spare group entries so addding them seperately
SELECT	DISTINCT MediaId, (CASE isInMediaGroup WHEN 1 THEN 0 ELSE sparegroupId END), 0, 0, 0,LastRestoreTime,LastBackupTime, MediaLocation, IsAged
FROM	MMMedia WITH (NOLOCK)
INNER JOIN MMLibrary WITH (NOLOCK) ON MMMedia.LibraryId = MMLibrary.LibraryId AND MMLibrary.LibraryId = @i_LibraryId AND LibraryTypeId = 9
WHERE	MediaId > 0 AND mediaTypeId <> 10001 AND MediaLocation = 3
	AND BarCode <> ('StdAln_' + CAST(MediaId AS varchar(64)))
UPDATE #tmp_mediaTbl
SET	t_spareGroupType = spareGroupType
FROM	MMSpareGroup WITH (NOLOCK)
WHERE	t_sparegroupId = spareGroupId AND t_sparegroupId > 0
UPDATE M
SET M.t_status1 = T.minVolumeFlags , M.t_status2 = T.maxVolumeFlags
FROM #tmp_mediaTbl M , ( SELECT MT.t_id,  MIN(V.VolumeFlags) minVolumeFlags, MAX(V.VolumeFlags) maxVolumeFlags
			FROM MMVolume V  WITH (NOLOCK)
				INNER JOIN MMMediaSide S WITH (NOLOCK) ON V.MediaSideId = S.MediaSideId
				INNER JOIN #tmp_mediaTbl MT ON S.MediaId = MT.t_id
			WHERE t_sparegroupId = 0
			GROUP BY MT.t_id
			) T
WHERE M.t_id = T.t_id
--------
-- Drive
INSERT INTO @driveTbl
SELECT	DISTINCT D.driveId, (case when D.DriveSoftState > 0 and D.DriveEnabled > 0 and D.DriveBroken = 0 then 1 else 0 end)
FROM	MMDrive D WITH (NOLOCK)
	INNER JOIN MMMasterPool P WITH (NOLOCK) ON D.MasterPoolId = P.MasterPoolId AND P.LibraryId = @i_libraryId
--------
-- Slot
INSERT INTO @slotTbl
SELECT	S.slotId, S.slotType, S.isOccupied
FROM	MMSlot S WITH (NOLOCK)
	INNER JOIN MMBay B WITH (NOLOCK) ON S.BayId = B.BayId AND B.LibraryId = @i_libraryId
--------
-- jobs
SELECT	@clientId = MAX(clientId)
FROM	MMLibraryController WITH (NOLOCK)
WHERE	LibraryId = @i_libraryId AND LibraryControllerId > 0 AND libraryControllerActive > 0
SELECT	@dataSizeInLast1H = SUM(dataWritten)*1024*1024 , @durationInLast1H = SUM(cast(dataWriteDurationSec AS BIGINT))
FROM	MMDrivehistory WITH (NOLOCK)
WHERE	driveId IN (SELECT t_id FROM @driveTbl) AND clientId = @clientId AND datediff(mi, modified, getUTCDate()) < 60 AND dataWritten > 0
AND		historyType = 2
SELECT	@dataSizeInLast24H = SUM(dataWritten)*1024*1024, @durationInLast24H = SUM(cast(dataWriteDurationSec as BIGINT))
FROM	MMDrivehistory WITH (NOLOCK)
WHERE	driveId in (SELECT t_id FROM @driveTbl) AND clientId = @clientId AND datediff(mi, modified, getUTCDate()) < 1440 AND dataWritten > 0
AND		historyType = 2
IF object_id('tempdb.dbo.#tempTapeLib') IS NOT NULL DROP TABLE #tempTapeLib
SELECT	LibraryVendor, LibraryModel, firmwarerevision, LibraryEnabled, ExtendedAttributes, SerialNumber, BarCodeReaderPresent
INTO	#tempTapeLib
FROM	MMLibrary WITH (NOLOCK)
WHERE	LibraryId = @i_libraryId
SET @isOnline = 0
IF EXISTS (	SELECT TOP 1 ML.Libraryid
		FROM 	MMLibrary ML WITH (NOLOCK)
			INNER JOIN MMLibraryController MLC WITH (NOLOCK) ON MLC.LibraryId = ML.LibraryId
		WHERE	ML.LibraryId = @i_libraryId
			AND ML.LibrarySoftState > 0 AND ML.LibraryEnabled > 0 AND ML.LibraryBroken = 0
			AND MLC.LibraryControllerActive > 0 AND MLC.LibraryControllerSoftState > 0
			AND MLC.LibraryControllerEnabled > 0
	  )
BEGIN
	SET @isOnline = 1
END
SELECT	@libraryStatusEventId=LibraryStatusEventId
FROM	MMLibrary WITH (NOLOCK)
WHERE	LibraryId = @i_libraryId
SELECT	@lastBkpTime = max(t_lastBkpTime) from #tmp_mediaTbl
SET @lastBkpTime = ISNULL(@lastBkpTime, 0)
IF(@lastBkpTime <> 0)
  SELECT	@lastBkpTime =  dbo.GetUnixTime(dbo.UTCToLocalTime(  dbo.GetDateTime( max(t_lastBkpTime)), dbo.GetClientTimeZone(2))) from #tmp_mediaTbl
SELECT	@lastRstTime = max(t_lastRstTime) from #tmp_mediaTbl
SET @lastRstTime = ISNULL(@lastRstTime, 0)
IF(@lastRstTime <> 0)
  SELECT	@lastRstTime =  dbo.GetUnixTime(dbo.UTCToLocalTime(  dbo.GetDateTime( max(t_lastRstTime)), dbo.GetClientTimeZone(2))) from #tmp_mediaTbl
--------------------------
-- HERE IS THE RESPONSE --
--------------------------
SELECT  TAG								= 1,
	Parent								= null,
	[EVGui_SummPageGetTapeLibraries!1!vendor]			= (select LibraryVendor from #tempTapeLib),
	[EVGui_SummPageGetTapeLibraries!1!model]			= (select LibraryModel from #tempTapeLib),
	[EVGui_SummPageGetTapeLibraries!1!serialNumber]			= (select SerialNumber from #tempTapeLib),
[EVGui_SummPageGetTapeLibraries!1!barcodeReader]		= (select DBO.fn_EvFormatEventMsgText(0, @i_localeId, CASE BarCodeReaderPresent WHEN 1 THEN (394 | (CAST(POWER(2, 24) AS BIGINT) * 61)) ELSE (395 | (CAST(POWER(2, 24) AS BIGINT) * 61)) END, 0,2) from #tempTapeLib),
	[EVGui_SummPageGetTapeLibraries!1!firmwareRevision]		= (select firmwarerevision from #tempTapeLib),
	[EVGui_SummPageGetTapeLibraries!1!controller]			= (select name from APP_Client with (nolock) where id = @clientId),
	[EVGui_SummPageGetTapeLibraries!1!numOfDrives]			= (select count(*) from @driveTbl),
	[EVGui_SummPageGetTapeLibraries!1!numOfDrivesOffline]		= (select count(*) from @driveTbl where t_isOnline = 0),
	[EVGui_SummPageGetTapeLibraries!1!numOfMedia]			= (select count(DISTINCT t_id) from #tmp_mediaTbl),
	[EVGui_SummPageGetTapeLibraries!1!numOfFullMedia]		= (select count(DISTINCT t_id) from #tmp_mediaTbl where t_status1 = 2 OR t_status2 = 2),
	[EVGui_SummPageGetTapeLibraries!1!numOfActiveMedia]		= (select count(DISTINCT t_id) from #tmp_mediaTbl where t_status1 = 1 OR t_status2 = 1),
	[EVGui_SummPageGetTapeLibraries!1!numOfAppendableMedia]		= (select count(DISTINCT t_id) from #tmp_mediaTbl where t_status1 = 7 OR t_status2 = 7),
	[EVGui_SummPageGetTapeLibraries!1!numOfAssignedMedia]		= (select count(DISTINCT t_id) from #tmp_mediaTbl where t_spareGroupId = 0),
	[EVGui_SummPageGetTapeLibraries!1!numOfSpareMedia]		= (select count(DISTINCT t_id) from #tmp_mediaTbl where t_spareGroupType in (1, 2) AND isAged = 0),
	[EVGui_SummPageGetTapeLibraries!1!numOfAgedMedia]		= (select count(DISTINCT t_id) from #tmp_mediaTbl where isAged = 1),
	[EVGui_SummPageGetTapeLibraries!1!numOfCleaningMedia]		= (select count(DISTINCT t_id) from #tmp_mediaTbl where t_spareGroupType = 32),
	[EVGui_SummPageGetTapeLibraries!1!numOfMediaExporting]		= null,
	[EVGui_SummPageGetTapeLibraries!1!numOfRegSlots]		= (select count(*) from @slotTbl where t_type = 1),
	[EVGui_SummPageGetTapeLibraries!1!numOfRegSlotOccupied]		= (select count(*) from @slotTbl where t_type = 1 and t_isOccupied > 0),
	[EVGui_SummPageGetTapeLibraries!1!numOfIESlots]			= (select count(*) from @slotTbl where t_type = 2),
	[EVGui_SummPageGetTapeLibraries!1!numOfIESlotOccupied]		= (select count(*) from @slotTbl where t_type = 2 and t_isOccupied > 0),
[EVGui_SummPageGetTapeLibraries!1!isOnline]			= (select DBO.fn_EvFormatEventMsgText(0, @i_localeId, CASE @isOnline WHEN 1 THEN (394 | (CAST(POWER(2, 24) AS BIGINT) * 61)) ELSE (395 | (CAST(POWER(2, 24) AS BIGINT) * 61)) END, 0, 2) ),
[EVGui_SummPageGetTapeLibraries!1!offlineReason]		= (select DBO.fn_EvFormatEventMsgText(0, @i_localeId, CASE @isOnline WHEN 1 THEN (369 | (CAST(POWER(2, 24) AS BIGINT) * 61)) ELSE @libraryStatusEventId END, 0, 2) ),
	[EVGui_SummPageGetTapeLibraries!1!bytesBackedupInLast1H]	= DBO.GetSizeString(@dataSizeInLast1H),
	[EVGui_SummPageGetTapeLibraries!1!bytesBackedupInLast24H]	= DBO.GetSizeString(@dataSizeInLast24H),
[EVGui_SummPageGetTapeLibraries!1!lastBackupTime]		= (case @lastBkpTime when 0 then DBO.fn_EvFormatEventMsgText(0, @i_localeId, (369 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0, 2) else DBO.getDateTime2(@lastBkpTime, null, 0) end),
[EVGui_SummPageGetTapeLibraries!1!lastRestoreTime]		= (case @lastRstTime when 0 then DBO.fn_EvFormatEventMsgText(0, @i_localeId, (369 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0, 2) else DBO.getDateTime2(@lastRstTime, null, 0) end),
	[EVGui_SummPageGetTapeLibraries!1!lastHourThroughput]		= DBO.GetThroughputString(@dataSizeInLast1H, @durationInLast1H, 1),
	[EVGui_SummPageGetTapeLibraries!1!lastDayThroughput]		= DBO.GetThroughputString(@dataSizeInLast24H, @durationInLast24H, 1),
	[EVGui_SummPageGetTapeLibraries!1!totalNumberOfWriteReservations] = (SELECT COUNT(*) FROM MMRESOURCE WITH (NOLOCK) WHERE ReservationType = 2 AND LibraryId =@i_libraryId AND HasJobInterrupted=0 and IntrJobId_L=0),
	[EVGui_SummPageGetTapeLibraries!1!backupReservations]		= (SELECT COUNT(*) FROM MMRESOURCE WITH (NOLOCK) WHERE ReservationType = 2 AND LibraryId = @i_libraryId AND HasJobInterrupted = 0
															AND IntrJobId_l = 0 AND EXISTS(SELECT 1 FROM MMRESOURCETOJOB WITH (NOLOCK) WHERE ReservationId = MMRESOURCE.ReservationId AND DBO.GETJOBTYPEFORJOBID(JobId_l) IN (4, 11, 14,18,30,43,59,60,70,98,101))),
	[EVGui_SummPageGetTapeLibraries!1!auxiliaryCopyWriteReservations] = (SELECT COUNT(*) FROM MMRESOURCE  WITH (NOLOCK) WHERE ReservationType = 2 AND LibraryId = @i_libraryId AND HasJobInterrupted = 0
															AND IntrJobId_l = 0 AND EXISTS(SELECT 1 FROM MMRESOURCETOJOB WITH(NOLOCK) WHERE ReservationId = MMRESOURCE.ReservationId AND DBO.GETJOBTYPEFORJOBID(JobId_l) IN (@AUXCOPY,@DASHCOPY))),
	[EVGui_SummPageGetTapeLibraries!1!associatedMediaAgents]	= ISNULL ( (select stuff((select ','+ displayName from app_client WITH (NOLOCK)  INNER JOIN mmlibrarycontroller AS m WITH (NOLOCK)  ON id = ClientId AND m.Libraryid = @i_libraryId
															    FOR XML PATH(''), TYPE).value('.', 'varchar(max)'),1,1,' ')),''),
	[EVGui_SummPageGetTapeLibraries!1!isEnabled]			= (select LibraryEnabled from #tempTapeLib),
	[EVGui_SummPageGetTapeLibraries!1!attribute]			= (select ExtendedAttributes from #tempTapeLib),
	[EVGui_SummPageGetTapeLibraries!1!status]			= (select @isOnline)
FOR XML EXPLICIT
IF OBJECT_ID('tempdb.dbo.#tempTapeLib') IS NOT NULL DROP TABLE #tempTapeLib
IF OBJECT_ID('tempdb.dbo.#tmp_mediaTbl') IS NOT NULL DROP TABLE #tmp_mediaTbl
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MMSummPageGetTapeLibrary')
	delete from GxQscripts where name = 'MMSummPageGetTapeLibrary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMSummPageGetTapeLibrary')
	delete from GXDBVersions where aliasname = 'MMSummPageGetTapeLibrary'
GO

insert into GXDBVersions values(2, 'MMSummPageGetTapeLibrary',  '00010021004000150000', 'MMSummPageGetTapeLibrary', '00010021004000150000')
GO

