

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMSummPageGetTapeLibraries.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMSummPageGetTapeLibraries.sp,v $ $Id: MMSummPageGetTapeLibraries.sp,v 1.6.36.5 2018/03/20 00:09:38 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		STORED PROCEDURE : "MMSummPageGetTapeLibraries"		|
--	|									|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMSummPageGetTapeLibraries <<<'

IF EXISTS (select * from sysobjects where name='MMSummPageGetTapeLibraries')
	drop procedure MMSummPageGetTapeLibraries
IF EXISTS (select * from GxQscripts where name='MMSummPageGetTapeLibraries')
	delete from GxQscripts where name = 'MMSummPageGetTapeLibraries'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMSummPageGetTapeLibraries')
	delete from GXDBVersions where aliasname = 'MMSummPageGetTapeLibraries'
GO
print '... Creating Procedure: MMSummPageGetTapeLibraries'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMSummPageGetTapeLibraries
  @i_userId INTEGER,
  @i_localeId INTEGER,
  @i_libraryId INTEGER
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
--DECLARE @i_userId           INTEGER
--DECLARE @i_localeId         INTEGER
--DECLARE @i_libraryId        INTEGER
--SET @i_userId = 1
--SET @i_localeId = 0
--SET @i_libraryId = 0
DECLARE @clientId		INT
DECLARE @lastBkpTime		INT
DECLARE @lastRstTime		INT
DECLARE @dataSizeInLast1H	BIGINT
DECLARE @durationInLast1H	BIGINT
DECLARE @dataSizeInLast24H	BIGINT
DECLARE @durationInLast24H	BIGINT
IF object_id('tempdb.dbo.#tempTapeLib') is not null DROP TABLE #tempTapeLib
IF object_id('tempdb.dbo.#tempTapeLib2') is not null DROP TABLE #tempTapeLib2
CREATE TABLE	#tempTapeLib
(
	LibraryID integer,
	LibraryVendor varchar(16),
	LibraryModel varchar(32),
	Firmware varchar(32),
	LibraryStatusReason int,
	isOnline int,
	clientId integer,
	lastBkpTime integer,
	lastRstTime integer,
	dataSizeInLast1H BIGINT,
	durationInLast1H BIGINT,
	dataSizeInLast24H BIGINT,
	durationInLast24H	BIGINT
)
DECLARE @driveTbl		TABLE (t_libId int, t_id int, t_isOnline int)
DECLARE @slotTbl		TABLE (t_libId int, t_id int, t_type int, t_isOccupied int)
DECLARE @mediaTbl		TABLE (t_libId int, t_id int, t_sparegroupId int, t_spareGroupType int, t_status1 int, t_status2 int,t_lastRstTime int, t_lastBkpTime int)
DECLARE	@exportSGId		TABLE (sgId int, libId int)
DECLARE	@exportMGId		TABLE (medId int, libId int)
DECLARE @libControllerTbl	TABLE (t_libId int, t_clientid int)
INSERT INTO #tempTapeLib
SELECT LibraryId, LibraryVendor, LibraryModel, firmwarerevision, LibraryStatusReason,
		isOnline = (case when LibrarySoftState > 0 and LibraryEnabled > 0 and LibraryBroken = 0 then 1 else 0 end),
		0, 0, 0, 0, 0, 0, 0
FROM	MMLibrary
WHERE	(@i_libraryId = 0 OR LibraryId = @i_libraryId)
		AND LibraryId > 0
AND LibraryTypeId in (1,4)
--------
--media
-- media inside library
INSERT INTO @mediaTbl
SELECT DISTINCT L.LibraryId, MediaId, (case isInMediaGroup when 1 then 0 else sparegroupId end), 0, 0, 0,LastRestoreTime,LastBackupTime
FROM 	MMMedia, #tempTapeLib L
WHERE 	MMMedia.LibraryId = L.LibraryId AND MediaId > 0 AND mediaTypeId <> 10001 AND MediaLocation <> 3
	AND BarCode <> ('StdAln_' + CAST(MediaId as varchar(64)))
								--Dummy Media for stand alone library not to be shown MR 9121
								--#define MMS2_STANDALONE_DUMMY_BARCODE     "StdAln"
-- media outside library
INSERT INTO @exportSGId
SELECT	SpareGroupId, L.LibraryId
FROM	MMSpareGroup, #tempTapeLib L
WHERE	MMSpareGroup.LibraryId = L.LibraryId
INSERT INTO @exportMGId
SELECT	V.MediaId, T.libId
FROM	MMMediaGroup G, MMVolume V, @exportSGId T
WHERE	G.SpareGroupId = T.sgId AND G.MediaGroupId = V.MediaGroupId and V.MediaGroupId > 0
INSERT INTO @mediaTbl
SELECT DISTINCT L.LibraryId, MediaId, (case isInMediaGroup when 1 then 0 else sparegroupId end), 0, 0, 0,LastRestoreTime,LastBackupTime
FROM	MMMedia, #tempTapeLib L
WHERE	LastWriteLibraryId = L.LibraryId AND MediaId > 0 AND mediaTypeId <> 10001 AND MediaLocation = 3
	AND BarCode <> ('StdAln_' + CAST(MediaId as varchar(64)))
								--Dummy Media for stand alone library not to be shown MR 9121
								--#define MMS2_STANDALONE_DUMMY_BARCODE     "StdAln"
UNION
SELECT DISTINCT SG.libId, MediaId, (case isInMediaGroup when 1 then 0 else sparegroupId end), 0, 0, 0,LastRestoreTime,LastBackupTime
FROM	MMMedia, @exportSGId SG
WHERE	LastWriteLibraryId <> SG.libId AND MediaId > 0 AND mediaTypeId <> 10001 AND MediaLocation = 3 AND
	IsInMediaGroup = 0 AND SpareGroupId = SG.sgId
	AND BarCode <> ('StdAln_' + CAST(MediaId as varchar(64)))
								--Dummy Media for stand alone library not to be shown MR 9121
								--#define MMS2_STANDALONE_DUMMY_BARCODE     "StdAln"
UNION
SELECT DISTINCT MG.libId, MediaId, (case isInMediaGroup when 1 then 0 else sparegroupId end), 0, 0, 0,LastRestoreTime,LastBackupTime
FROM	MMMedia, @exportMGId MG
WHERE	LastWriteLibraryId <> MG.libId AND MediaId > 0 AND mediaTypeId <> 10001 AND MediaLocation = 3 AND
	IsInMediaGroup > 0 AND MediaId = MG.medId AND LastWriteLibraryId <> 0
	AND BarCode <> ('StdAln_' + CAST(MediaId as varchar(64)))
								--Dummy Media for stand alone library not to be shown MR 9121
								--#define MMS2_STANDALONE_DUMMY_BARCODE     "StdAln"
UPDATE @mediaTbl
SET	t_spareGroupType = spareGroupType
FROM	MMSpareGroup
WHERE	t_sparegroupId = spareGroupId AND t_sparegroupId > 0
UPDATE @mediaTbl
SET	t_status1 = (	SELECT min(V.VolumeFlags) FROM MMVolume V, MMMediaSide S
			where V.MediaSideId = S.MediaSideId AND S.MediaId = t_id AND t_sparegroupId = 0),
	t_status2 = (	SELECT max(V.VolumeFlags) FROM MMVolume V, MMMediaSide S
			where V.MediaSideId = S.MediaSideId AND S.MediaId = t_id AND t_sparegroupId = 0)
--------
-- Drive
INSERT INTO @driveTbl
SELECT	DISTINCT L.LibraryId, D.driveId, (case when D.DriveSoftState > 0 and D.DriveEnabled > 0 and D.DriveBroken = 0 then 1 else 0 end)
FROM	MMDrive D, MMMasterPool P, #tempTapeLib L
WHERE	P.libraryId = L.LibraryID AND D.MasterPoolId = P.MasterPoolId
------
-- Slot
INSERT INTO @slotTbl
SELECT	L.LibraryId, S.slotId, S.slotType, S.isOccupied
FROM	MMSlot S, MMBay B, #tempTapeLib L
WHERE	B.LibraryId = L.LibraryId AND S.BayId = B.BayId
--------
-- jobs
UPDATE	#tempTapeLib
SET		clientId = M.clientid
FROM	(SELECT  LibraryID, MAX(ClientID) AS ClientID FROM MMLibraryController WHERE LibraryControllerId > 0 and libraryControllerActive > 0 GROUP BY LibraryID) M
WHERE	M.LibraryId = #tempTapeLib.LibraryId
UPDATE	#tempTapeLib
SET		dataSizeInLast1H = D.dataSizeInLast1H,
		durationInLast1H = D.durationInLast1H
FROM	(SELECT	L.LibraryID, dataSizeInLast1H = sum(DH.dataWritten)*1024*1024, durationInLast1H	= sum(cast(dataWriteDurationSec as bigint))
			FROM	MMDrivehistory DH, @driveTbl D, #tempTapeLib L
			WHERE	D.t_libId = L.LibraryID
					AND DH.ClientId = L.clientId
					AND datediff(mi, DH.modified, getUTCDate()) < 60
					AND DH.dataWritten > 0 AND historytype=2
			GROUP BY L.LibraryID
			) D
WHERE	D.LibraryId = #tempTapeLib.LibraryId
UPDATE	#tempTapeLib
SET		dataSizeInLast24H = D.dataSizeInLast24H,
		durationInLast24H = D.durationInLast24H
FROM	(SELECT	L.LibraryID, dataSizeInLast24H = sum(DH.dataWritten)*1024*1024, durationInLast24H	= sum(cast(DH.dataWriteDurationSec as bigint))
			FROM	MMDrivehistory DH, @driveTbl D, #tempTapeLib L
			WHERE	D.t_libId = L.LibraryID
					AND DH.ClientId = L.clientId
					AND datediff(mi, DH.modified, getUTCDate()) < 1440
					AND DH.dataWritten > 0 AND historytype=2
			GROUP BY L.LibraryID
			) D
WHERE	D.LibraryId = #tempTapeLib.LibraryId
UPDATE	#tempTapeLib
SET		lastBkpTime = M.lastBkpTime,
		lastRstTime = M.lastRstTime
FROM	(SELECT  t_libId, max(t_lastBkpTime) AS lastBkpTime, max(t_lastRstTime) AS lastRstTime FROM @mediaTbl GROUP BY t_libId) M
WHERE	M.t_libId = #tempTapeLib.LibraryId
SELECT
	libraryID		= LibraryID,
	vendor			= LibraryVendor,
	model			= LibraryModel,
    firmwareRevision	= Firmware,
    controller			= (SELECT name FROM APP_client where id = clientId),
    numOfDrives			= (SELECT count(*) FROM @driveTbl WHERE t_libId = LibraryID),
    numOfDrivesOffline	= (SELECT count(*) FROM @driveTbl WHERE t_libId = LibraryID AND t_isOnline = 0),
    numOfMedia			= (SELECT count(DISTINCT t_id) FROM @mediaTbl WHERE t_libId = LibraryID),
  	numOfActiveMedia	= (SELECT count(DISTINCT t_id) FROM @mediaTbl WHERE t_libId = LibraryID AND (t_status1 = 1 OR t_status2 = 1)),
  	numOfFullMedia		= (SELECT count(DISTINCT t_id) FROM @mediaTbl WHERE t_libId = LibraryID AND (t_status1 = 2 OR t_status2 = 2)),
	numOfAppendableMedia	= (SELECT count(DISTINCT t_id) FROM @mediaTbl WHERE t_libId = LibraryID AND (t_status1 = 7 OR t_status2 = 7)),
  	numOfIdleMedia		= (SELECT count(DISTINCT t_id) FROM @mediaTbl WHERE t_libId = LibraryID AND (t_status1 = 5 OR t_status2 = 5)),
  	numOfReadOnlyMedia	= (SELECT count(DISTINCT t_id) FROM @mediaTbl WHERE t_libId = LibraryID AND (t_status1 = 3 OR t_status2 = 3)),
  	numOfBadMedia		= (SELECT count(DISTINCT t_id) FROM @mediaTbl WHERE t_libId = LibraryID AND (t_status1 = 4 OR t_status2 = 4)),
	numOfSpareMedia		= (SELECT count(DISTINCT t_id) FROM @mediaTbl WHERE t_libId = LibraryID AND (t_spareGroupType = 2 OR t_spareGroupType = 1)),
	numOfCleaningMedia	= (SELECT count(DISTINCT t_id) FROM @mediaTbl WHERE t_libId = LibraryID AND t_spareGroupType = 32),
	numOfExpiredMedia	= (SELECT count(DISTINCT t_id) FROM @mediaTbl WHERE t_libId = LibraryID AND t_spareGroupType = 8),
	numOfForeignMedia	= (SELECT count(DISTINCT t_id) FROM @mediaTbl WHERE t_libId = LibraryID AND t_spareGroupType = 16),
	numOfSavedMedia		= (SELECT count(DISTINCT t_id) FROM @mediaTbl WHERE t_libId = LibraryID AND t_spareGroupType = 64),
	numOfAgedMedia		= (SELECT count(DISTINCT t_id) FROM @mediaTbl WHERE t_libId = LibraryID AND t_spareGroupType = 64),
	numOfMediaExporting	= null,
	numOfRegSlots		= (SELECT count(*) FROM @slotTbl where t_libId = LibraryID AND t_type = 1),
	numOfRegSlotOccupied	= (SELECT count(*) FROM @slotTbl where t_libId = LibraryID AND t_type = 1 and t_isOccupied > 0),
	numOfIESlots		= (SELECT count(*) FROM @slotTbl where t_libId = LibraryID AND t_type = 2),
	numOfIESlotOccupied	= (SELECT count(*) FROM @slotTbl where t_libId = LibraryID AND t_type = 2 and t_isOccupied > 0),
	isOnline			= isOnline,
--	offlineReason		= (SELECT LibraryStatusReason FROM #tempTapeLib),
	bytesBackedupInLast1H	= DBO.GetSizeString(dataSizeInLast1H),
	bytesBackedupInLast24H	= DBO.GetSizeString(dataSizeInLast24H),
	lastBackupTime		= (case lastBkpTime when 0 then null else DBO.getDateTime2(lastBkpTime, null, 0) end),
	lastRestoreTime		= (case lastRstTime when 0 then null else DBO.getDateTime2(lastRstTime, null, 0) end),
	lastHourThroughput	= DBO.GetThroughputString(dataSizeInLast1H, durationInLast1H, 1),
	lastDayThroughput	= DBO.GetThroughputString(dataSizeInLast24H, durationInLast24H, 1)
INTO #tempTapeLib2
FROM	#tempTapeLib
--------------------------
-- HERE IS THE RESPONSE --
--------------------------
DECLARE @XMLDoc XML
SET @XMLDoc =
(
SELECT
		(SELECT
			libraryID AS '@libraryID',
			vendor AS '@vendor',
			model AS '@model',
			firmwareRevision AS '@firmwareRevision',
			controller AS '@controller',
			numOfDrives AS '@numOfDrives',
			numOfDrivesOffline AS '@numOfDrivesOffline',
			numOfMedia AS '@numOfMedia',
			numOfActiveMedia AS '@numOfActiveMedia',
			numOfFullMedia AS '@numOfFullMedia',
			numOfAppendableMedia AS '@numOfAppendableMedia',
			numOfIdleMedia AS '@numOfIdleMedia',
			numOfReadOnlyMedia AS '@numOfReadOnlyMedia',
			numOfBadMedia AS '@numOfBadMedia',
			numOfSpareMedia AS '@numOfSpareMedia',
			numOfCleaningMedia AS '@numOfCleaningMedia',
			numOfExpiredMedia AS '@numOfExpiredMedia',
			numOfForeignMedia AS '@numOfForeignMedia',
			numOfSavedMedia AS '@numOfSavedMedia',
			numOfAgedMedia AS '@numOfAgedMedia',
			numOfMediaExporting AS '@numOfMediaExporting',
			numOfRegSlots AS '@numOfRegSlots',
			numOfRegSlotOccupied AS '@numOfRegSlotOccupied',
			numOfIESlots AS '@numOfIESlots',
			numOfIESlotOccupied AS '@numOfIESlotOccupied',
			isOnline AS '@isOnline',
			bytesBackedupInLast1H AS '@bytesBackedupInLast1H',
			bytesBackedupInLast24H AS '@bytesBackedupInLast24H',
			lastBackupTime AS '@lastBackupTime',
			lastRestoreTime AS '@lastRestoreTime',
			lastHourThroughput AS '@lastHourThroughput',
			lastDayThroughput AS '@lastDayThroughput'
		FROM #tempTapeLib2
		FOR XML PATH ('libraries'), TYPE)
FOR	XML PATH ('EVGui_SummPageGetTapeLibraries')
)
SELECT @XMLDoc
DROP TABLE #tempTapeLib
DROP TABLE #tempTapeLib2
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MMSummPageGetTapeLibraries')
	delete from GxQscripts where name = 'MMSummPageGetTapeLibraries'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMSummPageGetTapeLibraries')
	delete from GXDBVersions where aliasname = 'MMSummPageGetTapeLibraries'
GO

insert into GXDBVersions values(2, 'MMSummPageGetTapeLibraries',  '00010006003600050000', 'MMSummPageGetTapeLibraries', '00010006003600050000')
GO

