

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMSummPageGetStoragePolicies.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMSummPageGetStoragePolicies.sp,v $ $Id: MMSummPageGetStoragePolicies.sp,v 1.6.190.2 2018/03/20 00:02:26 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		STORED PROCEDURE : "MMSummPageGetStoragePolicies"	|
--	|									|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMSummPageGetStoragePolicies <<<'

IF EXISTS (select * from sysobjects where name='MMSummPageGetStoragePolicies')
	drop procedure MMSummPageGetStoragePolicies
IF EXISTS (select * from GxQscripts where name='MMSummPageGetStoragePolicies')
	delete from GxQscripts where name = 'MMSummPageGetStoragePolicies'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMSummPageGetStoragePolicies')
	delete from GXDBVersions where aliasname = 'MMSummPageGetStoragePolicies'
GO
print '... Creating Procedure: MMSummPageGetStoragePolicies'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMSummPageGetStoragePolicies
  @i_userId INTEGER,
  @i_localeId INTEGER
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @spTbl		TABLE (t_spId int, t_type int)
-----------------------------
-- Get all Shelf Libraries --
-----------------------------
INSERT INTO @spTbl
SELECT	DISTINCT id, type
FROM	archGroup
WHERE	id > 1
----------------------
-- VISIBILITY CHECK --
----------------------
IF @i_userId > 0
BEGIN
	IF object_id('tempdb.dbo.#MMSummUserObjects') IS NOT null DROP TABLE #MMSummUserObjects
create table  #MMSummUserObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	EXEC sec_getUserObjects @i_userId, 0, 0, '#MMSummUserObjects'
	delete #MMSummUserObjects
	WHERE clientGroupId <> 0 OR clientID <> 0 OR mediaAgentId <> 0 OR libraryID <> 0 OR VtShelfId <> 0 OR vtContainerId <> 0 OR vtPolicyId <> 0
	OR reviewSetId <> 0 OR querySetId <> 0 OR downloadSetId <> 0 OR tagId <> 0 OR legalHoldId <> 0 OR ermId <> 0 OR cdPolicyId <> 0 OR complianceReportId <> 0
	OR taskId <> 0 OR workflowId <> 0 OR logMonitoringPolicyId <> 0 OR arrayId <> 0
	OR cloudId <> 0 OR userGroupId <> 0 OR providerId <> 0 OR entityId1 <> 0
	OR entityId2 <> 0 OR entityId3 <> 0 OR entityId4 <> 0 OR entityId5 <> 0
	OR entityId6 <> 0 OR entityId7 <> 0 OR entityId8 <> 0 OR entityId9 <> 0
	delete @spTbl
	WHERE NOT EXISTS (select * from #MMSummUserObjects where archGroupID in (0, t_spId))
	DROP TABLE #MMSummUserObjects
END
--------------------------
-- HERE IS THE RESPONSE --
--------------------------
SELECT  TAG								= 1,
	Parent								= null,
	[EVGui_SummPageGetStoragePolicies!1!numberOfStoragePolicies]	= (select count(*) from @spTbl),
[EVGui_SummPageGetStoragePolicies!1!numberOfDRPolicies]		= (select count(*) from @spTbl where t_type = 2),
[EVGui_SummPageGetStoragePolicies!1!numberOfRegularPolicies]	= (select count(*) from @spTbl where t_type <> 2)
FOR XML EXPLICIT
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MMSummPageGetStoragePolicies')
	delete from GxQscripts where name = 'MMSummPageGetStoragePolicies'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMSummPageGetStoragePolicies')
	delete from GXDBVersions where aliasname = 'MMSummPageGetStoragePolicies'
GO

insert into GXDBVersions values(2, 'MMSummPageGetStoragePolicies',  '00010006019000020000', 'MMSummPageGetStoragePolicies', '00010006019000020000')
GO

