

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMSummPageGetSlots.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMSummPageGetSlots.sp,v $ $Id: MMSummPageGetSlots.sp,v 1.5.198.2 2018/03/20 00:11:59 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		STORED PROCEDURE : "MMSummPageGetSlots"			|
--	|									|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMSummPageGetSlots <<<'

IF EXISTS (select * from sysobjects where name='MMSummPageGetSlots')
	drop procedure MMSummPageGetSlots
IF EXISTS (select * from GxQscripts where name='MMSummPageGetSlots')
	delete from GxQscripts where name = 'MMSummPageGetSlots'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMSummPageGetSlots')
	delete from GXDBVersions where aliasname = 'MMSummPageGetSlots'
GO
print '... Creating Procedure: MMSummPageGetSlots'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMSummPageGetSlots
  @i_userId INTEGER,
  @i_localeId INTEGER,
  @i_libraryId INTEGER,
  @i_isRegSlots INTEGER
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @mediaExporting		INT
DECLARE @mediaTbl		TABLE (t_id int, t_exportTime int)
DECLARE @slotTbl		TABLE (t_id int, t_isOccupied int, t_medId int)
DECLARE	@exportSGId		TABLE (sgId int, libId int)
DECLARE	@exportMGId		TABLE (medId int, libId int)
IF @i_isRegSlots = 1  --MMS2_SLOT_ACCESSIBLE
BEGIN
	INSERT INTO @slotTbl
	SELECT	DISTINCT S.slotId, S.isOccupied, 0
	FROM	MMSlot S, MMBay B
	WHERE	B.LibraryId = @i_libraryId AND S.BayId = B.BayId AND S.slotType = 1
--------------------------
-- HERE IS THE RESPONSE --
--------------------------
SELECT  TAG						= 1,
	Parent						= null,
	[EVGui_SummPageGetSlot!1!totalSlots]		= (select count(*) from @slotTbl),
	[EVGui_SummPageGetSlot!1!totalOccupiedSlots]	= (select count(*) from @slotTbl where t_isOccupied > 0)
FOR XML EXPLICIT
END
ELSE IF @i_isRegSlots = 6  --MMS2_SLOT_DEFAULT_IMPORT | MMS2_SLOT_DEFAULT_EXPORT
BEGIN
	INSERT INTO @slotTbl
	SELECT	DISTINCT S.slotId, S.isOccupied, S.MediaId
	FROM	MMSlot S, MMBay B
	WHERE	B.LibraryId = @i_libraryId AND S.BayId = B.BayId AND S.slotType > 1
	-- get last export time
	INSERT INTO @exportSGId
	SELECT	SpareGroupId, LibraryId
	FROM	MMSpareGroup
	WHERE	LibraryId = @i_LibraryId
	INSERT INTO @exportMGId
	SELECT	V.MediaId, T.libId
	FROM	MMMediaGroup G, MMVolume V, @exportSGId T
	WHERE	G.SpareGroupId = T.sgId AND G.MediaGroupId = V.MediaGroupId and V.MediaGroupId > 0
	INSERT INTO @mediaTbl
	SELECT DISTINCT MediaId, lastExportTime
	FROM	MMMedia
	WHERE	LastWriteLibraryId = @i_LibraryId AND MediaId > 0 AND mediaTypeId <> 10001 AND MediaLocation = 3
	UNION
	SELECT DISTINCT MediaId, lastExportTime
	FROM	MMMedia, @exportSGId SG
	WHERE	LastWriteLibraryId <> @i_LibraryId AND MediaId > 0 AND mediaTypeId <> 10001 AND MediaLocation = 3 AND
		IsInMediaGroup = 0 AND SpareGroupId = SG.sgId
	UNION
	SELECT DISTINCT MediaId, lastExportTime
	FROM	MMMedia, @exportMGId MG
	WHERE	LastWriteLibraryId <> @i_LibraryId AND MediaId > 0 AND mediaTypeId <> 10001 AND MediaLocation = 3 AND
		IsInMediaGroup > 0 AND MediaId = MG.medId AND LastWriteLibraryId <> 0
	SELECT	@mediaExporting = count(*)
	FROM	@slotTbl
	WHERE	t_medId in (select MediaId from MMMediaExport)
--------------------------
-- HERE IS THE RESPONSE --
--------------------------
DECLARE @lastexportTime		INT
SELECT	@lastexportTime =  max(t_exportTime) from @mediaTbl
IF(@lastexportTime IS NOT NULL AND @lastexportTime <> 0)
  SELECT	@lastexportTime =  dbo.GetUnixTime(dbo.UTCToLocalTime(  dbo.GetDateTime( max(t_exportTime)), dbo.GetClientTimeZone(2))) from @mediaTbl
SELECT  TAG							= 1,
	Parent							= null,
	[EVGui_SummPageGetIEPort!1!totalIEPorts]		= (select count(*) from @slotTbl),
	[EVGui_SummPageGetIEPort!1!totalOccupiedMailSlots]	= (select count(*) from @slotTbl where t_isOccupied > 0),
	[EVGui_SummPageGetIEPort!1!numberOfExportsInProgress]	= @mediaExporting,
	[EVGui_SummPageGetIEPort!1!lastExportTime]		= ((CASE   WHEN @lastexportTime IS NULL  THEN NULL WHEN @lastexportTime =0 THEN 'N/A' ELSE DBO.getDateTime2(@lastexportTime, null, 0)END ))
FOR XML EXPLICIT
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MMSummPageGetSlots')
	delete from GxQscripts where name = 'MMSummPageGetSlots'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMSummPageGetSlots')
	delete from GXDBVersions where aliasname = 'MMSummPageGetSlots'
GO

insert into GXDBVersions values(2, 'MMSummPageGetSlots',  '00010005019800020000', 'MMSummPageGetSlots', '00010005019800020000')
GO

