

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMSummPageGetSPDetails.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMSummPageGetSPDetails.sp,v $ $Id: MMSummPageGetSPDetails.sp,v 1.25.2.8 2020/05/01 23:59:50 pveeravalli Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		STORED PROCEDURE : "MMSummPageGetSPDetails"		|
--	|									|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMSummPageGetSPDetails')
BEGIN
	print '>>> Drop Stored Procedure: MMSummPageGetSPDetails <<<'
	drop procedure MMSummPageGetSPDetails
END
IF EXISTS (select * from GxQscripts where name='MMSummPageGetSPDetails')
	delete from GxQscripts where name = 'MMSummPageGetSPDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMSummPageGetSPDetails')
	delete from GXDBVersions where aliasname = 'MMSummPageGetSPDetails'
GO
print '... Creating Procedure: MMSummPageGetSPDetails'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMSummPageGetSPDetails
  @i_userId INTEGER,
  @i_localeId INTEGER,
  @i_policyId INTEGER
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @availableJobs	INT = 0
DECLARE @runningJobs	INT
DECLARE @totalBkpData	BIGINT = 0
DECLARE @appTbl		TABLE (t_clientId int, t_subclientId int)
DECLARE @SPListTbl		TABLE (agid int)
--------------
-- Get data --
--------------
DECLARE @isGlobalPolicy BIT = 0
DECLARE @isGlobalSecPolicy BIT = 0
DECLARE	@l_spFlags		INT = 0
SELECT	@l_spFlags = flags	FROM archGroup WITH (NOLOCK) WHERE id = @i_policyId
DECLARE @maxstreams		INT =0
IF	(@l_spFlags & ( 256 | 8388608 | 16384 ) ) <> 0
BEGIN
	SET @maxstreams = NULL -- no need to set as this is not applicatable sending NULL GUi will not display this column
	SET @isGlobalPolicy = 1
IF (@l_spFlags & 16384) > 0
		SET @isGlobalSecPolicy = 1
END
ELSE
	SET @maxstreams = (select maxStreams from archGroup WITH (NOLOCK) where id = @i_policyId)
--insert actual Storage policy to figure out number of clients/Subclients/running jobs
INSERT INTO @SPListTbl
SELECT @i_policyId
--insert dependent primary copy storage policy to figure out number of clients/Subclients/running jobs
IF	(@isGlobalPolicy = 1)
BEGIN
	INSERT INTO @SPListTbl
	select DISTINCT AG.id from archGroupCopy AGC WITH (NOLOCK)
	inner join archCopyToGlobalPolicy AGP WITH (NOLOCK) on AGP.copyId = AGC.id
	inner join archGroup AG WITH (NOLOCK) on AGC.archGroupId = AG.id AND AGC.id = AG.defaultCopy
	where AGP.globalPolicyId = @i_policyId
END
--Get running jobs
SELECT	@runningJobs = count(distinct jobId)
FROM	JMBkpJobInfo WITH (NOLOCK)
INNER JOIN APP_application WITH (NOLOCK) on applicationId = id
INNER JOIN @SPListTbl TMP on dataArchGrpId = TMP.agid OR logArchGrpID = TMP.agid
--insert dependent secondary copy storage policy to figure out number of clients/Subclients
IF	(@isGlobalPolicy = 1)
BEGIN
	INSERT INTO @SPListTbl
	select DISTINCT AGC.archGroupId from archGroupCopy AGC WITH (NOLOCK)
	inner join archCopyToGlobalPolicy AGP WITH (NOLOCK) on AGP.copyId = AGC.id
	left outer join @SPListTbl TMP on TMP.agid = AGC.archGroupId
	where AGP.globalPolicyId = @i_policyId AND TMP.agid IS NULL
END
--insert incremental Storage policy to figure out number of clients/Subclients
INSERT INTO @SPListTbl
SELECT id FROM ARCHGROUP WITH (NOLOCK) WHERE INCRSP=@i_policyId
INSERT INTO @appTbl
	SELECT  app.clientId, app.id
	FROM    APP_Application app WITH (NOLOCK)
		WHERE   EXISTS(SELECT agid FROM @SPListTbl WHERE agid = app.dataArchGrpId OR agid = app.logArchGrpID)
DECLARE @archGroupCopyList TABLE (
    archGroupId int,
    archGroupName nvarchar(288),
    defaultCopyId int,
    totalStreams int,
	streamsInUse int,
    unUsedStreams int
)
-- if global policy then skipping to fetch streams information
IF	(@isGlobalPolicy = 0)
BEGIN
	INSERT INTO @archGroupCopyList
	SELECT  sp.id, sp.name, sp.defaultCopy ,sp.maxStreams,0, 0
	FROM    ArchGroup sp WITH (NOLOCK)
	WHERE   sp.id = @i_policyId
	UPDATE  copylist
	SET streamsInUse = (ISNULL((SELECT COUNT(DISTINCT StreamId) streamsInUse FROM MMResource WITH (NOLOCK) INNER JOIN  @archGroupCopyList copylist
				ON CopyId = copylist.defaultCopyId
				WHERE   StreamId > 0
				AND     HasJobInterrupted = 0 AND IntrJobId_l = 0
				AND     LogicalRelease = 0
				GROUP BY CopyId), 0) )
	FROM    @archGroupCopyList copylist
	UPDATE  copylist
	SET unUsedStreams = copylist.totalStreams - copylist.streamsInUse  FROM    @archGroupCopyList copylist
END
----------------------
-- VISIBILITY CHECK --
----------------------
IF @i_userId > 0
BEGIN
	IF object_id('tempdb.dbo.#MMSummUserObjects') IS NOT null DROP TABLE #MMSummUserObjects
create table  #MMSummUserObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	EXEC sec_getUserObjects @i_userId, 0, 0, '#MMSummUserObjects'
	delete #MMSummUserObjects
	WHERE clientGroupId <> 0 OR archGroupID <> 0 OR mediaAgentId <> 0 OR libraryID <> 0 OR VtShelfId <> 0 OR vtContainerId <> 0 OR vtPolicyId <> 0
	OR reviewSetId <> 0 OR querySetId <> 0 OR downloadSetId <> 0 OR tagId <> 0 OR legalHoldId <> 0 OR ermId <> 0 OR cdPolicyId <> 0 OR complianceReportId <> 0
	OR taskId <> 0 OR workflowId <> 0 OR logMonitoringPolicyId <> 0 OR arrayId <> 0
	OR cloudId <> 0 OR userGroupId <> 0 OR providerId <> 0 OR entityId1 <> 0
	OR entityId2 <> 0 OR entityId3 <> 0 OR entityId4 <> 0 OR entityId5 <> 0
	OR entityId6 <> 0 OR entityId7 <> 0 OR entityId8 <> 0 OR entityId9 <> 0
	delete @appTbl
	WHERE NOT EXISTS (select * from #MMSummUserObjects where clientId in (0, t_clientId))
	DROP TABLE #MMSummUserObjects
END
--------------------------
-- HERE IS THE RESPONSE --
--------------------------
SELECT  TAG									= 1,
	Parent									= null,
[EVGui_SummPageGetStoragePolicyDetailes!1!numberOfCopies]		= (select count(id) from archGroupCopy WITH (NOLOCK) where archGroupId = @i_policyId  AND type NOT IN (5) ),
	[EVGui_SummPageGetStoragePolicyDetailes!1!numberOfStreams]		= CASE WHEN @isGlobalPolicy = 0 THEN @maxstreams ELSE NULL END,
	[EVGui_SummPageGetStoragePolicyDetailes!1!numberOfAvailableJobs]	= CASE WHEN @isGlobalSecPolicy = 0 THEN @availableJobs ELSE NULL END,
	[EVGui_SummPageGetStoragePolicyDetailes!1!numberOfRunningJobs]		= CASE WHEN @isGlobalSecPolicy = 0 THEN @runningJobs ELSE NULL END,
	[EVGui_SummPageGetStoragePolicyDetailes!1!totalBackedUpData]		= CASE WHEN @isGlobalSecPolicy = 0 THEN DBO.GetSizeString(@totalBkpData) ELSE NULL END,
	[EVGui_SummPageGetStoragePolicyDetailes!1!primaryCopyRetention]		= null,
	[EVGui_SummPageGetStoragePolicyDetailes!1!numberOfAssociatedClients]	= (select count(distinct t_clientId) from @appTbl),
	[EVGui_SummPageGetStoragePolicyDetailes!1!numberOfAssociatedSubclients]	= (select count(distinct t_subclientId) from @appTbl),
    [EVGui_SummPageGetStoragePolicyDetailes!1!totalStreamsConfigured]	= CASE WHEN @isGlobalPolicy = 0 THEN (SELECT totalStreams FROM @archGroupCopyList) ELSE NULL END,
    [EVGui_SummPageGetStoragePolicyDetailes!1!streamsInUse]	=  CASE WHEN @isGlobalPolicy = 0 THEN (SELECT streamsInUse FROM @archGroupCopyList) ELSE NULL END,
    [EVGui_SummPageGetStoragePolicyDetailes!1!streamsAvailable]	= CASE WHEN @isGlobalPolicy = 0 THEN (SELECT unUsedStreams FROM @archGroupCopyList) ELSE NULL END
FOR XML EXPLICIT
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MMSummPageGetSPDetails')
	delete from GxQscripts where name = 'MMSummPageGetSPDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMSummPageGetSPDetails')
	delete from GXDBVersions where aliasname = 'MMSummPageGetSPDetails'
GO

insert into GXDBVersions values(2, 'MMSummPageGetSPDetails',  '00010025000200080000', 'MMSummPageGetSPDetails', '00010025000200080000')
GO

